/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class HttpTask {
    protected URL url = null;
    protected String authorization = null;
    protected Properties requestParameters = null;
    protected Properties response = null;
    protected int status = -1;

    public HttpTask(URL uRL, HttpServletRequest httpServletRequest) {
        this.url = uRL;
        if (httpServletRequest != null) {
            this.authorization = httpServletRequest.getHeader("Authorization");
            this.requestParameters = new Properties();
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String[] stringArray = httpServletRequest.getParameterValues(string);
                if (stringArray == null) continue;
                if (stringArray.length == 1) {
                    this.requestParameters.put(string, stringArray[0]);
                    continue;
                }
                if (stringArray.length <= 1) continue;
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
                this.requestParameters.put(string, vector);
            }
        }
    }

    public void setRequestParameters(Properties properties) {
        this.requestParameters = properties;
    }

    public void setRequestParameter(String string, Object object) {
        if (this.requestParameters == null) {
            this.requestParameters = new Properties();
        }
        this.requestParameters.put(string, object);
    }

    public URL getUrl() {
        URL uRL = null;
        try {
            if (this.url != null) {
                if (this.requestParameters != null) {
                    String string = this.url.toExternalForm() + "?" + this.encodeRequestString(this.requestParameters);
                    uRL = new URL(string);
                } else {
                    uRL = this.url;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public int exec() throws IOException {
        int n = 1;
        this.status = -1;
        this.response = new Properties();
        URL uRL = this.getUrl();
        if (uRL != null) {
            URLConnection uRLConnection = uRL.openConnection();
            if (this.authorization != null) {
                uRLConnection.setRequestProperty("Authorization", this.authorization);
            }
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.addResponseParameter(string, this.response);
            }
            n = 0;
        }
        return n;
    }

    public Properties getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.status;
    }

    protected void addResponseParameter(String string, Properties properties) {
        int n = -1;
        n = string.indexOf(":");
        if (n != -1) {
            Object object;
            String string2 = string.substring(0, n).trim().toLowerCase();
            String string3 = string.substring(n + 1).trim().toLowerCase();
            if (string2.equalsIgnoreCase("nmc_status")) {
                try {
                    this.status = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((object = properties.get(string2)) == null) {
                properties.put(string2, string3);
            } else if (object instanceof String && !((String)object).equals(string3)) {
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(object);
                hashSet.add(string3);
                properties.put(string2, hashSet);
            } else if (object instanceof AbstractSet) {
                AbstractSet abstractSet = (AbstractSet)object;
                abstractSet.add(string3);
            }
        }
    }

    protected String encodeRequestString(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                String string2 = null;
                Object object = properties.get(string);
                if (object instanceof String) {
                    string2 = (String)object;
                    stringBuffer.append(URLEncoder.encode(string) + "=" + URLEncoder.encode(string2));
                } else if (object instanceof AbstractCollection) {
                    AbstractCollection abstractCollection = (AbstractCollection)object;
                    Iterator iterator = abstractCollection.iterator();
                    while (iterator.hasNext()) {
                        string2 = iterator.next().toString();
                        stringBuffer.append(URLEncoder.encode(string) + "=" + URLEncoder.encode(string2));
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append("&");
                    }
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append("&");
            }
        }
        return stringBuffer.toString();
    }
}

