/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task;

import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.CommandLineTaskEventManager;
import com.iplanet.idar.task.DefaultTaskDialogManager;
import com.iplanet.idar.task.DefaultTaskEventManager;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.task.TaskEventManager;
import com.iplanet.idar.ui.task.IplanetTaskDialogManager;
import com.iplanet.idar.ui.task.IplanetTaskEventManager;
import com.iplanet.idar.ui.task.SwingTaskDialogManager;
import com.iplanet.idar.ui.task.SwingTaskEventManager;
import com.netscape.management.client.util.Debug;

public class TaskManagerFactory {
    static int context = 1;

    static TaskEventManager createTaskEventManager(AbstractTask abstractTask) throws IllegalStateException {
        Debug.println((int)7, (String)("TaskManagerFactory.createTaskEventManager: task=" + abstractTask));
        if (context == -1) {
            throw new IllegalStateException("context not set");
        }
        if (abstractTask == null) {
            throw new IllegalStateException("null task");
        }
        DefaultTaskEventManager defaultTaskEventManager = null;
        switch (context) {
            case 3: {
                defaultTaskEventManager = new IplanetTaskEventManager();
                break;
            }
            case 1: {
                defaultTaskEventManager = new CommandLineTaskEventManager();
                break;
            }
            case 2: {
                defaultTaskEventManager = new SwingTaskEventManager();
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized context " + context);
            }
        }
        if (defaultTaskEventManager != null) {
            defaultTaskEventManager.setTask(abstractTask);
        }
        return defaultTaskEventManager;
    }

    static TaskDialogManager createTaskDialogManager(AbstractTask abstractTask) throws IllegalStateException {
        Debug.println((int)7, (String)("TaskManagerFactory.createTaskDialogManager: task=" + abstractTask));
        if (context == -1) {
            throw new IllegalStateException("context not set");
        }
        if (abstractTask == null) {
            throw new IllegalStateException("null task");
        }
        TaskDialogManager taskDialogManager = null;
        switch (context) {
            case 3: {
                taskDialogManager = new IplanetTaskDialogManager();
                break;
            }
            case 1: {
                taskDialogManager = new DefaultTaskDialogManager();
                break;
            }
            case 2: {
                taskDialogManager = new SwingTaskDialogManager();
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized context " + context);
            }
        }
        return taskDialogManager;
    }

    public static void setContextIndicator(int n) {
        Debug.println((String)("TaskManagerFactory.setContextIndicator: context=" + context));
        context = n;
    }

    public static boolean isInitialized() {
        return context != -1;
    }
}

