/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.idar;

import com.iplanet.idar.objectmodel.bean.AdminServerBean;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskParameters;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.DARTask;
import com.netscape.management.client.util.Debug;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class IdarTask
extends AbstractTask {
    public static final String NULL_IDAR = IDARResourceSet.getString("idarTask", "UNEXEC_MSG_NULL_IDAR");
    public static final String IDAR_UNSYNCED = IDARResourceSet.getString("idarTask", "UNEXEC_MSG_IDAR_UNSYNCED");
    public static final String NULL_USER_ID = IDARResourceSet.getString("idarTask", "UNEXEC_MSG_USER_ID");
    public static final String NULL_PASSWORD = IDARResourceSet.getString("idarTask", "UNEXEC_MSG_NULL_PASSWORD");
    protected IDARBean idar = null;
    protected String userId = null;
    protected String password = null;
    protected String failureMessage = "";

    public IdarTask(IDARBean iDARBean) {
        this(iDARBean, null, null);
    }

    public IdarTask(IDARBean iDARBean, String string, String string2) {
        this.idar = iDARBean;
        this.userId = string;
        this.password = string2;
        this.setExecutable(this.checkExecutable());
    }

    public void setAuthentication(String string, String string2) {
        this.userId = string;
        this.password = string2;
        this.setExecutable(this.checkExecutable());
    }

    public void setUserId(String string) {
        this.userId = string;
        this.setExecutable(this.checkExecutable());
    }

    public void setPassword(String string) {
        this.password = string;
        this.setExecutable(this.checkExecutable());
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.idar == null) {
            string = NULL_IDAR;
        } else if (this.idar.getIdarRoot() == null) {
            string = IDAR_UNSYNCED;
        } else if (this.userId == null) {
            string = NULL_USER_ID;
        } else if (this.password == null) {
            string = NULL_PASSWORD;
        }
        return string;
    }

    public String getExecutionFailureMessage() {
        return this.failureMessage;
    }

    protected boolean setParameters(TaskParameters taskParameters) {
        Debug.println((int)6, (String)"IdarTask.setParameters");
        boolean bl = false;
        if (this.idar != null) {
            String string = this.idar.getIdarRoot();
            if (string != null) {
                taskParameters.addParameter("idarroot", string);
                String string2 = this.idar.getHostName();
                if (string2 != null) {
                    taskParameters.addParameter("host", string2);
                    SystemBean systemBean = this.idar.getSystemBean();
                    if (systemBean != null) {
                        Integer n = systemBean.getPort();
                        if (n != null) {
                            taskParameters.addParameter("port", n.toString());
                            bl = true;
                        } else {
                            Debug.println((String)"IdarTask.setParameters:  ERROR: null port");
                        }
                    } else {
                        Debug.println((String)"IdarTask.setParameters:  ERROR: can't access system bean");
                    }
                } else {
                    Debug.println((String)"IdarTask.setParameters:  ERROR: null host");
                }
            } else {
                Debug.println((String)"IdarTask.setParameters: ERROR: null idarroot");
            }
        } else {
            Debug.println((String)"IdarTask.setParameters: ERROR: null idar");
        }
        return bl;
    }

    protected DARTask getHttpTask(String string) {
        TaskParameters taskParameters = new TaskParameters();
        return this.getHttpTask(string, taskParameters);
    }

    protected DARTask getHttpTask(String string, TaskParameters taskParameters) {
        this.setParameters(taskParameters);
        DARTask dARTask = new DARTask(this.getTaskUrl(string), this.userId, this.password);
        dARTask.setArgumentVector(taskParameters.toArgumentVector());
        return dARTask;
    }

    protected URL getTaskUrl(String string) {
        Debug.println((int)6, (String)("IdarTask.getTaskUrl: idar=" + this.idar + " uri=" + string));
        URL uRL = null;
        if (this.idar != null) {
            AdminServerBean adminServerBean = this.idar.getAdminServerBean();
            if (adminServerBean != null) {
                String string2 = this.idar.getHostName();
                Integer n = adminServerBean.getPort();
                if (string2 != null && n != null) {
                    StringBuffer stringBuffer = new StringBuffer("http");
                    if (adminServerBean.isSecurityOn()) {
                        stringBuffer.append("s");
                    }
                    stringBuffer.append("://");
                    stringBuffer.append(string2);
                    stringBuffer.append(":");
                    stringBuffer.append(n.toString());
                    stringBuffer.append("/");
                    stringBuffer.append(this.idar.getId());
                    stringBuffer.append(string);
                    try {
                        uRL = new URL(stringBuffer.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.println((String)("IdarTask.getTaskUrl:  ERROR: invalid url " + stringBuffer.toString()));
                    }
                } else {
                    Debug.println((String)("IdarTask.getTaskUrl:  ERROR: bad host or port " + string2 + " " + n));
                }
            } else {
                Debug.println((String)"IdarTask.getTaskUrl:  ERROR: cannot access admin server info");
            }
        }
        return uRL;
    }

    private boolean checkExecutable() {
        return this.idar != null && this.userId != null && this.password != null;
    }
}

