/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.ui.common.DirBrowserCombo;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import netscape.ldap.util.DN;

public class DNDialog
extends AbstractDialog {
    protected static final String TITLE = IDARResourceSet.getString("dialogDN", "TITLE");
    protected static final String NOTE = IDARResourceSet.getString("dialogDN", "NOTE");
    protected static final String ILLEGAL_DN_MESSAGE = IDARResourceSet.getString("dialogDN", "ILLEGAL_DN_MESSAGE");
    protected static final String ILLEGAL_DN_TITLE = IDARResourceSet.getString("dialogDN", "ILLEGAL_DN_TITLE");
    protected static final String BROWSE = IDARResourceSet.getString("button", "BROWSE");
    protected ConsoleInfo info;
    protected DNView view;
    private IDARReference configuration;
    protected static final int BUTTONS = 3;

    public DNDialog(Frame frame) {
        this(frame, null);
    }

    public DNDialog(Frame frame, ConsoleInfo consoleInfo) {
        super(frame, TITLE, 3);
        this.info = consoleInfo;
        this.view = new DNView();
        this.setComponent(this.view.getPanel());
        this.pack();
        this.center();
    }

    public DNDialog(Frame frame, ConsoleInfo consoleInfo, String string) {
        super(frame, TITLE, 3);
        this.info = consoleInfo;
        this.view = new DNView(string);
        this.setComponent(this.view.getPanel());
        this.pack();
        this.center();
    }

    public DNDialog(Frame frame, ConsoleInfo consoleInfo, IDARReference iDARReference) {
        super(frame, TITLE, 3);
        this.info = consoleInfo;
        this.configuration = iDARReference;
        this.view = new DNView();
        this.setComponent(this.view.getPanel());
        this.pack();
        this.center();
    }

    public DNDialog(Frame frame, ConsoleInfo consoleInfo, IDARReference iDARReference, DN dN) {
        super(frame, TITLE, 3);
        this.info = consoleInfo;
        this.configuration = iDARReference;
        this.view = new DNView(dN.toString());
        this.setComponent(this.view.getPanel());
        this.pack();
        this.center();
    }

    public DNDialog(Frame frame, ConsoleInfo consoleInfo, DN dN) {
        this(frame, consoleInfo, dN.toString());
    }

    public DN getDN() {
        return new DN(this.view.getDN());
    }

    public DN getNormalizedDN() {
        return new DN(IDARUtilities.toNormalizedDN(this.view.getDN()));
    }

    public void setDN(DN dN) {
        this.view.setDN(dN.toString());
    }

    public void okInvoked() {
        DN dN = this.getDN();
        if (dN.toString().trim().equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), ILLEGAL_DN_MESSAGE, ILLEGAL_DN_TITLE, 0);
        } else {
            super.okInvoked();
        }
    }

    static /* synthetic */ IDARReference access$100(DNDialog dNDialog) {
        return dNDialog.configuration;
    }

    public class DNView
    extends JPanel {
        String dn;
        JTextField tfDN;
        JButton butBrowse;

        DNView() {
            this("");
        }

        DNView(String string) {
            this.dn = string;
            this.initComponents();
        }

        void setDN(String string) {
            this.tfDN.setText(string);
        }

        String getDN() {
            return this.tfDN.getText();
        }

        void initComponents() {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText(NOTE);
            jTextArea.setEditable(false);
            jTextArea.setBackground(this.getBackground());
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            this.tfDN = new JTextField(25);
            this.tfDN.setText(this.dn);
            if (DNDialog.this.info != null) {
                this.butBrowse = ButtonFactory.createButton((String)BROWSE);
                ButtonFactory.resizeButton((JButton)this.butBrowse);
                this.butBrowse.addActionListener(new ActionListener(this){
                    private final /* synthetic */ DNView this$1;
                    {
                        this.this$1 = dNView;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        DirBrowserCombo dirBrowserCombo = new DirBrowserCombo(IDARUtilities.getParentJFrame((Component)((Object)DNView.access$000(this.this$1))), DNView.access$000((DNView)this.this$1).info, DNDialog.access$100(DNView.access$000(this.this$1)));
                        dirBrowserCombo.show();
                        if (!dirBrowserCombo.isCancel()) {
                            this.this$1.tfDN.setText(dirBrowserCombo.getSelectedDN());
                        }
                        dirBrowserCombo = null;
                    }
                });
            }
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 9);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 2;
            this.add((Component)jTextArea, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            this.add((Component)this.tfDN, gridBagConstraints);
            if (this.butBrowse != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(9, 9, 0, 0);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 18;
                this.add((Component)this.butBrowse, gridBagConstraints);
            }
        }

        public JPanel getPanel() {
            return this;
        }

        static /* synthetic */ DNDialog access$000(DNView dNView) {
            return dNView.DNDialog.this;
        }
    }
}

