/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.configuration;

import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.IBlankPanelListener;
import com.netscape.management.client.components.IPAddressField;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BlankPanel
extends JPanel
implements IBlankPanelListener,
ActionListener,
ChangeListener,
DocumentListener {
    private Vector idarEventListeners = new Vector();
    private boolean eventFiringEnabled = true;
    private Vector childrenBlankPanels;
    private String name;

    public BlankPanel() {
        this("<no name>");
    }

    public BlankPanel(String string) {
        this.name = string;
    }

    public void add(Component component, Object object) {
        this.register(component);
        super.add(component, object);
    }

    public Component add(String string, Component component) {
        this.register(component);
        return super.add(string, component);
    }

    public Component add(Component component) {
        this.register(component);
        return super.add(component);
    }

    private void register(Component component) {
        Debug.println((int)8, (String)("BlankPanel.register: this=" + this + " comp=" + component));
        if (component != null) {
            if (component instanceof JTextField) {
                ((JTextField)component).getDocument().addDocumentListener(this);
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).addActionListener(this);
            } else if (component instanceof JRadioButton) {
                ((JRadioButton)component).addActionListener(this);
            } else if (component instanceof IPAddressField) {
                ((IPAddressField)component).addChangeListener((ChangeListener)this);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).addActionListener(this);
            } else if (component instanceof JSlider) {
                ((JSlider)component).addChangeListener(this);
            } else if (component instanceof JScrollPane) {
                this.register(((JScrollPane)component).getViewport().getView());
            } else if (component instanceof BlankPanel) {
                ((BlankPanel)component).addBlankPanelListener(this);
                if (this.childrenBlankPanels == null) {
                    this.childrenBlankPanels = new Vector();
                }
                if (!this.childrenBlankPanels.contains(component)) {
                    this.childrenBlankPanels.add(component);
                }
            }
        }
    }

    public void unregister(Component component) {
        Debug.println((int)8, (String)("BlankPanel.unregister: this=" + this + " comp=" + component));
        if (component != null) {
            if (component instanceof JTextField) {
                ((JTextField)component).getDocument().removeDocumentListener(this);
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).removeActionListener(this);
            } else if (component instanceof JRadioButton) {
                ((JRadioButton)component).removeActionListener(this);
            } else if (component instanceof IPAddressField) {
                ((IPAddressField)component).removeChangeListener((ChangeListener)this);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).removeActionListener(this);
            } else if (component instanceof JSlider) {
                ((JSlider)component).removeChangeListener(this);
            } else if (component instanceof JScrollPane) {
                this.unregister(((JScrollPane)component).getViewport().getView());
            } else if (component instanceof BlankPanel) {
                ((BlankPanel)component).removeBlankPanelListener(this);
                if (this.childrenBlankPanels == null) {
                    this.childrenBlankPanels = new Vector();
                }
                if (!this.childrenBlankPanels.contains(component)) {
                    this.childrenBlankPanels.remove(component);
                }
            }
        }
    }

    public void addBlankPanelListener(IBlankPanelListener iBlankPanelListener) {
        Debug.println((int)8, (String)("BlankPanel.addBlankPanelListener: this=" + this + " listener=" + iBlankPanelListener));
        if (!this.idarEventListeners.contains(iBlankPanelListener)) {
            this.idarEventListeners.add(iBlankPanelListener);
        }
    }

    public void removeBlankPanelListener(IBlankPanelListener iBlankPanelListener) {
        Debug.println((int)8, (String)("BlankPanel.removeBlankPanelListener: this=" + this + " listener=" + iBlankPanelListener));
        if (!this.idarEventListeners.contains(iBlankPanelListener)) {
            this.idarEventListeners.remove(iBlankPanelListener);
        }
    }

    public void fireBlankPanelEvent(BlankPanelEvent blankPanelEvent) {
        Debug.println((int)8, (String)("BlankPanel.fireBlankPanelEvent: e=" + blankPanelEvent));
        if (this.eventFiringEnabled) {
            Enumeration enumeration = this.idarEventListeners.elements();
            while (enumeration.hasMoreElements()) {
                IBlankPanelListener iBlankPanelListener = (IBlankPanelListener)enumeration.nextElement();
                Debug.println((int)8, (String)(this + " notifies " + iBlankPanelListener + " of " + blankPanelEvent));
                iBlankPanelListener.panelChanged(blankPanelEvent);
            }
        }
    }

    public void setEventFiringEnabled(boolean bl) {
        Debug.println((int)8, (String)("BlankPanel.setEventFiringEnabled: enabled=" + bl + " pnl=" + this));
        this.eventFiringEnabled = bl;
        if (this.childrenBlankPanels != null) {
            Enumeration enumeration = this.childrenBlankPanels.elements();
            while (enumeration.hasMoreElements()) {
                BlankPanel blankPanel = (BlankPanel)enumeration.nextElement();
                blankPanel.setEventFiringEnabled(bl);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.println((int)8, (String)("BlankPanel.actionPerformed: e=" + actionEvent + " pnl=" + this + " efe=" + this.eventFiringEnabled));
        if (this.eventFiringEnabled) {
            this.fireBlankPanelEvent(new BlankPanelEvent(this, actionEvent));
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        Debug.println((int)8, (String)("BlankPanel.insertUpdate: e=" + documentEvent + " pnl=" + this + " efe=" + this.eventFiringEnabled));
        if (this.eventFiringEnabled) {
            this.fireBlankPanelEvent(new BlankPanelEvent(this, documentEvent));
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        Debug.println((int)8, (String)("BlankPanel.removeUpdate: e=" + documentEvent + " pnl=" + this + " efe=" + this.eventFiringEnabled));
        if (this.eventFiringEnabled) {
            this.fireBlankPanelEvent(new BlankPanelEvent(this, documentEvent));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Debug.println((int)8, (String)("BlankPanel.changedUpdate: e=" + documentEvent + " pnl=" + this + " efe=" + this.eventFiringEnabled));
        if (this.eventFiringEnabled) {
            this.fireBlankPanelEvent(new BlankPanelEvent(this, documentEvent));
        }
    }

    public void panelChanged(BlankPanelEvent blankPanelEvent) {
        Debug.println((int)8, (String)("BlankPanel.panelChanged: e=" + blankPanelEvent + " pnl=" + this + " efe=" + this.eventFiringEnabled));
        if (this.eventFiringEnabled) {
            this.fireBlankPanelEvent(blankPanelEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Debug.println((int)8, (String)("BlankPanel.stateChanged: e=" + changeEvent + " pnl=" + this + " efe=" + this.eventFiringEnabled));
        if (this.eventFiringEnabled) {
            this.fireBlankPanelEvent(new BlankPanelEvent(this, changeEvent));
        }
    }

    public String toString() {
        return "BlankPanel[" + this.name + "]";
    }
}

