/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.ui.common.IDARFrameworkInitializer;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.configurator.ConfigurationPage;
import com.iplanet.idar.ui.configurator.ConfigurationResource;
import com.netscape.management.client.AboutDialog;
import com.netscape.management.client.FrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfiguratorFrameworkInitializer
extends FrameworkInitializer
implements IDARFrameworkInitializer {
    private static final ResourceSet licenseResource = new ResourceSet("com.iplanet.idar.defaultIdarLicense");
    ConsoleInfo consoleInfo = null;
    INodeInfo nodeInfo = null;
    IDARReference reference = null;
    Vector changeListeners = new Vector();

    public ConfiguratorFrameworkInitializer(ConsoleInfo consoleInfo, ConfigurationResource configurationResource) {
        this.consoleInfo = (ConsoleInfo)consoleInfo.clone();
        this.reference = configurationResource.getReference();
        this.consoleInfo.setCurrentDN(this.reference.getHandle());
        Debug.println((String)("ConfiguratorFrameworkInitializer: setCurrentDN = " + this.reference.getHandle()));
        this.addPage((IPage)new ConfigurationPage(this.consoleInfo, configurationResource));
        RemoteImage remoteImage = this.getMinimizedIcon();
        if (remoteImage != null) {
            this.setMinimizedImage(remoteImage.getImage());
        } else {
            Debug.println((String)"IDAR:  cannot load minimized icon");
        }
        RemoteImage remoteImage2 = ImageFactory.getImage("BANNER");
        if (remoteImage2 != null) {
            this.setBannerImage(remoteImage2.getImage());
        } else {
            Debug.println((String)"IDAR:  cannot load banner image");
        }
        this.setFrameTitle(IDARResourceSet.getString("config", "IDAR_CONFIGURATION_EDITOR") + " - " + this.getServerId());
        this.setBannerText(IDARResourceSet.getString("config", "CONFIGURATION_EDITOR"));
        configurationResource.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConfiguratorFrameworkInitializer.this.setFrameTitle(IDARResourceSet.getString("config", "IDAR_CONFIGURATION_EDITOR") + " - " + ConfiguratorFrameworkInitializer.this.getServerId());
                ConfiguratorFrameworkInitializer.this.setBannerText(IDARResourceSet.getString("config", "CONFIGURATION_EDITOR"));
                ConfiguratorFrameworkInitializer.this.fireStateChanged(changeEvent);
            }
        });
    }

    public String getServerId() {
        return this.reference.getId();
    }

    public ConsoleInfo getConsoleInfo() {
        return this.consoleInfo;
    }

    private RemoteImage getMinimizedIcon() {
        RemoteImage remoteImage = ImageFactory.getImage("CONFIGURATION");
        return remoteImage;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void fireStateChanged(ChangeEvent changeEvent) {
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void aboutInvoked(JFrame jFrame) {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Frame)jFrame, licenseResource.getString("defaultAbout", "dialogTitle"));
            this.aboutDialog.setProduct(null, licenseResource.getString("defaultAbout", "productCopyright"), licenseResource.getString("defaultAbout", "productLicense"));
        }
        this.aboutDialog.show();
    }
}

