/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.ForwardingBindsView;
import com.iplanet.idar.ui.configurator.group.ForwardingOperationsView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ForwardingView
extends ConfigurationView
implements SuiConstants {
    private JTabbedPane tabViews;
    private ConfigurationView viewForwardingBinds;
    private ConfigurationView viewForwardingOperations;

    public ForwardingView() {
        this.initComponents();
    }

    public ForwardingView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("FowardingView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.viewForwardingBinds != null && this.viewForwardingOperations != null) {
            this.viewForwardingBinds.setDataModel(iDARModelBean, bl);
            this.viewForwardingOperations.setDataModel(iDARModelBean, bl);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("ForwardingView.resetContent: model=" + networkGroupBean));
        this.viewForwardingBinds.resetContent();
        this.viewForwardingOperations.resetContent();
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        try {
            this.viewForwardingBinds.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewForwardingBinds.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewForwardingOperations.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewForwardingOperations.getPanel());
            throw configurationViewException;
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupForwardingGeneral", "TITLE");
    }

    public String getHelpTopic() {
        String string = "";
        Component component = this.tabViews.getSelectedComponent();
        if (component instanceof ConfigurationView) {
            ConfigurationView configurationView = (ConfigurationView)component;
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewForwardingBinds != null) {
            this.viewForwardingBinds.setConsoleInfo(consoleInfo);
            this.viewForwardingOperations.setConsoleInfo(consoleInfo);
        }
    }

    protected void initComponents() {
        this.tabViews = new JTabbedPane();
        this.viewForwardingBinds = new ForwardingBindsView();
        this.viewForwardingBinds.setConsoleInfo(this.getConsoleInfo());
        this.viewForwardingOperations = new ForwardingOperationsView();
        this.viewForwardingOperations.setConsoleInfo(this.getConsoleInfo());
        this.viewForwardingBinds.addBlankPanelListener(this);
        this.viewForwardingOperations.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewForwardingBinds.getTitleText(), null, this.viewForwardingBinds.getPanel());
        this.tabViews.addTab(this.viewForwardingOperations.getTitleText(), null, this.viewForwardingOperations.getPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabViews, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ForwardingView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

