/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.LoadBalanceData;
import com.iplanet.idar.objectmodel.bean.LoadBalancePropertyBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.DynamicListModel;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.NewItemListener;
import com.iplanet.idar.ui.common.ViewMap;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.Editor;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LDAPServersView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-loadbalance";
    private boolean alreadyAskedLdapServerConversion = false;
    final String[] descLDAP = new String[]{"ldap-server"};
    JTextArea txtNote;
    JComboBox cboLoadBalance;
    JButton butNewLoadBalance;
    JButton butEditLoadBalance;
    NewItemListener newLoadBalanceListener;
    protected final IplanetEditObjectTask editLoadBalanceTask = new IplanetEditObjectTask();
    protected final IplanetCreateAndEditObjectTask createLoadBalanceTask = new IplanetCreateAndEditObjectTask("load-balancing");

    public LDAPServersView() {
        this.initComponents();
    }

    public LDAPServersView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in Constructor(LDAPServersView). Model = " + networkGroupBean));
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        super.setDataModel(iDARModelBean, bl);
        if (iDARModelBean != null) {
            this.createLoadBalanceTask.setParentConfiguration(iDARModelBean.getParentConfiguration());
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editLoadBalanceTask.setConsoleInfo(consoleInfo);
        this.createLoadBalanceTask.setConsoleInfo(consoleInfo);
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("groupLDAPServers", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.butNewLoadBalance = new TaskButton(this.createLoadBalanceTask);
        ButtonFactory.resizeButton((JButton)this.butNewLoadBalance);
        this.newLoadBalanceListener = new NewItemListener(this.butNewLoadBalance);
        this.butEditLoadBalance = new TaskButton(this.editLoadBalanceTask);
        ButtonFactory.resizeButton((JButton)this.butEditLoadBalance);
        this.cboLoadBalance = new JComboBox();
        this.cboLoadBalance.setToolTipText(IDARResourceSet.getString("tooltip", "selected_load_balance_property"));
        this.cboLoadBalance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LDAPServersView.this.setEnablement();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cboLoadBalance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butNewLoadBalance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butEditLoadBalance, gridBagConstraints);
    }

    protected void setEnablement() {
        boolean bl = true;
        this.cboLoadBalance.setEnabled(bl);
        this.createLoadBalanceTask.setEnabled(bl);
        this.editLoadBalanceTask.setEnabled(bl);
        this.editLoadBalanceTask.setObject(this.getSelectedReference("load-balancing"));
    }

    private IDARReference getSelectedReference(String string) {
        IDARModelBean iDARModelBean;
        IDARReference iDARReference = null;
        Object object = null;
        int n = -1;
        if (string.equals("load-balancing")) {
            n = this.cboLoadBalance.getSelectedIndex();
            object = this.cboLoadBalance.getSelectedItem();
        }
        if ((iDARModelBean = this.getDataModel()) != null && object != null && string != null) {
            try {
                iDARReference = BeanSpace.getInstance().getBeanReference(object.toString(), string, iDARModelBean.getParentConfiguration());
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        return iDARReference;
    }

    public DynamicComboBoxModel getListModel(String string) {
        DynamicComboBoxModel dynamicComboBoxModel = null;
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            IDARBeanCollection iDARBeanCollection = null;
            try {
                iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(networkGroupBean.getParentConfiguration(), string);
            }
            catch (IDARBeanException iDARBeanException) {
                // empty catch block
            }
            if (iDARBeanCollection != null) {
                dynamicComboBoxModel = new DynamicComboBoxModel(iDARBeanCollection);
            }
        }
        return dynamicComboBoxModel;
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            networkGroupBean.removeAllLoadBalanceProperties();
            Object object = this.cboLoadBalance.getSelectedItem();
            if (object != null && !((String)object).equals("") && !((String)object).equals(DynamicListModel.NONE)) {
                networkGroupBean.addLoadBalancePropertyId((String)object);
                networkGroupBean.removeAllLdapServerProperties();
            }
        } else {
            throw new ConfigurationViewException();
        }
        this.alreadyAskedLdapServerConversion = false;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupLDAPServers", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("LDAPServersView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            Serializable serializable;
            if (!(this.cboLoadBalance.getModel() instanceof DynamicComboBoxModel) && (serializable = this.getListModel("load-balancing")) != null) {
                this.newLoadBalanceListener.setModel((DynamicComboBoxModel)serializable);
                this.cboLoadBalance.setModel(serializable);
            }
            serializable = networkGroupBean.getLoadBalancePropertyIds();
            Vector vector = networkGroupBean.getLdapServerPropertyIds();
            if (!this.alreadyAskedLdapServerConversion && vector.size() > 0) {
                Debug.println((int)6, (String)"LDAPServersView.resetContent: deprecated ldap server found");
                String string = (String)vector.firstElement();
                networkGroupBean.removeAllLoadBalanceProperties();
                ConsoleInfo consoleInfo = this.getConsoleInfo();
                IFramework iFramework = IDARUtilities.getFramework(consoleInfo.getCurrentDN());
                JFrame jFrame = null;
                if (iFramework != null) {
                    jFrame = iFramework.getJFrame();
                }
                int n = JOptionPane.showConfirmDialog(jFrame, IDARResourceSet.getString("groupLDAPServers", "ASK_MIGRATE_MESSAGE1") + "\n" + string + "\n" + IDARResourceSet.getString("groupLDAPServers", "ASK_MIGRATE_MESSAGE2"), IDARResourceSet.getString("groupLDAPServers", "ASK_MIGRATE_TITLE"), 2, 2);
                Debug.println((int)6, (String)"LDAPServersView.resetContent: displayed confirm dialog");
                this.alreadyAskedLdapServerConversion = true;
                if (n == 0) {
                    Debug.println((int)6, (String)"LDAPServersView.resetContent: Attempting to convert ldap server to a load balance");
                    try {
                        LoadBalancePropertyBean loadBalancePropertyBean = (LoadBalancePropertyBean)BeanSpace.getInstance().createBean(networkGroupBean.getParentConfiguration(), "load-balancing");
                        LoadBalanceData loadBalanceData = new LoadBalanceData(networkGroupBean.getParentConfiguration(), string, new Integer(100));
                        loadBalancePropertyBean.setDirty(true);
                        loadBalancePropertyBean.addLoadBalanceData(loadBalanceData);
                        networkGroupBean.addLoadBalancePropertyId(loadBalancePropertyBean.getId());
                        Debug.println((int)6, (String)("LDAPServersView.resetContent:  Converted ldap server to new load balance id =" + loadBalancePropertyBean.getId()));
                        ConfigurationView configurationView = ViewMap.getInstance().obtainView(loadBalancePropertyBean.getDescriptor(), loadBalancePropertyBean.getParentConfiguration());
                        if (configurationView != null) {
                            configurationView.setConsoleInfo(this.getConsoleInfo());
                            configurationView.setDataModel(loadBalancePropertyBean);
                            Editor editor = new Editor((Component)jFrame, configurationView);
                            editor.pack();
                            editor.show();
                        }
                    }
                    catch (IDARBeanException iDARBeanException) {
                        Debug.println((int)0, (String)"LDAPServersView.resetContent: *** ERROR - UNABLE TO CREATE NEW LOAD BALANCE BEAN");
                        Debug.println((int)0, (String)("LDAPServersView.resetContent: *** model = " + networkGroupBean));
                        Debug.println((int)0, (String)("LDAPServersView.resetContent: *** parent configuration = " + networkGroupBean.getParentConfiguration()));
                        Debug.println((int)0, (String)"LDAPServersView.resetContent: *** descriptor = load-balancing");
                        iDARBeanException.printStackTrace();
                    }
                    networkGroupBean.removeAllLdapServerProperties();
                    networkGroupBean.setDirty(true);
                } else {
                    networkGroupBean.setDirty(false);
                    Debug.println((int)6, (String)"LDAPServersView.resetContent: WARNING - LDAP SERVER CONVERSION CANCELLED");
                }
            } else if (vector.size() == 0) {
                Debug.println((int)6, (String)"LDAPServersView.resetContent: no deprecated single ldap servers in use by this group - OK");
            } else {
                Debug.println((int)6, (String)"LDAPServersView.resetContent: deprecated ldap server exist but already asked this console session - OK");
            }
            serializable = networkGroupBean.getLoadBalancePropertyIds();
            if (!((Vector)serializable).isEmpty()) {
                this.cboLoadBalance.setSelectedItem(((Vector)serializable).firstElement());
            } else {
                this.cboLoadBalance.setSelectedItem(DynamicComboBoxModel.NONE);
            }
            this.setEnablement();
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LDAPServersView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

