/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.SSLPolicyPanel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReferralView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Referral";
    private JTextArea txtNote;
    private SSLPolicyPanel pnlReferralSSLPolicy;
    private JLabel lblBindPolicy;
    private JComboBox cboBindPolicy;
    private JCheckBox chkMaxRefCount;
    private JTextField tfMaxRefCount;
    private JRadioButton radDiscard;
    private JRadioButton radForward;
    private JRadioButton radFollow;
    private String BIND_ANONYMOUS = IDARResourceSet.getString("groupReferrals", "BIND_ANONYMOUS");
    private String BIND_ANY = IDARResourceSet.getString("groupReferrals", "BIND_ANY");
    private String BIND_REQUIRED = IDARResourceSet.getString("groupReferrals", "BIND_REQUIRED");

    public ReferralView() {
        this.initComponents();
    }

    public ReferralView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("ReferralView: Unable to resetContent: model = " + networkGroupBean));
        }
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("groupReferrals", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.radDiscard = new JRadioButton(IDARResourceSet.getString("groupReferrals", "SEARCH_REF_DISCARD"));
        this.radDiscard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReferralView.this.setButtonEnablement();
            }
        });
        this.radFollow = new JRadioButton(IDARResourceSet.getString("groupReferrals", "SEARCH_REF_FOLLOW"));
        this.radFollow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReferralView.this.setButtonEnablement();
            }
        });
        this.radForward = new JRadioButton(IDARResourceSet.getString("groupReferrals", "SEARCH_REF_FORWARD"));
        this.radForward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReferralView.this.setButtonEnablement();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radDiscard);
        buttonGroup.add(this.radFollow);
        buttonGroup.add(this.radForward);
        this.pnlReferralSSLPolicy = new SSLPolicyPanel();
        this.lblBindPolicy = new JLabel(IDARResourceSet.getString("groupReferrals", "BIND_POLICY") + ":");
        this.lblBindPolicy.setLabelFor(this.cboBindPolicy);
        this.cboBindPolicy = new JComboBox();
        this.cboBindPolicy.addItem(this.BIND_ANONYMOUS);
        this.cboBindPolicy.addItem(this.BIND_ANY);
        this.cboBindPolicy.addItem(this.BIND_REQUIRED);
        this.chkMaxRefCount = new JCheckBox(IDARResourceSet.getString("groupReferrals", "MAX_REF_COUNT") + ":");
        this.chkMaxRefCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReferralView.this.setMaxRefCountEnablement(true);
            }
        });
        this.tfMaxRefCount = new JTextField(6);
        this.tfMaxRefCount.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupReferrals", "MAX_REF_COUNT"));
        this.tfMaxRefCount.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfMaxRefCount.setMinimumSize(this.tfMaxRefCount.getPreferredSize());
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.setButtonEnablement();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.radDiscard, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        this.add((Component)this.radForward, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        this.add((Component)this.radFollow, gridBagConstraints);
        int n2 = 0;
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 12;
        blankPanel.add((Component)this.lblBindPolicy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.cboBindPolicy, gridBagConstraints);
        BlankPanel blankPanel2 = new BlankPanel();
        blankPanel2.setLayout(new GridBagLayout());
        int n3 = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 0, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.anchor = 18;
        blankPanel2.add((Component)this.chkMaxRefCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel2.add((Component)this.tfMaxRefCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)blankPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlReferralSSLPolicy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 25, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)blankPanel, gridBagConstraints);
    }

    private void setButtonEnablement() {
        boolean bl = this.radFollow.isSelected();
        this.lblBindPolicy.setEnabled(bl);
        this.cboBindPolicy.setEnabled(bl);
        this.chkMaxRefCount.setEnabled(bl);
        this.setMaxRefCountEnablement(bl);
        this.pnlReferralSSLPolicy.setFollowReferrals(bl);
        this.pnlReferralSSLPolicy.setEnablement();
        this.pnlReferralSSLPolicy.setEnabled(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            if (this.radDiscard.isSelected()) {
                networkGroupBean.setReference("discard");
                networkGroupBean.setRefSSLPolicy("ssl_unavailable");
                networkGroupBean.setRefBindPolicy("bind_any");
                networkGroupBean.setMaxRefcount(new Integer(15));
                return;
            } else if (this.radForward.isSelected()) {
                networkGroupBean.setReference("forward");
                networkGroupBean.setRefSSLPolicy("ssl_unavailable");
                networkGroupBean.setRefBindPolicy("bind_any");
                networkGroupBean.setMaxRefcount(new Integer(15));
                return;
            } else {
                networkGroupBean.setReference("follow");
                if (this.pnlReferralSSLPolicy.isPanelEnabled()) {
                    if (this.pnlReferralSSLPolicy.isSSLUnavailable()) {
                        networkGroupBean.setRefSSLPolicy("ssl_unavailable");
                    } else if (this.pnlReferralSSLPolicy.isSSLRequired()) {
                        networkGroupBean.setRefSSLPolicy("ssl_required");
                    } else {
                        networkGroupBean.setRefSSLPolicy("ssl_optional");
                    }
                } else {
                    networkGroupBean.setRefSSLPolicy("ssl_unavailable");
                }
                String string = (String)this.cboBindPolicy.getSelectedItem();
                if (string.equals(this.BIND_ANONYMOUS)) {
                    networkGroupBean.setRefBindPolicy("bind_anonymous");
                } else if (string.equals(this.BIND_ANY)) {
                    networkGroupBean.setRefBindPolicy("bind_any");
                } else if (string.equals(this.BIND_REQUIRED)) {
                    networkGroupBean.setRefBindPolicy("bind_required");
                }
                if (this.chkMaxRefCount.isSelected()) {
                    String string2 = this.tfMaxRefCount.getText().trim();
                    if (string2.equals("")) throw new ConfigurationViewException(this.getTitleText(), IDARResourceSet.getString("error", "ERR_NO_MAX_REF"));
                    Integer n = null;
                    try {
                        n = new Integer(string2);
                        networkGroupBean.setMaxRefcount(n);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string2);
                    }
                } else {
                    networkGroupBean.setMaxRefcount(new Integer(0));
                }
            }
            return;
        } else {
            Debug.println((String)("ReferralView:applyChanges(): model= " + networkGroupBean));
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupReferrals", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("ReferralView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.cboBindPolicy.setSelectedItem(this.BIND_ANY);
            this.tfMaxRefCount.setText(new Integer(15).toString());
            this.chkMaxRefCount.setSelected(true);
            String string = networkGroupBean.getReference();
            if (string.equals("discard")) {
                this.radDiscard.setSelected(true);
            } else if (string.equals("forward")) {
                this.radForward.setSelected(true);
            } else {
                this.radFollow.setSelected(true);
                String string2 = networkGroupBean.getRefSSLPolicy();
                if (string2.equals("ssl_unavailable")) {
                    this.pnlReferralSSLPolicy.setRadSSLUnavailable();
                } else if (string2.equals("ssl_required")) {
                    this.pnlReferralSSLPolicy.setRadSSLRequired();
                } else {
                    this.pnlReferralSSLPolicy.setRadSSLOptional();
                }
                String string3 = networkGroupBean.getRefBindPolicy();
                if (string3.equals("bind_anonymous")) {
                    this.cboBindPolicy.setSelectedItem(this.BIND_ANONYMOUS);
                } else if (string3.equals("bind_any")) {
                    this.cboBindPolicy.setSelectedItem(this.BIND_ANY);
                } else if (string3.equals("bind_required")) {
                    this.cboBindPolicy.setSelectedItem(this.BIND_REQUIRED);
                }
                Integer n = networkGroupBean.getMaxRefcount();
                this.chkMaxRefCount.setEnabled(true);
                if (n != 0) {
                    this.tfMaxRefCount.setText(networkGroupBean.getMaxRefcount().toString());
                    this.chkMaxRefCount.setSelected(true);
                } else {
                    this.chkMaxRefCount.setSelected(false);
                }
                this.setMaxRefCountEnablement(this.radFollow.isSelected());
            }
        } else {
            Debug.println((String)("ReferralView:resetContent(): model= " + networkGroupBean));
        }
        this.setButtonEnablement();
    }

    private void setMaxRefCountEnablement(boolean bl) {
        if (bl && this.chkMaxRefCount.isSelected()) {
            this.tfMaxRefCount.setEnabled(true);
            this.tfMaxRefCount.setBackground(Color.white);
        } else {
            this.tfMaxRefCount.setEnabled(false);
            this.tfMaxRefCount.setBackground(null);
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ReferralView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

