/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.DNDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import netscape.ldap.util.DN;

public class SubtreeHidingView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-DataHiding-Subtree";
    private JTable tblForbiddenSubtrees;
    private SubtreeHidingTableModel tableModel;
    private JTextArea txtNote;
    private JPanel pnlButtons;
    private JButton butAdd = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
    private JButton butEdit = IDARJButtonFactory.create(IDARResourceSet.getString("button", "EDIT"));
    private JButton butRemove = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
    protected static final String DN = IDARResourceSet.getString("groupDataHidingSubtree", "DN");
    protected static final String CRITERIA = IDARResourceSet.getString("groupDataHidingSubtree", "CRITERIA");
    protected static final String TYPE = IDARResourceSet.getString("groupDataHidingSubtree", "TYPE");

    public SubtreeHidingView() {
        this.initComponents();
    }

    public SubtreeHidingView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)"Unable to resetContent in Constructor");
        }
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.pnlButtons = this.initButtonBar();
        this.setLayout(new GridBagLayout());
        this.txtNote.setText(IDARResourceSet.getString("groupDataHidingSubtree", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.tableModel = new SubtreeHidingTableModel();
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                SubtreeHidingView.this.setEnablement();
            }
        });
        this.tblForbiddenSubtrees = new JTable(this.tableModel);
        this.tblForbiddenSubtrees.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_hidden_subtrees"));
        this.tblForbiddenSubtrees.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.tblForbiddenSubtrees.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.tblForbiddenSubtrees.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SubtreeHidingView.this.setEnablement();
            }
        });
        this.tblForbiddenSubtrees.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SubtreeHidingView.this.butEdit.doClick();
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this.tblForbiddenSubtrees), gridBagConstraints);
    }

    protected JPanel initButtonBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 6, 0));
        this.butAdd.setToolTipText(IDARResourceSet.getString("tooltip", "add_subtree_to_hide"));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(SubtreeHidingView.this), SubtreeHidingView.this.getConsoleInfo(), SubtreeHidingView.this.getDataModel().getParentConfiguration());
                dNDialog.showModal();
                if (!dNDialog.isCancel()) {
                    DN dN = dNDialog.getDN();
                    SubtreeHidingView.this.tableModel.addDn(dN);
                    SubtreeHidingView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SubtreeHidingView.this.tableModel)));
                }
            }
        });
        this.butAdd.setToolTipText(IDARResourceSet.getString("tooltip", "edit_subtree_to_hide"));
        this.butEdit.setEnabled(false);
        this.butEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = SubtreeHidingView.this.tblForbiddenSubtrees.getSelectedRow();
                if (n != -1 && (object = SubtreeHidingView.this.tableModel.getValueAt(n, 0)) instanceof DN) {
                    DN dN = (DN)object;
                    DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(SubtreeHidingView.this), SubtreeHidingView.this.getConsoleInfo(), SubtreeHidingView.this.getDataModel().getParentConfiguration(), dN);
                    dNDialog.showModal();
                    if (!dNDialog.isCancel()) {
                        dN = dNDialog.getDN();
                        SubtreeHidingView.this.tableModel.setValueAt(dN, n, 0);
                        SubtreeHidingView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SubtreeHidingView.this.tableModel)));
                    }
                }
            }
        });
        this.butAdd.setToolTipText(IDARResourceSet.getString("tooltip", "remove_subtree_to_hide"));
        this.butRemove.setEnabled(false);
        this.butRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SubtreeHidingView.this.tblForbiddenSubtrees.getSelectedRow();
                if (n != -1) {
                    SubtreeHidingView.this.tableModel.removeElement(n);
                }
                SubtreeHidingView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SubtreeHidingView.this.tableModel)));
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.butAdd);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.butEdit);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.butRemove);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void setEnablement() {
        boolean bl = this.tblForbiddenSubtrees.getRowCount() != 0 && this.tblForbiddenSubtrees.getSelectedRow() != -1 && this.tblForbiddenSubtrees.getRowCount() > this.tblForbiddenSubtrees.getSelectedRow();
        this.butRemove.setEnabled(bl);
        this.butEdit.setEnabled(bl);
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            networkGroupBean.setForbiddenSubtree(this.tableModel.getDns());
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupDataHidingSubtree", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("SubtreeHidingView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.tableModel.removeAll();
            Vector vector = new Vector();
            vector.addAll(networkGroupBean.getForbiddenSubtree());
            this.tableModel.setData(vector);
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SubtreeHidingView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public class SubtreeHidingTableModel
    extends AbstractTableModel {
        private Vector data = new Vector();

        public Object getValueAt(int n, int n2) {
            Object object = null;
            try {
                SHTMStruct sHTMStruct = (SHTMStruct)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        object = sHTMStruct.value;
                        break;
                    }
                    case 1: {
                        object = sHTMStruct.type;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                SHTMStruct sHTMStruct = (SHTMStruct)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        sHTMStruct.value = object;
                        break;
                    }
                    case 1: {
                        sHTMStruct.type = object.toString();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            this.fireTableDataChanged();
        }

        public void setData(Vector vector) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof DN)) continue;
                this.addDn((DN)e);
            }
            this.fireTableDataChanged();
        }

        public void addDn(DN dN) {
            this.data.addElement(new SHTMStruct(dN, DN));
            this.fireTableDataChanged();
        }

        public Vector getDns() {
            Vector<DN> vector = new Vector<DN>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                SHTMStruct sHTMStruct = (SHTMStruct)enumeration.nextElement();
                if (!sHTMStruct.type.equals(DN)) continue;
                vector.addElement((DN)sHTMStruct.value);
            }
            return vector;
        }

        public void removeElement(int n) {
            this.data.removeElementAt(n);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? CRITERIA : TYPE;
        }

        public void removeAll() {
            this.data.clear();
        }

        private class SHTMStruct {
            public Object value;
            public String type;

            SHTMStruct(Object object, String string) {
                this.value = object;
                this.type = string;
            }

            public String toString() {
                return "value=" + this.value.toString() + " type=" + this.type;
            }
        }
    }
}

