/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LogRotationView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Server-Configuration-Logs-Rotation";
    private JCheckBox chkLogMaxSize;
    private JCheckBox chkLogMaxFiles;
    private JTextField tfLogMaxSize;
    private JTextField tfLogMaxFiles;
    private JCheckBox chkAuditMaxSize;
    private JCheckBox chkAuditMaxFiles;
    private JTextField tfAuditMaxSize;
    private JTextField tfAuditMaxFiles;
    private BlankPanel pnlLogFile;
    private BlankPanel pnlAuditFile;

    public LogRotationView() {
        this.initComponents(true);
    }

    public LogRotationView(boolean bl, ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public LogRotationView(boolean bl) {
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        if (logPropertyBean != null) {
            String string = null;
            string = logPropertyBean.getLogMaxFilesize();
            if (string != null && !string.equals("")) {
                this.chkLogMaxSize.setSelected(true);
                this.tfLogMaxSize.setText(string);
            } else {
                this.chkLogMaxSize.setSelected(false);
                this.tfLogMaxSize.setText("");
            }
            string = logPropertyBean.getLogMaxFiles();
            if (string != null) {
                this.chkLogMaxFiles.setSelected(true);
                this.tfLogMaxFiles.setText(string);
            } else {
                this.chkLogMaxFiles.setSelected(false);
                this.tfLogMaxFiles.setText("");
            }
            string = logPropertyBean.getAuditMaxFilesize();
            if (string != null && !string.equals("")) {
                this.chkAuditMaxSize.setSelected(true);
                this.tfAuditMaxSize.setText(string);
            } else {
                this.chkAuditMaxSize.setSelected(false);
                this.tfAuditMaxSize.setText("");
            }
            string = logPropertyBean.getAuditMaxFiles();
            if (string != null) {
                this.chkAuditMaxFiles.setSelected(true);
                this.tfAuditMaxFiles.setText(string);
            } else {
                this.chkAuditMaxFiles.setSelected(false);
                this.tfAuditMaxFiles.setText("");
            }
            this.setButtonEnablement();
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        if (logPropertyBean != null) {
            if (this.chkLogMaxSize.isSelected() && (this.tfLogMaxSize.getText().equals("") || this.tfLogMaxSize.getText().equals("0"))) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_LOG_MAX_SIZE"));
            }
            if (this.chkLogMaxSize.isSelected()) {
                logPropertyBean.setLogMaxFilesize(this.tfLogMaxSize.getText());
            } else {
                logPropertyBean.setLogMaxFilesize(null);
            }
            if (this.chkLogMaxFiles.isSelected() && (this.tfLogMaxFiles.getText().equals("") || this.tfLogMaxFiles.getText().equals("0"))) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_LOG_MAX_FILES"));
            }
            if (this.chkLogMaxFiles.isSelected()) {
                logPropertyBean.setLogMaxFiles(this.tfLogMaxFiles.getText());
            } else {
                logPropertyBean.setLogMaxFiles(null);
            }
            if (this.chkAuditMaxSize.isSelected() && (this.tfAuditMaxSize.getText().equals("") || this.tfAuditMaxSize.getText().equals("0"))) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_AUDIT_MAX_SIZE"));
            }
            if (this.chkAuditMaxSize.isSelected()) {
                logPropertyBean.setAuditMaxFilesize(this.tfAuditMaxSize.getText());
            } else {
                logPropertyBean.setAuditMaxFilesize(null);
            }
            if (this.chkAuditMaxFiles.isSelected() && (this.tfAuditMaxFiles.getText().equals("") || this.tfAuditMaxFiles.getText().equals("0"))) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_AUDIT_MAX_FILES"));
            }
            if (this.chkAuditMaxFiles.isSelected()) {
                logPropertyBean.setAuditMaxFiles(this.tfAuditMaxFiles.getText());
            } else {
                logPropertyBean.setAuditMaxFiles(null);
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLogRotation", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.initComponents(true);
    }

    protected void initComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.chkLogMaxSize = new JCheckBox(IDARResourceSet.getString("propertyLogRotation", "LOG_ROTATION_MAX_SIZE") + ":");
        this.chkLogMaxSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogRotationView.this.setButtonEnablement();
            }
        });
        this.tfLogMaxSize = new JTextField(6);
        this.tfLogMaxSize.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogRotation", "LOG_ROTATION_MAX_SIZE"));
        this.tfLogMaxSize.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.chkLogMaxFiles = new JCheckBox(IDARResourceSet.getString("propertyLogRotation", "LOG_ROTATION_MAX_FILES") + ":");
        this.chkLogMaxFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogRotationView.this.setButtonEnablement();
            }
        });
        this.tfLogMaxFiles = new JTextField(6);
        this.tfLogMaxFiles.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogRotation", "LOG_ROTATION_MAX_FILES"));
        this.tfLogMaxFiles.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.chkAuditMaxSize = new JCheckBox(IDARResourceSet.getString("propertyLogRotation", "AUDIT_ROTATION_MAX_SIZE") + ":");
        this.chkAuditMaxSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogRotationView.this.setButtonEnablement();
            }
        });
        this.tfAuditMaxSize = new JTextField(6);
        this.tfAuditMaxSize.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogRotation", "AUDIT_ROTATION_MAX_SIZE"));
        this.tfAuditMaxSize.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.chkAuditMaxFiles = new JCheckBox(IDARResourceSet.getString("propertyLogRotation", "AUDIT_ROTATION_MAX_FILES") + ":");
        this.chkAuditMaxFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogRotationView.this.setButtonEnablement();
            }
        });
        this.tfAuditMaxFiles = new JTextField(6);
        this.tfAuditMaxFiles.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogRotation", "AUDIT_ROTATION_MAX_FILES"));
        this.tfAuditMaxSize.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.pnlLogFile = new BlankPanel();
        this.pnlLogFile.setLayout(new GridBagLayout());
        this.pnlLogFile.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLogRotation", "LOG_FILE")));
        this.pnlAuditFile = new BlankPanel();
        this.pnlAuditFile.setLayout(new GridBagLayout());
        this.pnlAuditFile.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLogRotation", "AUDIT_FILE")));
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        this.pnlLogFile.add((Component)this.chkLogMaxSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        this.pnlLogFile.add((Component)this.tfLogMaxSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        this.pnlLogFile.add((Component)new JLabel(IDARResourceSet.getString("propertyLogRotation", "SIZE")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        this.pnlLogFile.add((Component)this.chkLogMaxFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        this.pnlLogFile.add((Component)this.tfLogMaxFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 0;
        this.add((Component)this.pnlLogFile, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        this.pnlAuditFile.add((Component)this.chkAuditMaxSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        this.pnlAuditFile.add((Component)this.tfAuditMaxSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        this.pnlAuditFile.add((Component)new JLabel(IDARResourceSet.getString("propertyLogRotation", "SIZE")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        this.pnlAuditFile.add((Component)this.chkAuditMaxFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        this.pnlAuditFile.add((Component)this.tfAuditMaxFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 9;
        this.add((Component)this.pnlAuditFile, gridBagConstraints);
        this.setButtonEnablement();
    }

    private void setButtonEnablement() {
        if (this.chkLogMaxSize.isSelected()) {
            this.tfLogMaxSize.setEnabled(true);
            this.tfLogMaxSize.setBackground(Color.white);
        } else {
            this.tfLogMaxSize.setEnabled(false);
            this.tfLogMaxSize.setBackground(null);
        }
        if (this.chkLogMaxFiles.isSelected()) {
            this.tfLogMaxFiles.setEnabled(true);
            this.tfLogMaxFiles.setBackground(Color.white);
        } else {
            this.tfLogMaxFiles.setEnabled(false);
            this.tfLogMaxFiles.setBackground(null);
        }
        if (this.chkAuditMaxSize.isSelected()) {
            this.tfAuditMaxSize.setEnabled(true);
            this.tfAuditMaxSize.setBackground(Color.white);
        } else {
            this.tfAuditMaxSize.setEnabled(false);
            this.tfAuditMaxSize.setBackground(null);
        }
        if (this.chkAuditMaxFiles.isSelected()) {
            this.tfAuditMaxFiles.setEnabled(true);
            this.tfAuditMaxFiles.setBackground(Color.white);
        } else {
            this.tfAuditMaxFiles.setEnabled(false);
            this.tfAuditMaxFiles.setBackground(null);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LogRotationView(false));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

