/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.system;

import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SSLView
extends ConfigurationView
implements SuiConstants {
    private static final String TITLE = IDARResourceSet.getString("systemEncryption", "SSL_TLS_TAB_NAME");
    private static final String SETTINGS = IDARResourceSet.getString("systemEncryption", "SETTINGS");
    private static final String VERSION = IDARResourceSet.getString("systemEncryption", "VERSION");
    private static final String CLIENT_VERSION = IDARResourceSet.getString("systemEncryption", "CLIENT_VERSION");
    private static final String SERVER_VERSION = IDARResourceSet.getString("systemEncryption", "SERVER_VERSION");
    private static final String SSL_NONE = IDARResourceSet.getString("systemEncryption", "SSL_NONE");
    private static final String SSL_V_2_OR_3 = IDARResourceSet.getString("systemEncryption", "SSL_V_2_OR_3");
    private static final String SSL_V_2 = IDARResourceSet.getString("systemEncryption", "SSL_V_2");
    private static final String SSL_V_3 = IDARResourceSet.getString("systemEncryption", "SSL_V_3");
    private static final String TLS_V_1 = IDARResourceSet.getString("systemEncryption", "TLS_V_1");
    private static final String TLS_V1_OR_SSL_V3 = IDARResourceSet.getString("systemEncryption", "TLS_V1_OR_SSL_V3");
    private static final String TLS_V1_OR_SSL_V2 = IDARResourceSet.getString("systemEncryption", "TLS_V1_OR_SSL_V2");
    private static final String TLS_V1_OR_SSL_V2_OR_SSL_V3 = IDARResourceSet.getString("systemEncryption", "TLS_V1_OR_SSL_V2_OR_SSL_V3");
    private static final String SEND_CERT = IDARResourceSet.getString("systemEncryption", "SEND_CERT");
    private static final String REQ_CERT = IDARResourceSet.getString("systemEncryption", "REQ_CERT");
    private static final String CERT_SETUP_WIZARD = IDARResourceSet.getString("systemEncryption", "CERT_SETUP_WIZARD");
    protected static final String SSL_INFO_NOT_COMPLETE = IDARResourceSet.getString("error", "ERR_SSL_INFO_NOT_COMPLETE");
    private static final String HELP_TOPIC = "System-Settings-SSL";
    private ConsoleInfo info = null;
    private BlankPanel pnlSSLVersions;
    private JCheckBox chkSendCertAsClient;
    private JLabel lblClientSSLVersion;
    private JComboBox cbClientSSLVersion;
    private JLabel lblServerSSLVersion;
    private JComboBox cbServerSSLVersion;
    private JCheckBox chkRequireClientCert;
    private JComponent[] sslComps;

    public SSLView() {
        this((ConsoleInfo)null);
    }

    public SSLView(ConsoleInfo consoleInfo) {
        this.info = consoleInfo;
        this.initComponents();
    }

    public SSLView(ConsoleInfo consoleInfo, SystemBean systemBean) {
        this.info = consoleInfo;
        this.setDataModel(systemBean, false);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void resetContent() throws ConfigurationViewException {
        SystemBean systemBean = (SystemBean)this.getDataModel();
        if (systemBean != null) {
            this.setViewEnabled(true);
            this.chkSendCertAsClient.setSelected(systemBean.isSendCertificateAsClientEnabled());
            this.chkRequireClientCert.setSelected(systemBean.isSslCertificateRequired());
            String string = systemBean.getClientSslVersion();
            if (string.equals("0")) {
                this.cbClientSSLVersion.setSelectedItem(SSL_NONE);
            } else if (string.equals("2")) {
                this.cbClientSSLVersion.setSelectedItem(SSL_V_2);
            } else if (string.equals("1")) {
                this.cbClientSSLVersion.setSelectedItem(SSL_V_3);
            } else if (string.equals("3")) {
                this.cbClientSSLVersion.setSelectedItem(SSL_V_2_OR_3);
            } else if (string.equals("4")) {
                this.cbClientSSLVersion.setSelectedItem(TLS_V_1);
            } else if (string.equals("5")) {
                this.cbClientSSLVersion.setSelectedItem(TLS_V1_OR_SSL_V3);
            } else if (string.equals("6")) {
                this.cbClientSSLVersion.setSelectedItem(TLS_V1_OR_SSL_V2);
            } else if (string.equals("7")) {
                this.cbClientSSLVersion.setSelectedItem(TLS_V1_OR_SSL_V2_OR_SSL_V3);
            }
            String string2 = systemBean.getServerSslVersion();
            if (string2.equals("0")) {
                this.cbServerSSLVersion.setSelectedItem(SSL_NONE);
            } else if (string2.equals("2")) {
                this.cbServerSSLVersion.setSelectedItem(SSL_V_2);
            } else if (string2.equals("1")) {
                this.cbServerSSLVersion.setSelectedItem(SSL_V_3);
            } else if (string2.equals("3")) {
                this.cbServerSSLVersion.setSelectedItem(SSL_V_2_OR_3);
            } else if (string2.equals("4")) {
                this.cbServerSSLVersion.setSelectedItem(TLS_V_1);
            } else if (string2.equals("5")) {
                this.cbServerSSLVersion.setSelectedItem(TLS_V1_OR_SSL_V3);
            } else if (string2.equals("6")) {
                this.cbServerSSLVersion.setSelectedItem(TLS_V1_OR_SSL_V2);
            } else if (string2.equals("7")) {
                this.cbServerSSLVersion.setSelectedItem(TLS_V1_OR_SSL_V2_OR_SSL_V3);
            }
        } else {
            this.setViewEnabled(false);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        SystemBean systemBean = (SystemBean)this.getDataModel();
        if (systemBean != null) {
            systemBean.setSendCertificateAsClientEnabled(this.chkSendCertAsClient.isSelected());
            systemBean.setSslCertificateRequired(this.chkRequireClientCert.isSelected());
            String string = this.cbClientSSLVersion.getSelectedItem().toString();
            if (string.equals(SSL_NONE)) {
                systemBean.setClientSslVersion("0");
            } else if (string.equals(SSL_V_2)) {
                systemBean.setClientSslVersion("2");
            } else if (string.equals(SSL_V_3)) {
                systemBean.setClientSslVersion("1");
            } else if (string.equals(SSL_V_2_OR_3)) {
                systemBean.setClientSslVersion("3");
            } else if (string.equals(TLS_V_1)) {
                systemBean.setClientSslVersion("4");
            } else if (string.equals(TLS_V1_OR_SSL_V3)) {
                systemBean.setClientSslVersion("5");
            } else if (string.equals(TLS_V1_OR_SSL_V2)) {
                systemBean.setClientSslVersion("6");
            } else if (string.equals(TLS_V1_OR_SSL_V2_OR_SSL_V3)) {
                systemBean.setClientSslVersion("7");
            }
            String string2 = this.cbServerSSLVersion.getSelectedItem().toString();
            if (string2.equals(SSL_NONE)) {
                systemBean.setServerSslVersion("0");
            } else if (string2.equals(SSL_V_2)) {
                systemBean.setServerSslVersion("2");
            } else if (string2.equals(SSL_V_3)) {
                systemBean.setServerSslVersion("1");
            } else if (string2.equals(SSL_V_2_OR_3)) {
                systemBean.setServerSslVersion("3");
            } else if (string2.equals(TLS_V_1)) {
                systemBean.setServerSslVersion("4");
            } else if (string2.equals(TLS_V1_OR_SSL_V3)) {
                systemBean.setServerSslVersion("5");
            } else if (string2.equals(TLS_V1_OR_SSL_V2)) {
                systemBean.setServerSslVersion("6");
            } else if (string2.equals(TLS_V1_OR_SSL_V2_OR_SSL_V3)) {
                systemBean.setServerSslVersion("7");
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return TITLE;
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.pnlSSLVersions = new BlankPanel();
        this.pnlSSLVersions.addBlankPanelListener(this);
        this.chkSendCertAsClient = new JCheckBox();
        this.lblClientSSLVersion = new JLabel();
        this.cbClientSSLVersion = new JComboBox();
        this.lblServerSSLVersion = new JLabel();
        this.cbServerSSLVersion = new JComboBox();
        this.chkRequireClientCert = new JCheckBox();
        this.sslComps = new JComponent[]{this.chkSendCertAsClient, this.lblClientSSLVersion, this.cbClientSSLVersion, this.lblServerSSLVersion, this.cbServerSSLVersion, this.chkRequireClientCert, this.pnlSSLVersions};
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.chkSendCertAsClient.setText(SEND_CERT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.chkSendCertAsClient, gridBagConstraints);
        this.chkRequireClientCert.setText(REQ_CERT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.chkRequireClientCert, gridBagConstraints);
        this.pnlSSLVersions.setBorder(BorderFactory.createTitledBorder(VERSION));
        this.pnlSSLVersions.setLayout(new GridBagLayout());
        this.lblClientSSLVersion.setText(CLIENT_VERSION + ":");
        this.lblClientSSLVersion.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 1.0;
        this.pnlSSLVersions.add((Component)this.lblClientSSLVersion, gridBagConstraints);
        this.cbClientSSLVersion.addItem(SSL_NONE);
        this.cbClientSSLVersion.addItem(SSL_V_2_OR_3);
        this.cbClientSSLVersion.addItem(SSL_V_2);
        this.cbClientSSLVersion.addItem(SSL_V_3);
        this.cbClientSSLVersion.addItem(TLS_V_1);
        this.cbClientSSLVersion.addItem(TLS_V1_OR_SSL_V3);
        this.cbClientSSLVersion.addItem(TLS_V1_OR_SSL_V2);
        this.cbClientSSLVersion.addItem(TLS_V1_OR_SSL_V2_OR_SSL_V3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlSSLVersions.add((Component)this.cbClientSSLVersion, gridBagConstraints);
        this.lblServerSSLVersion.setText(SERVER_VERSION + ":");
        this.lblServerSSLVersion.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 1.0;
        this.pnlSSLVersions.add((Component)this.lblServerSSLVersion, gridBagConstraints);
        this.cbServerSSLVersion.addItem(SSL_NONE);
        this.cbServerSSLVersion.addItem(SSL_V_2_OR_3);
        this.cbServerSSLVersion.addItem(SSL_V_2);
        this.cbServerSSLVersion.addItem(SSL_V_3);
        this.cbServerSSLVersion.addItem(TLS_V_1);
        this.cbServerSSLVersion.addItem(TLS_V1_OR_SSL_V3);
        this.cbServerSSLVersion.addItem(TLS_V1_OR_SSL_V2);
        this.cbServerSSLVersion.addItem(TLS_V1_OR_SSL_V2_OR_SSL_V3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlSSLVersions.add((Component)this.cbServerSSLVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSSLVersions, gridBagConstraints);
    }

    protected void setSSLSettingsComponentsEnabled(boolean bl) {
        for (int i = 0; i < this.sslComps.length; ++i) {
            this.sslComps[i].setEnabled(bl);
        }
    }

    private void setViewEnabled(boolean bl) {
        this.setEnabled(bl);
        this.chkSendCertAsClient.setEnabled(bl);
        this.chkRequireClientCert.setEnabled(bl);
        this.cbClientSSLVersion.setEnabled(bl);
        this.cbServerSSLVersion.setEnabled(bl);
        this.lblClientSSLVersion.setEnabled(bl);
        this.lblServerSSLVersion.setEnabled(bl);
        this.pnlSSLVersions.setEnabled(bl);
        if (bl) {
            ((TitledBorder)this.pnlSSLVersions.getBorder()).setTitleColor(Color.black);
            this.cbClientSSLVersion.setBackground(Color.white);
            this.cbServerSSLVersion.setBackground(Color.white);
        } else {
            ((TitledBorder)this.pnlSSLVersions.getBorder()).setTitleColor(Color.gray);
            this.cbClientSSLVersion.setBackground(null);
            this.cbServerSSLVersion.setBackground(null);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SSLView(null, null));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

