/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.system;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.system.ConnectionsView;
import com.iplanet.idar.ui.configurator.system.GeneralView;
import com.iplanet.idar.ui.configurator.system.SSLView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SystemView
extends ConfigurationView
implements SuiConstants {
    private static final String SETTINGS = IDARResourceSet.getString("system", "SETTINGS");
    private static final String ENCRYPTION = IDARResourceSet.getString("system", "ENCRYPTION");
    private static final String CONNECTIONS = IDARResourceSet.getString("system", "CONNECTIONS");
    protected static final String TITLE = IDARResourceSet.getString("system", "TITLE");
    protected static final String SSL_INFO_NOT_COMPLETE = IDARResourceSet.getString("error", "ERR_SSL_INFO_NOT_COMPLETE");
    private static final String ERR_NO_ID = IDARResourceSet.getString("error", "ERR_NO_ID");
    protected static final Icon ICON = ImageFactory.getImage("SYSTEM");
    private static final String NAME = IDARResourceSet.getString("systemGeneral", "SYSTEM_NAME");
    private JLabel lblName;
    private JTextField tfName;
    GeneralView viewGeneral;
    ConfigurationView viewConnections;
    ConfigurationView viewEncryption;
    JScrollPane spGeneral;
    JScrollPane spConnections;
    JScrollPane spEncryption;
    JTabbedPane tabs;

    public SystemView() {
        this.initComponents();
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewGeneral != null) {
            this.viewGeneral.setConsoleInfo(consoleInfo);
            this.viewEncryption.setConsoleInfo(consoleInfo);
            this.viewConnections.setConsoleInfo(consoleInfo);
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("DataHidingView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.viewGeneral != null) {
            this.viewGeneral.setDataModel(iDARModelBean, bl);
            this.viewConnections.setDataModel(iDARModelBean, bl);
            this.viewEncryption.setDataModel(iDARModelBean, bl);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public String getHelpTopic() {
        String string = null;
        int n = this.tabs.getSelectedIndex();
        if (n != -1) {
            String string2 = this.tabs.getTitleAt(n);
            if (SETTINGS.equals(string2)) {
                string = this.viewGeneral.getHelpTopic();
            } else if (CONNECTIONS.equals(string2)) {
                string = this.viewConnections.getHelpTopic();
            } else if (ENCRYPTION.equals(string2)) {
                string = this.viewEncryption.getHelpTopic();
            }
        }
        return string;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return TITLE;
    }

    public void applyChanges() throws ConfigurationViewException {
        block12: {
            if (this.tfName.getText().trim().equals("")) {
                throw new ConfigurationViewException(ERR_NO_ID);
            }
            try {
                SystemBean systemBean = (SystemBean)super.getDataModel();
                if (systemBean == null) break block12;
                if (!systemBean.getConfigurationName().equals(this.tfName.getText())) {
                    try {
                        systemBean.setConfigurationName(this.tfName.getText());
                    }
                    catch (UniqueNameException uniqueNameException) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                    }
                }
                try {
                    this.viewGeneral.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.tabs.setSelectedComponent(this.spGeneral);
                    throw configurationViewException;
                }
                try {
                    this.viewConnections.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.tabs.setSelectedComponent(this.spConnections);
                    throw configurationViewException;
                }
                try {
                    this.viewEncryption.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.tabs.setSelectedComponent(this.spEncryption);
                    throw configurationViewException;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((int)6, (String)"SystemView.resetContent");
        try {
            SystemBean systemBean = (SystemBean)super.getDataModel();
            if (systemBean != null) {
                this.tfName.setText(systemBean.getId());
                this.viewGeneral.resetContent();
                this.viewConnections.resetContent();
                this.viewEncryption.resetContent();
            }
        }
        catch (ClassCastException classCastException) {
            Debug.println((int)6, (String)"SystemView.resetContent:  model not of type SystemBean");
        }
    }

    protected void initComponents() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setIcon(ICON);
        titlePanel.setText(TITLE);
        this.lblName = new JLabel();
        this.lblName.setText(NAME + ":");
        this.tfName = new JTextField();
        this.tabs = new JTabbedPane();
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        ConsoleInfo consoleInfo = super.getConsoleInfo();
        this.viewGeneral = new GeneralView(consoleInfo);
        this.viewGeneral.addBlankPanelListener(this);
        this.spGeneral = new JScrollPane(this.viewGeneral.getPanel());
        this.spGeneral.setBorder(emptyBorder);
        this.tabs.add(SETTINGS, this.spGeneral);
        this.viewConnections = new ConnectionsView(consoleInfo);
        this.viewConnections.addBlankPanelListener(this);
        this.spConnections = new JScrollPane(this.viewConnections.getPanel());
        this.spConnections.setBorder(emptyBorder);
        this.tabs.add(CONNECTIONS, this.spConnections);
        this.viewEncryption = new SSLView(consoleInfo);
        this.viewEncryption.addBlankPanelListener(this);
        this.spEncryption = new JScrollPane(this.viewEncryption.getPanel());
        this.spEncryption.setBorder(emptyBorder);
        this.tabs.add(ENCRYPTION, this.spEncryption);
        this.setLayout(new BorderLayout(9, 9));
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)titlePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        this.add((Component)blankPanel, "North");
        this.add((Component)this.tabs, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SystemView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

