/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.server.ServerStatusAdapter;
import com.iplanet.idar.server.ServerStatusEvent;
import com.iplanet.idar.task.Task;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.TaskEventManager;
import com.iplanet.idar.task.TaskManagerFactory;
import com.iplanet.idar.task.idar.PingTask;
import com.iplanet.idar.ui.common.IDARFramework;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.configurator.ConfiguratorTopologyPlugin;
import com.iplanet.idar.ui.server.IDARServerFrameworkInitializer;
import com.iplanet.idar.ui.task.IplanetTaskEventManager;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.StatusItemSecureMode;
import com.netscape.management.client.StatusItemSpacer;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AbstractServerObject;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;

public class IDARServer
extends AbstractServerObject
implements SuiConstants {
    protected StatusItemSpacer _statusSpacer = new StatusItemSpacer("SECURE_MODE_SPACER");
    protected StatusItemSecureMode _statusSecureMode = new StatusItemSecureMode("StatusItemSecureMode");
    private ServerStatusAdapter statusListener = new ServerStatusAdapter(){

        public void statusMessageChanged(ServerStatusEvent serverStatusEvent) {
            if (IDARServer.this.frame != null) {
                String string = serverStatusEvent == null ? "" : serverStatusEvent.getMessage();
                IDARServer.this.frame.changeStatusItemState("StatusItemText", string);
            }
        }
    };
    private TaskAdapter statusReporter = new TaskAdapter(){

        public void taskStopped(TaskEvent taskEvent) {
            Task task = taskEvent.getTask();
            if (task != null && task instanceof PingTask && IDARServer.this.frame != null) {
                String string = STATUS_UNKNOWN_STRING;
                switch (((PingTask)task).getPingResult()) {
                    case 1: {
                        string = STATUS_STARTED_STRING;
                        break;
                    }
                    case 2: {
                        string = STATUS_STOPPED_STRING;
                        break;
                    }
                    case 3: {
                        string = STATUS_ALERT_STRING;
                    }
                }
                IDARServer.this.frame.changeStatusItemState("StatusItemText", string);
            }
        }
    };
    private static final String STATUS_UNKNOWN_STRING = IDARResourceSet.getString("status", "unknown");
    private static final String STATUS_STARTED_STRING = IDARResourceSet.getString("status", "started");
    private static final String STATUS_STOPPED_STRING = IDARResourceSet.getString("status", "stopped");
    private static final String STATUS_ALERT_STRING = IDARResourceSet.getString("status", "alert");
    private static final String STATUS_STRING = IDARResourceSet.getString("status", "status");
    private IDARBean idar;
    private IDARFramework frame = null;

    public static ResourceSet getResourceSet() {
        return IDARResourceSet.getResourceSet();
    }

    public void initialize(final ConsoleInfo consoleInfo) {
        super.initialize(consoleInfo);
        boolean bl = consoleInfo.get((Object)"ldapSecurity").equals("on");
        this._statusSecureMode.setSecureMode(bl);
        this.setIcon((Icon)ImageFactory.getImage("IDAR_SERVER_NODE"));
        if (!BeanSpace.isInitialized()) {
            ConfiguratorTopologyPlugin.initBeanSpace(consoleInfo);
            ConfiguratorTopologyPlugin.createResources(consoleInfo);
        }
        TaskManagerFactory.setContextIndicator(3);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String string;
                String string2 = null;
                if (consoleInfo != null && (string = consoleInfo.getCurrentDN()) != null) {
                    string2 = string.substring(string.indexOf(61) + 1, string.indexOf(44)).trim();
                }
                if (string2 != null) {
                    try {
                        IDARServer.this.idar = (IDARBean)BeanSpace.getInstance().retrieveBean(string2, "idar-server", IDARReference.NULL_REFERENCE);
                        IDARServer.this.startPinger(IDARServer.this.idar, IDARServer.this.frame);
                    }
                    catch (IDARBeanException iDARBeanException) {
                        Debug.println((String)("IDARServer.initialize:  ERROR:  could not retrieve idar bean " + string2));
                    }
                } else {
                    Debug.println((String)"IDARServer.initialize:  ERROR:  unable to determine server id");
                }
            }
        });
        thread.setName("iDAR Server Bean Loader");
        thread.start();
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        if (iResourceObjectArray.length == 1) {
            return this.run(iPage);
        }
        return false;
    }

    public void cloneFrom(String string) {
    }

    public boolean isCloningEnabled() {
        return false;
    }

    public synchronized int getServerStatus() {
        int n = 0;
        if (this.idar != null) {
            return this.idar.getStatusCode();
        }
        return n;
    }

    protected void createFramework() {
        String string = IDARServerFrameworkInitializer.getServerId(this._consoleInfo.getLDAPConnection(), this._consoleInfo.getCurrentDN());
        this.frame = IDARFramework.getInstance(string);
        IDARServerFrameworkInitializer iDARServerFrameworkInitializer = null;
        if (this.frame == null) {
            iDARServerFrameworkInitializer = new IDARServerFrameworkInitializer(this._consoleInfo, (INodeInfo)this);
            this.frame = IDARFramework.getInstance(iDARServerFrameworkInitializer);
            try {
                this.frame.setHelpAdminURL(new URL(this._consoleInfo.getAdminURL()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.frame.getState() == 1) {
            this.frame.setState(0);
        }
        this.startPinger(this.idar, this.frame);
        this.populateStatusItems();
    }

    private boolean run(IPage iPage) {
        this.createFramework();
        return true;
    }

    private void startPinger(IDARBean iDARBean, IDARFramework iDARFramework) {
        if (iDARBean != null) {
            iDARBean.addServerStatusListener(this.statusListener);
            if (iDARFramework != null) {
                iDARFramework.changeStatusItemState("StatusItemText", STATUS_STRING + iDARBean.getStatusMessage());
            }
            PingTask pingTask = iDARBean.getPingTask();
            pingTask.addTaskListener(this.statusReporter);
            TaskEventManager taskEventManager = pingTask.getEventManager();
            if (taskEventManager instanceof IplanetTaskEventManager) {
                Debug.println((String)("IDARServer.beanLoader: set pinger framework to " + (Object)((Object)iDARFramework)));
                ((IplanetTaskEventManager)taskEventManager).showProgressOnFramework(false);
                ((IplanetTaskEventManager)taskEventManager).showStatusMessagesOnFramework(false);
            }
        }
    }

    protected void populateStatusItems() {
        Debug.println((String)"IDARServer.populateStatusItems");
        this.frame.addStatusItem((IStatusItem)this._statusSpacer, "LF");
        this.frame.addStatusItem((IStatusItem)this._statusSecureMode, "LF");
    }
}

