/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.task.TaskManagerFactory;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.common.configuration.DynamicConfigurationView;
import com.iplanet.idar.ui.common.configuration.EmbeddedConfigurationView;
import com.iplanet.idar.ui.configurator.property.FilesView;
import com.iplanet.idar.ui.configurator.property.LogLevelView;
import com.iplanet.idar.ui.configurator.property.LogRotationView;
import com.iplanet.idar.ui.configurator.property.StatisticsView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class IDARLogView
extends EmbeddedConfigurationView
implements SuiConstants {
    private PropertyChangeListener systemListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                IDARLogView.this.resetContent();
            }
            catch (ConfigurationViewException configurationViewException) {
                configurationViewException.printStackTrace();
            }
        }
    };
    DynamicLogView logView = null;

    public IDARLogView() {
        this.initComponents(true);
    }

    public IDARLogView(ConsoleInfo consoleInfo, IDARBean iDARBean) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents(true);
        this.setDataModel(iDARBean);
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        SystemBean systemBean;
        IDARBean iDARBean = (IDARBean)iDARModelBean;
        IDARBean iDARBean2 = (IDARBean)this.getDataModel();
        if (iDARBean2 != null && (systemBean = iDARBean2.getSystemBean()) != null) {
            systemBean.removePropertyChangePersistanceListener(this.systemListener);
        }
        if (iDARBean != null && (systemBean = iDARBean.getSystemBean()) != null) {
            systemBean.addPropertyChangePersistanceListener(this.systemListener);
        }
        super.setDataModel(iDARBean, bl);
    }

    public IDARReference getCurrentItem() {
        SystemBean systemBean;
        IDARReference iDARReference = null;
        IDARBean iDARBean = (IDARBean)this.getDataModel();
        if (iDARBean != null && (systemBean = iDARBean.getSystemBean()) != null) {
            iDARReference = systemBean.getLogProperty();
        }
        return iDARReference;
    }

    public void setCurrentItem(IDARReference iDARReference) {
        IDARBean iDARBean = (IDARBean)this.getDataModel();
        if (iDARBean != null) {
            SystemBean systemBean = iDARBean.getSystemBean();
            if (systemBean != null) {
                systemBean.setLogProperty(iDARReference);
            } else {
                Debug.println((String)("IDARLogView.setCurrentItem: ERROR idar " + iDARBean + " has no system"));
            }
        }
    }

    protected void initComponents() {
        this.initComponents(true);
    }

    protected void initComponents(boolean bl) {
        this.logView = new DynamicLogView(this.getConsoleInfo());
        JLabel jLabel = new JLabel();
        jLabel.setText(IDARResourceSet.getString("common", "settings_saved_as") + ":");
        jLabel.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        super.initComponents(this.logView, jLabel, "log", IDARReference.NULL_REFERENCE, true);
    }

    public String getTitleText() {
        return IDARResourceSet.getString("serverLog", "TITLE");
    }

    public String getHelpTopic() {
        return this.logView.getHelpTopic();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        TaskManagerFactory.setContextIndicator(3);
        jFrame.getContentPane().add(new IDARLogView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class DynamicLogView
    extends DynamicConfigurationView {
        private JTabbedPane tabViews = null;
        private BlankPanel pnlLogs;
        private StatisticsView viewStatistics;
        private FilesView viewFiles;
        private LogLevelView viewLogLevels;
        private LogRotationView viewLogRotation;

        DynamicLogView(ConsoleInfo consoleInfo) {
            this.viewStatistics = new StatisticsView(true, consoleInfo);
            this.viewFiles = new FilesView(true, consoleInfo);
            this.viewLogLevels = new LogLevelView(true, consoleInfo);
            this.viewLogRotation = new LogRotationView(true, consoleInfo);
        }

        public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
            Debug.println((int)6, (String)("IDARLogView.DynamicLogView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
            this.viewStatistics.setDataModel(iDARModelBean, false);
            this.viewFiles.setDataModel(iDARModelBean, false);
            this.viewLogLevels.setDataModel(iDARModelBean, false);
            this.viewLogRotation.setDataModel(iDARModelBean, false);
            super.setDataModel(iDARModelBean, bl);
        }

        public String getHelpTopic() {
            String string = this.tabViews.getTitleAt(this.tabViews.getSelectedIndex());
            String string2 = null;
            if (string.equals(this.viewStatistics.getTitleText())) {
                string2 = this.viewStatistics.getHelpTopic();
            } else if (string.equals(this.viewFiles.getTitleText())) {
                string2 = this.viewFiles.getHelpTopic();
            } else if (string.equals(this.viewLogLevels.getTitleText())) {
                string2 = this.viewLogLevels.getHelpTopic();
            } else if (string.equals(this.viewLogRotation.getTitleText())) {
                string2 = this.viewLogRotation.getHelpTopic();
            }
            return string2;
        }

        public void resetContent() throws ConfigurationViewException {
            Debug.println((int)6, (String)"IDARLogView.DynamicLogView.resetContent");
            this.viewStatistics.resetContentEventlessly();
            this.viewFiles.resetContentEventlessly();
            this.viewLogLevels.resetContentEventlessly();
            this.viewLogRotation.resetContentEventlessly();
        }

        public void applyChanges() throws ConfigurationViewException {
            Debug.println((int)7, (String)"IDARLogView.DynamicLogView.applyChanges");
            try {
                this.viewStatistics.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewStatistics.getTitleText()));
                throw configurationViewException;
            }
            try {
                this.viewFiles.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewFiles.getTitleText()));
                throw configurationViewException;
            }
            try {
                this.viewLogLevels.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewLogLevels.getTitleText()));
                throw configurationViewException;
            }
            try {
                this.viewLogRotation.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewLogRotation.getTitleText()));
                throw configurationViewException;
            }
        }

        public String getTitleText() {
            return "logView";
        }

        public JPanel getContentPanel() {
            if (this.pnlLogs == null) {
                this.pnlLogs = new BlankPanel();
                this.pnlLogs.setLayout(new BorderLayout());
                this.viewStatistics.addBlankPanelListener(this);
                this.viewFiles.addBlankPanelListener(this);
                this.viewLogLevels.addBlankPanelListener(this);
                this.viewLogRotation.addBlankPanelListener(this);
                this.tabViews = new JTabbedPane(4);
                this.tabViews.addTab(this.viewStatistics.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewStatistics.getPanel()));
                this.tabViews.addTab(this.viewFiles.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewFiles.getPanel()));
                this.tabViews.addTab(this.viewLogLevels.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewLogLevels.getPanel()));
                this.tabViews.addTab(this.viewLogRotation.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewLogRotation.getPanel()));
                this.pnlLogs.add(this.tabViews);
            }
            return this.pnlLogs;
        }
    }
}

