/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenerAdapter;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.server.configuration.ConfigurationPageResourceModel;
import com.iplanet.idar.ui.server.configuration.IDARTabView;
import com.iplanet.idar.ui.server.configuration.LoggingNode;
import com.iplanet.idar.ui.server.configuration.ManagingConfigurationView;
import com.iplanet.idar.ui.server.configuration.NetworkGroupsNode;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class IDARServerNode
extends ResourceObject {
    private static final String NAME = IDARResourceSet.getString("config", "IDAR_NAME");
    private int theCount = 0;
    private ConsoleInfo info;
    private IDARBean idarBean = null;
    private ManagingConfigurationView mView = null;
    private String serverId = null;
    private String serverRoot = null;
    private ResourceModel resourceModel = null;
    private SystemBeanListener systemBeanListener = null;
    private SystemBean systemBean = null;
    private IDARTabView tabViews;
    private LoggingNode loggingNode;
    private NetworkGroupsNode networkGroupsNode;

    public IDARServerNode(ConsoleInfo consoleInfo, ConfigurationPageResourceModel configurationPageResourceModel) {
        super(NAME);
        Debug.println((int)5);
        this.info = consoleInfo;
        this.resourceModel = configurationPageResourceModel;
        this.serverRoot = this.getServerRoot(configurationPageResourceModel);
        this.setAllowsChildren(true);
        this.serverId = IDARUtilities.getServerId(consoleInfo.getCurrentDN());
        this.systemBeanListener = new SystemBeanListener();
        this.tabViews = new IDARTabView(this, consoleInfo);
        this.mView = new ManagingConfigurationView(consoleInfo, this.tabViews);
    }

    public IDARBean getModel() {
        return this.idarBean;
    }

    public void setModel(final IDARBean iDARBean) {
        Debug.println((int)7, (String)("IDARServerNode.setModel: model=" + iDARBean));
        this.idarBean = iDARBean;
        String string = NAME;
        if (this.idarBean != null) {
            SystemBean systemBean = this.idarBean.getSystemBean();
            if (systemBean != null) {
                String string2 = systemBean.getHost();
                if ("localhost".equalsIgnoreCase(string2)) {
                    string2 = this.idarBean.getHostName();
                }
                string = string2 + ":" + systemBean.getPort();
            } else {
                string = this.idarBean.getHostName();
            }
            this.idarBean.addBeanListener(new BeanListenerAdapter(){

                public void beanPersisted(BeanEvent beanEvent) {
                    IDARServerNode.this.setChildren(iDARBean);
                }
            });
            this.setChildren(iDARBean);
        }
        this.setName(string);
    }

    public void treeStructureChanged(ResourceObject resourceObject) {
        if (this.resourceModel != null) {
            if (resourceObject == null) {
                resourceObject = this;
            }
            this.resourceModel.fireTreeStructureChanged(resourceObject);
        }
    }

    private void setChildren(IDARBean iDARBean) {
        Debug.println((int)7, (String)"IDARServerNode.setChildren");
        if (iDARBean != null) {
            this.systemBean = iDARBean.getSystemBean();
            if (this.systemBean != null) {
                this.systemBean.removeBeanListener(this.systemBeanListener);
                this.systemBean.removePropertyChangePersistanceListener("ids-proxy-con-include-logproperty", this.systemBeanListener);
                this.systemBean.addBeanListener(this.systemBeanListener);
                this.systemBean.addPropertyChangePersistanceListener("ids-proxy-con-include-logproperty", this.systemBeanListener);
            }
        } else {
            Debug.println((int)6, (String)"IDARServerNode.setChildren:  ERROR:  null idar bean");
        }
        if (this.networkGroupsNode == null) {
            this.networkGroupsNode = new NetworkGroupsNode(this.info, iDARBean, this.mView);
            this.add((MutableTreeNode)((Object)this.networkGroupsNode));
        }
        if (this.loggingNode == null) {
            this.loggingNode = new LoggingNode(this.info, iDARBean, this.mView);
            this.add((MutableTreeNode)((Object)this.loggingNode));
        }
        if (this.theCount == 0) {
            this.theCount = 1;
            this.treeStructureChanged(this);
            try {
                final JTree jTree = ((ConfigurationPageResourceModel)this.resourceModel).getTree();
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (jTree.isRootVisible()) {
                                jTree.setSelectionRow(0);
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Icon getIcon() {
        return ImageFactory.getImage("IDAR_SERVER_NODE");
    }

    public String getServerId() {
        return this.serverId;
    }

    public Component getCustomPanel() {
        Debug.println((int)7, (String)"IDARServerNode.getCustomPanel()");
        if (this.mView.isNeedsReloading()) {
            this.mView.setModelInfo(IDARReference.NULL_REFERENCE, this.getServerId(), "idar-server");
        } else {
            this.mView.showView(this.tabViews.getTitleText());
        }
        return this.mView;
    }

    protected String getServerRoot() {
        return this.serverRoot;
    }

    protected String getServerRoot(ConfigurationPageResourceModel configurationPageResourceModel) {
        String string = null;
        INodeInfo iNodeInfo = configurationPageResourceModel.getNodeInfo();
        if (iNodeInfo != null) {
            for (int i = 0; i < iNodeInfo.getNodeDataCount(); ++i) {
                Object object;
                NodeData nodeData = iNodeInfo.getNodeData(i);
                if (nodeData == null || !nodeData.getName().equals("Server root") || !((object = nodeData.getValue()) instanceof String)) continue;
                string = (String)object;
            }
        }
        return string;
    }

    public class SystemBeanListener
    extends BeanListenerAdapter
    implements PropertyChangeListener {
        public void beanLoaded(BeanEvent beanEvent) {
        }

        public void beanDeleted(BeanEvent beanEvent) {
            IDARServerNode.this.setChildren(IDARServerNode.this.getModel());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IDARServerNode.this.setChildren(IDARServerNode.this.getModel());
        }
    }
}

