/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.server.configuration.IDAREncryptionPanel;
import com.iplanet.idar.ui.server.configuration.IDARServerNode;
import com.iplanet.idar.ui.server.configuration.IDARView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class IDARTabView
extends ConfigurationView
implements SuiConstants {
    private IDARServerNode node;
    private JTabbedPane tabViews;
    private ConfigurationView viewSettings;
    private ConfigurationView viewEncryption;

    public IDARTabView() {
        this(null, null);
    }

    public IDARTabView(IDARServerNode iDARServerNode, ConsoleInfo consoleInfo) {
        this.node = iDARServerNode;
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((int)7, (String)("IDARTabView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (iDARModelBean != null && this.node != null) {
            this.node.setModel((IDARBean)iDARModelBean);
        }
        if (this.viewSettings != null) {
            this.viewSettings.setDataModel(iDARModelBean, false);
        }
        if (this.viewEncryption != null) {
            this.viewEncryption.setDataModel(iDARModelBean, false);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((String)"IDARTabView.resetConstent()");
        try {
            this.viewSettings.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSettings.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewEncryption.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewEncryption.getPanel());
            throw configurationViewException;
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        Debug.println((String)"IDARTabView.applyChanges");
        try {
            this.viewSettings.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSettings);
            throw configurationViewException;
        }
        try {
            this.viewEncryption.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewEncryption);
            throw configurationViewException;
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return "idartabs";
    }

    public String getHelpTopic() {
        String string = "";
        Component component = this.tabViews.getSelectedComponent();
        if (component instanceof ConfigurationView) {
            ConfigurationView configurationView = (ConfigurationView)component;
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        Debug.println((String)("IDARTabView.setConsoleInfo: consoleInfo " + consoleInfo));
        if (this.viewSettings != null) {
            this.viewSettings.setConsoleInfo(consoleInfo);
        }
        if (this.viewEncryption != null) {
            this.viewEncryption.setConsoleInfo(consoleInfo);
        }
        super.setConsoleInfo(consoleInfo);
    }

    protected void initComponents() {
        Debug.println((String)"IDARTabView.initComponents");
        this.tabViews = new JTabbedPane();
        ConsoleInfo consoleInfo = this.getConsoleInfo();
        this.viewSettings = new IDARView();
        this.viewSettings.setConsoleInfo(consoleInfo);
        this.viewEncryption = new IDAREncryptionPanel();
        this.viewEncryption.setConsoleInfo(consoleInfo);
        this.viewSettings.addBlankPanelListener(this);
        this.viewEncryption.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewSettings.getTitleText(), null, this.viewSettings.getPanel());
        this.tabViews.addTab(this.viewEncryption.getTitleText(), null, this.viewEncryption.getPanel());
        IDARModelBean iDARModelBean = this.getDataModel();
        if (iDARModelBean != null) {
            this.viewSettings.setDataModel(iDARModelBean);
            this.viewEncryption.setDataModel(iDARModelBean);
        }
        this.setLayout(new BorderLayout());
        this.tabViews.revalidate();
        this.add((Component)this.tabViews, "Center");
    }
}

