/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.task.TaskManagerFactory;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.common.configuration.DynamicConfigurationView;
import com.iplanet.idar.ui.common.configuration.EmbeddedConfigurationView;
import com.iplanet.idar.ui.configurator.system.ConnectionsView;
import com.iplanet.idar.ui.configurator.system.GeneralView;
import com.iplanet.idar.ui.configurator.system.SSLView;
import com.iplanet.idar.ui.configurator.system.UnixPropertiesView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class IDARView
extends EmbeddedConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "System-Settings";
    DynamicSystemView systemView = null;

    public IDARView() {
        this.initComponents();
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("6, IDARView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (iDARModelBean != null && iDARModelBean instanceof IDARModelBean) {
            IDARBean iDARBean = (IDARBean)iDARModelBean;
            if (this.systemView != null) {
                this.systemView.showUnixProperties(iDARBean.getOS() != 0);
            }
            super.setDataModel(iDARModelBean, bl);
        }
    }

    public void resetContent() throws ConfigurationViewException {
        super.resetContent();
    }

    public IDARReference getCurrentItem() {
        IDARReference iDARReference = null;
        IDARBean iDARBean = (IDARBean)this.getDataModel();
        if (iDARBean != null) {
            iDARReference = iDARBean.getSystemConfiguration();
        }
        return iDARReference;
    }

    public void setCurrentItem(IDARReference iDARReference) {
        IDARBean iDARBean = (IDARBean)this.getDataModel();
        if (iDARBean != null) {
            SystemBean systemBean = iDARBean.getSystemBean();
            Debug.println((String)("removing belongsTo from system:" + systemBean.getId()));
            systemBean.removeBelongsTo(iDARBean.getId());
            iDARBean.setSystemConfiguration(iDARReference);
            SystemBean systemBean2 = null;
            try {
                systemBean2 = (SystemBean)iDARReference.getBean();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            catch (RetrievalException retrievalException) {
                retrievalException.printStackTrace();
            }
            Debug.println((String)("adding belongsTo to system:" + systemBean2.getId()));
            systemBean2.addBelongsTo(iDARBean.getId());
        }
    }

    public String getHelpTopic() {
        return this.systemView.getHelpTopic();
    }

    public String getTitleText() {
        return IDARResourceSet.getString("serverConfiguration", "TITLE");
    }

    protected void initComponents() {
        Debug.println((String)"IDARView.initComponents");
        JLabel jLabel = new JLabel(IDARResourceSet.getString("common", "settings_saved_as") + ":");
        jLabel.setIcon((Icon)ImageFactory.getImage("SYSTEM"));
        this.systemView = new DynamicSystemView(this.getConsoleInfo());
        IDARBean iDARBean = (IDARBean)this.getDataModel();
        if (iDARBean != null) {
            this.systemView.showUnixProperties(iDARBean.getOS() != 0);
        }
        super.initComponents(this.systemView, jLabel, "system", IDARReference.NULL_REFERENCE, false);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        TaskManagerFactory.setContextIndicator(3);
        jFrame.getContentPane().add(new IDARView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class DynamicSystemView
    extends DynamicConfigurationView {
        private JTabbedPane tabViews = null;
        private GeneralView viewGeneral;
        private ConnectionsView viewConnections;
        private SSLView viewEncryption;
        private UnixPropertiesView viewUnix;
        private BlankPanel pnlSystem;
        private SystemBean prevSystemBean = null;

        DynamicSystemView(ConsoleInfo consoleInfo) {
            this.setConsoleInfo(consoleInfo);
            JTabbedPane jTabbedPane = new JTabbedPane(4);
            this.viewGeneral = new GeneralView(consoleInfo);
            this.viewEncryption = new SSLView(consoleInfo);
            this.viewConnections = new ConnectionsView(consoleInfo);
            this.showUnixProperties(true);
        }

        public void showUnixProperties(boolean bl) {
            if (bl) {
                if (this.viewUnix == null) {
                    this.viewUnix = new UnixPropertiesView(this.getConsoleInfo());
                    if (this.pnlSystem != null) {
                        this.viewUnix.addBlankPanelListener(this.pnlSystem);
                    }
                    if (this.tabViews != null) {
                        this.tabViews.add(this.viewUnix);
                    }
                }
            } else if (this.viewUnix != null) {
                if (this.tabViews != null) {
                    this.tabViews.remove(this.viewUnix);
                }
                this.viewUnix = null;
            }
        }

        public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
            Debug.println((int)7, (String)("IDARView.DynamicSystemView.setDataModel: system=" + iDARModelBean + " reset=" + bl));
            if (iDARModelBean == null) {
                this.showError();
            } else {
                this.viewGeneral.setDataModel(iDARModelBean, false);
                this.viewEncryption.setDataModel(iDARModelBean, false);
                this.viewConnections.setDataModel(iDARModelBean, false);
                if (this.viewUnix != null) {
                    this.viewUnix.setDataModel(iDARModelBean, false);
                }
                super.setDataModel(iDARModelBean, bl);
            }
        }

        public String getHelpTopic() {
            String string = this.tabViews.getTitleAt(this.tabViews.getSelectedIndex());
            String string2 = null;
            if (string.equals(this.viewGeneral.getTitleText())) {
                string2 = this.viewGeneral.getHelpTopic();
            } else if (string.equals(this.viewConnections.getTitleText())) {
                string2 = this.viewConnections.getHelpTopic();
            } else if (string.equals(this.viewEncryption.getTitleText())) {
                string2 = this.viewEncryption.getHelpTopic();
            } else if (string.equals(this.viewUnix.getTitleText())) {
                string2 = this.viewUnix.getHelpTopic();
            }
            return string2;
        }

        public void resetContent() throws ConfigurationViewException {
            Debug.println((int)6, (String)"IDARView.DynamicSystemView.resetContent");
            this.prevSystemBean = (SystemBean)this.getDataModel();
            this.viewGeneral.resetContentEventlessly();
            this.viewEncryption.resetContentEventlessly();
            this.viewConnections.resetContentEventlessly();
            if (this.viewUnix != null) {
                this.viewUnix.resetContentEventlessly();
            }
        }

        public void applyChanges() throws ConfigurationViewException {
            Debug.println((int)7, (String)"IDARView.DynamicSystemView.applyChanges");
            try {
                this.viewGeneral.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewGeneral.getTitleText()));
                throw configurationViewException;
            }
            try {
                this.viewEncryption.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewEncryption.getTitleText()));
                throw configurationViewException;
            }
            try {
                this.viewConnections.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewConnections.getTitleText()));
                throw configurationViewException;
            }
            if (this.viewUnix != null) {
                try {
                    this.viewUnix.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.tabViews.setSelectedIndex(this.tabViews.indexOfTab(this.viewUnix.getTitleText()));
                    throw configurationViewException;
                }
            }
        }

        public String getTitleText() {
            return "systemView";
        }

        public JPanel getContentPanel() {
            if (this.pnlSystem == null) {
                this.pnlSystem = new BlankPanel("IDARView.System");
                this.pnlSystem.setLayout(new BorderLayout());
                this.viewGeneral.addBlankPanelListener(this.pnlSystem);
                this.viewEncryption.addBlankPanelListener(this.pnlSystem);
                this.viewConnections.addBlankPanelListener(this.pnlSystem);
                if (this.viewUnix != null) {
                    this.viewUnix.addBlankPanelListener(this.pnlSystem);
                }
                this.tabViews = new JTabbedPane(4);
                this.tabViews.addTab(this.viewGeneral.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewGeneral.getPanel()));
                this.tabViews.addTab(this.viewEncryption.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewEncryption.getPanel()));
                this.tabViews.addTab(this.viewConnections.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewConnections.getPanel()));
                if (this.viewUnix != null) {
                    this.tabViews.addTab(this.viewUnix.getTitleText(), null, IDARUtilities.createEmptyBorderScrollPane(this.viewUnix.getPanel()));
                }
                this.pnlSystem.add(this.tabViews);
            }
            return this.pnlSystem;
        }
    }
}

