/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task.configuration;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.configuration.CreateObjectTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.task.IplanetTaskEventManager;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;

public class IplanetCreateAndEditObjectTask
extends AbstractTask {
    CreateObjectTask createTask = new CreateObjectTask();
    IplanetEditObjectTask editTask = new IplanetEditObjectTask();

    public IplanetCreateAndEditObjectTask() {
        this(null, null, null);
    }

    public IplanetCreateAndEditObjectTask(String string) {
        this(null, string, null);
    }

    public IplanetCreateAndEditObjectTask(ConsoleInfo consoleInfo, String string, IDARReference iDARReference) {
        this.setConsoleInfo(consoleInfo);
        this.setDescriptor(string);
        this.setParentConfiguration(iDARReference);
    }

    public String getName() {
        return IDARResourceSet.getString("taskCreateObject", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskCreateObject", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        if (!this.createTask.isExecutable()) {
            return this.createTask.getUnexecutableMessage();
        }
        return this.editTask.getUnexecutableMessage();
    }

    public void setDescriptor(String string) {
        this.createTask.setDescriptor(string);
        this.setExecutableness();
    }

    public void setParentConfiguration(IDARReference iDARReference) {
        this.createTask.setParentConfiguration(iDARReference);
        this.setExecutableness();
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        this.editTask.setConsoleInfo(consoleInfo);
        this.setExecutableness();
    }

    public IDARReference getNewObjectReference() {
        return this.createTask.getNewObjectReference();
    }

    public int doExecute() {
        Debug.println((String)"IplanetCreateAndEditObjectTask.doExecute");
        IplanetTaskEventManager iplanetTaskEventManager = (IplanetTaskEventManager)this.getEventManager();
        iplanetTaskEventManager.stopFramework();
        int n = this.createTask.executeAndWait();
        if (n == 0) {
            this.editTask.setObject(this.createTask.getNewObjectReference());
            if (this.editTask.isExecutable()) {
                n = this.editTask.executeAndWait();
            } else {
                Debug.println((String)("IplanetCreateAndEditObjectTask.doExecute: CANT EDIT: " + this.editTask.getUnexecutableMessage()));
                n = -1;
            }
        } else {
            Debug.println((String)"IplanetCreateAndEditObjectTask.doExecute: create failed");
            n = -1;
        }
        return n;
    }

    protected void setExecutableness() {
        this.setExecutable(this.createTask.isExecutable() && this.editTask.getConsoleInfo() != null);
    }
}

