/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.ldap.LdapServer;
import com.iplanet.idar.ldap.task.LdapPingTask;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDAREnabledConfigurationModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.LoadBalanceData;
import com.iplanet.idar.objectmodel.bean.LoadBalancePropertyBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.PropertyBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.LDAPComm;
import com.netscape.management.client.util.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPServerPropertyBean
extends PropertyBean
implements LdapServer,
IDARConstants,
LDAPComm {
    private LDAPConnection ldc;
    protected static final String PREDELETE_MESSAGE = IDARResourceSet.getString("error", "LDAP_SERVER_PROPERTY_DELETE");
    private static final String ERR_NO_HOST = IDARResourceSet.getString("error", "ERR_NO_HOST");
    private static final String ERR_NO_PORT = IDARResourceSet.getString("error", "ERR_NO_PORT");
    private String host = "";
    private Integer port = new Integer(389);
    private Integer securePort;
    private Integer cldapPort;
    private Integer keepAlive = new Integer(180);
    private String supportedVersion = "23";
    private String useVersion = "23";
    private Boolean noDelay = new Boolean(true);
    private String securityPolicy = "ssl_optional";
    private String x509certSubject;
    private String illegalMessage = null;
    String questionableMessage;

    protected static String getIdPrefix() {
        return "ldap-server";
    }

    public boolean isLegal() {
        boolean bl = true;
        this.illegalMessage = null;
        if (this.host == null || this.host.trim().equals("")) {
            bl = false;
            this.illegalMessage = ERR_NO_HOST;
        } else if (this.port == null) {
            bl = false;
            this.illegalMessage = ERR_NO_PORT;
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.illegalMessage;
    }

    public boolean isQuestionable() {
        boolean bl = false;
        this.questionableMessage = null;
        try {
            Debug.print((String)("LDAPServerPropertyBean.isQuestionable: resolving " + this.host + "..."));
            InetAddress inetAddress = InetAddress.getByName(this.host);
            Debug.println((String)"OK");
        }
        catch (UnknownHostException unknownHostException) {
            bl = true;
            this.questionableMessage = IDARResourceSet.getString("questionable", "UNRESOLVABLE_HOSTNAME");
        }
        if (!bl) {
            try {
                if (this.ldc != null) {
                    Debug.print((int)6, (String)"LDAPServerPropertyBean.isQuestionable: try LDAP connect...");
                    if (!this.ldc.isConnected()) {
                        this.ldc.connect(3, this.ldc.getHost(), this.ldc.getPort(), this.ldc.getAuthenticationDN(), this.ldc.getAuthenticationPassword());
                    } else {
                        Debug.println((int)6, (String)"LDAPServerPropertyBean.isQuestionable: ERROR - cannot connect");
                    }
                    this.ldc.setConnectTimeout(5);
                    this.ldc.disconnect();
                    Debug.println((int)6, (String)"LDAPServerPropertyBean.isQuestionable: LDAP connection....OK");
                } else {
                    Debug.println((int)6, (String)"LDAPServerPropertyBean.isQuestionable: ERROR - no ldap connection");
                }
            }
            catch (LDAPException lDAPException) {
                bl = true;
                this.questionableMessage = IDARResourceSet.getString("questionable", "CANT_LDAP_CONNECT");
            }
        }
        return bl;
    }

    public String getQuestionableExplanationMessage() {
        this.isQuestionable();
        return this.questionableMessage;
    }

    public boolean isDeletable() {
        boolean bl = true;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray.length > 0) {
            bl = false;
        }
        return bl;
    }

    public String getPredeletionMessage() {
        String string = null;
        return string;
    }

    public void setLDAPConnection(Object object) {
        if (object instanceof LDAPConnection && object != null) {
            this.ldc = (LDAPConnection)((LDAPConnection)object).clone();
        } else {
            Debug.println((String)"LDAPServerPropertyBean.setLDAPConnection: ERROR - trying to set wrong kind of connection");
        }
    }

    public IDARReference[] getSubscribers() {
        Object object;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            String string;
            LoadBalanceData[] loadBalanceDataArray;
            IDAREnabledConfigurationModelBean iDAREnabledConfigurationModelBean;
            Object e;
            object = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "network-group");
            Vector vector2 = ((IDARBeanCollection)object).toBeanVector();
            String string2 = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                if (e instanceof NetworkGroupBean) {
                    iDAREnabledConfigurationModelBean = (NetworkGroupBean)e;
                    loadBalanceDataArray = ((NetworkGroupBean)iDAREnabledConfigurationModelBean).getLdapServerPropertyIds();
                    if (loadBalanceDataArray == null) continue;
                    Enumeration enumeration2 = loadBalanceDataArray.elements();
                    while (enumeration2.hasMoreElements()) {
                        string = enumeration2.nextElement().toString();
                        if (string == null || !string.equals(string2)) continue;
                        vector.add(iDAREnabledConfigurationModelBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"LDAPServerPropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
            object = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "load-balancing");
            vector2 = ((IDARBeanCollection)object).toBeanVector();
            enumeration = vector2.elements();
            block4: while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                if (e instanceof LoadBalancePropertyBean) {
                    iDAREnabledConfigurationModelBean = (LoadBalancePropertyBean)e;
                    loadBalanceDataArray = ((LoadBalancePropertyBean)iDAREnabledConfigurationModelBean).getLoadBalanceData();
                    if (loadBalanceDataArray == null) continue;
                    for (int i = 0; i < loadBalanceDataArray.length; ++i) {
                        string = loadBalanceDataArray[i].getServerId();
                        if (string == null || !string.equals(string2)) continue;
                        vector.add(iDAREnabledConfigurationModelBean.getSelfReference());
                        continue block4;
                    }
                    continue;
                }
                Debug.println((String)"LDAPServerPropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"LDAPServerPropertyBean.getSubscribers: WARNING: could not get bean collection");
        }
        object = new IDARReference[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String getDescriptor() {
        return LDAPServerPropertyBean.getIdPrefix();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setHostName(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        try {
            this.port = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setPort(Integer n) {
        this.port = n;
    }

    public Integer getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(int n) {
        try {
            this.securePort = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setSecurePort(Integer n) {
        this.securePort = n;
    }

    public Integer getCldapPort() {
        return this.cldapPort;
    }

    public void setCldapPort(int n) {
        try {
            this.cldapPort = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setCldapPort(Integer n) {
        this.cldapPort = n;
    }

    public Integer getKeepAliveInterval() {
        return this.keepAlive;
    }

    public void setKeepAliveInterval(Integer n) {
        if (n != null) {
            this.keepAlive = n;
        }
    }

    public void setKeepAliveInterval(int n) {
        try {
            this.keepAlive = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    public String getSupportedVersion() {
        return this.supportedVersion;
    }

    public void setSupportedVersion(String string) {
        this.supportedVersion = string;
    }

    public String getUseVersion() {
        return this.useVersion;
    }

    public void setUseVersion(String string) {
        this.useVersion = string;
    }

    public Boolean getNoDelay() {
        Boolean bl = this.noDelay;
        if (bl == null) {
            bl = new Boolean(true);
        }
        return bl;
    }

    public void setNoDelay(boolean bl) {
        this.noDelay = new Boolean(bl);
    }

    public void setNoDelay(Boolean bl) {
        this.noDelay = bl;
    }

    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(String string) {
        this.securityPolicy = string;
    }

    public String getX509certSubject() {
        return this.x509certSubject;
    }

    public void setX509certSubject(String string) {
        this.x509certSubject = string;
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("ids-proxy-con-host", this.host);
        if (this.port != null && this.port != 389) {
            taskParameters.addParameter("ids-proxy-con-port", this.port.toString());
        }
        if (this.securePort != null) {
            taskParameters.addParameter("ids-proxy-con-sport", this.securePort.toString());
        }
        if (this.cldapPort != null) {
            taskParameters.addParameter("ids-proxy-con-cldap-port", this.cldapPort.toString());
        }
        if (this.keepAlive != null && this.keepAlive != 180) {
            taskParameters.addParameter("ids-proxy-con-keepalive-interval", this.keepAlive.toString());
        }
        if (this.supportedVersion != null) {
            if (!this.supportedVersion.equals("23") && !this.supportedVersion.equals("2")) {
                throw new IllegalPropertyException("illegal supported version");
            }
            if (!this.supportedVersion.equals("23")) {
                taskParameters.addParameter("ids-proxy-con-supported-version", this.supportedVersion);
            }
        }
        if (this.useVersion != null) {
            if (!(this.useVersion.equals("23") || this.useVersion.equals("3") || this.useVersion.equals("2"))) {
                throw new IllegalPropertyException("illegal use version");
            }
            if (!this.useVersion.equals("23")) {
                taskParameters.addParameter("ids-proxy-con-use-version", this.useVersion);
            }
        }
        if (this.noDelay != null && !this.noDelay.booleanValue()) {
            taskParameters.addParameter("ids-proxy-con-tcp-no-delay", this.noDelay.toString());
        }
        if (this.securityPolicy != null) {
            if (!(this.securityPolicy.equals("ssl_always") || this.securityPolicy.equals("ssl_never") || this.securityPolicy.equals("ssl_optional"))) {
                throw new IllegalPropertyException("illegal link policy");
            }
            if (!this.securityPolicy.equals("ssl_optional")) {
                taskParameters.addParameter("ids-proxy-con-link-security-policy", this.securityPolicy);
            }
        }
        if (this.x509certSubject != null) {
            taskParameters.addParameter("ids-proxy-con-x509cert-subject", this.x509certSubject);
        }
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        String string = null;
        this.host = taskResult.getAttributeValue("ids-proxy-con-host");
        try {
            string = taskResult.getAttributeValue("ids-proxy-con-port");
            if (string != null) {
                this.port = new Integer(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.port = null;
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: bad port " + string));
        }
        try {
            string = taskResult.getAttributeValue("ids-proxy-con-sport");
            if (string != null) {
                this.securePort = new Integer(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.securePort = null;
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: bad sport " + string));
        }
        try {
            string = taskResult.getAttributeValue("ids-proxy-con-cldap-port");
            if (string != null) {
                this.cldapPort = new Integer(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.cldapPort = null;
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: bad cldap port " + string));
        }
        try {
            string = taskResult.getAttributeValue("ids-proxy-con-keepalive-interval");
            if (string != null) {
                this.keepAlive = new Integer(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.keepAlive = new Integer(180);
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: bad keep alive " + string));
        }
        string = taskResult.getAttributeValue("ids-proxy-con-supported-version");
        if (string == null) {
            Debug.println((int)7, (String)"LDAPServerPropertyBean.synchronize:  missing supported verion, resorting to default");
            this.supportedVersion = "23";
        } else if (string.equals("23") || string.equals("2")) {
            this.supportedVersion = string;
        } else {
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: unsupported supported verions " + string));
        }
        string = taskResult.getAttributeValue("ids-proxy-con-use-version");
        if (string == null) {
            Debug.println((int)7, (String)"LDAPServerPropertyBean.synchronize:  missing use verion, resorting to default");
            this.useVersion = "23";
        } else if (string != null && (string.equals("23") || string.equals("2") || string.equals("3"))) {
            this.useVersion = string;
        } else {
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: unsupported user verion " + string));
        }
        string = taskResult.getAttributeValue("ids-proxy-con-tcp-no-delay");
        if (string != null) {
            this.noDelay = new Boolean(string);
        }
        if ((string = taskResult.getAttributeValue("ids-proxy-con-link-security-policy")) == null) {
            Debug.println((int)7, (String)"LDAPServerPropertyBean.synchronize:  missing link policy, resorting to default");
            this.securityPolicy = "ssl_optional";
        } else if (string.equals("ssl_always") || string.equals("ssl_never") || string.equals("ssl_optional")) {
            this.securityPolicy = string;
        } else {
            Debug.println((String)("LDAPServerPropertyBean.synchronize:  ERROR: unsupported link policy '" + string + "'"));
        }
        this.x509certSubject = taskResult.getAttributeValue("ids-proxy-con-x509cert-subject");
    }

    public String getHostName() {
        return this.host;
    }

    public Integer getPort() {
        if (this.port == null) {
            return new Integer(389);
        }
        return this.port;
    }

    public LdapPingTask getLdapPingTask() {
        return new LdapPingTask(this);
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "LDAP_SERVER_PROPERTY_DESCRIPTOR");
    }
}

