/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.PropertyBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.util.DN;

public class SizeLimitPropertyBean
extends PropertyBean
implements IDARConstants {
    private static final String STAT_DELIMITER = "|";
    String questionableMessage;
    Integer sizeLimit = new Integer(-1);
    Vector oneLevelSearchDns = new Vector();
    Vector subtreeLevelSearchDns = new Vector();

    protected static String getIdPrefix() {
        return "search-size-limit";
    }

    public boolean isLegal() {
        return true;
    }

    public String getIllegalityExplanationMessage() {
        return null;
    }

    public boolean isQuestionable() {
        boolean bl = false;
        this.questionableMessage = null;
        if (this.oneLevelSearchDns.size() == 0 && this.subtreeLevelSearchDns.size() == 0) {
            this.questionableMessage = IDARResourceSet.getString("questionable", "NO_SEARCH_CRITERIA");
            bl = true;
        }
        return bl;
    }

    public String getQuestionableExplanationMessage() {
        this.isQuestionable();
        return this.questionableMessage;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return super.getPredeletionMessage();
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "network-group");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof NetworkGroupBean) {
                    NetworkGroupBean networkGroupBean = (NetworkGroupBean)e;
                    Vector vector3 = networkGroupBean.getSearchSizeLimitPropertyIds();
                    if (vector3 == null) continue;
                    Enumeration enumeration2 = vector3.elements();
                    while (enumeration2.hasMoreElements()) {
                        String string2 = enumeration2.nextElement().toString();
                        if (string2 == null || !string2.equals(string)) continue;
                        vector.add(networkGroupBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"SizeLimitPropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"SizeLimitPropertyBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getDescriptor() {
        return SizeLimitPropertyBean.getIdPrefix();
    }

    public boolean isEnforcingSizeLimit() {
        return this.sizeLimit != -1;
    }

    public void setNoSizeLimit() {
        this.sizeLimit = new Integer(-1);
    }

    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(Integer n) {
        this.sizeLimit = n;
    }

    public Vector getOneLevelSearchDns() {
        return this.oneLevelSearchDns;
    }

    public void setOneLevelSearchDns(Vector vector) {
        this.oneLevelSearchDns = vector;
    }

    public Vector getSubtreeLevelSearchDns() {
        return this.subtreeLevelSearchDns;
    }

    public void setSubtreeLevelSearchDns(Vector vector) {
        this.subtreeLevelSearchDns = vector;
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        Object e;
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("ids-proxy-con-size-limit", this.sizeLimit.toString());
        Enumeration enumeration = this.oneLevelSearchDns.elements();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (!(e instanceof DN)) continue;
            taskParameters.addParameter("ids-proxy-con-dn-one", e.toString());
        }
        enumeration = this.subtreeLevelSearchDns.elements();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (!(e instanceof DN)) continue;
            taskParameters.addParameter("ids-proxy-con-dn-sub", e.toString());
        }
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        DN dN;
        int n;
        TaskResult taskResult = super.doSynchronize();
        String string = taskResult.getAttributeValue("ids-proxy-con-size-limit");
        try {
            this.sizeLimit = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.println((String)("SizeLimitPropertyBean.synchronize:  ERROR:  bad size limit value " + string));
        }
        String[] stringArray = taskResult.getAttributeValues("ids-proxy-con-dn-one");
        this.oneLevelSearchDns.clear();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                dN = new DN(stringArray[n]);
                if (!dN.toString().equals("")) {
                    this.oneLevelSearchDns.addElement(dN);
                    continue;
                }
                Debug.println((String)("SizeLimitPropertyBean.synchronize:  ERROR:  bad dn " + stringArray[n]));
            }
        }
        stringArray = taskResult.getAttributeValues("ids-proxy-con-dn-sub");
        this.subtreeLevelSearchDns.clear();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                dN = new DN(stringArray[n]);
                if (!dN.toString().equals("")) {
                    this.subtreeLevelSearchDns.addElement(dN);
                    continue;
                }
                Debug.println((String)("SizeLimitPropertyBean.synchronize:  ERROR:  bad dn " + stringArray[n]));
            }
        }
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "SEARCH_SIZE_LIMIT_PROPERTY_DESCRIPTOR");
    }
}

