/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.bean.EncryptionConfigData;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.components.IDARScrollPane;
import com.iplanet.idar.ui.configurator.ConfigurationResource;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class IDARUtilities {
    private static Hashtable nicknames = new Hashtable();
    private static HashSet serverIds = new HashSet();
    private static Hashtable frameworks = new Hashtable();
    private static Hashtable configurations = new Hashtable();
    public static final String OS_WIN32 = "Win32";
    public static final String OS_UNIX = "Unix (Generic)";
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$com$netscape$management$client$IFramework;

    public static Frame getParentFrame(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Frame)container;
    }

    public static JFrame getParentJFrame(Component component) {
        return (JFrame)IDARUtilities.getContainer(component, class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = IDARUtilities.class$("javax.swing.JFrame")) : class$javax$swing$JFrame);
    }

    public static IPage getPage(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof IPage); container = container.getParent()) {
        }
        return (IPage)container;
    }

    public static IFramework getFramework(Component component) {
        return (IFramework)IDARUtilities.getContainer(component, class$com$netscape$management$client$IFramework == null ? (class$com$netscape$management$client$IFramework = IDARUtilities.class$("com.netscape.management.client.IFramework")) : class$com$netscape$management$client$IFramework);
    }

    public static void registerServerId(String string, String string2) {
        Debug.println((int)0, (String)("New framework server id = " + string2 + " for " + string));
        nicknames.put(string, string2);
    }

    public static String getServerId(String string) {
        return (String)nicknames.get(string);
    }

    public static String getServerId(LDAPConnection lDAPConnection, String string) {
        String string2 = null;
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(string);
                String string3 = LDAPUtil.getLDAPAttributeLocale();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsserverid", string3);
                if (lDAPAttribute == null) {
                    lDAPAttribute = lDAPEntry.getAttribute("cn", string3);
                    if (lDAPAttribute != null) {
                        string2 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                    }
                } else {
                    string2 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)6, (String)("IDARUtilities.getServerId: " + (Object)((Object)lDAPException)));
            }
        }
        return string2;
    }

    public static void registerIdarServerId(String string) {
        serverIds.add(string);
    }

    public static Collection getIdarServerIds() {
        return serverIds;
    }

    public static boolean isServerIdInUse(String string) {
        return serverIds.contains(string);
    }

    public static void registerFramework(String string, IFramework iFramework) {
        if (iFramework != null) {
            frameworks.put(string, iFramework);
        }
    }

    public static void deregisterFramework(IFramework iFramework) {
        if (iFramework != null) {
            frameworks.remove(iFramework);
        }
    }

    public static IFramework getFramework(String string) {
        return (IFramework)frameworks.get(string);
    }

    public static Container getContainer(Component component, Class clazz) {
        Debug.println((String)("IdarUtilities.getContainer: child = " + component + " containerClass=" + clazz));
        Container container = null;
        if (component != null && clazz != null) {
            if (clazz.isInstance(component)) {
                container = (Container)component;
            } else {
                Debug.println((String)("IdarUtilities.getContainer: child.getParent() = " + container));
                for (container = component.getParent(); container != null && !clazz.isInstance(container); container = container.getParent()) {
                }
            }
        }
        return container;
    }

    public static void registerConfigurationResource(String string, ConfigurationResource configurationResource) {
        Debug.println((int)6, (String)("IDARUtilities.registerConfigurationResource: key=" + string + ", resource=" + configurationResource.toString()));
        if (string != null && configurationResource != null) {
            configurations.put(string, configurationResource);
        } else {
            Debug.println((String)"IDARUtilities.registerConfigurationResource:  ERROR: configuration not registered due to null data");
        }
    }

    public static ConfigurationResource getConfigurationResource(String string) {
        Debug.println((int)6, (String)("IDARUtilities.getConfigurationResource: key=" + string));
        return (ConfigurationResource)((Object)configurations.get(string));
    }

    public static void removeConfigurationResource(String string) {
        Debug.println((int)6, (String)("IDARUtilities.RemoveConfigurationResource : key = " + string));
        configurations.remove(string);
    }

    public static Enumeration getConfigurationResources() {
        return configurations.elements();
    }

    public static String[] getDescriptorSubclasses(String string) {
        if ("group".equals(string)) {
            return new String[]{"network-group"};
        }
        if ("rule".equals(string) || "rule".equals(string)) {
            return new String[]{"on-bind", "on-ssl"};
        }
        if ("action".equals(string)) {
            return new String[]{"change-group"};
        }
        if ("property".equals(string)) {
            return new String[]{"attribute-renaming", "forbidden-entry", "ldap-server", "load-balancing", "search-size-limit"};
        }
        return null;
    }

    public static String getDescriptorSuperclass(String string) {
        if (string.equals("network-group")) {
            return "group";
        }
        if (string.equals("on-bind") || string.equals("on-ssl")) {
            return "rule";
        }
        if (string.equals("change-group")) {
            return "action";
        }
        if (string.equals("attribute-renaming") || string.equals("forbidden-entry") || string.equals("ldap-server") || string.equals("load-balancing") || string.equals("search-size-limit")) {
            return "property";
        }
        return null;
    }

    public static String toNormalizedDN(String string) {
        return LDAPDN.normalize((String)string);
    }

    public static String normalizeDnExpression(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",=", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2.trim());
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static JLabel[] createJLabels(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<JLabel> vector = new Vector<JLabel>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(new JLabel(stringTokenizer.nextToken()));
        }
        Object[] objectArray = new JLabel[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static IDARScrollPane createEmptyBorderScrollPane(JComponent jComponent) {
        IDARScrollPane iDARScrollPane = new IDARScrollPane(jComponent);
        iDARScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return iDARScrollPane;
    }

    public static String getOS() {
        if (File.separatorChar == '\\') {
            return OS_WIN32;
        }
        return OS_UNIX;
    }

    public static boolean isSSLServerOn(IDARBean iDARBean) {
        Debug.println((int)7, (String)"IDARUtilities.isSSLServerOn");
        boolean bl = false;
        if (iDARBean != null) {
            EncryptionConfigData encryptionConfigData = iDARBean.getEncryptionData();
            bl = encryptionConfigData.isSslServerOn();
        } else {
            Debug.println((int)0, (String)"IDARUtilities.isSSLServerOn: ERROR - UNABLE TO RETRIEVE ENCRYPTION DATA. BEAN IS NULL.");
        }
        Debug.println((int)7, (String)("IDARUtilities.isSSLServerOn: SSL ENABLED = " + bl));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isPINFilePresent(IDARBean iDARBean) {
        boolean bl;
        block11: {
            block12: {
                Debug.println((int)7, (String)"IDARUtilities.isPINFilePresent");
                bl = false;
                if (iDARBean == null) break block12;
                String string = "";
                string = iDARBean.getOS() == 0 ? "\\" : "/";
                StringBuffer stringBuffer = new StringBuffer(iDARBean.getServerRoot());
                stringBuffer.append(string);
                stringBuffer.append(IDARResourceSet.getString("encryptionConfiguration", "IDAR_SSL_PASSWORD_FILE_ROOT"));
                stringBuffer.append(string);
                stringBuffer.append(iDARBean.getServerName());
                stringBuffer.append("-pin.txt");
                String string2 = stringBuffer.toString();
                FileReader fileReader = null;
                fileReader = new FileReader(string2);
                bl = true;
                Debug.println((int)0, (String)("IDARUtilities.isPINFilePresent: PIN file found at " + string2));
                Object var8_6 = null;
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    Debug.println((int)0, (String)("IDARUtilities.isPINFilePresent: ERROR - UNABLE TO CLOSE RESOURCE = " + string2));
                }
                break block11;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        Debug.println((int)0, (String)("IDARUtilities.isPINFilePresent: ERROR - PIN FILE NOT FOUND at " + string2));
                        bl = false;
                        Object var8_7 = null;
                        try {
                            if (fileReader != null) {
                                fileReader.close();
                            }
                            break block11;
                        }
                        catch (IOException iOException) {
                            Debug.println((int)0, (String)("IDARUtilities.isPINFilePresent: ERROR - UNABLE TO CLOSE RESOURCE = " + string2));
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Debug.println((int)0, (String)("IDARUtilities.isPINFilePresent: ERROR - UNABLE TO CLOSE RESOURCE = " + string2));
                    }
                    throw throwable;
                }
            }
            Debug.println((int)0, (String)"IDARUtilities.isSSLServerOn: ERROR - UNABLE TO RETRIEVE ENCRYPTION DATA. BEAN IS NULL.");
        }
        return bl;
    }

    public static String toUSASCII(char[] cArray) throws CharacterCodingException {
        Charset charset = Charset.forName("US-ASCII");
        CharsetEncoder charsetEncoder = charset.newEncoder();
        charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
        return new String(byteBuffer.array());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

