/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenerAdapter;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.netscape.management.client.util.Debug;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class ViewMap {
    private static final Hashtable viewMap = new Hashtable();
    private static ViewMap singleton;
    private Hashtable freeViewsTable = new Hashtable();
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$group$GroupView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$rule$OnSSLRuleView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$rule$OnBindRuleView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$action$ChangeGroupView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$property$AttributeRenamingPropertyView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$property$ForbiddenEntryPropertyView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$property$LDAPServerPropertyView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$property$LoadBalancePropertyView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$property$LogPropertyView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$property$SizeLimitPropertyView;
    static /* synthetic */ Class class$com$iplanet$idar$ui$configurator$system$SystemView;

    public static Class lookupViewClass(String string) {
        return (Class)viewMap.get(string);
    }

    public static ViewMap getInstance() {
        return singleton;
    }

    private ViewMap() {
    }

    public void releaseView(ConfigurationView configurationView, IDARReference iDARReference) {
        Debug.println((String)("ViewMap.releaseView: view=" + configurationView + " parent=" + iDARReference.getId()));
        Hashtable hashtable = (Hashtable)this.freeViewsTable.get(iDARReference.getId());
        if (hashtable != null) {
            this.releaseView(configurationView, hashtable);
        }
    }

    private void releaseView(ConfigurationView configurationView, Hashtable hashtable) {
        Class<?> clazz = configurationView.getClass();
        HashSet hashSet = (HashSet)hashtable.get(clazz);
        if (hashSet != null) {
            Debug.println((String)("ViewMap.releaseView: view " + clazz.getName()));
            hashSet.add(configurationView);
        }
    }

    public ConfigurationView obtainView(String string, final IDARReference iDARReference) {
        Debug.println((String)("ViewMap.obtainView: desc=" + string + " parent=" + iDARReference.getId()));
        ConfigurationView configurationView = null;
        final String string2 = iDARReference.getId();
        Hashtable hashtable = (Hashtable)this.freeViewsTable.get(iDARReference.getId());
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.freeViewsTable.put(iDARReference.getId(), hashtable);
            iDARReference.addBeanListener(new BeanListenerAdapter(){

                public void beanDeleted(BeanEvent beanEvent) {
                    ViewMap.this.freeViewsTable.remove(iDARReference.getId());
                }

                public void beanRenamed(BeanEvent beanEvent) {
                    Hashtable hashtable = (Hashtable)ViewMap.this.freeViewsTable.remove(string2);
                    String string = beanEvent.getReference().getId();
                    if (hashtable != null && string != null) {
                        ViewMap.this.freeViewsTable.put(string, hashtable);
                    }
                }
            });
        }
        configurationView = this.obtainView(string, hashtable);
        return configurationView;
    }

    private ConfigurationView obtainView(String string, Hashtable hashtable) {
        ConfigurationView configurationView = null;
        Class clazz = ViewMap.lookupViewClass(string);
        HashSet hashSet = (HashSet)hashtable.get(clazz);
        if (hashSet == null) {
            hashSet = new HashSet();
            hashtable.put(clazz, hashSet);
        }
        if (hashSet.size() == 0) {
            try {
                Debug.println((String)("ViewMap.obtainView: creating new view " + clazz.getName()));
                configurationView = (ConfigurationView)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
        } else {
            Debug.println((String)("ViewMap.obtainView: refurbished view " + clazz.getName()));
            Iterator iterator = hashSet.iterator();
            configurationView = (ConfigurationView)iterator.next();
            iterator.remove();
        }
        return configurationView;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        viewMap.put("group", class$com$iplanet$idar$ui$configurator$group$GroupView == null ? (class$com$iplanet$idar$ui$configurator$group$GroupView = ViewMap.class$("com.iplanet.idar.ui.configurator.group.GroupView")) : class$com$iplanet$idar$ui$configurator$group$GroupView);
        viewMap.put("network-group", class$com$iplanet$idar$ui$configurator$group$GroupView == null ? (class$com$iplanet$idar$ui$configurator$group$GroupView = ViewMap.class$("com.iplanet.idar.ui.configurator.group.GroupView")) : class$com$iplanet$idar$ui$configurator$group$GroupView);
        viewMap.put("on-ssl", class$com$iplanet$idar$ui$configurator$rule$OnSSLRuleView == null ? (class$com$iplanet$idar$ui$configurator$rule$OnSSLRuleView = ViewMap.class$("com.iplanet.idar.ui.configurator.rule.OnSSLRuleView")) : class$com$iplanet$idar$ui$configurator$rule$OnSSLRuleView);
        viewMap.put("on-bind", class$com$iplanet$idar$ui$configurator$rule$OnBindRuleView == null ? (class$com$iplanet$idar$ui$configurator$rule$OnBindRuleView = ViewMap.class$("com.iplanet.idar.ui.configurator.rule.OnBindRuleView")) : class$com$iplanet$idar$ui$configurator$rule$OnBindRuleView);
        viewMap.put("change-group", class$com$iplanet$idar$ui$configurator$action$ChangeGroupView == null ? (class$com$iplanet$idar$ui$configurator$action$ChangeGroupView = ViewMap.class$("com.iplanet.idar.ui.configurator.action.ChangeGroupView")) : class$com$iplanet$idar$ui$configurator$action$ChangeGroupView);
        viewMap.put("attribute-renaming", class$com$iplanet$idar$ui$configurator$property$AttributeRenamingPropertyView == null ? (class$com$iplanet$idar$ui$configurator$property$AttributeRenamingPropertyView = ViewMap.class$("com.iplanet.idar.ui.configurator.property.AttributeRenamingPropertyView")) : class$com$iplanet$idar$ui$configurator$property$AttributeRenamingPropertyView);
        viewMap.put("forbidden-entry", class$com$iplanet$idar$ui$configurator$property$ForbiddenEntryPropertyView == null ? (class$com$iplanet$idar$ui$configurator$property$ForbiddenEntryPropertyView = ViewMap.class$("com.iplanet.idar.ui.configurator.property.ForbiddenEntryPropertyView")) : class$com$iplanet$idar$ui$configurator$property$ForbiddenEntryPropertyView);
        viewMap.put("ldap-server", class$com$iplanet$idar$ui$configurator$property$LDAPServerPropertyView == null ? (class$com$iplanet$idar$ui$configurator$property$LDAPServerPropertyView = ViewMap.class$("com.iplanet.idar.ui.configurator.property.LDAPServerPropertyView")) : class$com$iplanet$idar$ui$configurator$property$LDAPServerPropertyView);
        viewMap.put("load-balancing", class$com$iplanet$idar$ui$configurator$property$LoadBalancePropertyView == null ? (class$com$iplanet$idar$ui$configurator$property$LoadBalancePropertyView = ViewMap.class$("com.iplanet.idar.ui.configurator.property.LoadBalancePropertyView")) : class$com$iplanet$idar$ui$configurator$property$LoadBalancePropertyView);
        viewMap.put("log", class$com$iplanet$idar$ui$configurator$property$LogPropertyView == null ? (class$com$iplanet$idar$ui$configurator$property$LogPropertyView = ViewMap.class$("com.iplanet.idar.ui.configurator.property.LogPropertyView")) : class$com$iplanet$idar$ui$configurator$property$LogPropertyView);
        viewMap.put("search-size-limit", class$com$iplanet$idar$ui$configurator$property$SizeLimitPropertyView == null ? (class$com$iplanet$idar$ui$configurator$property$SizeLimitPropertyView = ViewMap.class$("com.iplanet.idar.ui.configurator.property.SizeLimitPropertyView")) : class$com$iplanet$idar$ui$configurator$property$SizeLimitPropertyView);
        viewMap.put("system", class$com$iplanet$idar$ui$configurator$system$SystemView == null ? (class$com$iplanet$idar$ui$configurator$system$SystemView = ViewMap.class$("com.iplanet.idar.ui.configurator.system.SystemView")) : class$com$iplanet$idar$ui$configurator$system$SystemView);
        singleton = new ViewMap();
    }
}

