/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.components;

import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public abstract class IDARAbstractDialog
extends JDialog
implements SuiConstants {
    static final int DO_NOTHING = 0;
    static final int DO_ACTION = 1;
    static final int DO_CANCEL = 2;
    static final int DO_SAVE = 3;
    static final int DO_RESET = 4;
    public static final int HORIZONTAL_BUTTONS = 0;
    public static final int VERTICAL_BUTTONS = 1;
    public static final int NO_BUTTONS = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int HELP = 8;
    public static final int SAVE = 16;
    public static final int RESET = 32;
    protected FocusListener _focusListener = new ButtonFocusListener();
    public JButton _defaultButton;
    private static final boolean _isSolaris = System.getProperty("os.name").equalsIgnoreCase("solaris");
    private static final boolean _isIrix = System.getProperty("os.name").equalsIgnoreCase("irix");
    private KeyListener _textFieldKeyListener = new TextFieldKeyListener();
    private Component _buttonComponent;
    private JPanel _customPanel;
    private JButton _closeButton = null;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JButton _helpButton = null;
    private JButton _saveButton = null;
    private JButton _resetButton = null;
    private int _buttons = 0;
    private int _buttonOrientation = 0;
    private JComponent _focusComponent = null;
    private Frame _parentFrame = null;
    private int minWidth = 0;
    private int minHeight = 0;
    protected int _actionPerformed;

    public IDARAbstractDialog() {
        this((Frame)null, (String)null, false);
    }

    public IDARAbstractDialog(Frame frame) {
        this(frame, null, false);
    }

    public IDARAbstractDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public IDARAbstractDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public IDARAbstractDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, 0, 0);
    }

    public IDARAbstractDialog(Frame frame, String string, int n) {
        this(frame, string, false, n);
    }

    public IDARAbstractDialog(Frame frame, String string, boolean bl, int n) {
        this(frame, string, bl, n, 0);
    }

    public IDARAbstractDialog(Frame frame, String string, boolean bl, int n, int n2) {
        super(frame, string, bl);
        this._parentFrame = frame;
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ResizeComponentListener());
        this.addWindowListener(new DialogWindowListener());
        Container container = super.getContentPane();
        container.setLayout(new GridBagLayout());
        this._buttons = n;
        this._buttonOrientation = n2;
        this._actionPerformed = 0;
        this._customPanel = new JPanel(new BorderLayout());
        GridBagUtil.constrain((Container)container, (Component)this._customPanel, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)18, (int)1, (int)9, (int)9, (int)(this._buttonOrientation == 0 ? 12 : 9), (int)(this._buttonOrientation == 0 ? 9 : 12));
        if (this._buttons != 0) {
            if (this._buttonOrientation == 0) {
                this._buttonComponent = new HorizontalButtonPanel(new DialogActionListener());
                GridBagUtil.constrain((Container)container, (Component)this._buttonComponent, (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)0.0, (int)17, (int)2, (int)0, (int)9, (int)9, (int)9);
            } else {
                this._buttonComponent = new VerticalButtonPanel(new DialogActionListener());
                GridBagUtil.constrain((Container)container, (Component)this._buttonComponent, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)11, (int)0, (int)9, (int)0, (int)9, (int)9);
            }
        }
        container.setBackground(UIManager.getColor("control"));
        container.setForeground(UIManager.getColor("text"));
    }

    protected Component getButtonComponent() {
        return this._buttonComponent;
    }

    public void setMinimumSize(Dimension dimension) {
        this.setMinimumSize(dimension.width, dimension.height);
    }

    public void setMinimumSize(int n, int n2) {
        this.minWidth = n;
        this.minHeight = n2;
        super.setSize(n, n2);
    }

    public void center() {
    }

    public void validate() {
        this.addTextFieldKeyListener(this._customPanel);
        super.validate();
    }

    private void addTextFieldKeyListener(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JTextField) {
                componentArray[i].removeKeyListener(this._textFieldKeyListener);
                componentArray[i].addKeyListener(this._textFieldKeyListener);
                continue;
            }
            if (!(componentArray[i] instanceof Container)) continue;
            this.addTextFieldKeyListener((Container)componentArray[i]);
        }
    }

    public void show() {
        this.addTextFieldKeyListener(this._customPanel);
        if (this._parentFrame != null) {
            this.setDialogLocation(this._parentFrame);
        }
        super.show();
    }

    protected void setParentFrame(JFrame jFrame) {
        this._parentFrame = jFrame;
    }

    protected void setDialogLocation(Frame frame) {
        ModalDialogUtil.setDialogLocation((Component)this, (Component)frame);
    }

    public void showModal() {
        this.setModal(true);
        this.show();
    }

    public void dispose() {
        if ((_isIrix || _isSolaris) && this.isModal()) {
            super.setVisible(false);
        } else if (this._parentFrame != null) {
            super.dispose();
        }
    }

    public void disposeAndRaise() {
        this.setVisible(false);
        if (this._parentFrame != null) {
            ModalDialogUtil.raise((Frame)this._parentFrame);
        }
    }

    public void pack() {
        boolean bl = this.isResizable();
        this.setResizable(true);
        super.pack();
        this.setResizable(bl);
    }

    public void setDefaultButton(int n) {
        if (n == 1) {
            this.setDefaultButton(this._okButton);
        } else if (n == 2) {
            this.setDefaultButton(this._cancelButton);
        } else if (n == 4) {
            this.setDefaultButton(this._closeButton);
        } else if (n == 8) {
            this.setDefaultButton(this._helpButton);
        } else if (n == 16) {
            this.setDefaultButton(this._saveButton);
        } else if (n == 32) {
            this.setDefaultButton(this._resetButton);
        }
    }

    public void setDefaultButton(JButton jButton) {
        this._defaultButton = jButton;
        this.getRootPane().setDefaultButton(jButton);
    }

    public boolean isCancel() {
        return this._actionPerformed == 2;
    }

    public boolean isClose() {
        return this._actionPerformed == 0;
    }

    protected void closeInvoked() {
        this._actionPerformed = 0;
        this.setVisible(false);
    }

    protected void okInvoked() {
        this._actionPerformed = 1;
        this.setVisible(false);
    }

    protected void cancelInvoked() {
        this._actionPerformed = 2;
        this.setVisible(false);
    }

    protected void saveInvoked() {
        this._actionPerformed = 3;
        this.setVisible(false);
    }

    protected void resetInvoked() {
        this._actionPerformed = 4;
        this.setVisible(false);
    }

    protected void helpInvoked() {
        Debug.println((String)"IDARAbstractDialog.helpInvoked:  help not implemented");
    }

    public Container getContentPane() {
        return this._customPanel;
    }

    public void setPanel(JPanel jPanel) {
        this.setComponent(jPanel);
    }

    public void setComponent(Component component) {
        this._customPanel.add("Center", component);
        this.pack();
        super.getContentPane().validate();
    }

    public void setFocusComponent(JComponent jComponent) {
        this._focusComponent = jComponent;
    }

    public void setOKButtonText(String string) {
        this._okButton.setText(string);
        IDARJButtonFactory.resizeGroup((JButton)this._okButton, (JButton)this._closeButton, (JButton)this._cancelButton, (JButton)this._helpButton);
        super.getContentPane().validate();
    }

    public void setOKButtonEnabled(boolean bl) {
        this._okButton.setEnabled(bl);
    }

    public void setOKButtonVisible(boolean bl) {
        this._okButton.setVisible(bl);
    }

    public void setCancelButtonText(String string) {
        this._cancelButton.setText(string);
        IDARJButtonFactory.resizeGroup((JButton)this._okButton, (JButton)this._closeButton, (JButton)this._cancelButton, (JButton)this._helpButton);
        super.getContentPane().validate();
    }

    public void setCancelButtonEnabled(boolean bl) {
        this._cancelButton.setEnabled(bl);
    }

    public void setCancelButtonVisible(boolean bl) {
        this._cancelButton.setVisible(bl);
    }

    public void setCloseButtonText(String string) {
        this._closeButton.setText(string);
        IDARJButtonFactory.resizeGroup((JButton)this._okButton, (JButton)this._closeButton, (JButton)this._cancelButton, (JButton)this._helpButton);
        super.getContentPane().validate();
    }

    public void setCloseButtonEnabled(boolean bl) {
        this._closeButton.setEnabled(bl);
    }

    public void setCloseButtonVisible(boolean bl) {
        this._closeButton.setVisible(bl);
    }

    public void setHelpButtonText(String string) {
        this._helpButton.setText(string);
        IDARJButtonFactory.resizeGroup((JButton)this._okButton, (JButton)this._closeButton, (JButton)this._cancelButton, (JButton)this._helpButton);
        super.getContentPane().validate();
    }

    public void setHelpButtonEnabled(boolean bl) {
        this._helpButton.setEnabled(bl);
    }

    public void setHelpButtonVisible(boolean bl) {
        this._helpButton.setVisible(bl);
    }

    public void setSaveButtonText(String string) {
        this._saveButton.setText(string);
        IDARJButtonFactory.resizeGroup((JButton)this._okButton, (JButton)this._closeButton, (JButton)this._saveButton, (JButton)this._helpButton);
        super.getContentPane().validate();
    }

    public void setSaveButtonEnabled(boolean bl) {
        this._saveButton.setEnabled(bl);
    }

    public void setSaveButtonVisible(boolean bl) {
        this._saveButton.setVisible(bl);
    }

    public void setResetButtonText(String string) {
        this._resetButton.setText(string);
        IDARJButtonFactory.resizeGroup((JButton)this._okButton, (JButton)this._closeButton, (JButton)this._resetButton, (JButton)this._helpButton);
        super.getContentPane().validate();
    }

    public void setResetButtonEnabled(boolean bl) {
        this._resetButton.setEnabled(bl);
    }

    public void setResetButtonVisible(boolean bl) {
        this._resetButton.setVisible(bl);
    }

    class TextFieldKeyListener
    extends KeyAdapter {
        TextFieldKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && IDARAbstractDialog.this._defaultButton != null) {
                IDARAbstractDialog.this._defaultButton.doClick();
            }
        }
    }

    class ButtonFocusListener
    implements FocusListener {
        ButtonFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            IDARAbstractDialog.this.setDefaultButton(IDARAbstractDialog.this._defaultButton);
        }
    }

    class VerticalButtonPanel
    extends JPanel {
        VerticalButtonPanel(ActionListener actionListener) {
            int n = 0;
            this.setLayout(new GridBagLayout());
            Vector<JButton> vector = new Vector<JButton>();
            if ((IDARAbstractDialog.this._buttons & 1) == 1) {
                IDARAbstractDialog.this._okButton = IDARJButtonFactory.createOKButton((ActionListener)actionListener);
                IDARAbstractDialog.this._okButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                GridBagUtil.constrain((Container)this, (Component)IDARAbstractDialog.this._okButton, (int)0, (int)n++, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)0, (int)0, (int)0, (int)0, (int)0);
                vector.addElement(IDARAbstractDialog.this._okButton);
                IDARAbstractDialog.this.setDefaultButton(1);
            }
            if ((IDARAbstractDialog.this._buttons & 0x10) == 16) {
                IDARAbstractDialog.this._saveButton = IDARJButtonFactory.createSaveButton(actionListener);
                IDARAbstractDialog.this._saveButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                GridBagUtil.constrain((Container)this, (Component)IDARAbstractDialog.this._saveButton, (int)0, (int)n++, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)0, (int)0, (int)0, (int)0, (int)0);
                vector.addElement(IDARAbstractDialog.this._saveButton);
                IDARAbstractDialog.this.setDefaultButton(16);
            }
            if ((IDARAbstractDialog.this._buttons & 0x20) == 32) {
                IDARAbstractDialog.this._resetButton = IDARJButtonFactory.createResetButton(actionListener);
                IDARAbstractDialog.this._resetButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                GridBagUtil.constrain((Container)this, (Component)IDARAbstractDialog.this._resetButton, (int)0, (int)n++, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)0, (int)0, (int)0, (int)0, (int)0);
                vector.addElement(IDARAbstractDialog.this._resetButton);
                IDARAbstractDialog.this.setDefaultButton(32);
            }
            if ((IDARAbstractDialog.this._buttons & 2) == 2) {
                IDARAbstractDialog.this._cancelButton = IDARJButtonFactory.createCancelButton((ActionListener)actionListener);
                IDARAbstractDialog.this._cancelButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                IDARAbstractDialog.this._focusComponent = IDARAbstractDialog.this._cancelButton;
                GridBagUtil.constrain((Container)this, (Component)IDARAbstractDialog.this._cancelButton, (int)0, (int)n++, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)0, (int)6, (int)0, (int)0, (int)0);
                vector.addElement(IDARAbstractDialog.this._cancelButton);
            }
            if ((IDARAbstractDialog.this._buttons & 4) == 4) {
                IDARAbstractDialog.this._closeButton = IDARJButtonFactory.createCloseButton((ActionListener)actionListener);
                IDARAbstractDialog.this._closeButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                IDARAbstractDialog.this._focusComponent = IDARAbstractDialog.this._closeButton;
                GridBagUtil.constrain((Container)this, (Component)IDARAbstractDialog.this._closeButton, (int)0, (int)n++, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)0, (int)0, (int)0, (int)0, (int)0);
                IDARAbstractDialog.this.setDefaultButton(4);
                vector.addElement(IDARAbstractDialog.this._closeButton);
            }
            if ((IDARAbstractDialog.this._buttons & 8) == 8) {
                IDARAbstractDialog.this._helpButton = IDARJButtonFactory.createHelpButton((ActionListener)actionListener);
                IDARAbstractDialog.this._helpButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                GridBagUtil.constrain((Container)this, (Component)IDARAbstractDialog.this._helpButton, (int)0, (int)n++, (int)1, (int)1, (double)1.0, (double)0.0, (int)11, (int)0, (int)12, (int)0, (int)0, (int)0);
                vector.addElement(IDARAbstractDialog.this._helpButton);
            }
            Object[] objectArray = new JButton[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null) {
                IDARJButtonFactory.resize((JButton[])objectArray);
            }
        }
    }

    class HorizontalButtonPanel
    extends Box {
        HorizontalButtonPanel(ActionListener actionListener) {
            super(0);
            Vector<JButton> vector = new Vector<JButton>();
            this.add(Box.createHorizontalGlue());
            if ((IDARAbstractDialog.this._buttons & 1) == 1) {
                IDARAbstractDialog.this._okButton = IDARJButtonFactory.createOKButton((ActionListener)actionListener);
                IDARAbstractDialog.this._okButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                this.add(Box.createHorizontalStrut(6));
                this.add(IDARAbstractDialog.this._okButton);
                vector.addElement(IDARAbstractDialog.this._okButton);
                IDARAbstractDialog.this.setDefaultButton(1);
            }
            if ((IDARAbstractDialog.this._buttons & 0x10) == 16) {
                IDARAbstractDialog.this._saveButton = IDARJButtonFactory.createSaveButton(actionListener);
                IDARAbstractDialog.this._saveButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                this.add(Box.createHorizontalStrut(6));
                this.add(IDARAbstractDialog.this._saveButton);
                vector.addElement(IDARAbstractDialog.this._saveButton);
                IDARAbstractDialog.this.setDefaultButton(16);
            }
            if ((IDARAbstractDialog.this._buttons & 0x20) == 32) {
                IDARAbstractDialog.this._resetButton = IDARJButtonFactory.createResetButton(actionListener);
                IDARAbstractDialog.this._resetButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                this.add(Box.createHorizontalStrut(6));
                this.add(IDARAbstractDialog.this._resetButton);
                vector.addElement(IDARAbstractDialog.this._resetButton);
                IDARAbstractDialog.this.setDefaultButton(32);
            }
            if ((IDARAbstractDialog.this._buttons & 2) == 2) {
                IDARAbstractDialog.this._cancelButton = IDARJButtonFactory.createCancelButton((ActionListener)actionListener);
                IDARAbstractDialog.this._cancelButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                IDARAbstractDialog.this._focusComponent = IDARAbstractDialog.this._cancelButton;
                this.add(Box.createHorizontalStrut(6));
                this.add(IDARAbstractDialog.this._cancelButton);
                vector.addElement(IDARAbstractDialog.this._cancelButton);
            }
            if ((IDARAbstractDialog.this._buttons & 4) == 4) {
                IDARAbstractDialog.this._closeButton = IDARJButtonFactory.createCloseButton((ActionListener)actionListener);
                IDARAbstractDialog.this._closeButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                IDARAbstractDialog.this._focusComponent = IDARAbstractDialog.this._closeButton;
                this.add(Box.createHorizontalStrut(6));
                this.add(IDARAbstractDialog.this._closeButton);
                IDARAbstractDialog.this.setDefaultButton(4);
                vector.addElement(IDARAbstractDialog.this._closeButton);
            }
            if ((IDARAbstractDialog.this._buttons & 8) == 8) {
                IDARAbstractDialog.this._helpButton = IDARJButtonFactory.createHelpButton((ActionListener)actionListener);
                IDARAbstractDialog.this._helpButton.addFocusListener(IDARAbstractDialog.this._focusListener);
                this.add(Box.createHorizontalStrut(12));
                this.add(IDARAbstractDialog.this._helpButton);
                vector.addElement(IDARAbstractDialog.this._helpButton);
            }
            Object[] objectArray = new JButton[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null) {
                IDARJButtonFactory.resize((JButton[])objectArray);
            }
        }
    }

    class DialogActionListener
    implements ActionListener {
        DialogActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals("OK")) {
                    IDARAbstractDialog.this.okInvoked();
                } else if (string.equals("CLOSE")) {
                    IDARAbstractDialog.this.closeInvoked();
                } else if (string.equals("CANCEL")) {
                    IDARAbstractDialog.this.cancelInvoked();
                } else if (string.equals("HELP")) {
                    IDARAbstractDialog.this.helpInvoked();
                } else if (string.equals("SAVE")) {
                    IDARAbstractDialog.this.saveInvoked();
                } else if (string.equals("RESET")) {
                    IDARAbstractDialog.this.resetInvoked();
                }
            }
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        DialogWindowListener() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (IDARAbstractDialog.this._focusComponent != null) {
                IDARAbstractDialog.this._focusComponent.requestFocus();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            IDARAbstractDialog.this.cancelInvoked();
        }
    }

    class ResizeComponentListener
    implements ComponentListener {
        ResizeComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (IDARAbstractDialog.this.isResizable()) {
                boolean bl;
                boolean bl2 = IDARAbstractDialog.this.getSize().width < IDARAbstractDialog.this.minWidth;
                boolean bl3 = bl = IDARAbstractDialog.this.getSize().height < IDARAbstractDialog.this.minHeight;
                if (bl2 || bl) {
                    IDARAbstractDialog.this.setSize(bl2 ? IDARAbstractDialog.this.minWidth : IDARAbstractDialog.this.getSize().width, bl ? IDARAbstractDialog.this.minHeight : IDARAbstractDialog.this.getSize().height);
                }
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }
}

