/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.components;

import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.components.PrecedenceTableSorter;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PrecedenceTable
extends JPanel
implements SuiConstants {
    private static final boolean DEBUG = false;
    protected static final Icon UP = ImageFactory.getImage("UP16");
    protected static final Icon DOWN = ImageFactory.getImage("DOWN16");
    private JTable table;
    private PrecedenceTableSorter model;
    private JButton butHigher;
    private JButton butLower;

    public PrecedenceTable() {
        this((PrecedenceTableSorter)null);
    }

    public PrecedenceTable(PrecedenceTableSorter precedenceTableSorter) {
        this.setModel(precedenceTableSorter);
        this.initComponents();
    }

    public void setModel(PrecedenceTableSorter precedenceTableSorter) {
        this.model = precedenceTableSorter;
        if (this.table != null) {
            this.table.setModel(precedenceTableSorter);
            precedenceTableSorter.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    PrecedenceTable.this.setButtonEnablement();
                }
            });
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setTable(JTable jTable) {
        if (jTable != null) {
            this.table = jTable;
            if (this.model != null) {
                jTable.setModel(this.model);
            }
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    PrecedenceTable.this.setButtonEnablement();
                }
            });
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public void setToolTipText(String string) {
        if (this.table != null) {
            this.table.setToolTipText(string);
        }
    }

    public JButton getHigherPrecedenceButton() {
        return this.butHigher;
    }

    public JButton getLowerPrecedenceButton() {
        return this.butLower;
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.table.setPreferredScrollableViewportSize(dimension);
    }

    public void addRowSelectionInterval(int n, int n2) {
        this.table.addRowSelectionInterval(n, n2);
    }

    protected void initComponents() {
        this.setTable(new JTable());
        this.butHigher = new JButton(UP);
        this.butHigher.setToolTipText(IDARResourceSet.getString("tooltip", "upgrade_priority"));
        this.butHigher.setEnabled(false);
        this.butHigher.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PrecedenceTable.this.table.getSelectedRow();
                PrecedenceTable.this.model.swapPrecedences(n, n - 1);
                PrecedenceTable.this.table.setRowSelectionInterval(n - 1, n - 1);
            }
        });
        this.butLower = new JButton(DOWN);
        this.butLower.setToolTipText(IDARResourceSet.getString("tooltip", "downgrade_priority"));
        this.butLower.setEnabled(false);
        this.butLower.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PrecedenceTable.this.table.getSelectedRow();
                PrecedenceTable.this.model.swapPrecedences(n, n + 1);
                PrecedenceTable.this.table.setRowSelectionInterval(n + 1, n + 1);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.butHigher, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.butLower, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "East");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void setButtonEnablement() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        if (n2 != 0 && n != -1 && this.table.getSelectedRowCount() == 1) {
            if (n > 0) {
                bl = true;
            }
            if (n < n2 - 1) {
                bl2 = true;
            }
        }
        this.butHigher.setEnabled(bl);
        this.butLower.setEnabled(bl2);
    }

    public void dumpTable() {
        int n = this.model.getColumnCount();
        int n2 = this.model.getRowCount();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Debug.print((String)(this.model.getValueAt(i, j) + "\t"));
            }
            Debug.println((int)this.model.getPrecedenceOf(i));
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new PrecedenceTable());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

