/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.configuration;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.UnknownBeanTypeException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.LoadErrorPanel;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.util.Debug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class DynamicConfigurationView
extends ConfigurationView {
    IDARReference beanRef = null;
    IDARReference configuration = null;
    String id = null;
    String descriptor = null;
    boolean needsReloading = true;
    boolean isLoading = false;
    protected static final String CONTENT = "content";
    protected static final String ERROR = "error";
    protected static final String LOAD = "load";
    private String currentCard;
    private CardLayout cardLayout;
    private IDARReference lastRef;

    protected abstract JPanel getContentPanel();

    public DynamicConfigurationView() {
        this.initComponents();
    }

    public void initComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(IDARResourceSet.getString("general", "LOADING"), 0), "Center");
        LoadErrorPanel loadErrorPanel = new LoadErrorPanel();
        loadErrorPanel.addReloadButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Debug.println((String)("DynamicConfigurationView.pnlError.reloadButton.action: lastRef=" + DynamicConfigurationView.this.lastRef));
                if (DynamicConfigurationView.this.lastRef != null) {
                    DynamicConfigurationView.this.setModelInfo(DynamicConfigurationView.this.lastRef);
                }
            }
        });
        this.add(ERROR, loadErrorPanel);
        this.add(LOAD, jPanel);
        this.currentCard = LOAD;
        this.cardLayout.show(this, LOAD);
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        super.setDataModel(iDARModelBean, bl);
        JPanel jPanel = this.getPanel();
        this.add(CONTENT, jPanel);
        this.currentCard = CONTENT;
        if (SwingUtilities.isEventDispatchThread()) {
            this.cardLayout.show(this, CONTENT);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DynamicConfigurationView.this.cardLayout.show(DynamicConfigurationView.this, DynamicConfigurationView.CONTENT);
                }
            });
        }
    }

    public void setModelInfo(IDARReference iDARReference, String string, String string2) {
        Debug.println((String)("DynamicConfigurationView.setModelInfo: config=" + iDARReference + " id=" + string + " desc=" + string2));
        this.currentCard = LOAD;
        this.cardLayout.show(this, LOAD);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DynamicConfigurationView.this.paintImmediately(DynamicConfigurationView.this.getVisibleRect());
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            this.paintImmediately(this.getVisibleRect());
        }
        BeanLoader beanLoader = new BeanLoader();
        beanLoader.setInfo(string, string2, iDARReference);
        beanLoader.setPriority(3);
        beanLoader.start();
        try {
            this.lastRef = BeanSpace.getInstance().getBeanReference(string, string2, iDARReference);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModelInfo(IDARReference iDARReference) {
        Debug.println((String)("DynamicConfigurationView.setModelInfo: ref=" + iDARReference));
        this.currentCard = LOAD;
        this.cardLayout.show(this, LOAD);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DynamicConfigurationView.this.paintImmediately(DynamicConfigurationView.this.getVisibleRect());
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            this.paintImmediately(this.getVisibleRect());
        }
        BeanLoader beanLoader = new BeanLoader();
        beanLoader.setReference(iDARReference);
        beanLoader.setPriority(3);
        beanLoader.start();
        this.lastRef = iDARReference;
    }

    public void addNotify() {
        Debug.println((int)6, (String)"DynamicConfigurationView.addNotify");
        super.addNotify();
        if (this.isLoading) {
            this.commenceProgressBar();
        }
    }

    public void commenceProgressBar() {
        Debug.println((int)6, (String)"DynamicConfigurationView.commenceProgressBar");
        final IFramework iFramework = IDARUtilities.getFramework(this);
        if (iFramework != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(-1));
                }
            });
        }
    }

    public void stopProgressBar() {
        Debug.println((int)6, (String)"DynamicConfigurationView.stopProgressBar");
        IFramework iFramework = null;
        iFramework = IDARUtilities.getFramework(this);
        if (iFramework != null) {
            iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
        }
    }

    public JPanel getPanel() {
        return this.getContentPanel();
    }

    public void showError() {
        this.currentCard = ERROR;
        this.cardLayout.show(this, ERROR);
    }

    public boolean isShowingError() {
        return this.currentCard.equals(ERROR);
    }

    public void showContent() {
        this.currentCard = CONTENT;
        this.cardLayout.show(this, CONTENT);
    }

    public boolean isShowingContent() {
        return this.currentCard.equals(CONTENT);
    }

    public boolean isNeedsReloading() {
        return this.needsReloading;
    }

    public void setNeedsReloading(boolean bl) {
        this.needsReloading = bl;
    }

    class BeanLoader
    extends Thread {
        IDARReference ref;
        IDARReference config;
        String id;
        String descriptor;

        BeanLoader() {
        }

        public void setInfo(String string, String string2, IDARReference iDARReference) {
            this.id = string;
            this.descriptor = string2;
            this.config = iDARReference;
            this.setName("iDAR Bean Loader");
        }

        public void setReference(IDARReference iDARReference) {
            this.ref = iDARReference;
        }

        public IDARReference getReference() {
            return this.ref;
        }

        public void run() {
            Debug.println((String)"DynamicConfigurationView.BeanLoader.run");
            DynamicConfigurationView.this.isLoading = true;
            DynamicConfigurationView.this.commenceProgressBar();
            IDARModelBean iDARModelBean = null;
            String string = null;
            try {
                iDARModelBean = this.ref == null ? BeanSpace.getInstance().retrieveBean(this.id, this.descriptor, this.config) : BeanSpace.getInstance().retrieveBean(this.ref);
            }
            catch (UnknownBeanTypeException unknownBeanTypeException) {
                string = unknownBeanTypeException.getMessage();
            }
            catch (RetrievalException retrievalException) {
                string = retrievalException.getMessage();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                string = noSuchBeanException.getMessage();
            }
            Debug.println((String)"DynamicConfigurationView.BeanLoader.run: got bean");
            if (this.ref == null && iDARModelBean != null) {
                this.ref = iDARModelBean.getSelfReference();
            }
            DynamicConfigurationView.this.setDataModel(iDARModelBean);
            String string2 = string;
            SwingUtilities.invokeLater(new Runnable(this, string2){
                private final /* synthetic */ String val$finalErrorMessage;
                private final /* synthetic */ BeanLoader this$1;
                {
                    this.this$1 = beanLoader;
                    this.val$finalErrorMessage = string;
                }

                public void run() {
                    BeanLoader.access$200(this.this$1).stopProgressBar();
                    BeanLoader.access$200((BeanLoader)this.this$1).isLoading = false;
                    if (this.val$finalErrorMessage != null) {
                        BeanLoader.access$200(this.this$1).showError();
                        JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(BeanLoader.access$200(this.this$1)), IDARResourceSet.getString("error", "MODEL_RETRIEVAL_MESSAGE"), IDARResourceSet.getString("error", "MODEL_RETRIEVAL_TITLE"), 0);
                        BeanLoader.access$200(this.this$1).setNeedsReloading(true);
                    } else {
                        BeanLoader.access$200(this.this$1).showContent();
                        BeanLoader.access$200(this.this$1).setNeedsReloading(false);
                    }
                }
            });
        }

        static /* synthetic */ DynamicConfigurationView access$200(BeanLoader beanLoader) {
            return beanLoader.DynamicConfigurationView.this;
        }
    }
}

