/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.action;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.ActionToGroupData;
import com.iplanet.idar.objectmodel.bean.ChangeGroupActionBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.ui.common.AbstractChooserDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.TableModelBeanListener;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.components.PrecedenceTable;
import com.iplanet.idar.ui.common.components.PrecedenceTableModel;
import com.iplanet.idar.ui.common.components.PrecedenceTableSorter;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.action.ActionView;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ChangeGroupView
extends ConfigurationView
implements SuiConstants {
    private boolean DEBUG = true;
    private static final String HELP_TOPIC = "Action-ChangeGroup";
    private TitlePanel pnlTitle;
    private ActionView viewAction;
    private JTextArea txtNote;
    private JButton butNew;
    private JButton butEdit;
    private JButton butDelete;
    private PrecedenceTable tblTable;
    private PrecedenceTableSorter sorter;
    private ToGroupTableModel tableModel;
    private DNExpressionEditor dnExpressionEditor = new DNExpressionEditor();
    private JPopupMenu popup;
    private static final String GROUP = IDARResourceSet.getString("actionChangeGroupSettings", "GROUP");
    private static final String DN_EXPR = IDARResourceSet.getString("actionChangeGroupSettings", "DN_EXPRESSION");
    private static final String NO_CHANGE = IDARResourceSet.getString("actionChangeGroupSettings", "NO_CHANGE");
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();

    public ChangeGroupView() {
        this.initComponents();
    }

    public ChangeGroupView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public ChangeGroupView(ConsoleInfo consoleInfo, ChangeGroupActionBean changeGroupActionBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(changeGroupActionBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean) {
        super.setDataModel(iDARModelBean);
        if (this.tableModel != null) {
            this.tableModel.setParentConfiguration(iDARModelBean.getParentConfiguration());
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    public String getTitleText() {
        return IDARResourceSet.getString("actionChangeGroupAction", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void resetContent() throws ConfigurationViewException {
        try {
            ChangeGroupActionBean changeGroupActionBean = (ChangeGroupActionBean)super.getDataModel();
            if (changeGroupActionBean != null) {
                this.dnExpressionEditor.stopCellEditing();
                this.viewAction.setDataModel(changeGroupActionBean);
                this.viewAction.resetContent();
                ActionToGroupData[] actionToGroupDataArray = changeGroupActionBean.getGroupData();
                if (actionToGroupDataArray != null) {
                    this.tableModel.setToGroupData(actionToGroupDataArray);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        try {
            ChangeGroupActionBean changeGroupActionBean = (ChangeGroupActionBean)super.getDataModel();
            if (changeGroupActionBean != null) {
                this.dnExpressionEditor.stopCellEditing();
                if (this.tableModel.getRowCount() == 0) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_TO_GROUP_DATA"));
                }
                ActionToGroupData[] actionToGroupDataArray = this.tableModel.getToGroupData();
                Arrays.sort(actionToGroupDataArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n = 0;
                        if (object instanceof ActionToGroupData && object2 instanceof ActionToGroupData) {
                            Integer n2 = ((ActionToGroupData)object).getPrecedence();
                            Integer n3 = ((ActionToGroupData)object2).getPrecedence();
                            if (n2 != null) {
                                n = n2.compareTo(n3);
                            } else if (n3 != null) {
                                n = n3.compareTo(n2);
                            }
                        }
                        return n;
                    }

                    public boolean equals(Object object) {
                        return false;
                    }
                });
                for (int i = 1; i < actionToGroupDataArray.length; ++i) {
                    if (!actionToGroupDataArray[i].getDnRegexp().equals(".*")) continue;
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "SUSPECT_TO_GROUP_DATA"));
                }
                this.viewAction.setDataModel(changeGroupActionBean);
                this.viewAction.applyChanges();
                changeGroupActionBean.setGroupData(this.tableModel.getToGroupData());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public JPanel getPanel() {
        return this;
    }

    protected void initComponents() {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("ACTION"));
        this.pnlTitle.setText(this.getTitleText());
        this.viewAction = new ActionView();
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("actionChangeGroupSettings", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.initPopupMenu();
        this.butNew = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
        this.butNew.setToolTipText(IDARResourceSet.getString("tooltip", "add_group"));
        this.butNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeGroupView.this.dnExpressionEditor.stopCellEditing();
                ChangeGroupView.this.popup.show(ChangeGroupView.this, ChangeGroupView.this.butNew.getX() + ChangeGroupView.this.butNew.getWidth(), ChangeGroupView.this.butNew.getY());
            }
        });
        this.butEdit = new TaskButton(this.editTask);
        this.editTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                ChangeGroupView.this.dnExpressionEditor.stopCellEditing();
            }
        });
        this.butDelete = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
        this.butDelete.setToolTipText(IDARResourceSet.getString("tooltip", "remove_group"));
        this.butDelete.setEnabled(false);
        this.butDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeGroupView.this.dnExpressionEditor.stopCellEditing();
                int n = ChangeGroupView.this.tblTable.getSelectedRow();
                if (n != -1) {
                    ChangeGroupView.this.sorter.removeRow(n);
                    int n2 = ChangeGroupView.this.tblTable.getRowCount();
                    if (n2 > 0) {
                        if (n >= n2) {
                            n = n2 - 1;
                        }
                        ChangeGroupView.this.tblTable.addRowSelectionInterval(n, n);
                    }
                    ChangeGroupView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(ChangeGroupView.this.sorter)));
                }
            }
        });
        IDARModelBean iDARModelBean = this.getDataModel();
        IDARReference iDARReference = null;
        if (iDARModelBean != null) {
            iDARReference = iDARModelBean.getParentConfiguration();
        }
        this.tableModel = new ToGroupTableModel(iDARReference);
        this.sorter = new PrecedenceTableSorter(this.tableModel);
        this.tblTable = new PrecedenceTable(this.sorter);
        this.tblTable.setToolTipText(IDARResourceSet.getString("tooltip", "to_group"));
        this.tblTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.tblTable.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChangeGroupView.this.setEnablement();
            }
        });
        this.tblTable.getTable().getColumnModel().getColumn(1).setCellEditor(this.dnExpressionEditor);
        this.tblTable.getHigherPrecedenceButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeGroupView.this.dnExpressionEditor.cancelCellEditing();
            }
        });
        this.tblTable.getLowerPrecedenceButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeGroupView.this.dnExpressionEditor.cancelCellEditing();
            }
        });
        this.tblTable.getTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ChangeGroupView.this.butEdit.doClick();
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.viewAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butNew, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.tblTable, gridBagConstraints);
    }

    private void setEnablement() {
        boolean bl = this.tblTable.getRowCount() != 0 && this.tblTable.getSelectedRow() != -1 && this.tblTable.getRowCount() > this.tblTable.getSelectedRow();
        this.butDelete.setEnabled(bl);
        this.editTask.setObject(this.getSelectedReference());
    }

    private IDARReference getSelectedReference() {
        IDARReference iDARReference = null;
        int n = this.tblTable.getSelectedRow();
        Object object = null;
        if (n > -1) {
            object = this.sorter.getValueAt(n, 0);
        }
        if (object != null) {
            String string = object.toString();
            try {
                iDARReference = BeanSpace.getInstance().getBeanReference(string, "group", this.getDataModel().getParentConfiguration());
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        } else {
            Debug.println((int)0, (String)"ERROR: VALUE IS NULL");
        }
        return iDARReference;
    }

    private void initPopupMenu() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(IDARResourceSet.getString("actionChangeGroupSettings", "ADD_CHANGE_GROUP"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDARModelBean iDARModelBean = ChangeGroupView.this.getDataModel();
                if (iDARModelBean != null) {
                    AbstractChooserDialog abstractChooserDialog = new AbstractChooserDialog(IDARUtilities.getParentFrame(ChangeGroupView.this), IDARResourceSet.getString("dialogGroupChooser", "TITLE"), IDARResourceSet.getString("dialogGroupChooser", "NOTE"), ChangeGroupView.this.getDataModel().getParentConfiguration(), "network-group", ChangeGroupView.super.getConsoleInfo(), true);
                    abstractChooserDialog.show();
                    if (!abstractChooserDialog.isCancel()) {
                        BeanListenable beanListenable = abstractChooserDialog.getSelectedBean();
                        ChangeGroupView.this.sorter.addRow(new Object[]{new ActionToGroupData(beanListenable.getSelfReference())});
                        ChangeGroupView.this.tableModel.dumpTable();
                        ChangeGroupView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(ChangeGroupView.this.sorter)));
                    }
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(IDARResourceSet.getString("actionChangeGroupSettings", "ADD_NO_CHANGE_GROUP"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeGroupView.this.sorter.addRow(new Object[]{new ActionToGroupData(null, "NONE")});
                ChangeGroupView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(ChangeGroupView.this.sorter)));
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ChangeGroupView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class DNExpressionEditor
    extends JPanel
    implements TableCellEditor {
        JTextField tfDNExpression;
        Vector listeners = new Vector();
        String originalValue;
        DocumentListener docListener = new DocumentListener(this){
            private final /* synthetic */ DNExpressionEditor this$1;
            {
                this.this$1 = dNExpressionEditor;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.fire();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.fire();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.fire();
            }

            private void fire() {
                DNExpressionEditor.access$1300(this.this$1).fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(ChangeGroupView.access$400(DNExpressionEditor.access$1300(this.this$1)))));
            }
        };

        public DNExpressionEditor() {
            this.setLayout(new BorderLayout());
            this.tfDNExpression = new JTextField();
            this.tfDNExpression.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke('\n'), new AbstractAction(this){
                private final /* synthetic */ DNExpressionEditor this$1;
                {
                    this.this$1 = dNExpressionEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
            this.add((Component)this.tfDNExpression, "Center");
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = IDARUtilities.normalizeDnExpression(object.toString());
            this.tfDNExpression.setText(string);
            this.tfDNExpression.getDocument().addDocumentListener(this.docListener);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.tfDNExpression.getDocument().removeDocumentListener(this.docListener);
            this.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            return IDARUtilities.normalizeDnExpression(this.tfDNExpression.getText());
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.tfDNExpression.getDocument().removeDocumentListener(this.docListener);
            this.fireEditingStopped();
            return true;
        }

        protected void fireEditingCanceled() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
                cellEditorListener.editingCanceled(changeEvent);
            }
        }

        protected void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
                cellEditorListener.editingStopped(changeEvent);
            }
        }

        public String toString() {
            return "PercentageEditor[value=" + this.tfDNExpression.getText() + "]";
        }

        static /* synthetic */ ChangeGroupView access$1300(DNExpressionEditor dNExpressionEditor) {
            return dNExpressionEditor.ChangeGroupView.this;
        }
    }

    class ToGroupTableModel
    extends DefaultTableModel
    implements PrecedenceTableModel {
        IDARReference config = null;
        TableModelBeanListener monitor = null;

        public ToGroupTableModel(IDARReference iDARReference) {
            super(new Object[]{GROUP, DN_EXPR}, 0);
            this.setParentConfiguration(iDARReference);
            this.monitor = new TableModelBeanListener(this);
        }

        public void setParentConfiguration(IDARReference iDARReference) {
            this.config = iDARReference;
        }

        public int getPrecedenceOf(int n) {
            ActionToGroupData actionToGroupData = (ActionToGroupData)super.getValueAt(n, 0);
            return actionToGroupData.getPrecedence();
        }

        public void setPrecedenceOf(int n, int n2) {
            ActionToGroupData actionToGroupData = (ActionToGroupData)super.getValueAt(n, 0);
            actionToGroupData.setPrecedence(new Integer(n2));
            ChangeGroupView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(this)));
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Object getValueAt(int n, int n2) {
            Debug.println((int)0, (String)("row=" + n + " col=" + n2));
            Object object = null;
            ActionToGroupData actionToGroupData = (ActionToGroupData)super.getValueAt(n, 0);
            switch (n2) {
                case 0: {
                    object = actionToGroupData.getGroupId();
                    if (object != null && !object.equals("NONE")) break;
                    object = NO_CHANGE;
                    break;
                }
                case 1: {
                    object = actionToGroupData.getDnRegexp();
                    break;
                }
                case 2: {
                    object = actionToGroupData.getPrecedence();
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            Debug.println((int)0, (String)("row=" + n + " col=" + n2));
            try {
                ActionToGroupData actionToGroupData = (ActionToGroupData)super.getValueAt(n, 0);
                switch (n2) {
                    case 0: {
                        actionToGroupData.setGroupId(this.config, object.toString());
                        break;
                    }
                    case 1: {
                        actionToGroupData.setDnRegexp(object.toString());
                        break;
                    }
                    case 2: {
                        actionToGroupData.setPrecedence(new Integer(object.toString()));
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.fireTableDataChanged();
        }

        public void addRow(Vector vector) {
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            this.addRow(objectArray);
        }

        public void addRow(Object[] objectArray) {
            if (objectArray.length == 1 && objectArray[0] != null) {
                if (objectArray[0] instanceof ActionToGroupData) {
                    this.addToGroup((ActionToGroupData)objectArray[0]);
                } else {
                    this.addToGroup(new ActionToGroupData(this.config, objectArray[0].toString()));
                }
            } else if (objectArray.length > 2) {
                Object object = objectArray[0];
                Object object2 = objectArray[1];
                String string = objectArray[2].toString();
                Integer n = null;
                try {
                    n = new Integer(string.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (object != null && object2 != null) {
                    this.addToGroup(new ActionToGroupData(this.config, object.toString(), object2.toString(), n));
                }
            }
        }

        public void addToGroup(ActionToGroupData actionToGroupData) {
            if (actionToGroupData != null && actionToGroupData.isValid()) {
                Debug.println((int)0, (String)("ToGroupTableModel.addToGroup: atgd=" + actionToGroupData));
                Vector<ActionToGroupData> vector = new Vector<ActionToGroupData>();
                vector.add(actionToGroupData);
                super.addRow(vector);
                BeanListenable beanListenable = actionToGroupData.getGroup();
                if (beanListenable != null) {
                    beanListenable.addBeanListener(this.monitor);
                }
                this.newRowsAdded(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
            } else {
                Debug.println((int)0, (String)("ToGroupTableModel.addToGroup: invalid data " + actionToGroupData));
            }
            if (ChangeGroupView.this.DEBUG) {
                this.dumpTable();
            }
        }

        public void setToGroupData(ActionToGroupData[] actionToGroupDataArray) {
            this.removeAllToGroupData();
            for (int i = 0; i < actionToGroupDataArray.length; ++i) {
                this.addToGroup(actionToGroupDataArray[i]);
            }
            this.fireTableDataChanged();
        }

        public void removeAllToGroupData() {
            Debug.println((int)0, (String)(" row count=" + this.getRowCount()));
            Vector<Vector> vector = this.getDataVector();
            Debug.println((int)0, (String)(" dataVector.size=" + vector.size()));
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = vector.elementAt(i);
                ActionToGroupData actionToGroupData = (ActionToGroupData)vector2.elementAt(0);
                BeanListenable beanListenable = actionToGroupData.getGroup();
                if (beanListenable == null) continue;
                beanListenable.removeBeanListener(this.monitor);
            }
            vector.clear();
            Debug.println((int)0, (String)(" row count=" + this.getRowCount()));
        }

        public ActionToGroupData[] getToGroupData() {
            ActionToGroupData[] actionToGroupDataArray = new ActionToGroupData[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                actionToGroupDataArray[i] = (ActionToGroupData)super.getValueAt(i, 0);
            }
            return actionToGroupDataArray;
        }

        public void dumpTable() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                ActionToGroupData actionToGroupData = (ActionToGroupData)super.getValueAt(i, 0);
                Debug.println((int)0, (String)("model index= " + i));
                Debug.println((int)0, (String)("dn regex=" + actionToGroupData.getDnRegexp()));
                Debug.println((int)0, (String)("groupid=" + actionToGroupData.getGroupId()));
                Debug.println((int)0, (String)("precedence=" + actionToGroupData.getPrecedence()));
            }
        }
    }
}

