/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.AbstractChooserDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.ObjectTableModel;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AttributeRenamingView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Attribute-Renaming";
    private ObjectTableModel tableModel;
    private String[] colNames = new String[]{"Name"};
    private Vector vAttributes;
    private int selectedRow;
    private JTable tblTable;
    final String[] descriptors = new String[]{"attribute-renaming"};
    private JTextArea txtNote;
    private JPanel pnlButtons;
    private JButton butAdd;
    private JButton butEdit;
    private JButton butRemove;
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();

    public AttributeRenamingView() {
        this.initComponents();
    }

    public AttributeRenamingView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("ReferralView: Unable to resetContent: model = " + networkGroupBean));
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.pnlButtons = this.initButtonBar();
        this.tableModel = new ObjectTableModel(false);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AttributeRenamingView.this.setEnablement();
            }
        });
        this.tblTable = new JTable(this.tableModel);
        this.tblTable.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_attribute_renaming_property"));
        this.tblTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.tblTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AttributeRenamingView.this.setEnablement();
            }
        });
        this.tblTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AttributeRenamingView.this.butEdit.doClick();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tblTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.setLayout(new GridBagLayout());
        this.txtNote.setText(IDARResourceSet.getString("groupAttributeRenaming", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    protected JPanel initButtonBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 6, 0));
        this.butAdd = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
        this.butAdd.setToolTipText(IDARResourceSet.getString("tooltip", "add_attribute_renaming_property"));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDARModelBean iDARModelBean = AttributeRenamingView.this.getDataModel();
                if (iDARModelBean != null) {
                    AbstractChooserDialog abstractChooserDialog = new AbstractChooserDialog(IDARUtilities.getParentFrame(AttributeRenamingView.this), IDARResourceSet.getString("groupAttributeRenaming", "CHOOSER_RENAMING_TITLE"), IDARResourceSet.getString("groupAttributeRenaming", "CHOOSER_RENAMING_NOTE"), iDARModelBean.getParentConfiguration(), AttributeRenamingView.this.descriptors, AttributeRenamingView.this.getConsoleInfo(), true);
                    abstractChooserDialog.show();
                    if (!abstractChooserDialog.isCancel()) {
                        AttributeRenamingView.this.vAttributes = abstractChooserDialog.getSelectedBeans();
                        for (int i = 0; i < AttributeRenamingView.this.vAttributes.size(); ++i) {
                            AttributeRenamingView.this.tableModel.addElement((BeanListenable)AttributeRenamingView.this.vAttributes.elementAt(i));
                            AttributeRenamingView.this.tblTable.revalidate();
                        }
                        AttributeRenamingView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(AttributeRenamingView.this.tableModel)));
                    }
                }
            }
        });
        this.butEdit = new TaskButton(this.editTask);
        this.butEdit.setToolTipText(IDARResourceSet.getString("tooltip", "edit_attribute_renaming_property"));
        ButtonFactory.resizeButton((JButton)this.butEdit);
        this.butRemove = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
        this.butRemove.setToolTipText(IDARResourceSet.getString("tooltip", "remove_attribute_renaming_property"));
        this.butRemove.setEnabled(false);
        this.butRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeRenamingView.this.selectedRow = AttributeRenamingView.this.tblTable.getSelectedRow();
                AttributeRenamingView.this.tableModel.removeElement(AttributeRenamingView.this.selectedRow);
                AttributeRenamingView.this.setEnablement();
                AttributeRenamingView.this.tblTable.revalidate();
                AttributeRenamingView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(AttributeRenamingView.this.tableModel)));
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.butAdd);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.butEdit);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.butRemove);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void setEnablement() {
        boolean bl = this.tblTable.getRowCount() != 0 && this.tblTable.getSelectedRow() != -1 && this.tblTable.getRowCount() > this.tblTable.getSelectedRow();
        this.butRemove.setEnabled(bl);
        this.editTask.setObject(this.tableModel.getReference(this.tblTable.getSelectedRow()));
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            networkGroupBean.removeAllRenamingAttributes();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                vector.add((String)this.tableModel.getValueAt(i, 0));
            }
            networkGroupBean.setAttributeRenamingPropertyIds(vector);
        } else {
            Debug.println((String)("AttributeRenamingView:applyChanges(): model= " + networkGroupBean));
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupAttributeRenaming", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("AttributeRenamingView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.tableModel.removeAllElements();
            this.tableModel.setElements(networkGroupBean.getAttributeRenamingProperties());
            this.tblTable.revalidate();
        } else {
            Debug.println((String)("AttributeRenamingView:resetContent: model= " + networkGroupBean));
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new AttributeRenamingView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

