/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.NewItemListener;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GeneralView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-General";
    private JPanel pnlEvents;
    private JLabel lblOnBind;
    private JComboBox cboOnBind;
    private JButton butNewOnBind;
    private JButton butEditOnBind;
    private NewItemListener newOnBindListener;
    private JLabel lblOnSSL;
    private JComboBox cboOnSSL;
    private JButton butNewOnSSL;
    private JButton butEditOnSSL;
    private NewItemListener newOnSSLListener;
    protected final IplanetEditObjectTask editOnBindTask = new IplanetEditObjectTask();
    protected final IplanetEditObjectTask editOnSSLTask = new IplanetEditObjectTask();
    protected final IplanetCreateAndEditObjectTask createOnBindTask = new IplanetCreateAndEditObjectTask("on-bind");
    protected final IplanetCreateAndEditObjectTask createOnSSLTask = new IplanetCreateAndEditObjectTask("on-ssl");

    public GeneralView() {
        this.initComponents();
    }

    public GeneralView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        super.setDataModel(iDARModelBean, bl);
        if (iDARModelBean != null) {
            this.createOnBindTask.setParentConfiguration(iDARModelBean.getParentConfiguration());
            this.createOnSSLTask.setParentConfiguration(iDARModelBean.getParentConfiguration());
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editOnBindTask.setConsoleInfo(consoleInfo);
        this.editOnSSLTask.setConsoleInfo(consoleInfo);
        this.createOnBindTask.setConsoleInfo(consoleInfo);
        this.createOnSSLTask.setConsoleInfo(consoleInfo);
    }

    public DynamicComboBoxModel getOnBindListModel() {
        DynamicComboBoxModel dynamicComboBoxModel = null;
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            IDARBeanCollection iDARBeanCollection = null;
            try {
                iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(networkGroupBean.getParentConfiguration(), "on-bind");
            }
            catch (IDARBeanException iDARBeanException) {
                // empty catch block
            }
            if (iDARBeanCollection != null) {
                DynamicComboBoxModel dynamicComboBoxModel2 = (DynamicComboBoxModel)this.cboOnBind.getModel();
                dynamicComboBoxModel2.setBeanCollection(iDARBeanCollection);
                this.newOnBindListener.setModel(dynamicComboBoxModel2);
            }
        }
        return dynamicComboBoxModel;
    }

    public DynamicComboBoxModel getOnSslListModel() {
        DynamicComboBoxModel dynamicComboBoxModel = null;
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            IDARBeanCollection iDARBeanCollection = null;
            try {
                iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(networkGroupBean.getParentConfiguration(), "on-ssl");
            }
            catch (IDARBeanException iDARBeanException) {
                // empty catch block
            }
            if (iDARBeanCollection != null) {
                DynamicComboBoxModel dynamicComboBoxModel2 = (DynamicComboBoxModel)this.cboOnSSL.getModel();
                dynamicComboBoxModel2.setBeanCollection(iDARBeanCollection);
                this.newOnSSLListener.setModel(dynamicComboBoxModel2);
            }
        }
        return dynamicComboBoxModel;
    }

    protected void initComponents() {
        this.pnlEvents = new BlankPanel();
        this.pnlEvents.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("groupGeneral", "EVENT_PNL")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        this.lblOnBind = new JLabel(IDARResourceSet.getString("groupGeneral", "ON_BIND") + ":");
        this.cboOnBind = new JComboBox(new DynamicComboBoxModel());
        this.cboOnBind.setToolTipText(IDARResourceSet.getString("tooltip", "selected_on_bind_event"));
        this.cboOnBind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralView.this.setEnablement();
            }
        });
        this.butNewOnBind = new TaskButton(this.createOnBindTask);
        ButtonFactory.resizeButton((JButton)this.butNewOnBind);
        this.newOnBindListener = new NewItemListener(this.butNewOnBind);
        this.butNewOnSSL = new TaskButton(this.createOnSSLTask);
        ButtonFactory.resizeButton((JButton)this.butNewOnSSL);
        this.newOnSSLListener = new NewItemListener(this.butNewOnSSL);
        this.butEditOnBind = new TaskButton(this.editOnBindTask);
        ButtonFactory.resizeButton((JButton)this.butEditOnBind);
        this.butEditOnSSL = new TaskButton(this.editOnSSLTask);
        ButtonFactory.resizeButton((JButton)this.butEditOnSSL);
        this.lblOnSSL = new JLabel(IDARResourceSet.getString("groupGeneral", "ON_SSL") + ":");
        this.cboOnSSL = new JComboBox(new DynamicComboBoxModel());
        this.cboOnSSL.setToolTipText(IDARResourceSet.getString("tooltip", "selected_on_ssl_event"));
        this.cboOnSSL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralView.this.setEnablement();
            }
        });
        this.newOnSSLListener = new NewItemListener(this.butNewOnSSL);
        this.pnlEvents.setLayout(new GridBagLayout());
        boolean bl = false;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.pnlEvents.add((Component)this.lblOnBind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlEvents.add((Component)this.cboOnBind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.pnlEvents.add((Component)this.butNewOnBind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 9, 9);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        this.pnlEvents.add((Component)this.butEditOnBind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.pnlEvents.add((Component)this.lblOnSSL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlEvents.add((Component)this.cboOnSSL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.pnlEvents.add((Component)this.butNewOnSSL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 6, 9, 9);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.pnlEvents.add((Component)this.butEditOnSSL, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.pnlEvents, gridBagConstraints);
    }

    public void applyChanges() throws ConfigurationViewException {
        IDARModelBean iDARModelBean = this.getDataModel();
        if (iDARModelBean != null && iDARModelBean instanceof NetworkGroupBean) {
            Object object;
            NetworkGroupBean networkGroupBean = (NetworkGroupBean)iDARModelBean;
            networkGroupBean.removeAllRules();
            Object object2 = this.cboOnBind.getSelectedItem();
            if (object2 != null && !object2.equals(DynamicComboBoxModel.NONE)) {
                networkGroupBean.addRuleId(object2.toString());
            }
            if ((object = this.cboOnSSL.getSelectedItem()) != null && !object.equals(DynamicComboBoxModel.NONE)) {
                networkGroupBean.addRuleId(object.toString());
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupGeneral", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        IDARModelBean iDARModelBean = this.getDataModel();
        Debug.println((String)("GeneralView.resetContent: model=" + iDARModelBean));
        if (iDARModelBean != null && iDARModelBean instanceof NetworkGroupBean) {
            NetworkGroupBean networkGroupBean = (NetworkGroupBean)iDARModelBean;
            this.setRuleComboBoxes(networkGroupBean);
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    private void setRuleComboBoxes(NetworkGroupBean networkGroupBean) {
        Object object;
        if (this.cboOnBind != null) {
            if (this.cboOnBind.getModel() instanceof DynamicComboBoxModel && (object = this.getOnBindListModel()) != null) {
                this.cboOnBind.setModel(object);
            }
            object = networkGroupBean.getOnBindRuleId();
            Debug.println((String)("GeneralView.setRuleComboBoxes: onbind=" + (String)object));
            if (object == null) {
                this.cboOnBind.setSelectedItem(DynamicComboBoxModel.NONE);
            } else {
                this.cboOnBind.setSelectedItem(object);
            }
        }
        if (this.cboOnSSL != null) {
            if (this.cboOnSSL.getModel() instanceof DynamicComboBoxModel && (object = this.getOnSslListModel()) != null) {
                this.cboOnSSL.setModel(object);
            }
            object = networkGroupBean.getOnSSLRuleId();
            Debug.println((String)("GeneralView.setRuleComboBoxes: onbind=" + (String)object));
            if (object == null) {
                this.cboOnSSL.setSelectedItem(DynamicComboBoxModel.NONE);
            } else {
                this.cboOnSSL.setSelectedItem(object);
            }
        }
        this.setEnablement();
    }

    protected void setEnablement() {
        this.editOnBindTask.setObject(this.getSelectedReference("on-bind"));
        this.editOnSSLTask.setObject(this.getSelectedReference("on-ssl"));
    }

    private IDARReference getSelectedReference(String string) {
        IDARReference iDARReference = null;
        Object object = null;
        int n = -1;
        if (string.equals("on-bind")) {
            n = this.cboOnBind.getSelectedIndex();
            object = this.cboOnBind.getSelectedItem();
        } else if (string.equals("on-ssl")) {
            n = this.cboOnSSL.getSelectedIndex();
            object = this.cboOnSSL.getSelectedItem();
        }
        IDARModelBean iDARModelBean = this.getDataModel();
        if (iDARModelBean != null && object != null && string != null) {
            try {
                iDARReference = BeanSpace.getInstance().getBeanReference(object.toString(), string, iDARModelBean.getParentConfiguration());
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        return iDARReference;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new GeneralView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

