/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LDAPServerPropertyBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeneralView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-LDAPServer-Settings";
    private JLabel lblHost;
    private JTextField tfHost;
    private JLabel lblPort;
    private JTextField tfPort;
    private JLabel lblSecurePort;
    private JTextField tfSecurePort;
    private JLabel lblKeepAlive;
    private JTextField tfKeepAlive;
    private JCheckBox chkTCPNoDelay;
    protected JOptionPane opMessage;
    protected JDialog dMessage;

    public GeneralView(ConsoleInfo consoleInfo) {
        this.initComponents();
    }

    public GeneralView(ConsoleInfo consoleInfo, LDAPServerPropertyBean lDAPServerPropertyBean) {
        this.setDataModel(lDAPServerPropertyBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)this.getDataModel();
        if (lDAPServerPropertyBean != null) {
            this.tfHost.setText(lDAPServerPropertyBean.getHost());
            this.tfPort.setText(lDAPServerPropertyBean.getPort().toString());
            if (lDAPServerPropertyBean.getSecurePort() != null) {
                this.tfSecurePort.setText(lDAPServerPropertyBean.getSecurePort().toString());
            } else {
                this.tfSecurePort.setText("");
            }
            this.tfKeepAlive.setText(lDAPServerPropertyBean.getKeepAliveInterval().toString());
            this.chkTCPNoDelay.setSelected(lDAPServerPropertyBean.getNoDelay());
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)this.getDataModel();
        if (lDAPServerPropertyBean != null) {
            if (this.tfHost.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_HOST"));
            }
            lDAPServerPropertyBean.setHost(this.tfHost.getText());
            try {
                lDAPServerPropertyBean.setPort(new Integer(this.tfPort.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_PORT"));
            }
            if (!this.tfSecurePort.getText().trim().equals("")) {
                try {
                    lDAPServerPropertyBean.setSecurePort(new Integer(this.tfSecurePort.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_SPORT"));
                }
            } else {
                lDAPServerPropertyBean.setSecurePort(null);
            }
            if (!this.tfKeepAlive.getText().trim().equals("")) {
                try {
                    lDAPServerPropertyBean.setKeepAliveInterval(new Integer(this.tfKeepAlive.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_KEEP_ALIVE"));
                }
            } else {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_KEEP_ALIVE"));
            }
            if (!this.chkTCPNoDelay.isSelected()) {
                lDAPServerPropertyBean.setNoDelay(false);
            } else {
                lDAPServerPropertyBean.setNoDelay(null);
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLDAPServerSettings", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.tfHost = new JTextField();
        this.lblHost = new JLabel(IDARResourceSet.getString("propertyLDAPServerSettings", "HOST") + ":");
        this.lblHost.setLabelFor(this.tfHost);
        this.tfPort = new JTextField(6);
        this.tfPort.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.lblPort = new JLabel(IDARResourceSet.getString("propertyLDAPServerSettings", "PORT") + ":");
        this.lblPort.setLabelFor(this.tfPort);
        this.tfSecurePort = new JTextField(6);
        this.tfSecurePort.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.lblSecurePort = new JLabel(IDARResourceSet.getString("propertyLDAPServerSettings", "SECURE_PORT") + ":");
        this.lblSecurePort.setLabelFor(this.tfSecurePort);
        this.tfKeepAlive = new JTextField(6);
        this.tfKeepAlive.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.lblKeepAlive = new JLabel(IDARResourceSet.getString("propertyLDAPServerSettings", "KEEP_ALIVE") + ":");
        this.lblKeepAlive.setLabelFor(this.tfKeepAlive);
        this.opMessage = new JOptionPane();
        this.dMessage = new JDialog();
        this.chkTCPNoDelay = new JCheckBox(IDARResourceSet.getString("groupNetwork", "NO_DELAY"));
        this.chkTCPNoDelay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GeneralView.this.chkTCPNoDelay.isSelected()) {
                    GeneralView.this.opMessage.setMessage(IDARResourceSet.getString("dialogTCPNoDelay", "NOTE"));
                    JOptionPane cfr_ignored_0 = GeneralView.this.opMessage;
                    GeneralView.this.opMessage.setMessageType(2);
                    JOptionPane cfr_ignored_1 = GeneralView.this.opMessage;
                    GeneralView.this.opMessage.setOptionType(0);
                    GeneralView.this.dMessage = GeneralView.this.opMessage.createDialog(IDARUtilities.getParentFrame(GeneralView.this), IDARResourceSet.getString("dialogTCPNoDelay", "TITLE"));
                    GeneralView.this.opMessage.revalidate();
                    GeneralView.this.dMessage.setModal(true);
                    GeneralView.this.dMessage.pack();
                    GeneralView.this.dMessage.show();
                    Object object = GeneralView.this.opMessage.getValue();
                    if (object == null) {
                        GeneralView.this.chkTCPNoDelay.setSelected(false);
                    } else if (object instanceof Integer) {
                        int n = (Integer)object;
                        if (n == 1) {
                            GeneralView.this.chkTCPNoDelay.setSelected(true);
                        } else if (n == 0) {
                            GeneralView.this.chkTCPNoDelay.setSelected(false);
                        } else {
                            GeneralView.this.chkTCPNoDelay.setSelected(true);
                        }
                    } else {
                        GeneralView.this.chkTCPNoDelay.setSelected(true);
                    }
                    GeneralView.this.opMessage.setValue(JOptionPane.UNINITIALIZED_VALUE);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.lblHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.lblPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.lblSecurePort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfSecurePort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.lblKeepAlive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfKeepAlive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.chkTCPNoDelay, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new GeneralView(null, new LDAPServerPropertyBean()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

