/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.LDAPServerPropertyBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.property.EncryptionView;
import com.iplanet.idar.ui.configurator.property.GeneralView;
import com.iplanet.idar.ui.configurator.property.LDAPVersionView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LDAPServerPropertyView
extends ConfigurationView
implements SuiConstants {
    private TitlePanel pnlTitle;
    private JLabel lblName;
    private JTextField tfName;
    private JTabbedPane tabViews;
    private ConfigurationView viewGeneral;
    private ConfigurationView viewLDAPVersion;
    private ConfigurationView viewEncryption;

    public LDAPServerPropertyView(ConsoleInfo consoleInfo, LDAPServerPropertyBean lDAPServerPropertyBean) {
        super.setConsoleInfo(consoleInfo);
        this.initComponents();
        super.setDataModel(lDAPServerPropertyBean);
    }

    public LDAPServerPropertyView() {
        this.initComponents();
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewGeneral != null) {
            this.viewGeneral.setConsoleInfo(consoleInfo);
            this.viewLDAPVersion.setConsoleInfo(consoleInfo);
            this.viewEncryption.setConsoleInfo(consoleInfo);
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        this.viewGeneral.setDataModel(iDARModelBean, false);
        this.viewLDAPVersion.setDataModel(iDARModelBean, false);
        this.viewEncryption.setDataModel(iDARModelBean, false);
        super.setDataModel(iDARModelBean, bl);
    }

    public String getHelpTopic() {
        return ((ConfigurationView)this.tabViews.getSelectedComponent()).getHelpTopic();
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLDAPServer", "TITLE");
    }

    public void applyChanges() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)super.getDataModel();
        if (lDAPServerPropertyBean != null) {
            if (this.tfName.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
            }
            if (!lDAPServerPropertyBean.getName().equals(this.tfName.getText())) {
                try {
                    lDAPServerPropertyBean.setName(this.tfName.getText());
                }
                catch (UniqueNameException uniqueNameException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                }
            }
            try {
                this.viewGeneral.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewGeneral.getPanel());
                throw configurationViewException;
            }
            try {
                this.viewLDAPVersion.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewLDAPVersion.getPanel());
                throw configurationViewException;
            }
            try {
                this.viewEncryption.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewEncryption.getPanel());
                throw configurationViewException;
            }
        }
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((int)6, (String)"LDAPServerPropertyView.resetContent");
        try {
            LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)super.getDataModel();
            if (lDAPServerPropertyBean != null) {
                this.tfName.setText(lDAPServerPropertyBean.getId());
                this.viewGeneral.resetContent();
                this.viewLDAPVersion.resetContent();
                this.viewEncryption.resetContent();
            }
        }
        catch (ClassCastException classCastException) {
            Debug.println((int)6, (String)"LDAPServerPropertyView.resetContent:  model not of type LDAPServerPropertyBean");
        }
    }

    protected void initComponents() {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        this.pnlTitle.setText(this.getTitleText());
        this.tfName = new JTextField();
        this.lblName = new JLabel();
        this.lblName.setText(IDARResourceSet.getString("propertyGeneral", "PROPERTY") + ":");
        this.lblName.setLabelFor(this.tfName);
        this.tabViews = new JTabbedPane();
        ConsoleInfo consoleInfo = super.getConsoleInfo();
        this.viewGeneral = new GeneralView(consoleInfo);
        this.viewLDAPVersion = new LDAPVersionView(consoleInfo);
        this.viewEncryption = new EncryptionView(consoleInfo);
        this.viewGeneral.addBlankPanelListener(this);
        this.viewLDAPVersion.addBlankPanelListener(this);
        this.viewEncryption.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewGeneral.getTitleText(), null, this.viewGeneral.getPanel());
        this.tabViews.addTab(this.viewLDAPVersion.getTitleText(), null, this.viewLDAPVersion.getPanel());
        this.tabViews.addTab(this.viewEncryption.getTitleText(), null, this.viewEncryption.getPanel());
        this.setLayout(new BorderLayout());
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        this.add((Component)blankPanel, "North");
        this.add((Component)this.tabViews, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LDAPServerPropertyView(null, new LDAPServerPropertyBean()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

