/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.property.FilesView;
import com.iplanet.idar.ui.configurator.property.LogLevelView;
import com.iplanet.idar.ui.configurator.property.StatisticsView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LogPropertyView
extends ConfigurationView
implements SuiConstants {
    private TitlePanel pnlTitle;
    private JLabel lblName;
    private JTextField tfName;
    private JTabbedPane tabViews;
    private ConfigurationView viewLevels;
    private ConfigurationView viewFiles;
    private ConfigurationView viewLogLevels;

    public LogPropertyView() {
        this.initComponents(true);
    }

    public LogPropertyView(boolean bl, ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.initComponents(bl);
    }

    public String getHelpTopic() {
        ConfigurationView configurationView = (ConfigurationView)this.tabViews.getSelectedComponent();
        return ((ConfigurationView)this.tabViews.getSelectedComponent()).getHelpTopic();
    }

    public void applyChanges() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)super.getDataModel();
        if (logPropertyBean != null) {
            if (this.tfName.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
            }
            if (!logPropertyBean.getName().equals(this.tfName.getText())) {
                try {
                    logPropertyBean.setName(this.tfName.getText());
                }
                catch (UniqueNameException uniqueNameException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                }
            }
            this.viewLevels.setDataModel(logPropertyBean);
            try {
                this.viewLevels.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewLevels.getPanel());
                throw configurationViewException;
            }
            this.viewFiles.setDataModel(logPropertyBean);
            try {
                this.viewFiles.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewFiles.getPanel());
                throw configurationViewException;
            }
            this.viewLogLevels.setDataModel(logPropertyBean);
            try {
                this.viewLogLevels.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewLogLevels.getPanel());
                throw configurationViewException;
            }
        }
    }

    public void resetContent() throws ConfigurationViewException {
        try {
            LogPropertyBean logPropertyBean = (LogPropertyBean)super.getDataModel();
            if (logPropertyBean != null) {
                this.tfName.setText(logPropertyBean.getId());
                this.viewLevels.setDataModel(logPropertyBean);
                this.viewLevels.resetContent();
                this.viewFiles.setDataModel(logPropertyBean);
                this.viewFiles.resetContent();
                this.viewLogLevels.setDataModel(logPropertyBean);
                this.viewLogLevels.resetContent();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLog", "TITLE");
    }

    protected void initComponents() {
        this.initComponents(true);
    }

    protected void initComponents(boolean bl) {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        this.pnlTitle.setText(this.getTitleText());
        this.tfName = new JTextField();
        this.lblName = new JLabel(IDARResourceSet.getString("propertyGeneral", "PROPERTY") + ":");
        this.lblName.setLabelFor(this.tfName);
        this.tabViews = new JTabbedPane();
        ConsoleInfo consoleInfo = super.getConsoleInfo();
        this.viewLevels = new StatisticsView(bl, consoleInfo);
        this.viewFiles = new FilesView(bl, consoleInfo);
        this.viewLogLevels = new LogLevelView(bl, consoleInfo);
        this.viewLevels.addBlankPanelListener(this);
        this.viewFiles.addBlankPanelListener(this);
        this.viewLogLevels.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewLevels.getTitleText(), null, this.viewLevels.getPanel());
        this.tabViews.addTab(this.viewFiles.getTitleText(), null, this.viewFiles.getPanel());
        this.tabViews.addTab(this.viewLogLevels.getTitleText(), null, this.viewLogLevels.getPanel());
        this.setLayout(new BorderLayout());
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        this.add((Component)blankPanel, "North");
        this.add((Component)this.tabViews, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new LogPropertyView(false, new ConsoleInfo()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

