/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.rule;

import com.iplanet.idar.objectmodel.bean.OnBindRuleBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SettingsView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Event-OnBind-Conditions";
    private JTextArea txtCondition;
    private JCheckBox chkSSLRequired;
    private BlankPanel pnlBind;
    private JCheckBox chkBindAnonymous;
    private JCheckBox chkBindSimple;
    private JCheckBox chkBindSASL;

    public SettingsView() {
        this.initComponents();
    }

    public SettingsView(ConsoleInfo consoleInfo, OnBindRuleBean onBindRuleBean) {
        this.initComponents();
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(onBindRuleBean);
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            configurationViewException.printStackTrace();
        }
    }

    protected void initComponents() {
        this.txtCondition = new JTextArea();
        this.txtCondition.setText(IDARResourceSet.getString("ruleOnBindSettings", "CONDITION"));
        this.txtCondition.setEditable(false);
        this.txtCondition.setBackground(this.getBackground());
        this.txtCondition.setLineWrap(true);
        this.txtCondition.setWrapStyleWord(true);
        this.chkSSLRequired = new JCheckBox();
        this.chkSSLRequired.setText(IDARResourceSet.getString("ruleOnBindSettings", "SSL_REQUIRED"));
        int n = 0;
        this.pnlBind = new BlankPanel();
        this.pnlBind.addBlankPanelListener(this);
        this.pnlBind.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("ruleOnBindSettings", "CLIENT")));
        this.pnlBind.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.chkBindAnonymous = new JCheckBox();
        this.chkBindAnonymous.setText(IDARResourceSet.getString("ruleOnBindSettings", "BIND_ANONYMOUS"));
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        this.pnlBind.add((Component)this.chkBindAnonymous, gridBagConstraints);
        this.chkBindSimple = new JCheckBox();
        this.chkBindSimple.setText(IDARResourceSet.getString("ruleOnBindSettings", "BIND_SIMPLE"));
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        this.pnlBind.add((Component)this.chkBindSimple, gridBagConstraints);
        this.chkBindSASL = new JCheckBox();
        this.chkBindSASL.setText(IDARResourceSet.getString("ruleOnBindSettings", "BIND_SASL"));
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        this.pnlBind.add((Component)this.chkBindSASL, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.txtCondition, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.chkSSLRequired, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 9;
        this.add((Component)this.pnlBind, gridBagConstraints);
    }

    public void applyChanges() throws ConfigurationViewException {
        OnBindRuleBean onBindRuleBean = (OnBindRuleBean)super.getDataModel();
        if (onBindRuleBean != null) {
            onBindRuleBean.setSSLRequired(this.chkSSLRequired.isSelected());
            onBindRuleBean.setBindAnonymous(this.chkBindAnonymous.isSelected());
            onBindRuleBean.setBindSimple(this.chkBindSimple.isSelected());
            onBindRuleBean.setBindSASL(this.chkBindSASL.isSelected());
        }
    }

    public void resetContent() throws ConfigurationViewException {
        OnBindRuleBean onBindRuleBean = (OnBindRuleBean)super.getDataModel();
        if (onBindRuleBean != null) {
            this.chkSSLRequired.setSelected(onBindRuleBean.getSSLRequired());
            this.chkBindAnonymous.setSelected(onBindRuleBean.getBindAnonymous());
            this.chkBindSimple.setSelected(onBindRuleBean.getBindSimple());
            this.chkBindSASL.setSelected(onBindRuleBean.getBindSASL());
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("ruleOnBindSettings", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SettingsView(null, null));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

