/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.system;

import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GeneralView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "System-Settings";
    private SuiTextField tfHost;
    private JLabel lblHost;
    private SuiTextField tfPort;
    private JLabel lblPort;
    private SuiTextField tfSecurePort;
    private JLabel lblSecurePort;

    public GeneralView() {
        this((ConsoleInfo)null);
    }

    public GeneralView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public GeneralView(ConsoleInfo consoleInfo, SystemBean systemBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(systemBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void resetContent() throws ConfigurationViewException {
        SystemBean systemBean = (SystemBean)this.getDataModel();
        Debug.println((int)7, (String)("GeneralView.resetContent: system=" + systemBean));
        if (systemBean != null) {
            this.setViewEnabled(true);
            this.tfHost.setText(systemBean.getHost());
            this.tfPort.setText(systemBean.getPort().toString());
            Integer n = systemBean.getLdapsPort();
            if (n != null) {
                this.tfSecurePort.setText(n.toString());
            } else {
                this.tfSecurePort.setText("");
            }
        } else {
            this.setViewEnabled(false);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        Debug.println((int)7, (String)"GeneralView.applyChanges");
        SystemBean systemBean = (SystemBean)this.getDataModel();
        Debug.println((int)7, (String)("GeneralView.applyChanges: system=" + systemBean));
        if (systemBean != null) {
            systemBean.setHost(this.tfHost.getText());
            this.setEventFiringEnabled(false);
            this.tfHost.setText(systemBean.getHost());
            this.setEventFiringEnabled(true);
            Integer n = null;
            try {
                n = new Integer(this.tfPort.getText());
                systemBean.setPort(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_PORT"));
            }
            Integer n2 = null;
            if (!this.tfSecurePort.getText().trim().equals("")) {
                try {
                    n2 = new Integer(this.tfSecurePort.getText());
                    if (n2.equals(n)) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_PORT_AND_SSL_PORT_SAME"));
                    }
                    systemBean.setLdapsPort(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_SPORT"));
                }
            } else {
                systemBean.setLdapsPort(null);
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("systemSettings", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        Debug.println((int)7, (String)"GeneralView.initComponents");
        this.tfHost = new SuiTextField();
        this.lblHost = new JLabel(IDARResourceSet.getString("systemSettings", "HOST") + ":");
        this.lblHost.setHorizontalAlignment(4);
        this.lblHost.setLabelFor(this.tfHost);
        this.tfPort = new SuiTextField(6);
        this.tfPort.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.lblPort = new JLabel(IDARResourceSet.getString("systemSettings", "PORT") + ":");
        this.lblPort.setLabelFor(this.tfPort);
        this.tfSecurePort = new SuiTextField(6);
        this.tfSecurePort.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.lblSecurePort = new JLabel(IDARResourceSet.getString("systemSettings", "SECURE_PORT") + ":");
        this.lblSecurePort.setLabelFor(this.tfSecurePort);
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.lblSecurePort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tfSecurePort, gridBagConstraints);
    }

    private void setViewEnabled(boolean bl) {
        this.setEnabled(bl);
        this.tfHost.setEnabled(bl);
        this.tfPort.setEnabled(bl);
        this.tfSecurePort.setEnabled(bl);
        this.lblHost.setEnabled(bl);
        this.lblPort.setEnabled(bl);
        this.lblSecurePort.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new GeneralView(new ConsoleInfo()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

