/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.task.TaskManagerFactory;
import com.iplanet.idar.ui.common.IDARFrameworkInitializer;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.server.configuration.ConfigurationPage;
import com.iplanet.idar.ui.server.task.ConfigureLoadBalancing;
import com.iplanet.idar.ui.server.task.KeyCert;
import com.iplanet.idar.ui.server.task.ReloadConfiguration;
import com.iplanet.idar.ui.server.task.Restart;
import com.iplanet.idar.ui.server.task.Start;
import com.iplanet.idar.ui.server.task.Stop;
import com.netscape.management.client.AboutDialog;
import com.netscape.management.client.FrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.TaskModel;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.TaskPage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AdminGroupNode;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Frame;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class IDARServerFrameworkInitializer
extends FrameworkInitializer
implements IDARFrameworkInitializer {
    private static final int START_TASK_POSITION = 0;
    private static final int STOP_TASK_POSITION = 1;
    private static final int RESTART_TASK_POSITION = 2;
    private static final int RELOAD_TASK_POSITION = 3;
    private static final int CONFIG_LOAD_BALANCING_POSITION = 4;
    private static final int MANAGE_CERTIFICATES_POSITION = 5;
    private static final int NUMBER_TASKS = 6;
    private static final ResourceSet dirResource = new ResourceSet("com.iplanet.idar.common.directory");
    private static final ResourceSet licenseResource = new ResourceSet("com.iplanet.idar.defaultIdarLicense");
    private static final String IDAR_ISIE = dirResource.getString("dir", "ISIE");
    private static final String IDAR_NICKNAME = dirResource.getString("dir", "NICKNAME");
    private static final String ADMIN_PREFIX = dirResource.getString("dir", "ADMIN_PREFIX");
    private String adminServerId = null;
    private String serverId = null;
    private ConsoleInfo consoleInfo = null;

    public IDARServerFrameworkInitializer(ConsoleInfo consoleInfo, INodeInfo iNodeInfo) {
        AdminConfigData[] adminConfigDataArray;
        Object object;
        this.consoleInfo = (ConsoleInfo)consoleInfo.clone();
        this.consoleInfo.put((Object)"SIE", (Object)this.getSIE(consoleInfo));
        if (Debug.isEnabled() && Debug.getTraceLevel() == 9) {
            Debug.println((String)"#######################ISFI: consoleInfo::");
            object = this.consoleInfo.keys();
            while (object.hasMoreElements()) {
                adminConfigDataArray = this.consoleInfo.elements();
                while (adminConfigDataArray.hasMoreElements()) {
                    Debug.println((String)(">>>>>>>>>>" + object.nextElement().toString() + ":::::" + adminConfigDataArray.nextElement().toString()));
                }
            }
        }
        this.serverId = IDARServerFrameworkInitializer.getServerId(this.consoleInfo.getLDAPConnection(), this.consoleInfo.getCurrentDN());
        this.adminServerId = this.getAdminServerId(this.consoleInfo);
        object = this.consoleInfo.getCurrentDN();
        if (this.serverId != null) {
            IDARUtilities.registerServerId((String)object, this.serverId);
        } else {
            Debug.println((String)"IDARServerFrameworkInitializer:  ERROR - NO SERVER ID");
        }
        try {
            adminConfigDataArray = new AdminConfigData[]{new AdminConfigData(this.adminServerId, this.consoleInfo.getAdminURL() + URLEncoder.encode(this.serverId) + "/tasks/xtl")};
            if (!BeanSpace.isInitialized()) {
                BeanSpace.initialize(this.consoleInfo, adminConfigDataArray);
            } else {
                BeanSpace.getInstance().addAccessUrls(adminConfigDataArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TaskManagerFactory.setContextIndicator(3);
        try {
            adminConfigDataArray = new TaskPage(this.consoleInfo);
            this.reorderTaskPage((TaskPage)adminConfigDataArray);
            adminConfigDataArray.setTaskModel(adminConfigDataArray.getModel());
            adminConfigDataArray.revalidate();
            this.addPage((IPage)adminConfigDataArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Debug.println((String)"IDARServerFrameworkInitializer adding ConfigurationPage");
        this.addPage((IPage)new ConfigurationPage(this.consoleInfo, iNodeInfo));
        Debug.println((String)"IDARServerFrameworkInitializer ConfigurationPage added");
        adminConfigDataArray = this.getMinimizedIcon();
        if (adminConfigDataArray != null) {
            this.setMinimizedImage(adminConfigDataArray.getImage());
        } else {
            Debug.println((String)"IDARServerFrameworkInitializer:  cannot load minimized icon");
        }
        RemoteImage remoteImage = ImageFactory.getImage("BANNER");
        if (remoteImage != null) {
            this.setBannerImage(remoteImage.getImage());
        } else {
            Debug.println((String)"IDARServerFrameworkInitializer:  cannot load banner image");
        }
        this.setFrameTitle(IDARResourceSet.getString("server", "IDAR_CONSOLE") + " - " + this.getDisplayId(this.consoleInfo.getLDAPConnection(), this.consoleInfo.getCurrentDN()));
        this.setBannerText(IDARResourceSet.getString("server", "VERSION"));
    }

    public String getServerId() {
        return this.serverId;
    }

    public static String getServerId(LDAPConnection lDAPConnection, String string) {
        String string2 = null;
        if (lDAPConnection != null) {
            try {
                String string3;
                LDAPEntry lDAPEntry;
                LDAPAttribute lDAPAttribute;
                if (!lDAPConnection.isConnected()) {
                    lDAPConnection.connect(3, lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword());
                }
                if ((lDAPAttribute = (lDAPEntry = lDAPConnection.read(string)).getAttribute("nsserverid", string3 = LDAPUtil.getLDAPAttributeLocale())) == null) {
                    lDAPAttribute = lDAPEntry.getAttribute("cn", string3);
                    if (lDAPAttribute != null) {
                        string2 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                    }
                } else {
                    string2 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)("IDARServerFrameworkInitializer.getServerId: " + (Object)((Object)lDAPException)));
            }
            Debug.println((int)7, (String)("IDARServerFrameworkInitializer.getServerId: serverId =" + string2));
        } else {
            Debug.println((int)7, (String)("IDARServerFrameworkInitializer.getServerId: ldapconnection=" + lDAPConnection));
        }
        return string2;
    }

    public String getAdminServerId() {
        return this.adminServerId;
    }

    public String getAdminServerId(ConsoleInfo consoleInfo) {
        if (consoleInfo != null) {
            ServiceLocator serviceLocator = new ServiceLocator(consoleInfo);
            LDAPConnection lDAPConnection = serviceLocator.getConnection();
            if (lDAPConnection == null) {
                Debug.println((int)7, (String)"IDARServerFrameworkInitializer:getAdminServerId: NO LDAPConnection");
            } else {
                try {
                    if (!lDAPConnection.isConnected() || !lDAPConnection.isAuthenticated()) {
                        Debug.println((int)7, (String)"IDARServerFrameworkInitializer.getAdminServerId: NOT CONNECTED! Trying to connect...");
                        lDAPConnection.connect(3, lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword());
                        Debug.println((int)7, (String)("IDARServerFrameworkInitializer.getAdminServerId isConnected = " + lDAPConnection.isConnected()));
                    }
                    if (!lDAPConnection.isAuthenticated()) {
                        Debug.println((int)7, (String)"IDARServerFrameworkInitializer.getAdminServerId: NOT AUTHENTICATED!");
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: ldap error message = " + lDAPException.toString()));
                }
                Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: host = " + lDAPConnection.getHost()));
                Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: port = " + lDAPConnection.getPort()));
                Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: auth dn = " + lDAPConnection.getAuthenticationDN()));
                Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: auth pass = " + lDAPConnection.getAuthenticationPassword()));
            }
            String string = null;
            boolean bl = false;
            try {
                LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)serviceLocator.getDomains();
                while (lDAPSearchResults.hasMoreElements() && !bl) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    String string2 = lDAPEntry.getDN();
                    Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: domain=" + string2));
                    LDAPSearchResults lDAPSearchResults2 = (LDAPSearchResults)serviceLocator.getHosts(string2);
                    while (lDAPSearchResults2.hasMoreElements() && !bl) {
                        lDAPEntry = lDAPSearchResults2.next();
                        String string3 = lDAPEntry.getDN();
                        Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: host=" + string3));
                        LDAPSearchResults lDAPSearchResults3 = (LDAPSearchResults)serviceLocator.getAdminGroup(string3);
                        while (lDAPSearchResults3.hasMoreElements() && !bl) {
                            lDAPEntry = lDAPSearchResults3.next();
                            String string4 = lDAPEntry.getDN();
                            String string5 = serviceLocator.getAdminServer(string4);
                            String string6 = AdminGroupNode.findAdminURL((ConsoleInfo)consoleInfo, (String)string5);
                            Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: group=" + string4));
                            Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: admin server=" + string5));
                            Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: admin url=" + string6));
                            AdminGroupNode adminGroupNode = new AdminGroupNode(serviceLocator, lDAPEntry);
                            LDAPSearchResults lDAPSearchResults4 = adminGroupNode.getApplications();
                            string = new DN(string5).explodeDN(true)[0];
                            Debug.println((String)("7, IDARServerFrameworkInitializer:getAdminServerId: adminServerId: " + string));
                            while (lDAPSearchResults4.hasMoreElements() && !bl) {
                                try {
                                    lDAPEntry = lDAPSearchResults4.next();
                                    String string7 = lDAPEntry.getDN();
                                    if (-1 == string7.indexOf(IDAR_ISIE)) continue;
                                    Debug.println((int)7, (String)("IDARServerFrameworkInitializer:getAdminServerId: discovered idar isie: " + string7));
                                    Enumeration enumeration = adminGroupNode.getServerIDs().elements();
                                    while (enumeration.hasMoreElements() && !bl) {
                                        String string8 = enumeration.nextElement().toString();
                                        if (!string8.startsWith(IDAR_NICKNAME)) continue;
                                        Debug.println((String)("7, IDARServerFrameworkInitializer:getAdminServerId: discovered idar: " + string8));
                                        if (!string8.equals(this.serverId)) continue;
                                        bl = true;
                                    }
                                }
                                catch (LDAPException lDAPException) {
                                    lDAPException.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                lDAPException.printStackTrace();
            }
        } else {
            Debug.println((int)7, (String)"IDARServerFrameworkInitializer.getAdminServerId: ERROR-No Connection");
        }
        return this.adminServerId;
    }

    public String getDisplayId(LDAPConnection lDAPConnection, String string) {
        String string2 = null;
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(string);
                String string3 = LDAPUtil.getLDAPAttributeLocale();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("serverproductname", string3);
                if (lDAPAttribute == null) {
                    lDAPAttribute = lDAPEntry.getAttribute("cn", string3);
                    if (lDAPAttribute != null) {
                        string2 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                    }
                } else {
                    string2 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)("FrameworkInitializer.getDisplayId: " + (Object)((Object)lDAPException)));
            }
        }
        return string2;
    }

    public ConsoleInfo getConsoleInfo() {
        return this.consoleInfo;
    }

    protected String getSIE(ConsoleInfo consoleInfo) {
        String string = consoleInfo.getCurrentDN();
        Debug.println((int)6, (String)("IDARServerFrameworkInitializer.getSIE: currentDN= " + string));
        return string.substring(string.indexOf("cn=") + 3, string.indexOf(","));
    }

    private RemoteImage getMinimizedIcon() {
        RemoteImage remoteImage = IDARUtilities.getOS().equals("Win32") ? ImageFactory.getImage("IDAR_SERVER_NT") : ImageFactory.getImage("IDAR_SERVER");
        return remoteImage;
    }

    private void reorderTaskPage(TaskPage taskPage) {
        TaskModel taskModel = (TaskModel)taskPage.getModel();
        TaskObject taskObject = (TaskObject)taskModel.getRoot();
        TaskObject[] taskObjectArray = new TaskObject[6];
        Enumeration enumeration = taskObject.children();
        while (enumeration.hasMoreElements()) {
            TaskObject taskObject2 = (TaskObject)enumeration.nextElement();
            if (taskObject2 instanceof Start) {
                taskObjectArray[0] = taskObject2;
                continue;
            }
            if (taskObject2 instanceof Stop) {
                taskObjectArray[1] = taskObject2;
                continue;
            }
            if (taskObject2 instanceof Restart) {
                taskObjectArray[2] = taskObject2;
                continue;
            }
            if (taskObject2 instanceof ReloadConfiguration) {
                taskObjectArray[3] = taskObject2;
                continue;
            }
            if (taskObject2 instanceof ConfigureLoadBalancing) {
                taskObjectArray[4] = taskObject2;
                continue;
            }
            if (!(taskObject2 instanceof KeyCert)) continue;
            taskObjectArray[5] = taskObject2;
        }
        for (int i = 0; i < taskObjectArray.length; ++i) {
            if (taskObjectArray[i] == null) continue;
            taskObject.add((MutableTreeNode)taskObjectArray[i]);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void fireStateChanged(ChangeEvent changeEvent) {
    }

    public void aboutInvoked(JFrame jFrame) {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Frame)jFrame, licenseResource.getString("defaultAbout", "dialogTitle"));
            this.aboutDialog.setProduct(null, licenseResource.getString("defaultAbout", "productCopyright"), licenseResource.getString("defaultAbout", "productLicense"));
        }
        this.aboutDialog.show();
    }
}

