/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.task;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.ui.common.AbstractChooserDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ViewMap;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.configurator.Editor;
import com.netscape.management.client.IPage;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConfigureLoadBalancing
extends TaskObject
implements IDARConstants {
    private static Icon serverTaskIcon = new RemoteImage("com/iplanet/idar/ui/common/images/50/system_configuration_32.gif");
    private static final String NAME = IDARResourceSet.getString("taskConfigureLoadBalancing", "NAME");
    private static final String DESCRIPTION = IDARResourceSet.getString("taskConfigureLoadBalancing", "DESCRIPTION");
    private static final String DELETION_ERROR_TITLE = IDARResourceSet.getString("error", "MODEL_RETRIEVAL_TITLE");
    private static final String DELETION_ERROR_MESSAGE = IDARResourceSet.getString("error", "MODEL_RETRIEVAL_MESSAGE");
    private static final String NO_CONFIG_MODEL_ERROR_TITLE = IDARResourceSet.getString("error", "NO_CONFIG_MODEL_TITLE");
    private static final String NO_CONFIG_MODEL_ERROR_MESSAGE = IDARResourceSet.getString("error", "NO_CONFIG_MODEL_MESSAGE");
    private static final String NO_SERVER_MODEL_ERROR_TITLE = IDARResourceSet.getString("error", "NO_SERVER_MODEL_TITLE");
    private static final String NO_SERVER_MODEL_ERROR_MESSAGE = IDARResourceSet.getString("error", "NO_SERVER_MODEL_MESSAGE");
    private static final String NO_LOAD_BALANCE_PROPS_TITLE = IDARResourceSet.getString("error", "NO_LOAD_BALANCE_PROPS_TITLE");
    private static final String NO_LOAD_BALANCE_PROPS_MESSAGE = IDARResourceSet.getString("error", "NO_LOAD_BALANCE_PROPS_MESSAGE");
    private static final String CHOOSE_LOAD_BALANCE_TITLE = IDARResourceSet.getString("dialogSelectGroupForLoadBalance", "TITLE");
    private static final String CHOOSE_LOAD_BALANCE_NOTE = IDARResourceSet.getString("dialogSelectGroupForLoadBalance", "NOTE");
    private static final String NO_NETWORK_GROUP_TITLE = IDARResourceSet.getString("dialogNoGroupsForLoadBalance", "NO_NETWORK_GROUP_TITLE");
    private static final String NO_NETWORK_GROUP_NOTE = IDARResourceSet.getString("dialogNoGroupsForLoadBalance", "NO_NETWORK_GROUP_NOTE");

    public ConfigureLoadBalancing() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
    }

    public Icon getIcon() {
        return serverTaskIcon;
    }

    public boolean run(IPage iPage) {
        block17: {
            Debug.println((String)"ConfigureLoadBalancing.run");
            JFrame jFrame = iPage.getFramework().getJFrame();
            ConsoleInfo consoleInfo = this.getConsoleInfo();
            String string = (String)consoleInfo.get((Object)"SIE");
            Debug.println((int)6, (String)("ConfigureLoadBalancing.run: serverId=" + string));
            IDARBeanCollection iDARBeanCollection = null;
            try {
                BeanSpace beanSpace = BeanSpace.getInstance();
                IDARReference iDARReference = beanSpace.getBeanReference(string, "idar-server", IDARReference.NULL_REFERENCE);
                Debug.println((int)6, (String)("ConfigureLoadBalancing.run: serverRef=" + iDARReference));
                IDARBean iDARBean = (IDARBean)beanSpace.retrieveBean(iDARReference);
                if (iDARBean != null) {
                    ConfigurationBean configurationBean = iDARBean.getConfigurationBean();
                    if (configurationBean != null) {
                        IDARReference iDARReference2;
                        Object object;
                        Object object2;
                        iDARBeanCollection = beanSpace.retrieveBeanCollection(configurationBean.getSelfReference(), "network-group");
                        int n = iDARBeanCollection.size();
                        NetworkGroupBean networkGroupBean = null;
                        if (n > 1) {
                            object2 = new AbstractChooserDialog((Frame)jFrame, CHOOSE_LOAD_BALANCE_TITLE, CHOOSE_LOAD_BALANCE_NOTE, configurationBean.getSelfReference(), "network-group", consoleInfo, true);
                            object2.show();
                            if (!object2.isCancel()) {
                                object = ((AbstractChooserDialog)((Object)object2)).getSelectedBean();
                                if (object instanceof NetworkGroupBean) {
                                    networkGroupBean = (NetworkGroupBean)object;
                                } else if (object instanceof IDARReference) {
                                    iDARReference2 = (IDARReference)object;
                                    networkGroupBean = (NetworkGroupBean)iDARReference2.getBean();
                                }
                            }
                        } else if (n == 1) {
                            object2 = iDARBeanCollection.getBeans();
                            object = object2.iterator();
                            networkGroupBean = (NetworkGroupBean)object.next();
                        } else {
                            JOptionPane.showMessageDialog(jFrame, NO_NETWORK_GROUP_NOTE, NO_NETWORK_GROUP_TITLE, 0);
                        }
                        if (networkGroupBean == null) break block17;
                        object2 = networkGroupBean.getLoadBalancePropertyIds();
                        if (((Vector)object2).size() == 1) {
                            object = ((Vector)object2).firstElement();
                            try {
                                iDARReference2 = beanSpace.getBeanReference((String)object, "load-balancing", networkGroupBean.getParentConfiguration());
                                Debug.println((int)6, (String)("ConfigureLoadBalancing.run: retrieving property id = " + iDARReference2.getId()));
                                IDARModelBean iDARModelBean = iDARReference2.getBean();
                                ConfigurationView configurationView = ViewMap.getInstance().obtainView(iDARModelBean.getDescriptor(), iDARModelBean.getParentConfiguration());
                                if (configurationView != null) {
                                    configurationView.setConsoleInfo(this.getConsoleInfo());
                                    configurationView.setDataModel(iDARModelBean);
                                    Editor editor = new Editor((Component)jFrame, configurationView);
                                    editor.pack();
                                    editor.show();
                                }
                                break block17;
                            }
                            catch (IDARBeanException iDARBeanException) {
                                Debug.println((String)"ConfigureLoadBalancing.run: ERROR - UNABLE TO INSTANTIATE BEAN");
                                JOptionPane.showMessageDialog(jFrame, NO_LOAD_BALANCE_PROPS_MESSAGE, NO_LOAD_BALANCE_PROPS_TITLE, 0);
                            }
                            break block17;
                        }
                        Debug.println((String)"ConfigureLoadBalancing.run: ERROR - INVALID NUMBER OF LOAD BALANCE PROPERTIES PRESENT");
                        JOptionPane.showMessageDialog(jFrame, NO_LOAD_BALANCE_PROPS_MESSAGE, NO_LOAD_BALANCE_PROPS_TITLE, 0);
                        break block17;
                    }
                    Debug.println((String)"ConfigureLoadBalancing.run: ERROR - NO LOAD BALANCE PROPERTIES PRESENT");
                    JOptionPane.showMessageDialog(jFrame, NO_CONFIG_MODEL_ERROR_MESSAGE, NO_CONFIG_MODEL_ERROR_TITLE, 0);
                    break block17;
                }
                Debug.println((String)"ConfigureLoadBalancing.run: ERROR - UNABLE TO RETRIEVE SERVER BEAN");
                JOptionPane.showMessageDialog(jFrame, NO_SERVER_MODEL_ERROR_MESSAGE, NO_SERVER_MODEL_ERROR_TITLE, 0);
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            catch (RetrievalException retrievalException) {
                JOptionPane.showMessageDialog(jFrame, DELETION_ERROR_MESSAGE, DELETION_ERROR_TITLE, 0);
            }
        }
        return true;
    }
}

