/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.task;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.idar.RestartTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.server.task.IDARTaskObject;
import com.netscape.management.client.IPage;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import javax.swing.JOptionPane;

public class Restart
extends IDARTaskObject
implements IDARConstants {
    private static final String NAME = IDARResourceSet.getString("taskRestart", "NAME");
    private static final String DESCRIPTION = IDARResourceSet.getString("taskRestart", "DESCRIPTION");

    public Restart() {
        super(NAME);
        this.setDescription(DESCRIPTION);
    }

    public boolean run(final IPage iPage) {
        Debug.println((int)6, (String)"Restart.run");
        final RestartTask restartTask = this.getRestartTask(iPage);
        if (restartTask != null) {
            restartTask.execute(new TaskAdapter(){

                public void taskStopped(TaskEvent taskEvent) {
                    if (restartTask.getExecutionStatus() == -1) {
                        JOptionPane.showMessageDialog((Component)iPage.getFramework(), restartTask.getExecutionFailureMessage(), IDARResourceSet.getString("error", "TITLE"), 0);
                    }
                }
            });
        }
        return true;
    }

    private RestartTask getRestartTask(IPage iPage) {
        Debug.println((int)6, (String)"Restart.getRestartTask");
        RestartTask restartTask = null;
        IDARBean iDARBean = this.getIdarBean();
        if (iDARBean != null) {
            restartTask = iDARBean.getRestartTask();
            this.setEventManagerFramework(iPage, restartTask);
        } else {
            Debug.println((String)"Restart.getRestartTask:  ERROR - could not get IDARBean");
        }
        return restartTask;
    }
}

