/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task;

import com.iplanet.idar.common.ContextNotSupportedException;
import com.iplanet.idar.dialog.IdarDialog;
import com.iplanet.idar.dialog.IdarDialogImplementation;
import com.iplanet.idar.task.TaskDialogManager;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SwingTaskDialogManager
implements TaskDialogManager,
Cloneable {
    protected Component parent = null;
    private int response;

    public void setParent(Component component) {
        this.parent = component;
    }

    public Component getParent() {
        return this.parent;
    }

    public void showMessage(String string, String string2, int n) {
        this.showMessage(this.getParent(), string, string2, n);
    }

    public void showMessage(final Component component, final String string, final String string2, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(component, string, string2, n);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(component, string, string2, n);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public int showConfirmation(String string, String string2, int n, int n2) {
        return this.showConfirmation(this.getParent(), string, string2, n, n2);
    }

    public synchronized int showConfirmation(final Component component, final String string, final String string2, final int n, final int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.response = JOptionPane.showConfirmDialog(component, string, string2, n, n2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingTaskDialogManager.this.response = JOptionPane.showConfirmDialog(component, string, string2, n, n2);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.response;
    }

    public void showDialog(final JDialog jDialog) {
        if (SwingUtilities.isEventDispatchThread()) {
            jDialog.show();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        jDialog.show();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public Object showCustomDialog(IdarDialog idarDialog) throws ContextNotSupportedException {
        IdarDialogImplementation idarDialogImplementation = idarDialog.getDialogImplementation(2);
        return idarDialogImplementation.showDialog();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

