/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class MigrateConfig3 {
    private static final boolean _verbose = true;
    private static final int MAX_LINE_SZ = 1024;
    private static final int TLS = 4;
    private static final int SSLv3 = 2;
    private static final int SSLv2 = 1;
    private ConfAccessProp[] _o_tailor;
    private ConfAccessProp[] _n_tailor;
    private String _o_tailor_file;
    private String _n_tailor_file;
    private String _backup_file;
    private Config _config;

    public MigrateConfig3(String string, String string2, String string3) {
        this._o_tailor_file = string;
        this._n_tailor_file = string2;
        this._backup_file = string3;
        this._o_tailor = new ConfAccessProp[32];
        this._n_tailor = new ConfAccessProp[32];
        this._config = new Config();
    }

    private boolean backup(ConfAccessProp[] confAccessPropArray) throws IOException {
        for (int i = 0; i < confAccessPropArray.length; ++i) {
            LDAPSearchResults lDAPSearchResults;
            LDAPUrl lDAPUrl;
            if (confAccessPropArray[i] == null) continue;
            ConfAccessProp confAccessProp = confAccessPropArray[i];
            System.out.println("Trying " + confAccessProp._url);
            try {
                lDAPUrl = new LDAPUrl(confAccessProp._url);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Bad URL " + confAccessProp._url);
                System.err.println(malformedURLException);
                return false;
            }
            LDAPConnection lDAPConnection = new LDAPConnection();
            try {
                lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
                lDAPConnection.setOption(20, (Object)new Integer(0));
            }
            catch (LDAPException lDAPException) {
                System.err.println("Error connecting to host: " + lDAPUrl.getHost());
                System.err.println(lDAPException.toString());
                return false;
            }
            System.out.println("Connected to " + lDAPUrl.getHost());
            try {
                lDAPConnection.authenticate(3, confAccessProp._bind_dn, confAccessProp._passwd);
            }
            catch (LDAPException lDAPException) {
                System.err.println("Error binding to host: " + lDAPUrl.getHost());
                System.err.println(lDAPException.toString());
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException2) {
                    // empty catch block
                }
                return false;
            }
            System.out.println("Authenticated to host " + lDAPUrl.getHost());
            try {
                lDAPSearchResults = lDAPConnection.search("ou=dar-config, o=NetscapeRoot", 2, "objectclass=*", null, false);
            }
            catch (LDAPException lDAPException) {
                System.err.print("Error encountered while searching forids-proxy-sch-LDAPProxy object.");
                System.err.println("Base was: " + lDAPUrl.getDN());
                System.err.println(lDAPException.toString());
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException3) {
                    // empty catch block
                }
                return false;
            }
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(this._backup_file + "." + Integer.toString(i));
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (LDAPException lDAPException) {
                    System.err.println("Could not get next entry");
                    ((Writer)fileWriter).close();
                    return false;
                }
                this.write_ldif_entry(fileWriter, lDAPEntry);
            }
            ((Writer)fileWriter).close();
            System.out.println("Backup complete for " + confAccessProp._url + " file was " + this._backup_file + "." + Integer.toString(i));
            try {
                lDAPConnection.disconnect();
                continue;
            }
            catch (LDAPException lDAPException) {
                System.err.println(lDAPException.toString());
            }
        }
        return true;
    }

    private void write_ldif_entry(Writer writer, LDAPEntry lDAPEntry) throws IOException {
        writer.write("dn: " + lDAPEntry.getDN());
        writer.write("\n");
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            Enumeration enumeration2 = lDAPAttribute.getStringValues();
            while (enumeration2.hasMoreElements()) {
                writer.write(lDAPAttribute.getName() + ": ");
                writer.write((String)enumeration2.nextElement());
                writer.write("\n");
            }
        }
        writer.write("\n");
    }

    public boolean migrate() throws IOException {
        System.out.println("Reading " + this._o_tailor_file);
        if (!this.read_tailor(this._o_tailor_file, this._o_tailor)) {
            System.out.println("Read failed");
            return false;
        }
        System.out.println("Reading " + this._n_tailor_file);
        if (!this.read_tailor(this._n_tailor_file, this._n_tailor)) {
            System.out.println("Read failed");
            return false;
        }
        System.out.println("Removing file:// entries from " + this._o_tailor_file);
        if (this.remove_file_based_entries(this._o_tailor) == 0) {
            System.err.println("At least one protocol based entry needed");
            return false;
        }
        System.out.println("Removing file:// entries from " + this._n_tailor_file);
        if (this.remove_file_based_entries(this._n_tailor) == 0) {
            System.err.println("At least one protocol based entry needed");
            return false;
        }
        System.out.println("Backuping up ou=dar-config, o=NetscapeRoot");
        if (!this.backup(this._n_tailor)) {
            System.err.println("Failed to backup some of the configurations");
            System.err.println("Aborting..., No changes made");
            return false;
        }
        System.out.println("Downloading config from 5.0 server ...");
        if (!this.download_config(this._o_tailor, this._config)) {
            System.err.println("Failed to download config");
            return false;
        }
        for (int i = 0; i < this._n_tailor.length; ++i) {
            if (this._n_tailor[i] == null) continue;
            this.fix_configuration(this._n_tailor[i], this._config);
        }
        System.out.println("Done");
        return true;
    }

    private boolean check_and_remove_entry(LDAPConnection lDAPConnection, LDAPEntry lDAPEntry, String string) {
        System.out.println("Trying to remove entry " + lDAPEntry.getDN());
        try {
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-belongs-to");
            String[] stringArray = lDAPAttribute.getStringValueArray();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                System.err.println(lDAPEntry.getDN() + " does not belong to " + string + " continuing...");
                return true;
            }
            if (stringArray.length > 1) {
                System.out.println("remove belongs-to from entry " + lDAPEntry.getDN());
                lDAPConnection.modify(lDAPEntry.getDN(), new LDAPModification(1, new LDAPAttribute("ids-proxy-sch-belongs-to", string)));
            } else {
                System.out.println("Removing entry " + lDAPEntry.getDN());
                lDAPConnection.delete(lDAPEntry.getDN());
            }
            return true;
        }
        catch (LDAPException lDAPException) {
            System.err.println("Exception while removing entry " + lDAPEntry.getDN());
            System.err.println((Object)lDAPException);
            lDAPException.printStackTrace();
            return false;
        }
    }

    private boolean check_and_remove_base(LDAPConnection lDAPConnection, String string, String string2) {
        try {
            boolean bl = false;
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-belongs-to");
            System.out.println("Trying to remove base " + string);
            if (lDAPAttribute != null) {
                String[] stringArray = lDAPAttribute.getStringValueArray();
                lDAPConnection.modify(string, new LDAPModification(1, new LDAPAttribute("ids-proxy-sch-belongs-to", string2)));
                if (stringArray.length <= 1) {
                    bl = true;
                }
            } else {
                System.err.println("WARNING: belongs-to attribute not found");
                System.err.println("         Trying to delete base " + string);
                bl = true;
            }
            if (bl) {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "objectclass=*", null, false);
                if (lDAPSearchResults.getCount() <= 0) {
                    System.out.println("Removing base " + string);
                    lDAPConnection.delete(string);
                } else {
                    System.out.println("Entries found under base " + string);
                }
            }
            return true;
        }
        catch (LDAPException lDAPException) {
            System.err.println("Exception while removing entry " + string);
            System.err.println((Object)lDAPException);
            lDAPException.printStackTrace();
            return false;
        }
    }

    private boolean remove_gpral(LDAPConnection lDAPConnection, LDAPEntry[] lDAPEntryArray, String string, String string2) {
        if (lDAPEntryArray != null) {
            for (int i = 0; i < lDAPEntryArray.length; ++i) {
                if (this.check_and_remove_entry(lDAPConnection, lDAPEntryArray[i], string)) continue;
                System.err.println("Failed to remove entry " + lDAPEntryArray[i].getDN());
                return false;
            }
        }
        if (string2 != null && !this.check_and_remove_base(lDAPConnection, string2, string)) {
            System.err.println("Failed to remove entry " + string2);
            return false;
        }
        return true;
    }

    private boolean remove_configuration(LDAPConnection lDAPConnection, Config config, ConfAccessProp confAccessProp) {
        if (!this.download_config(confAccessProp, config)) {
            System.err.println("Failed to get config for " + confAccessProp._url);
            return false;
        }
        if (!this.remove_gpral(lDAPConnection, config._system_properties, config._server_name, config._global_base)) {
            System.err.println("Failed to remove system properties");
            return false;
        }
        if (!this.remove_gpral(lDAPConnection, config._log, config._server_name, config._property_base)) {
            System.err.println("Failed to remove log entries");
            return false;
        }
        if (config._system != null && !this.check_and_remove_entry(lDAPConnection, config._system, config._server_name)) {
            System.err.println("Failed to remove system entry " + config._system.getDN());
            return false;
        }
        if (!this.remove_gpral(lDAPConnection, config._properties, config._server_name, config._property_base)) {
            System.err.println("Failed to remove property entries");
            return false;
        }
        if (!this.remove_gpral(lDAPConnection, config._groups, config._server_name, config._group_base)) {
            System.err.println("Failed to remove group entries");
            return false;
        }
        if (!this.remove_gpral(lDAPConnection, config._events, config._server_name, config._event_base)) {
            System.err.println("Failed to remove rule entries");
            return false;
        }
        if (!this.remove_gpral(lDAPConnection, config._actions, config._server_name, config._action_base)) {
            System.err.println("Failed to remove action entries");
            return false;
        }
        return true;
    }

    private void create_simple_ou_entry(LDAPConnection lDAPConnection, String string, String string2) throws LDAPException {
        block2: {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String[] stringArray = new String[]{"top", "organizationalUnit"};
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
            lDAPAttributeSet.add(new LDAPAttribute("ou", string2));
            System.out.println("Creating simple ou entry " + string);
            try {
                lDAPConnection.add(new LDAPEntry(string, lDAPAttributeSet));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 68) break block2;
                System.out.println("Could not create OU " + string);
                throw lDAPException;
            }
        }
    }

    private void create_ou_entry(LDAPConnection lDAPConnection, String string, String string2, String string3) throws LDAPException {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        String[] stringArray = new String[]{"top", "ids-proxy-top", "organizationalUnit"};
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
        lDAPAttributeSet.add(new LDAPAttribute("ou", string2));
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-sch-belongs-to", string3));
        System.out.println("Creating ou entry " + string);
        try {
            lDAPConnection.add(new LDAPEntry(string, lDAPAttributeSet));
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 68) {
                System.out.println("Could not create OU " + string);
                throw lDAPException;
            }
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            if (this.belongs_to(lDAPEntry, string3)) {
                System.err.println("WARNING: entry " + string + " already belongs-to " + string3 + ". Could be an uninstall problem");
            }
            lDAPConnection.modify(string, new LDAPModification(0, new LDAPAttribute("ids-proxy-sch-belongs-to", string3)));
        }
    }

    private boolean add_configuration(LDAPConnection lDAPConnection, Config config, Config config2) {
        System.out.println("Old Config is...");
        this.print_config(config);
        System.out.println("New Config is...");
        this.print_config(config2);
        try {
            int n;
            Object object;
            DN dN = new DN(config._group_base);
            dN = dN.getParent();
            System.out.println("Old base is " + dN.toString());
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            if (config2._properties != null && config2._properties.length != 0 && config._property_base == null) {
                object = new DN(dN.toString());
                object.addRDN(new RDN("ou=properties"));
                lDAPModificationSet.add(0, new LDAPAttribute("ids-proxy-sch-property-base", object.toString()));
                config._property_base = object.toString();
            } else if ((config2._properties == null || config2._properties.length == 0) && config._property_base != null) {
                lDAPModificationSet.add(1, new LDAPAttribute("ids-proxy-sch-property-base"));
                config._property_base = null;
            }
            if (config2._actions != null && config2._actions.length != 0 && config._action_base == null) {
                object = new DN(dN.toString());
                object.addRDN(new RDN("ou=actions"));
                lDAPModificationSet.add(0, new LDAPAttribute("ids-proxy-sch-action-base", object.toString()));
                config._action_base = object.toString();
            } else if ((config2._actions == null || config2._actions.length == 0) && config._action_base != null) {
                lDAPModificationSet.add(1, new LDAPAttribute("ids-proxy-sch-action-base"));
                config._action_base = null;
            }
            if (config2._events != null && config2._events.length != 0 && config._event_base == null) {
                object = new DN(dN.toString());
                object.addRDN(new RDN("ou=rules"));
                lDAPModificationSet.add(0, new LDAPAttribute("ids-proxy-sch-rule-base", object.toString()));
                config._event_base = object.toString();
            } else if ((config2._events == null || config2._events.length == 0) && config._event_base != null) {
                lDAPModificationSet.add(1, new LDAPAttribute("ids-proxy-sch-rule-base"));
                config._event_base = null;
            }
            lDAPModificationSet.add(2, new LDAPAttribute("ids-proxy-con-Server-Name", config._server_name));
            LDAPAttribute lDAPAttribute = config2._system.getAttribute("ids-proxy-con-config-name");
            String[] stringArray = lDAPAttribute.getStringValueArray();
            String string = new String("ids-proxy-con-config-name=" + stringArray[0] + ",ou=system," + dN.getParent().toString());
            lDAPModificationSet.add(2, new LDAPAttribute("ids-proxy-sch-global-config-dn", string));
            System.out.println("Modifying entry " + config._sie.getDN());
            System.out.println(lDAPModificationSet.toString());
            lDAPConnection.modify(config._sie.getDN(), lDAPModificationSet);
            System.out.println("Modified Sie entry " + config._sie.getDN());
            this.create_simple_ou_entry(lDAPConnection, "ou=system," + dN.getParent().toString(), "system");
            config._global_base = new String("ou=properties, ou=system, " + dN.getParent().toString());
            LDAPAttributeSet lDAPAttributeSet = config2._system.getAttributeSet();
            System.out.println("Set global-base to " + config._global_base);
            this.fix_system_entry(lDAPAttributeSet, "ou=system," + dN.getParent().toString(), stringArray[0]);
            if (!this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, "ou=system," + dN.getParent().toString(), "ids-proxy-con-config-name", config._server_name)) {
                System.err.println("Failed to add system entry");
                return false;
            }
            this.create_ou_entry(lDAPConnection, "ou=properties, ou=system," + dN.getParent().toString(), "properties", config._server_name);
            if (config2._log != null && config2._log.length != 0) {
                for (n = 0; n < config2._log.length; ++n) {
                    lDAPAttributeSet = config2._log[n].getAttributeSet();
                    if (this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, config._global_base, "ids-proxy-con-name", config._server_name)) continue;
                    System.err.println("Failed to add log entry");
                    return false;
                }
            }
            if (config2._system_properties != null && config2._system_properties.length != 0) {
                for (n = 0; n < config2._system_properties.length; ++n) {
                    lDAPAttributeSet = config2._system_properties[n].getAttributeSet();
                    if (this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, config._global_base, "ids-proxy-con-name", config._server_name)) continue;
                    System.err.println("Failed to add system entries");
                    return false;
                }
            }
            if (config2._properties != null && config2._properties.length != 0) {
                this.create_ou_entry(lDAPConnection, "ou=properties, " + dN.toString(), "properties", config._server_name);
            }
            this.create_ou_entry(lDAPConnection, "ou=groups, " + dN.toString(), "groups", config._server_name);
            if (config2._groups != null) {
                for (n = 0; n < config2._groups.length; ++n) {
                    lDAPAttributeSet = config2._groups[n].getAttributeSet();
                    object = this.get_attr_val(lDAPAttributeSet, "ids-proxy-con-server");
                    if (object != null) {
                        lDAPAttributeSet.remove("ids-proxy-con-server");
                        String string2 = this.add_lb_for_inner_server(lDAPConnection, config._property_base, config._server_name, (String)object);
                        if (string2 == null) {
                            System.err.println("Failed to convert ids-proxy-con-server to LoadBalance property");
                            return false;
                        }
                        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-include-property", string2));
                    }
                    if (this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, config._group_base, "ids-proxy-con-name", config._server_name)) continue;
                    System.err.println("Failed to add group entry");
                    return false;
                }
            }
            if (config2._properties != null && config2._properties.length != 0) {
                for (n = 0; n < config2._properties.length; ++n) {
                    lDAPAttributeSet = config2._properties[n].getAttributeSet();
                    if (this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, config._property_base, "ids-proxy-con-name", config._server_name)) continue;
                    System.err.println("Failed to add property entry");
                    return false;
                }
            }
            if (config2._events != null && config2._events.length != 0) {
                this.create_ou_entry(lDAPConnection, "ou=rules, " + dN.toString(), "rules", config._server_name);
                for (n = 0; n < config2._events.length; ++n) {
                    lDAPAttributeSet = config2._events[n].getAttributeSet();
                    if (this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, config._event_base, "ids-proxy-con-name", config._server_name)) continue;
                    System.err.println("Failed to add rule entry");
                    return false;
                }
            }
            if (config2._actions != null && config2._actions.length != 0) {
                this.create_ou_entry(lDAPConnection, "ou=actions, " + dN.toString(), "action", config._server_name);
                for (n = 0; n < config2._actions.length; ++n) {
                    lDAPAttributeSet = config2._actions[n].getAttributeSet();
                    if (this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, config._action_base, "ids-proxy-con-name", config._server_name)) continue;
                    System.err.println("Failed to add action entry");
                    return false;
                }
            }
        }
        catch (LDAPException lDAPException) {
            System.err.println("Failed to add configuration");
            System.err.println((Object)lDAPException);
            lDAPException.printStackTrace();
            return false;
        }
        return true;
    }

    private void fix_system_entry(LDAPAttributeSet lDAPAttributeSet, String string, String string2) {
        lDAPAttributeSet.remove("ids-proxy-con-ssl-cert");
        lDAPAttributeSet.remove("ids-proxy-con-ssl-key");
        lDAPAttributeSet.remove("ids-proxy-con-ssl-cafile");
        lDAPAttributeSet.remove("ids-proxy-con-ldaps-port");
        String string3 = MigrateConfig3.get_new_ssl_version(this.get_attr_val(lDAPAttributeSet, "ids-proxy-con-server-ssl-version"));
        if (string3 != null) {
            lDAPAttributeSet.remove("ids-proxy-con-server-ssl-version");
            lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-server-ssl-version", string3));
        }
        if ((string3 = MigrateConfig3.get_new_ssl_version(this.get_attr_val(lDAPAttributeSet, "ids-proxy-con-client-ssl-version"))) != null) {
            lDAPAttributeSet.remove("ids-proxy-con-client-ssl-version");
            lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-client-ssl-version", string3));
        }
        String string4 = new String("ou=properties," + string);
        lDAPAttributeSet.remove("ids-proxy-sch-global-base");
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-sch-global-base", string4));
        lDAPAttributeSet.remove("ids-proxy-con-Config-Name");
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-Config-Name", string2));
    }

    private String get_attr_val(LDAPAttributeSet lDAPAttributeSet, String string) {
        LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(string);
        String[] stringArray = null;
        lDAPAttribute = lDAPAttributeSet.getAttribute(string);
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()).length > 0) {
            return stringArray[0];
        }
        return null;
    }

    private String get_attr_val(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValueArray()).length > 0) {
            return stringArray[0];
        }
        return null;
    }

    private static String get_new_ssl_version(String string) {
        if (string == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 20: {
                    return String.valueOf(1);
                }
                case 30: {
                    return String.valueOf(2);
                }
                case 23: {
                    return String.valueOf(3);
                }
                case 31: {
                    return String.valueOf(4);
                }
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return null;
        }
    }

    String add_lb_for_inner_server(LDAPConnection lDAPConnection, String string, String string2, String string3) throws LDAPException {
        Date date = new Date();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        String[] stringArray = new String[]{"ids-proxy-sch-loadbalanceproperty", "ids-proxy-sch-Property", "ids-proxy-top", "top"};
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-sch-Enable", "true"));
        String string4 = new String("Migration_generated_lb_prop_" + date.hashCode());
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-Name", string4));
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n = stringTokenizer.countTokens();
        int n2 = 100 / n;
        String[] stringArray2 = new String[n];
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            String string5 = null;
            try {
                string5 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            stringArray2[i] = new String(string5 + "#" + n2);
            n3 += n2;
        }
        try {
            int n4 = 100 - n3;
            stringArray2[i] = new String(stringTokenizer.nextToken() + "#" + n4);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-con-server", stringArray2));
        if (!this.put_new_config_entry(lDAPConnection, lDAPAttributeSet, string, "ids-proxy-con-Name", string2)) {
            System.err.println("Failed to add generated LB property");
            return null;
        }
        System.out.println("Added generated load balance property " + string4);
        return string4;
    }

    private boolean put_new_config_entry(LDAPConnection lDAPConnection, LDAPAttributeSet lDAPAttributeSet, String string, String string2, String string3) throws LDAPException {
        LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(string2);
        if (lDAPAttribute == null) {
            return false;
        }
        String[] stringArray = lDAPAttribute.getStringValueArray();
        String string4 = new String(string2 + "=" + stringArray[0] + "," + string);
        System.out.println("New config entry's DN is " + string4);
        boolean bl = false;
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPConnection.read(string4);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                bl = true;
            }
            throw lDAPException;
        }
        if (bl) {
            System.out.println("Needs adding");
            lDAPAttributeSet.remove("ids-proxy-sch-belongs-to");
            lDAPAttributeSet.add(new LDAPAttribute("ids-proxy-sch-belongs-to", string3));
            LDAPEntry lDAPEntry2 = new LDAPEntry(string4, lDAPAttributeSet);
            lDAPConnection.add(lDAPEntry2);
        } else {
            System.out.println("Already exists... adding belongs-to");
            if (this.belongs_to(lDAPEntry, string3)) {
                System.err.println("WARNING: entry " + string4 + " already belongs-to " + string3 + ". Could be an uninstall problem");
            } else {
                lDAPConnection.modify(string4, new LDAPModification(0, new LDAPAttribute("ids-proxy-sch-belongs-to", string3)));
            }
        }
        return true;
    }

    private void fix_configuration(ConfAccessProp confAccessProp, Config config) {
        LDAPUrl lDAPUrl;
        try {
            lDAPUrl = new LDAPUrl(confAccessProp._url);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("**Bad URL " + confAccessProp._url);
            System.err.println(malformedURLException);
            return;
        }
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
            lDAPConnection.setOption(20, (Object)new Integer(0));
        }
        catch (LDAPException lDAPException) {
            System.err.println("**Error connecting to host: " + lDAPUrl.getHost());
            System.err.println(lDAPException.toString());
            return;
        }
        try {
            lDAPConnection.authenticate(3, confAccessProp._bind_dn, confAccessProp._passwd);
        }
        catch (LDAPException lDAPException) {
            System.err.println("**Error binding to host: " + lDAPUrl.getHost());
            System.err.println(lDAPException.toString());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException2) {
                // empty catch block
            }
            return;
        }
        Config config2 = new Config();
        if (!this.remove_configuration(lDAPConnection, config2, confAccessProp)) {
            System.err.println("**Failed to remove configuration for " + confAccessProp._url);
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return;
        }
        if (!this.add_configuration(lDAPConnection, config2, config)) {
            System.err.println("**Failed to add new configuration for" + confAccessProp._url);
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return;
        }
    }

    private LDAPEntry[] get_gpra(LDAPConnection lDAPConnection, String string, String string2) {
        LDAPEntry[] lDAPEntryArray;
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, string2, null, false);
            lDAPEntryArray = new LDAPEntry[lDAPSearchResults.getCount()];
            int n = 0;
            while (lDAPSearchResults.hasMoreElements()) {
                try {
                    lDAPEntryArray[n] = lDAPSearchResults.next();
                    ++n;
                }
                catch (LDAPReferralException lDAPReferralException) {
                    System.err.println("Received referral. Ignoring...");
                }
            }
        }
        catch (LDAPException lDAPException) {
            System.err.println("Error encountered while searching " + string + " with filter " + string2);
            System.err.println(lDAPException.toString());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException2) {
                // empty catch block
            }
            return null;
        }
        return lDAPEntryArray;
    }

    private boolean is_of_objectclass(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            stringArray = lDAPAttribute.getStringValueArray();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean belongs_to(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-belongs-to");
        if (lDAPAttribute == null) {
            System.err.println("WARNING: No belongs-to found");
            return false;
        }
        stringArray = lDAPAttribute.getStringValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void move_log_properties(Config config) {
        int n;
        if (config._properties == null) {
            return;
        }
        LDAPEntry[] lDAPEntryArray = null;
        LDAPEntry[] lDAPEntryArray2 = null;
        int n2 = 0;
        for (n = 0; n < config._properties.length; ++n) {
            if (!this.is_of_objectclass(config._properties[n], "ids-proxy-sch-LogProperty")) continue;
            ++n2;
        }
        lDAPEntryArray2 = new LDAPEntry[config._properties.length - n2];
        lDAPEntryArray = new LDAPEntry[n2];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < config._properties.length; ++n) {
            if (this.is_of_objectclass(config._properties[n], "ids-proxy-sch-LogProperty")) {
                lDAPEntryArray[n3] = config._properties[n];
                ++n3;
                continue;
            }
            lDAPEntryArray2[n4] = config._properties[n];
            ++n4;
        }
        Config.access$702(config, lDAPEntryArray);
        Config.access$1002(config, lDAPEntryArray2);
    }

    private boolean download_config(ConfAccessProp confAccessProp, Config config) {
        Object object;
        String[] stringArray;
        LDAPAttribute lDAPAttribute;
        LDAPSearchResults lDAPSearchResults;
        LDAPUrl lDAPUrl;
        System.out.println("Trying " + confAccessProp._url);
        try {
            lDAPUrl = new LDAPUrl(confAccessProp._url);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL " + confAccessProp._url);
            System.err.println(malformedURLException);
            return false;
        }
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort());
            lDAPConnection.setOption(20, (Object)new Integer(0));
        }
        catch (LDAPException lDAPException) {
            System.err.println("Error connecting to host: " + lDAPUrl.getHost());
            System.err.println(lDAPException.toString());
            return false;
        }
        System.out.println("Connected to " + lDAPUrl.getHost());
        try {
            lDAPConnection.authenticate(3, confAccessProp._bind_dn, confAccessProp._passwd);
        }
        catch (LDAPException lDAPException) {
            System.err.println("Error binding to host: " + lDAPUrl.getHost());
            System.err.println(lDAPException.toString());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException2) {
                // empty catch block
            }
            return false;
        }
        System.out.println("Authenticated to host " + lDAPUrl.getHost());
        try {
            lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN(), 0, "objectclass=ids-proxy-sch-LDAPProxy", null, false);
        }
        catch (LDAPException lDAPException) {
            System.err.print("Error encountered while searching forids-proxy-sch-LDAPProxy object.");
            System.err.println("Base was: " + lDAPUrl.getDN());
            System.err.println(lDAPException.toString());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException3) {
                // empty catch block
            }
            return false;
        }
        if (lDAPSearchResults.getCount() != 1) {
            System.err.println("Did not find ids-proxy-sch-LDAPProxy object. DN was: " + lDAPUrl.getDN());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return false;
        }
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPSearchResults.next();
            config._sie = lDAPEntry;
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        String string = null;
        try {
            lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Global-Config-DN");
            stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray.length > 1) {
                System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Global-Config-DN.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
            config._system_dn = stringArray[0];
            lDAPSearchResults = lDAPConnection.search(stringArray[0], 0, "objectclass=ids-proxy-sch-GlobalConfiguration", null, false);
            if (lDAPSearchResults.getCount() != 1) {
                System.err.println("Could not locate ids-proxy-sch-GlobalConfiguration object. DN was: " + stringArray[0]);
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
            object = lDAPSearchResults.next();
            lDAPAttribute = object.getAttribute("ids-proxy-sch-global-base");
            if (lDAPAttribute != null) {
                stringArray = lDAPAttribute.getStringValueArray();
                string = stringArray[0];
                config._global_base = string;
            }
            config._system = object;
        }
        catch (LDAPException lDAPException) {
            System.err.println("Error encountered while searching for ids-proxy-sch-GlobalConfiguration object.");
            System.err.println(lDAPException.toString());
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException4) {
                // empty catch block
            }
            return false;
        }
        lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-con-Server-Name");
        stringArray = lDAPAttribute.getStringValueArray();
        if (stringArray.length > 1) {
            System.err.println("Invalid configuration: more than one value found for ids-proxy-con-Server-Name.");
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return false;
        }
        object = stringArray[0];
        config._server_name = (String)object;
        if (string != null && Config.access$402(config, this.get_gpra(lDAPConnection, string, "(&(objectclass=ids-proxy-sch-Property)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))")) == null) {
            System.err.println("Could not write ids-proxy-sch-global-base entries.");
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return false;
        }
        lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Group-Base");
        stringArray = lDAPAttribute.getStringValueArray();
        if (stringArray.length > 1) {
            System.err.println("Invalid configuration: more than one values for ids-proxy-sch-Group-Base.");
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return false;
        }
        String string2 = stringArray[0];
        config._group_base = string2;
        String string3 = "(&(objectclass=ids-proxy-sch-Group)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
        if (Config.access$1102(config, this.get_gpra(lDAPConnection, string2, string3)) == null) {
            System.err.println("Could not write ids-proxy-sch-Group's entries.");
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            return false;
        }
        lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Property-Base");
        if (lDAPAttribute != null) {
            stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray.length > 1) {
                System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Property-Base.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
            string2 = stringArray[0];
            config._property_base = string2;
            string3 = "(&(objectclass=ids-proxy-sch-Property)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
            if (Config.access$1002(config, this.get_gpra(lDAPConnection, string2, string3)) == null) {
                System.err.println("Could not write ids-proxy-sch-Property's entries.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Rule-Base")) != null) {
            stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray.length > 1) {
                System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Rule-Base.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
            string2 = stringArray[0];
            config._event_base = string2;
            string3 = "(&(objectclass=ids-proxy-sch-Rule)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
            if (Config.access$1302(config, this.get_gpra(lDAPConnection, string2, string3)) == null) {
                System.err.println("Could not write ids-proxy-sch-Rule's entries.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("ids-proxy-sch-Action-Base")) != null) {
            stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray.length > 1) {
                System.err.println("Invalid configuration: more than one value found for ids-proxy-sch-Action-Base.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
            string2 = stringArray[0];
            config._action_base = string2;
            string3 = "(&(objectclass=ids-proxy-sch-Action)(ids-proxy-sch-enable=TRUE)(ids-proxy-sch-belongs-to=" + (String)object + "))";
            if (Config.access$1502(config, this.get_gpra(lDAPConnection, string2, string3)) == null) {
                System.err.println("Could not write ids-proxy-sch-Action's entries.");
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                return false;
            }
        }
        try {
            lDAPConnection.disconnect();
        }
        catch (LDAPException lDAPException) {
            System.err.println(lDAPException.toString());
        }
        System.out.println("Config downloaded from " + lDAPUrl.getHost() + lDAPUrl.getPort());
        this.move_log_properties(config);
        this.print_config(config);
        return true;
    }

    private void print_config(Config config) {
        System.out.println("Server Name " + config._server_name);
        System.out.println("Global Base " + config._global_base);
        System.out.println("Group Base " + config._group_base);
        System.out.println("Property Base " + config._property_base);
        System.out.println("Event Base " + config._event_base);
        System.out.println("Action Base " + config._action_base);
        System.out.println("System DN " + config._system_dn);
    }

    private boolean download_config(ConfAccessProp[] confAccessPropArray, Config config) {
        for (int i = 0; i < confAccessPropArray.length; ++i) {
            if (confAccessPropArray[i] == null || !this.download_config(confAccessPropArray[i], config)) continue;
            return true;
        }
        return false;
    }

    private int remove_file_based_entries(ConfAccessProp[] confAccessPropArray) {
        int n = 0;
        int n2 = 0;
        while (confAccessPropArray[n2] != null) {
            if (confAccessPropArray[n2]._url.startsWith("file://")) {
                System.out.println("Removing " + confAccessPropArray[n2]._url);
                confAccessPropArray[n2] = null;
            } else if (confAccessPropArray[n2]._sasl_mechanism != 0) {
                System.err.println("No SASL is supported from this utility");
                System.out.println("Removing " + confAccessPropArray[n2]._url);
                confAccessPropArray[n2] = null;
            } else {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int getline(FileReader fileReader, char[] cArray) throws IOException {
        int n;
        int n2 = fileReader.read();
        for (n = 0; (char)n2 != '\n' && n < cArray.length && n2 != -1; ++n) {
            cArray[n] = (char)n2;
            n2 = fileReader.read();
        }
        if (n2 == -1) {
            return n2;
        }
        if (n >= cArray.length) {
            return -2;
        }
        return n;
    }

    private boolean read_tailor(String string, ConfAccessProp[] confAccessPropArray) throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        FileReader fileReader = new FileReader(string);
        char[] cArray = new char[1024];
        while ((n = this.getline(fileReader, cArray)) != -1) {
            ++n2;
            if (n == -2) {
                System.err.println("Line too long " + n2);
                fileReader.close();
                return false;
            }
            String string2 = new String(cArray, 0, n);
            if ((string2 = string2.trim()).length() == 0 || Character.isWhitespace(string2.charAt(0)) || string2.charAt(0) == '#' || string2.charAt(0) == ';') continue;
            if (string2.compareToIgnoreCase("begin") == 0) {
                if (bl) {
                    System.err.println("Mismatched begin, line number " + n2);
                    fileReader.close();
                    return false;
                }
                bl = true;
                confAccessPropArray[n3] = new ConfAccessProp();
                confAccessPropArray[n3 + 1] = null;
                continue;
            }
            if (string2.equalsIgnoreCase("end")) {
                if (!bl) {
                    System.err.println("Mismatched end, line number " + n2);
                    fileReader.close();
                    return false;
                }
                bl = false;
                ++n3;
                continue;
            }
            if (!bl) {
                System.err.println("Options must be within begin and end");
                fileReader.close();
                return false;
            }
            int n4 = string2.indexOf(58);
            if (n4 == -1) {
                System.err.println("Missing : in line " + n2);
                fileReader.close();
                return false;
            }
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4 + 1);
            string3 = string3.trim();
            string4 = string4.trim();
            if (string3.equalsIgnoreCase("configuration_url")) {
                confAccessPropArray[n3]._url = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("configuration_bind_dn")) {
                confAccessPropArray[n3]._bind_dn = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("configuration_bind_pw")) {
                confAccessPropArray[n3]._passwd = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("configuration_username")) {
                confAccessPropArray[n3]._username = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("sasl_bind_mechanism")) {
                if (string4.equalsIgnoreCase("DIGEST-MD5")) {
                    confAccessPropArray[n3]._sasl_mechanism = 1;
                    continue;
                }
                if (string4.equalsIgnoreCase("CRAM-MD5")) {
                    confAccessPropArray[n3]._sasl_mechanism = 1;
                    continue;
                }
                System.err.println("The only supported sasl_bind_mechanisms are DIGEST-MD5 and CRAM-MD5. " + string4 + " is not recognized.");
                fileReader.close();
                return false;
            }
            System.err.println("Unrecognized keyword (" + string3 + ") in line " + n2);
            fileReader.close();
            return false;
        }
        fileReader.close();
        return true;
    }

    public static void usage() {
        System.err.println("Usage: -o <path to tailor.txt for older version\n       -n <path to tailor.txt for new version\n       -b <path to backup file for ou=dar-config, o=NetscapeRoot");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length < 6) {
            MigrateConfig3.usage();
        }
        int n = 0;
        block7: while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-') {
                MigrateConfig3.usage();
            }
            switch (stringArray[n].charAt(1)) {
                case 'n': {
                    if (++n >= stringArray.length) {
                        MigrateConfig3.usage();
                    }
                    string2 = stringArray[n];
                    ++n;
                    continue block7;
                }
                case 'o': {
                    if (++n >= stringArray.length) {
                        MigrateConfig3.usage();
                    }
                    string = stringArray[n];
                    ++n;
                    continue block7;
                }
                case 'b': {
                    if (++n >= stringArray.length) {
                        MigrateConfig3.usage();
                    }
                    string3 = stringArray[n];
                    ++n;
                    continue block7;
                }
            }
        }
        if (string == null || string2 == null || string3 == null) {
            MigrateConfig3.usage();
        }
        System.out.println("Old tailor file set to " + string + "\n" + "New tailor file set to " + string2 + "\n" + "Backup file set to " + string3);
        MigrateConfig3 migrateConfig3 = new MigrateConfig3(string, string2, string3);
        try {
            if (!migrateConfig3.migrate()) {
                System.out.println("Migration Failed");
            }
        }
        catch (IOException iOException) {
            System.err.println("An exception occured");
            System.err.println(iOException);
            throw iOException;
        }
    }

    private class Config {
        private String _server_name;
        private String _global_base;
        private String _group_base;
        private String _property_base;
        private String _event_base;
        private String _action_base;
        private String _system_dn;
        private LDAPEntry _sie;
        private LDAPEntry _system;
        private LDAPEntry[] _system_properties;
        private LDAPEntry[] _log;
        private LDAPEntry[] _properties;
        private LDAPEntry[] _events;
        private LDAPEntry[] _actions;
        private LDAPEntry[] _groups;

        private Config() {
        }

        static /* synthetic */ LDAPEntry[] access$702(Config config, LDAPEntry[] lDAPEntryArray) {
            config._log = lDAPEntryArray;
            return lDAPEntryArray;
        }

        static /* synthetic */ LDAPEntry[] access$1002(Config config, LDAPEntry[] lDAPEntryArray) {
            config._properties = lDAPEntryArray;
            return lDAPEntryArray;
        }

        static /* synthetic */ LDAPEntry[] access$402(Config config, LDAPEntry[] lDAPEntryArray) {
            config._system_properties = lDAPEntryArray;
            return lDAPEntryArray;
        }

        static /* synthetic */ LDAPEntry[] access$1102(Config config, LDAPEntry[] lDAPEntryArray) {
            config._groups = lDAPEntryArray;
            return lDAPEntryArray;
        }

        static /* synthetic */ LDAPEntry[] access$1302(Config config, LDAPEntry[] lDAPEntryArray) {
            config._events = lDAPEntryArray;
            return lDAPEntryArray;
        }

        static /* synthetic */ LDAPEntry[] access$1502(Config config, LDAPEntry[] lDAPEntryArray) {
            config._actions = lDAPEntryArray;
            return lDAPEntryArray;
        }
    }

    private class ConfAccessProp {
        private static final int no_sasl = 0;
        private static final int cram_md5 = 1;
        private static final int digest_md5 = 1;
        private String _url = null;
        private String _bind_dn = null;
        private String _passwd = null;
        private String _username = null;
        private int _sasl_mechanism = 0;

        private ConfAccessProp() {
        }
    }
}

