/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.comm.AsyncByteArrayInputStream;
import com.netscape.management.client.comm.ClientThread;
import com.netscape.management.client.comm.CommChannel;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommClient2;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpException;
import com.netscape.management.client.console.VersionInfo;
import com.netscape.management.client.util.DPSHttpManager;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.IProgressListener;
import com.netscape.management.client.util.Permissions;
import com.netscape.management.client.util.URLByteEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class DPSHttpChannel
implements Runnable,
CommChannel {
    protected static final String HTTP_GET = "GET";
    protected static final String HTTP_POST = "POST";
    protected static final String http_prot = "HTTP/1.0";
    protected static final String newline = "\r\n";
    protected static final int defaultExpectedLineLength = 128;
    protected static int defaultBufferLength = 512;
    protected Thread thread = null;
    protected URL tid = null;
    protected DPSHttpManager manager = null;
    protected String language = null;
    protected String name = null;
    protected boolean sendUTF8 = false;
    protected String _adminVersion;
    protected Socket socket = null;
    protected BufferedOutputStream bos = null;
    protected BufferedInputStream bis = null;
    protected boolean dead = false;
    protected boolean busy = false;
    private static final byte[] cipherset = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    protected DPSHttpChannel(Object object, String string, DPSHttpManager dPSHttpManager) {
        this.tid = (URL)object;
        this.manager = dPSHttpManager;
        DPSHttpChannel dPSHttpChannel = this;
        this.language = dPSHttpChannel.manager.getLanguage();
        this.name = this.tid.toString() + "[" + string + "]";
        DPSHttpChannel dPSHttpChannel2 = this;
        this.sendUTF8 = dPSHttpChannel2.manager.getSendUTF8();
    }

    public void open() throws IOException {
        Method method = Permissions.getEnablePrivilegeMethod();
        if (method != null) {
            Object[] objectArray = new Object[]{"UniversalConnect"};
            try {
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                System.err.println("DPSHttpChannel:open():unable to grant UniversalConnect:" + exception);
            }
        }
        this.socket = new Socket(this.getHost(), this.getPort());
        this.bos = new BufferedOutputStream(this.socket.getOutputStream(), defaultBufferLength);
        this.bis = new BufferedInputStream(this.socket.getInputStream(), defaultBufferLength);
        Debug.println((String)(this.name + " open> Ready"));
        this.thread = new Thread((Runnable)this, this.tid.toString());
        this.thread.start();
    }

    public void close() throws IOException {
        this.dead = true;
        if (this.bos != null) {
            this.bos.close();
            this.bos = null;
        }
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
            Debug.println((String)(this.name + " close> Closed"));
        }
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public boolean ready() {
        return this.thread != null && !this.dead && !this.busy;
    }

    public Object targetID() {
        return this.tid;
    }

    public String toString() {
        return this.name;
    }

    protected static void setBufferSize(int n) {
        defaultBufferLength = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        while (!this.dead) {
            CommRecord commRecord = null;
            this.busy = false;
            try {
                commRecord = this.manager.next(this);
            }
            catch (IOException iOException) {
                Debug.println((String)(this.name + " error> " + iOException));
                this.kill();
            }
            if (commRecord == null) {
                this.kill();
            }
            commRecord.setChannel((CommChannel)this);
            this.busy = true;
            Debug.println((String)(this.name + " accept> " + commRecord.getTarget()));
            if (commRecord.getStatus().equals("Error")) {
                Debug.println((String)(this.name + "error> CommRecord Status: " + "Error"));
                continue;
            }
            CommClient commClient = commRecord.getClient();
            try {
                if (bl) {
                    if (!this.isConnected()) {
                        Debug.println((String)(this.name + " test> connection is lost -- open new channel"));
                        this.retry(commRecord);
                        this.kill();
                        return;
                    }
                    Debug.println((String)(this.name + " test> connection is still there"));
                }
                bl = true;
                this.invoke(commRecord);
            }
            catch (HttpException httpException) {
                Debug.println((String)(this.name + " error> " + (Object)((Object)httpException)));
                commRecord.setStatus((Object)"Error");
                commClient.errorHandler((Exception)((Object)httpException), commRecord);
                this.kill();
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.println((String)(this.name + " error> " + interruptedIOException));
                commRecord.setStatus((Object)"Error");
                commClient.errorHandler((Exception)interruptedIOException, commRecord);
                this.kill();
            }
            catch (EOFException eOFException) {
                Debug.println((String)(this.name + " error> " + eOFException));
                commRecord.setStatus((Object)"Error");
                commClient.errorHandler((Exception)eOFException, commRecord);
                this.kill();
            }
            catch (IOException iOException) {
                Debug.println((String)(this.name + " error> " + iOException));
                this.retry(commRecord);
                this.kill();
            }
            finally {
                if (!Debug.httpTraceEnabled()) continue;
                Debug.println((String)"http", (String)"Done!");
            }
        }
    }

    private void retry(CommRecord commRecord) {
        try {
            this.manager.retry(commRecord);
        }
        catch (IOException iOException) {
            Debug.println((String)(this.name + " error> " + iOException));
        }
    }

    private void kill() {
        try {
            this.manager.closeChannel(this);
        }
        catch (IOException iOException) {
            Debug.println((String)(this.name + " error> " + iOException));
        }
    }

    private void invoke(CommRecord commRecord) throws IOException, HttpException {
        int n;
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = ((URL)commRecord.getTarget()).getFile();
        InputStream inputStream = commRecord.getData();
        if (!this.sendUTF8) {
            this.writeLine((inputStream == null ? HTTP_GET : HTTP_POST) + " " + string2 + " " + http_prot);
        } else {
            this.write((inputStream == null ? HTTP_GET : HTTP_POST) + " ");
            this.write(string2.getBytes("UTF8"));
            this.writeLine(" HTTP/1.0");
        }
        this.writeLine("Host: " + this.getHost() + ":" + this.getPort());
        this.writeLine("Connection: Keep-Alive");
        try {
            string = VersionInfo.getVersionNumber();
            this.writeLine("User-Agent: Netscape-Console/" + string);
        }
        catch (Exception exception) {
            this.writeLine("User-Agent: Netscape-Console/");
        }
        this.writeLine("Accept-Language: " + this.language);
        string = commRecord.getClient();
        Object object = commRecord.getAuthObj();
        String[] stringArray = (String[])commRecord.getChannelArg();
        if (object != null) {
            String string3 = string.username(object, commRecord);
            String string4 = string.password(object, commRecord);
            string3 = string3 != null ? string3 : "";
            String string5 = string4 = string4 != null ? string4 : "";
            if (!this.sendUTF8) {
                this.writeLine("Authorization: Basic " + DPSHttpChannel.uuencode(string3 + ":" + string4));
            } else {
                this.write("Authorization: Basic ");
                this.write(DPSHttpChannel.uuencode((string3 + ":" + string4).getBytes("UTF8")));
                this.writeLine("");
            }
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.writeLine(stringArray[i]);
            }
        }
        if (inputStream != null) {
            int n2 = commRecord.getDataLength();
            this.writeLine("Content-Length:" + n2);
            this.writeLine("Content-Type: application/x-www-form-urlencoded; charset=UTF-8");
            this.writeLine("Content-Transfer-Encoding: 7bit");
            this.writeLine("");
            this.write(inputStream, n2);
        } else {
            this.writeLine("");
        }
        commRecord.setStatus((Object)"Sent");
        this.socket.setSoTimeout(this.manager.getResponseTimeout());
        String string6 = this.readLine();
        int n3 = string6.indexOf(32);
        int n4 = Integer.parseInt(string6.substring(n3 + 1, n3 + 1 + 3));
        String string7 = string6.substring(0, n3);
        switch (n4) {
            case 200: 
            case 301: 
            case 302: {
                break;
            }
            case 401: {
                if (object == null) break;
                throw new HttpException((URL)commRecord.getTarget(), string6, n4);
            }
            default: {
                throw new HttpException((URL)commRecord.getTarget(), string6, n4);
            }
        }
        int n5 = -1;
        object = null;
        while (true) {
            if ((string6 = this.readLine()).regionMatches(true, 0, "Content-length", 0, 14)) {
                n5 = Integer.parseInt(string6.substring(string6.indexOf(58) + 2));
                continue;
            }
            if (string6.regionMatches(true, 0, "WWW-authenticate", 0, 16)) {
                n = string6.indexOf(61);
                if (n == -1) {
                    throw new HttpException((URL)commRecord.getTarget(), string6, -1);
                }
                object = string6.substring(n + 1);
                bl = true;
                continue;
            }
            if (string6.regionMatches(true, 0, "Admin-Server:", 0, 13)) {
                n = string6.indexOf(47);
                if (n == -1) {
                    Debug.println((String)("DPSHttpChannel.invoke: no version in " + string6));
                    continue;
                }
                this._adminVersion = string6.substring(n + 1);
                Debug.println((String)("DPSHttpChannel.invoke: admin version = " + this._adminVersion));
                continue;
            }
            if (string6.regionMatches(true, 0, "Server:", 0, 7) && this._adminVersion == null) {
                n = string6.indexOf(47);
                if (n == -1) {
                    Debug.println((String)("DPSHttpChannel.invoke: no version in " + string6));
                    continue;
                }
                this._adminVersion = string6.substring(n + 1);
                Debug.println((String)("DPSHttpChannel.invoke: admin version = " + this._adminVersion));
                continue;
            }
            if (string6.regionMatches(true, 0, "Location:", 0, 9) && (n4 == 301 || n4 == 302)) {
                commRecord.setTarget((Object)new URL(string6.substring(string6.indexOf(58) + 2)));
                bl = true;
                continue;
            }
            if (string6.trim().length() == 0) break;
        }
        n = commRecord.getAsyncResponseMode() ? 1 : 0;
        if (n5 == -1) {
            AsyncByteArrayInputStream asyncByteArrayInputStream = new AsyncByteArrayInputStream();
            if (!bl && n != 0) {
                new ClientThread(commRecord, (InputStream)asyncByteArrayInputStream).start();
            }
            Debug.println((String)(this.name + " recv> Reading unknown length bytes..."));
            try {
                int n6;
                while ((n6 = this.bis.read()) != -1) {
                    asyncByteArrayInputStream.write(n6);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            asyncByteArrayInputStream.setEOF();
            commRecord.setStatus((Object)"Complete");
            Debug.println((String)(this.name + " recv> " + asyncByteArrayInputStream.size() + " bytes read"));
            if (!bl && n == 0) {
                new ClientThread(commRecord, (InputStream)asyncByteArrayInputStream).start();
            }
            bl2 = true;
        } else if (n5 >= 0) {
            CommRecord commRecord2;
            IProgressListener iProgressListener = null;
            if (commRecord.getClient() instanceof CommClient2) {
                commRecord2 = commRecord;
                iProgressListener = new IProgressListener(){

                    public void progressUpdate(String string, int n, int n2) {
                        ((CommClient2)commRecord2.getClient()).progressUpdate(commRecord2.getTarget().toString(), n, n2);
                    }
                };
            }
            commRecord2 = new AsyncByteArrayInputStream(n5 > 0 ? n5 : 1, iProgressListener);
            if (!bl && n != 0) {
                new ClientThread(commRecord, (InputStream)commRecord2).start();
            }
            Debug.println((String)(this.name + " recv> Reading " + n5 + " bytes..."));
            if (n5 > 0) {
                commRecord2.write((InputStream)this.bis, n5);
            }
            commRecord2.setEOF();
            commRecord.setStatus((Object)"Complete");
            Debug.println((String)(this.name + " recv> " + commRecord2.available() + " bytes read"));
            if (!bl && n == 0) {
                new ClientThread(commRecord, (InputStream)commRecord2).start();
            }
            if (string7.compareTo(http_prot) < 0) {
                bl2 = true;
            }
        }
        if (object != null) {
            commRecord.setAuthObj(object);
        }
        if (bl) {
            this.retry(commRecord);
        }
        if (bl2) {
            this.kill();
        }
    }

    private void write(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println((String)(this.name + " send> " + string + " \\"));
    }

    private void write(byte[] byArray) throws IOException {
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println((String)(this.name + " send> " + new String(byArray) + " \\"));
    }

    private void writeLine(String string) throws IOException {
        byte[] byArray = (string + newline).getBytes();
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println((String)(this.name + " send> " + string));
    }

    private void write(InputStream inputStream, int n) throws IOException {
        Debug.println((String)(this.name + " send> Writing " + n + " bytes..."));
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        this.bos.write(byArray);
        this.bos.flush();
        Debug.println((String)(this.name + " send> " + n + " bytes written"));
    }

    protected String readLine() throws IOException {
        int n = defaultBufferLength;
        byte[] byArray = new byte[n];
        int n2 = 0;
        boolean bl = false;
        try {
            block9: while (!bl) {
                int n3 = this.bis.read();
                switch (n3) {
                    default: {
                        try {
                            if (this.bis.available() == 0) {
                                continue block9;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n2 == n) {
                            byte[] byArray2 = new byte[n + defaultBufferLength];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            n += defaultBufferLength;
                            byArray = byArray2;
                        }
                        byArray[n2++] = (byte)n3;
                        continue block9;
                    }
                    case 10: {
                        bl = true;
                        continue block9;
                    }
                    case -1: {
                        throw new EOFException("Connection lost");
                    }
                    case 13: 
                }
                bl = true;
                int n4 = this.bis.read();
                if (n4 == 10) continue;
                System.err.println("DPSHttpChannel:readLine():carriage return not followed by newline in stream.");
            }
            String string = new String(byArray, 0, n2);
            Debug.println((String)(this.name + " recv> " + string));
            return string;
        }
        catch (InterruptedIOException interruptedIOException) {
            Debug.println((String)(this.name + " recv> interrupted"));
            throw new InterruptedIOException("HTTP response timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() throws IOException {
        int n = this.socket.getSoTimeout();
        try {
            this.socket.setSoTimeout(100);
            int n2 = this.bis.read();
            if (n2 == -1) {
                boolean bl = false;
                return bl;
            }
            try {
                Debug.println((int)0, (String)("Unexpected data received 0x" + Integer.toHexString(n2)));
                throw new IOException();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
        }
        finally {
            this.socket.setSoTimeout(n);
        }
        return true;
    }

    public static ByteArrayInputStream encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(DPSHttpChannel._encode(new String(byArray)).getBytes());
    }

    public static ByteArrayInputStream encode(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string = string + string2 + "=" + URLByteEncoder.encodeUTF8((String)string3) + (enumeration.hasMoreElements() ? "&" : "");
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public static String _encode(String string) {
        return URLEncoder.encode(string);
    }

    public static String uuencode(String string) {
        return new String(DPSHttpChannel.uuencode(string.getBytes()));
    }

    public static byte[] uuencode(byte[] byArray) {
        int n;
        int n2 = (n = byArray.length) % 3;
        byte[] byArray2 = new byte[n + (n2 == 0 ? 0 : 3 - n2)];
        byte[] byArray3 = new byte[byArray2.length * 4 / 3];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length) {
            byte by = byArray2[n3++];
            byte by2 = byArray2[n3++];
            byte by3 = byArray2[n3++];
            byArray3[n4++] = cipherset[by >> 2 & 0x3F];
            byArray3[n4++] = cipherset[(by & 3) << 4 | (by2 & 0xF0) >> 4];
            byArray3[n4++] = cipherset[(by2 & 0xF) << 2 | (by3 & 0xC0) >> 6];
            byArray3[n4++] = cipherset[by3 & 0x3F];
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                int n5 = --n4;
                byArray3[--n4] = 61;
                byArray3[n5] = 61;
                break;
            }
            case 2: {
                byArray3[--n4] = 61;
            }
        }
        return byArray3;
    }

    protected String getHost() {
        String string = this.tid.getHost();
        if (string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    protected int getPort() {
        return this.tid.getPort();
    }

    protected String getProtocol() {
        return this.tid.getProtocol();
    }

    public String getAdminVersion() {
        return this._adminVersion;
    }
}

