// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='Vérifier l\'orthographe'
i18n['settings autospell exp']='Toujours vérifier l\'orthographe avant d\'envoyer un message'
i18n['spellok']='OK'
i18n['AutoSpellCheck']='Vérifier l\'orthographe avant l\'envoi d\'un message'
i18n['spell error']='Erreur du serveur : impossible de vérifier l\'orthographe'
i18n['spelldicterror']='Erreur du serveur : dictionnaire de la langue non disponible'
i18n['select  comp lang']='Sélectionnez la langue'
i18n['spelldict']='Dictionnaire'
i18n['spell change'] = '&nbsp;&nbsp;Modifier&nbsp;&nbsp;&nbsp;'
i18n['spell changeall'] = 'Tout modifier'
i18n['spell ignoreall'] = '&nbsp;Tout ignorer&nbsp;'
i18n['spell_progress']='Veuillez patienter. Le vérificateur d\'orthographe va démarrer sous peu.'
i18n['send_progress']='Envoi en cours';
i18n['spell_no_mistakes']="Aucune faute d\'orthographe";
i18n['spell_select_lang']="Sélectionnez une langue";
i18n['spell_nothing']='Rien à vérifier';
i18n['send_anyway']= 'Le message contient des mots inconnus du vérificateur d\'orthographe. Voulez-vous l\'envoyer quand même ?'
i18n['done_anyway']= 'Le message contient encore des mots inconnus du vérificateur d\'orthographe.'
i18n['spell_window_title']='Vérifier l\'orthographe du message'
i18n['spell yes']="Oui"
i18n['spell no']="Non"
i18n['spelltool done']="Terminé"
i18n['spelltool help']="Aide"
i18n['No Suggestions']='Pas de suggestion'
i18n['Suggestions']='Suggestions'

//SMIME
i18n['smime not available']='La configuration SMIME est incomplète ou la mini-application n\'est pas chargée'
i18n['smime recipients failure']='Erreur lors de l\'ajout du destinataire&nbsp;:'
i18n['Signed Message']='Message signé'
i18n['Invalid Signature']='Signature incorrecte'
i18n['Invalid Encryption']='Codage incorrect'
i18n['Encrypted Message']='Message codé'
i18n['url_error']="Erreur lors de l\'ajout de l\'URL"

// Compose window toolbar
i18n['compose_send']='Envoyer le message'
i18n['compose_attach']='Joindre un fichier au message'
i18n['compose_spell']='Vérifier l\'orthographe du message'
i18n['compose_editor']='Changer d\'éditeur (texte brut ou HTML)'




// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = 'Chargement en cours&nbsp;: veuillez patienter...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = 'Sélectionner'
i18n['Select All']= 'Tout sélectionner'
i18n['Deselect All']= 'Tout désélectionner'
i18n['no msg'] = 'Ce dossier ne contient aucun message.'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = 'Boîte de réception'
fldr['Trash'] = 'Corbeille'
fldr['Drafts'] = 'Brouillons'
fldr['Sent'] = 'Envoyé'
fldr['Sent Items'] = 'Éléments envoyés'

// Window titles
i18n['app title'] = 'Messagerie - Communications Express'
i18n['sjs app title'] = 'Sun Java&#153; System Messenger Express'
i18n['attach title'] = 'Joindre un fichier'
i18n['collect title'] = 'Récupérer le courrier externe'
i18n['compose title'] = 'Nouveau message'
i18n['lookup title'] = 'Recherche LDAP'
i18n['receipt title'] = 'Accusé de réception'
i18n['editgroup title'] = 'Mettre à jour le groupe'
i18n['editentry title'] = 'Mettre à jour le contact'
i18n['newgroup title'] = 'Nouveau groupe'
i18n['newentry title'] = 'Nouveau contact'
i18n['comprecipient title'] = 'Sélectionner les destinataires dans le carnet d\'adresses personnel'

// Tabs
i18n['folders'] = 'Dossiers'
i18n['message'] = 'Message'
i18n['pab'] = 'Adresses'
i18n['options'] = 'Options'
i18n['search results'] = 'Résultat de la recherche'
i18n['searching'] = 'Recherche...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='Vérification de l\'orthographe'

function i18n_tab_header(user) {
  return '<nobr>&nbsp;&nbsp;Bienvenue ' + user + '</nobr>'
}

function i18n_quota_warning(percent) {
  return 'AVERTISSEMENT : Vous utilisez actuellement ' + percent +
         '% de votre quota..'
}
function i18n_maxsize(maxsize) {
  return '(La taille maximale de la pièce jointe ne doit pas dépasser ' + maxsize +
         'Ko.)'
}
function i18n_msgQuota_warning(percent) {
  return 'AVERTISSEMENT : Vous utilisez actuellement ' + percent +
         '% de votre quota de messages.'
}

// Error Messages

i18n['fldr selfmove'] = 'Le déplacement d\'un dossier vers lui-même n\'est pas autorisé.' 
i18n['fldr noinbox'] = 'La création d\'un sous-dossier dans la boîte de réception n\'est pas autorisée.'
i18n['mbox nopermission'] = 'Vous n\'êtes pas autorisé à déplacer des messages vers ce dossier.'
i18n['mbox selfmove'] = 'Les messages ne peuvent pas être déplacés vers le dossier car ils s\'y trouvent déjà.'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']

// Message Headers
i18n['selected'] = 'Sélectionné'
i18n['seen'] = 'Consulté'
i18n['from'] = 'De'
i18n['date'] = 'Date'
i18n['recvdate'] = 'Reçu'
i18n['sentdate'] = 'Envoyé'
i18n['to'] = 'À'
i18n['cc'] = 'Cc'
i18n['bcc'] = 'Cci'
i18n['subject'] = 'Objet'
i18n['attachments'] = 'Pièces jointes'
i18n['size'] = 'Taille'
i18n['unread'] = 'non lu'
i18n['no subject'] = '[Sans objet]'
i18n['duplicates ignored'] = ' Doublons ignorés'
i18n['search invalidfolder'] = 'Dossier sélectionné non valide. Sélectionnez un dossier valide pour la recherche.'

// Tool Bars
i18n['delete'] = 'Supprimer'
i18n['undelete'] = 'Récupérer'
i18n['expunge'] = 'Purger'
i18n['rename'] = 'Renommer'
i18n['new folder'] = 'Nouveaux'
i18n['subscribe'] = 'Partager'
i18n['help'] = 'Aide'
i18n['logout'] = 'Fermer la session'
i18n['home'] = 'Privé'
i18n['attach'] = 'Joindre'
i18n['draft'] = 'Enregistrer le brouillon'
i18n['send'] = 'Envoyer'
i18n['cancel'] = 'Annuler'
i18n['compose_help']= 'Aide'
i18n['compose'] = 'Nouveau message'
i18n['search'] = 'Rechercher'
i18n['get mail'] = 'Récupérer les messages'
i18n['update'] = 'Actualiser'
i18n['forward'] = 'Transférer'
i18n['reply'] = 'Répondre'
i18n['reply all'] = 'Répondre à tous'
i18n['add sender'] = 'Ajouter l\'expéditeur'
i18n['previous'] = 'Précédent'
i18n['printable'] = 'Imprimable'
i18n['next'] = 'Suivant'
i18n['lookup'] = 'Adresse'
i18n['quote'] = 'Reprendre'
i18n['new search'] = 'Réviser'
i18n['add all addresses'] = 'Ajouter des adresses'
i18n['sharefolder toolbar'] = 'Partager'
i18n["attach_help"] = 'Aide'

// Shared Folders
i18n["share folder"] = 'Partager le dossier'
i18n["Shared Folders Title"] = 'Définir les droits du dossier'
i18n["SetPermissions Header"] = 'Dossier :'
i18n["SetPermissions AddUser"] = 'Liste d\'autorisations '
i18n["SetPermissions AddUser1"] = 'Pour partager ce dossier avec d\'autres utilisateurs, utilisez \"Rechercher\" pour les localiser.'
i18n["SetPermissions Subtitle1"] = 'Entrez un ID utilisateur, puis cliquez sur \"Ajouter\".'
i18n["SetPermissions Searchtitle"] = 'Pour trouver un utilisateur, cliquez sur \"Rechercher\".'
i18n["SetPermissions subtitle2"] = 'Définir des droits :'
i18n["SetPermissions info"] = 'Définissez ensuite les droits accordés à cet utilisateur.' 
i18n["SetPermissions read"] = 'Lecture seule'
i18n["SetPermissions readwrite"] = 'Lecture et écriture'
i18n["SetPermissions readwriteaccess"] = 'Accès en lecture, écriture et gestion'
i18n["SetPermissions User"] = 'ID utilisateur'
i18n["SetPermissions Permission"] = 'Droits'
i18n["SetPermissions Delete"] = 'Supprimer'
i18n["SetPermissions ok"] = 'OK'
i18n["SetPermissions apply"] = 'Appliquer'
i18n["SetPermissions cancel"] = 'Annuler'
i18n["SetPermissions Help"] = 'Aide'
i18n["SetPermissions Alert1"] = 'L\'utilisateur est déjà dans la liste'
i18n["SetPermissions AddButton"] = 'Ajouter'
i18n["SetPermissions SearchButton"] = 'Rechercher...'
i18n["SetPermissions Alert2"] = 'Entrez le nom de l\'utilisateur'
i18n["SetPermissions subtitle3"] = 'Sélectionnez un utilisateur dans la liste et cliquez sur Ajouter'
i18n["SetPermissions subtitle4"] = 'Rechercher des utilisateurs'
i18n["SetPermissions selfadd"] = 'Vous ne pouvez pas partager de dossier avec vous-même'
i18n["SetPermissions none"] = 'Aucun'
i18n["directdelivery"] = 'Activer l\'envoi direct des e-mails vers le dossier&nbsp;:  '
i18n["SetPermissions owneraddalert"] = 'Vous ne pouvez pas partager de dossier avec vous-même'
i18n["SetPermissions SearchResultHeader"] = 'Sélectionnez les utilisateurs dans la liste ci-dessous'
i18n["SetPermissions nopermissionslaert"] = 'Vous n\'êtes pas autorisé à définir les droits'
i18n["SetPermissions Remove"] = 'Supprimer'
i18n["SetPermissions InvalidUser"] = 'Utilisateur non valide'
i18n['SetPermissions anyone'] = 'Tout le monde'
i18n['Mail Delivery Address'] = 'Adresse de distribution du courrier'
i18n['Folders shared by '] = 'Dossiers partagés par '
i18n[ 'All Shared folders'] =  'Tous les dossiers partagés'
i18n['Initial help text'] = 'Sélectionnez les dossiers à afficher dans le menu ci-dessus.'

// Folders
i18n['fldr folders'] = 'Dossiers'
i18n['fldr personal'] = 'Dossiers personnels'
i18n['fldr shared'] = 'Dossiers partagés auxquels vous êtes inscrit'
i18n['fldr file header'] = 'Déplacer le dossier sélectionné vers'
i18n['fldr noinferiors'] = 'Sous-dossier non autorisé'
i18n['fldr delete inbox'] = 'Dossiers système&nbsp;: impossible de les supprimer'
i18n['fldr move inbox'] = 'Dossiers système : impossible de les déplacer'
i18n['fldr noselect'] = 'Impossible de modifier ce dossier.'
i18n['fldr cannotselect'] = 'Impossible de sélectionner ce dossier.'
i18n['fldr empty trash'] = 'Vider le corbeille'
i18n['fldr messages'] = 'Messages'
i18n['fldr nodelete'] = 'Impossible de renommer ce dossier.'
i18n['fldr exists']= 'Dossier existant.'
i18n['fldr select']= 'Sélectionnez un dossier.'
i18n['fldr nopermissions'] = 'Vous n\'êtes pas autorisé à créer un sous-dossier'
i18n['fldr nopermissionsdelete'] = 'Vous n\'êtes pas autorisé à supprimer un sous-dossier'
i18n['fldr unsubscribe'] = 'Impossible d\'annuler l\'inscription du dossier'
i18n['Folder Actions'] = 'Opérations sur les dossiers'

i18n['subscribe'] = 'S\'inscrire'
i18n['subscribe windowtitle'] = 'S\'inscrire aux dossiers partagés'
i18n['unsubscribe'] = 'Annuler l\'inscription'
i18n['Subscribe Header1'] = 'Les dossiers partagés sont organisés par leur propriétaire. Par conséquent, entrez ci-dessous le nom, l\'adresse e-mail'
i18n['Subscribe Header2'] = ' ou le numéro de téléphone du propriétaire et cliquez sur \"Rechercher\". Sélectionnez le(s) dossier(s) souhaité(s) et cliquez sur \"S\'inscrire\"'
i18n['No Unsubscribed Folders'] = 'Il n\'existe aucun dossier auquel s\'inscrire'
i18n['No Shared Folders'] = 'Il n\'existe aucun dossier partagé pour cet utilisateur'
i18n['subscribe select'] = 'Sélectionner'
i18n['subscribe Folder'] = 'Dossier'
i18n['subscribe owner'] = 'Propriétaire'
i18n['subscribe searchHeader'] = 'Sélectionnez l\'ID utilisateur dans la liste'
i18n['subscribe User ID'] = 'ID utilisateur'
i18n['subscribe Name'] = 'Nom'
i18n['subscribe E-Mail'] = 'Adresse e-mail'
i18n['subscribe owner Header'] = 'Du propriétaire'
i18n['subscribe search title'] = 'Sélectionner l\'ID utilisateur'
i18n['subscribe Search'] = 'Rechercher'
i18n['subscribe Result'] = 'S\'inscrire aux résultats de recherche pour '

//Rtf
i18n['FontsizeLabel'] = 'Taille'
i18n['FontnameLabel'] = 'Police'
i18n['Block Format'] = 'Paragraphe'
i18n['ViewHTMLSource'] = 'Afficher le code source HTML'
i18n['switchEditor']= 'Texte/HTML'
i18n['colorColorLabel'] = 'Couleur : '
i18n['colorOkLabel'] = ' OK '
i18n['colorCancelLabel']= ' Annuler '
i18n['emoCloseLabel'] = ' Fermer '
i18n['Smiley'] = 'Insérer une frimousse'
i18n['Cut'] = 'Couper'
i18n['Copy'] = 'Copier'
i18n['Paste'] = 'Coller'
i18n['Bold'] = 'Gras'
i18n['Italics'] = 'Italique'
i18n['Underline'] = 'Souligner'
i18n['Change foreground color'] = 'Couleur du texte'
i18n['Change Background color'] = 'Couleur d\'arrière-plan'
i18n['Left Justify'] = 'Aligner à gauche'
i18n['Center Justify'] = 'Centrer'
i18n['Right Justify'] = 'Aligner à droite'
i18n['Insert Ordered List'] = 'Liste numérotée'
i18n['Insert bullets'] = 'Liste à puce'
i18n['Outdent'] = 'Diminuer l\'alinéa '
i18n['Indent'] = 'Augmenter l\'alinéa'
i18n['Create HyperLink'] = 'Insérer un lien hypertexte'
i18n['make text left to right align'] = 'Aligner le texte de gauche à droite'
i18n['make text right to left align'] = 'Aligner le texte de droite à gauche'
i18n['all formatting will be lost'] = 'Tout le formatage sera perdu. Continuer ?'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = 'Désélectionnez "Afficher le code source HTML" pour utiliser les outils de formatage.'
i18n['Compose in'] = 'Rédiger en '
i18n['Plain Text'] = 'Texte brut'
i18n['Rich Text (HTML)']= 'Texte enrichi (HTML)'
//Attach Dialog

i18n['Attach Header'] = 'Cliquez sur Parcourir pour sélectionner un fichier, puis cliquez sur Ajouter pour le joindre au message.'
i18n['Attach Col1'] = 'Fichier joint'
i18n['Attach Col2'] = 'Taille'
i18n['Attach Remove'] = 'Supprimer'
i18n['Attach Add'] = 'Ajouter'
i18n['Attachments'] = 'Pièces jointes'
i18n['Action'] = 'Action'

//Tooltips
i18n['folder actions'] = 'Opérations sur les dossiers'
i18n['folder update'] = 'Mettre à jour les dossiers'
i18n['folder new'] = 'Nouveau dossier'
i18n['folder rename'] = 'Renommer le dossier'
i18n['folder share'] = 'Partager le dossier'
i18n['folder delete'] = 'Supprimer le dossier sélectionné'
i18n['folder subscribe'] = 'S\'inscrire au dossier partagé'
i18n['folder unsubscribe'] = 'Annuler l\'inscription au dossier'
i18n['folder owner'] = 'Propriétaire du dossier partagé'
i18n['mbox getmail'] = 'Récupérer les messages'
i18n['mbox search'] = 'Rechercher les messages'
i18n['mbox delete'] = 'Supprimer les messages sélectionnés'
i18n['mbox trash'] = 'Marquer le message sélectionné comme supprimé'
i18n['mbox actions'] = 'Opérations sur les messages'
i18n['mbox expunge'] = 'Purger'
i18n['mbox undelete'] = 'Récupérer'

i18n['seen up'] = 'Trier du haut vers le bas par type de message'
i18n['seen dn'] = 'Trier du bas vers le haut par type de message' 
i18n['recv up'] = 'Trier du haut vers le bas par date de réception '
i18n['recv dn'] = 'Trier du bas vers le haut par date de réception'
i18n['from up'] = 'Trier du haut vers le bas par expéditeur'
i18n['from dn'] = 'Trier du bas vers le haut par expéditeur'
i18n['size up'] = 'Trier du haut vers le bas par taille de message'
i18n['size dn'] = 'Trier du bas vers le haut par taille de message'
i18n['subj up'] = 'Trier du haut vers le bas par objet de message'
i18n['subj dn'] = 'Trier du bas vers le haut par objet de message'


i18n['name up'] = 'Trier du haut vers le bas par nom complet'
i18n['name dn'] = 'Trier du bas vers le haut par nom complet'
i18n['mail up'] = 'Trier du haut vers le bas par adresse e-mail'
i18n['mail dn'] = 'Trier du bas vers le haut par adresse e-mail'
i18n['attach dn'] = 'Trier du haut vers le bas par présence de pièce jointe'
i18n['attach up'] = 'Trier du bas vers le haut par présence de pièce jointe'
i18n['priority dn']  = 'Trier du haut vers le bas par priorité de message'
i18n['priority up'] = 'Trier du bas vers le haut par priorité de message'

i18n['msg compose'] = 'Rédiger un message'
i18n['msg reply'] = 'Répondre à un message'
i18n['msg replyall'] = 'Répondre à tous ceux du message'
i18n['msg forward'] = 'Transférer le message'
i18n['msg delete'] = 'Supprimer le message'
i18n['msg addall'] = 'Ajouter toutes les adresses au carnet d\'adresses'
i18n['msg prev'] = 'Message précédent'
i18n['msg next'] = 'Message suivant'
i18n['msg close'] = 'Fermer le message'
i18n['msg UnRead'] = 'État : non lu'
i18n['msg UnreadDel'] = 'État : non lu, supprimé'
i18n['msg Read'] = 'État : lu'
i18n['msg ReadDel'] = 'État : lu, supprimé'
i18n['msg ReadAns'] = 'État : lu, réponse envoyée'
i18n['msg ReadAnsDel'] = 'État : lu, réponse envoyée, supprimé'
i18n['msg Attachment'] = 'Pièce jointe'
i18n['msg FullHeader'] = 'Afficher l\'en-tête détaillé des messages'
i18n['msg NormalHeader'] = 'Afficher le résumé de l\'en-tête du message'
i18n['msg priority'] = 'Priorité'
i18n['msg high'] = 'Priorité : Élevée'
i18n['msg low'] = 'Priorité : Basse'

i18n['Previous'] = 'Précédent'
i18n['Showing'] = 'Montrant'
i18n['Messages'] = 'Messages'
i18n['Next'] = 'Suivant'
i18n['of'] = 'sur'

i18n['pab update'] = 'Mettre à jour le carnet d\'adresses personnel'
i18n['pab new'] = 'Nouveau contact'
i18n['pab group'] = 'Nouveau groupe'
i18n['pab search'] = 'Rechercher dans le carnet d\'adresses'
i18n['pab editgroup'] = 'Modifier le groupe'

function prompt_delete_folder(m, i) {

var fname = m;
for(j=0; j < fldr.length; j++)
 {
   if(fldr[j] == m)
   {
      fname = fldr[j];
      break;
   }
}

  if (i > 0)
    return 'Supprimer le dossier "' + fname + '" et ' + i + ' messages ?'
  else
    return 'Supprimer le dossier "' + fname + '"?'
}

function prompt_new_folder(m) {

var fname = m;
for(i=0; i < fldr.length; i++)
 {
   if(fldr[i] == m)
   {
      fname = fldr[i];
      break;
   }
}

  return 'Créer un dossier dans ' + fname + ' nommé :'
}

function prompt_rename_folder(f) {
  return 'Renommer le dossier "' + f + '" en :'
}

function prompt_subscribe_folder() {
  return 'S\'inscrire au dossier&nbsp;:'
}

function prompt_unsubscribe_folder(f) {
  return 'Annuler l\'inscription au dossier "' + f + '":'
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'Supprimer définitivement tous les messages dans ' + fname + '?'
}

// Mailbox
i18n['file selected msg'] = 'Déplacer les messages vers le dossier'
i18n['copy selected msg'] = 'Copier les messages dans le dossier'
i18n['select folder'] = 'Sélectionner le dossier'
i18n['mbox select all'] = 'Sélectionner tous les messages'
i18n['confirm expunge'] = 'Supprimer définitivement les messages sélectionnés&nbsp;?'
i18n['confirm expunge all'] = 'Aucun message sélectionné. Supprimer définitivement tous les messages supprimés&nbsp;?'

function i18n_mbox_date(d, now, laurel) {
  var i, s, timeformat = 12
 
  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12;

  if (d.getDate() == now.getDate() && d.getMonth() == now.getMonth() &&
    d.getYear() == now.getYear()) {
    i = d.getHours()
    if (i == 0)
      s = 12
    else if (i < 13)
      s = i
    else {
      if(timeformat == 12)
        s = i - 12;
      else
        s = i;
    }
    s += ':'
    if (d.getMinutes() <= 9)
      s += '0'
    s += d.getMinutes()
    if(timeformat == 12)
    {
      if (i < 12)
         s += ' am'
      else
         s += ' pm'
    }
  } else {
    i = d.getYear()
    if (i >= 2000)
      i -= 2000
    else if (i >= 100)
      i -= 100
    if (i < 10)
      i = '0' + i
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat'];
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimitr'] : '/';
      format = lformat ? lformat.charAt(0) : '0';
    }

    switch(format){
      case '0': case 'M':
           s = (d.getMonth() + 1) + deli + d.getDate() + deli + i;
           break;
      case '1': case 'D': 
           s = d.getDate() + deli +(d.getMonth() + 1)  + deli + i;
           break;
      case '2': case 'Y':
           s = i + deli + (d.getMonth() + 1) + deli + d.getDate();
           break;
    }
  }
  return s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + ' ne contient aucun message'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>' + total + ' Message' + (total > 1 ? 's' : '')
      if (unread == 0)
        s += ' (' + unread + ' non lu(s)) -'
      else
        s += ' (<b>' + unread + ' non lu(s)</b>) -'
      i = parseInt(used)
      s += '</nobr> <nobr>' + size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += 'aucune limite'
      else
        s += size(i) + ' limite'
      s += ')'
      s += ' -  ' + msgUsed + ' nombre total de messages ('
      if (msgLimit < 0)
        s += 'aucune limite'
      else
        s += msgLimit + ' limite'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = 'Aucune correspondance'
    else if (mboxFrame.sortid.length == 1)
      s = '1 correspondance'
    else
      s = total + ' correspondances'
    s += ' avec: '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() + ' ' +
      (val[0].length == 0 ? 'contient' : 'ne contient pas') +
//      ' "' + val[2] + '"' + ' dans ' + 
      ' "' + strflr + '"' + ' dans ' +
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'Aucun message sélectionné.\nRetirer tous les messages supprimés dans ' + fname + '?'
}

// Message
i18n['file msg'] = 'Déplacer le message vers le dossier&nbsp;:'
i18n['msg image'] = '[image]'
i18n['msg file prefix'] = 'Fichier :'
i18n['msg vcard'] = 'vCard'
i18n['msg signature'] = 'Signature numérique'
i18n['msg encrypted'] = 'Codé (décodage impossible)'
i18n['msg brief'] = 'Afficher le résumé des en-têtes de messages'
i18n['msg all'] = 'Afficher l\'en-tête détaillé des messages'

// Message Composition
i18n['fwd'] = 'Tr : '
i18n['re'] = 'Re : '
i18n['attachment pending'] = 'Pièces jointes en attente. Veuillez patienter.'
i18n['cancel message'] = 'Fermer le message et annuler les modifications ?'
i18n['recipient'] = 'Destinataires'
i18n['recipient mini help'] = 'Séparer les différents destinataires par des virgules.'
i18n['invalid addr'] = 'L\'adresse e-mail contient des caractères non valides'
i18n['no recipient'] = 'Aucun destinataire n\'a été précisé pour ce message. Cliquez sur À, Cc ou Cci pour ajouter une adresse e-mail.'
i18n['no subject confirm'] = 'Aucun objet n\'a été précisé pour ce message. Voulez-vous l\'envoyer quand même ? '
i18n['original message'] = 'Message d\'origine'
i18n['reply text'] = 'Message d\'origine'
i18n['remove'] = 'Supprimer'
i18n['reply separator'] = '----- Message d\'origine -----'
i18n['priority'] = 'Priorité'
i18n['priority n'] = 'Normale'
i18n['priority h'] = 'Élevée'
i18n['priority l'] = 'Basse'
i18n['receipt'] = 'Demander un accusé de réception'
i18n['receipt n'] = 'Aucun'
i18n['receipt d'] = 'À la remise'
i18n['receipt r'] = 'À l\'affichage'
i18n['receipt b'] = 'Les deux'
i18n['no mail'] = 'Pas d\'adresse e-mail. Impossible d\'envoyer les messages'
i18n['reply too long'] = 'Le message d\'origine est trop long pour être repris.\nIl sera intégré sous forme de pièce jointe.'
i18n['reply no text'] = 'Messenger Express ne peut pas reprendre le message d\'origine en texte brut.\nIl sera intégré sous forme de pièce jointe.'
i18n['add empty t'] = 'Envoyer ce message à&nbsp;:'
i18n['add empty c'] = 'Envoyer une copie conforme à&nbsp;:'
i18n['add empty b'] = 'Envoyer une copie conforme invisible à&nbsp;:'
i18n['sent status'] = 'Le message a bien été envoyé'

// Return receipt
i18n['receipt request'] = 'Accusé de réception demandé. Envoyer confirmation&nbsp;?'
i18n['receipt subject'] = 'Accusé de réception (affiché) - '

function i18n_receipt_text(from) {
  return 'Accusé de réception du message envoyé à \r\n' + from +
    '.\r\n\r\n' +
    'Remarque : cet accusé de réception confirme simplement que le message a été \r\n' +
    'affiché sur l\'ordinateur du destinataire. Il ne garantit pas que son\r\n' +
    'contenu a été lu ou compris.'
}

// Attachment
i18n['attach missing'] = 'Aucun fichier sélectionné'
i18n['attach empty'] = 'Fichier vide ou non valide'
i18n['attach msg canceled'] = 'Message annulé'
i18n['attach non ascii allowed'] = 'Impossible de joindre un fichier dont le nom n\'est pas en format ASCII'
i18n['attach pending'] = 'Pièce jointe en attente. Annuler pour abandonner...'
i18n['attach limited'] = 'Les pièces jointes sont limitées à '
i18n['attach maxlimit'] = 'Maximum atteint pour les pièces jointes'

function i18n_attach_msg() {
  return '<ul><li>Cliquez sur <b>Parcourir...</b> ' +
    (IE >= 3 && IE < 4 ? 'Vous devez disposer d\'un correctif de téléchargement de fichiers IE' : 'pour sélectionner un fichier.') + 
    '<li>Après avoir sélectionné un fichier, cliquez sur <b>Joindre</b>.' +
    '<li>Cette fenêtre est fermée dès que le transfert de fichier est terminé..' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = 'Récupérer'
i18n['collect long'] = 'Récupérer le courrier externe'
i18n['collect host'] = 'Serveur POP'
i18n['collect user'] = 'ID utilisateur POP'
i18n['collect pass'] = 'Mot de passe'
i18n['collect folder'] = 'Enregistrer dans le dossier'
i18n['collect delete'] = 'Supprimer les messages du serveur'
i18n['collect pending'] = 'Récupération en attente. Veuillez patienter.'
i18n['collect no host'] = 'Le serveur POP doit être indiqué.'
i18n['collect no user'] = 'L\'ID utilisateur doit être indiqué.'
i18n['collect no pass'] = 'Le mot de passe du compte doit être indiqué.'
i18n['msg nocollect'] = 'Vous n\'êtes pas autorisé à récupérer des messages dans ce dossier'

// LDAP Lookup
i18n['ldap givenname'] = 'Prénom'
i18n['ldap sn'] = 'Nom'
i18n['ldap cn'] = 'Nom'
i18n['ldap mail'] = 'Adresse e-mail'
i18n['ldap phone'] = 'Numéro de téléphone'
i18n['ldap searching'] = 'Recherche en cours. Veuillez patienter...'
i18n['close'] = 'Fermer'

// Options
i18n['account summary'] = 'Résumé du compte'
i18n['summary exp'] = 'Contactez votre administrateur système si vous avez besoin de modifier les informations suivantes.'
i18n['email addrs'] = 'Adresses e-mail'
i18n['email addrs exp'] = 'La configuration de votre compte vous autorise à recevoir des messages adressés à&nbsp;:'
i18n['quota'] = 'Quota'
i18n['quota exp'] = 'L\'administrateur système peut limiter la quantité d\'espace disponible sur le disque pour stocker les messages.'
i18n['quota limit'] = 'Le quota d\'utilisation du disque réservé à votre boîte à lettres est&nbsp;:'
i18n['no limit'] = 'Illimité'
i18n['quota usage'] = 'L\'espace actuellement occupé sur le disque est de&nbsp;:'
i18n['message quota limit'] = 'Votre quota de messages est de&nbsp;:'
i18n['message quota usage'] = 'Le nombre de messages actuel est de&nbsp;:'
i18n['password'] = 'Mot de passe'
i18n['passwd exp'] = 'Utilisez ce formulaire pour modifier le mot de passe utilisé pour accéder à Messenger Express.'
i18n['passwd old'] = '1. Entrez l\'ancien mot de passe :'
i18n['passwd new'] = '2. Entrez le nouveau mot de passe :'
i18n['passwd confirm'] = '3. Confirmez le nouveau mot de passe :'
i18n['passwd again'] = '(pour confirmation)'
i18n['passwd submit'] = 'Modifier le mot de passe'
i18n['clear'] = 'Réinitialiser'
i18n['new pass alert'] = 'Entrez un nouveau mot de passe.'
i18n['old pass alert'] = 'Entrez l\'ancien mot de passe.'
i18n['pass mismatch alert'] = 'Les deux entrées du nouveau mot de passe ne correspondent pas. Veuillez recommencer.'
i18n['pass changed'] = 'Le mot de passe a été modifié'
i18n['personal'] = 'Informations personnelles'
i18n['personal exp'] = 'Utilisez ce formulaire pour modifier vos informations personnelles.'
i18n['personal cn'] = 'Nom'
i18n['personal cn exp'] = 'Tel qu\'il apparaît sur les messages envoyés&nbsp;:'
i18n['personal lang'] = 'Langue préférée'
i18n['personal lang exp'] = 'Utiliser par défaut la langue suivante&nbsp;:'
i18n['personal lang changed'] = 'La langue préférée a été modifiée.\n\nPour que ce changement prenne effet,\nvous devez vous déconnecter, puis vous connecter à nouveau.'
i18n['personal replyto'] = 'Adresse de réponse'
i18n['personal replyto exp'] = 'Si elle est différente de '
i18n['personal vcard'] = 'vCard'
i18n['personal vcard exp'] = 'La vCard contient les informations suivantes&nbsp;:'
i18n['personal signature'] = 'Signature'
i18n['personal signature exp'] = 'Inclure ce texte dans tous les messages rédigés&nbsp;:'
i18n['delivery'] = 'Remise'
i18n['vacation'] = 'Message de notification d\'absence'
i18n['vacation exp'] = 'Utilisez ce formulaire pour définir des réponses automatiques pour les périodes pendant lesquelles vous n\'êtes pas joignable par courrier électronique.'
i18n['vacation toggle'] = 'Activer la réponse automatique.'
i18n['vacation date format exp'] = ' (mm/jj/aaaa)'
i18n['vacation date separator'] = '/'
i18n['vacation invalid date'] = 'Date non valide'
i18n['vacation invalidautoreplytimeout'] = 'Nombre de jours incorrect'
i18n['vacation start exp'] = 'Démarrer la réponse automatique le&nbsp;: '
i18n['vacation end exp'] = 'Arrêter la réponse automatique le&nbsp;: '
i18n['vacation timeout exp'] = 'Nombre de jours entre les réponses aux mêmes expéditeurs&nbsp;: '
i18n['vacation subject exp'] = 'Objet&nbsp;:'
i18n['vacation internal msg exp'] = 'Le texte suivant sera intégré au message de réponse automatique destiné aux expéditeurs en interne&nbsp;:'
i18n['vacation msg'] = 'Ceci est une réponse automatique. Je suis en congé ou je ne peux pas accéder à ma boîte à lettres. Je prendrai connaissance de votre message à mon retour.\n\nMerci.'
i18n['vacation msg exp'] = 'Le texte suivant sera intégré au message de réponse automatique destiné aux expéditeurs externes. Si aucun message de réponse automatique n\'est défini pour les expéditeurs en interne, ils recevront le même message que les expéditeurs externes.'
i18n['startgreaterend'] = 'La date de fin doit être postérieure d\'un jour au moins à la date de début.'
i18n['notBeforeToday'] = 'Indiquez une date (postérieure ou égale à la date d\'aujourd\'hui)'
i18n['mdy']='Mois, Jour, Année';
i18n['dmy']='Jour, Mois, Année';
i18n['ymd']='Année, Mois, Jour';
i18n['noReplyIfNoText']= 'Si la réponse automatique est activée, un texte de réponse doit être fourni.'
i18n['settings'] = 'Paramètres'
i18n['settings exp'] = 'Utilisez ce formulaire pour modifier le comportement de Messenger Express.'
i18n['settings delete'] = 'Suppression du courrier'
i18n['settings exit empty'] = 'Vider le dossier lors de la déconnexion'
i18n['settings delete imap'] = 'Marquer les messages comme supprimés (utilisez ' + i18n['expunge'] + ' pour les supprimer définitivement)'
i18n['settings exit expunge'] = 'Retirer les messages supprimés de la boîte de réception lors de la déconnexion'
i18n['settings draft'] = 'Brouillons de messages'
i18n['settings sent'] = 'Messages envoyés'
i18n['settings delivery'] = 'Transfert de message'
i18n['settings forward exp'] = 'Transférer les copies des nouveaux messages à (une adresse par ligne)&nbsp;:'
i18n['settings forward enable'] = 'Activer la fonction de transfert'
i18n['settings no copy'] = 'Ne laissez pas de copie sur le serveur.'
i18n['settings quote'] = 'Répondre avec historique'
i18n['settings quote exp'] = 'Reprise automatique du message d\'origine dans la réponse.'
i18n['appearance'] = 'Aspect'
i18n['appearance exp'] = 'Utilisez ce formulaire pour modifier l\'aspect de Messenger Express.'
i18n['appearance colors'] = 'Modèle de couleurs'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = 'Barre d\'outils'
i18n['appearance bar both'] = 'Afficher les icônes et le texte'
i18n['appearance bar icons'] = 'Afficher uniquement les icônes'
i18n['appearance bar text'] = 'Afficher uniquement le texte'
i18n['appearance page'] = 'Vue de la liste de messages'
i18n['appearance page exp'] = 'Afficher ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '<option value="100">100</option></select> messages par page'
i18n['appearance sort'] = 'Trier les messages ' +
  '<select name="meSortOrder"><option value="F">Le plus ancien en premier</option>' +
  '<option value="R">Le plus ancien en dernier</option></select>'
i18n['appearance date exp'] = 'Date '
i18n['appearance date format exp'] = 'Format de date '+
  '<select name="meDateFormatFormat"><option value="0">' + i18n['mdy'] + '</option>' +
  '<option value="1">' + i18n['dmy'] + '</option>' +
  '<option value="2">' + i18n['ymd'] + '</option></select>'
i18n['appearance date delimiter exp'] = 'Séparateur '
i18n['appearance fonts'] = 'Police d\'affichage'
i18n['appearance fonts face'] = 'Style'
i18n['appearance fonts space'] = 'Espacement'
i18n['serif'] = 'Serif'
i18n['sans serif'] = 'Sans Serif'
i18n['mono'] = 'Mono'
i18n['appearance fonts size'] = 'Taille'
i18n['appearance fonts xl'] = 'La plus grande'
i18n['appearance fonts l'] = 'Plus grande'
i18n['appearance fonts m'] = 'Par défaut'
i18n['appearance fonts s'] = 'Plus petite'
i18n['appearance fonts xs'] = 'La plus petite'
i18n['submit changes'] = 'Enregistrer les modifications'
i18n['not changed'] = 'Aucune option n\'a changé.'
i18n['success'] = 'La mise à jour du compte a été effectuée'
i18n['NDA'] = 'Administrateur délégué'
i18n['filters'] = 'Filtres de messages'
i18n['loadingFilters'] = 'Chargement des filtres...'
i18n['InvalidMsgSizePrompt'] = 'Entrez la taille du message.';
i18n['InvalidMobileFwdPrompt'] = 'Aucune donnée saisie ou données saisies non valides. Veuillez recommencer.';
i18n['InvalidFilterNamePrompt'] = 'Entrez un nom de filtre valide.';
i18n['DuplicateFilterPrompt'] = 'Nom du filtre en double. Indiquez un autre nom.';
i18n['InvalidSieveFormat'] = 'Format de filtre non valide Contactez votre service d\'assistance pour obtenir de l\'aide.';


function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  'n\'est pas une adresse e-mail valide')
}

// Alerts
i18n['js error'] = 'Erreur JavaScript'
i18n['line'] = 'Ligne'
i18n['login failed'] = 'Échec de la connexion'
i18n['timeout'] = 'Dépassement du délai de session. Connectez-vous à nouveau.'
i18n['FolderNameWithSpace'] = 'Un nom doit être indiqué pour le dossier'
i18n['orphanwin'] = 'Fenêtre inactive, impossible de continuer'

// Time Arrays
var months = new Array('Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin',
  'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre')
var days = new Array('Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi',
  'Vendredi', 'Samedi')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i >= 13)
    s = i - 12
  else
    s = i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  if (i < 12)
    s += ' am'
  else
    s += ' pm'
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
  return days[d.getDay()] + ', ' + months[d.getMonth()] + ' ' + d.getDate() +
    ', ' + i + ' ' + i18n_time(d)
}

function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + 'As' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">Rechercher dans le répertoire local</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    'Rechercher dans Netscape Netcenter</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'Rechercher dans Bigfoot</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    'Rechercher dans InfoSpace</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'Rechercher dans Switchboard</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    'Rechercher dans Verisign</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    'Rechercher dans WhoWhere</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'Rechercher dans Yahoo!</option>\n' +
    '</select>\n' +
    font() + 'les personnes dont' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">le nom complet</option>\n' +
    '<option value="givenname">le prénom</option>\n' +
    '<option value="sn">le nom</option>\n' +
    '<option value="mail">Adresse e-mail</option>\n' +
    '<option value="telephonenumber">le numéro de téléphone</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() +
    '<select name="rule">\n' +
    '<option value="contains">contient</option>\n' +
    //'<option value="does not">ne contient pas</option>\n' +
    '<option value="equal">est</option>\n' +
    //'<option value="not equal">n\\'est pas</option>\n' +
    '<option value="sound">ressemble à</option>\n' +
    '<option value="begin">commence par</option>\n' +
    '<option value="end">finit par</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
   return '<SELECT class="ActMenu" name=dir><option value="3 200">Rechercher dans l\'annuaire de l\'entreprise</option>\n'+
          '</SELECT>'+main.font() + '&nbsp;les utilisateurs dont'

  else if(what=='2')
   return '<SELECT  class="ActMenu" name=dir><option value="3 200">Rechercher dans l\'annuaire de l\'entreprise</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">Rechercher dans le carnet d\'adresses personnel</option>\n' : '' +
          '</select>\n' +
          main.font() + 'les contacts ou les groupes dont'
 else if(what=='3')
   return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;Sélectionner dans les dossiers&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">Tous les dossiers partagés</option>\n' : '') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">Rechercher les dossiers partagés par utilisateur</option>\n' : '') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('Go', ' Démarrer ', "parent.subscribeOptions()") + '\n'
}



function i18n_ldap_no_match(attr, rule, value) {
  return 'Aucun résultat pour les contacts dont ' + attr.toLowerCase() + ' ' +
    rule.toLowerCase() + ' <b>' + html(value) + '</b>'
}

function i18n_ldap_match(end, attr, rule, value) {
  return end + ' Résultat' + (end == 1 ? '' : 's') +
    ' pour les contacts dont ' + attr.toLowerCase() + ' ' + rule.toLowerCase() +
    ' <b>' + html(value) + '</b>'
}

function i18n_search_list() {
  var width1
 
  if(NN > 0) {
    width1 = win ? 12 : 25;
  }
  else
    width1 = 30;
 
  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() + 'Rechercher ' +
    folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' les messages où' +
    '</td>\n'+
   '<td>'+i18n['nbsp']+'</td>\n'+
   '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">Expéditeur</option>\n' +
    '<option value="SUBJECT">Objet</option>\n' +
    '<option value="BODY">le corps</option>\n' +
    '<option value="TO">Destinataire</option>\n' +
    '</select>\n' +
    '<select name="rule">\n' +
    '<option value="">contient</option>\n' +
    '<option value="NOT ">ne contient pas</option>\n' +
    '</select>\n' +
    '<input type=text name="string">\n'+
    main.nbutton('search', i18n['search'], "parent.doSearch()") + '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return 'Déplacer les messages supprimés vers ' + folder
}

function i18n_settings_draft_folder(folder) {
  return 'Conserver les brouillons des messages dans ' + folder
}

function i18n_settings_sent_folder(folder) {
  return 'Lors de l\'envoi d\'un message, placer une copie dans ' + folder
}

function i18n_settings_wrap_width() {
  return 'Couper les messages à <input size=2 name="meWrapWidth"> caractères'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    'Joindre vCard aux messages</td></tr>\n' +
    vc('Prénom', 'nf', 32) +
    vc('Nom', 'nl', 32) +
    vc('Nom complet', 'fn', 32) +
    vc('Titre', 'ti', 32) +
    vc('Société', 'or', 32) +
    vc('Département', 'od', 32) +
    vc('Adresse e-mail', 'ei', 32) +
    vc('Page d\'accueil', 'ur', 32) +
    vc('Téléphone professionnel', 'tw', 14) +
    vc('Téléphone personnel', 'th', 14) +
    vc('Télécopie', 'tf', 14) +
    vc('Messager de poche', 'tp', 14) +
    vc('Portable', 'tc', 14) +
    vc('Adresse', 'ad', 32) +
    vc('Ville', 'ci', 32) +
    vc('Département', 'st', 32) +
    vc('Code postal', 'zi', 32) +
    vc('Pays', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='Afrikaans'
i18n['ar']='Arabe'
i18n['ca']='Catalan'
i18n['zh-CN']='Chinois simplifié'
i18n['zh-TW']='Chinois traditionnel'
i18n['cs']='Tchèque'
i18n['hr']='Croate'
i18n['da']='Danois'
i18n['nl']='Néerlandais'
i18n['en']='Anglais'
i18n['fi']='Finnois'
i18n['fr']='Français'
i18n['gl']='Galicien'
i18n['de']='Allemand'
i18n['el']='Grec'
i18n['he']='Hébreu'
i18n['hu']='Hongrois'
i18n['is']='Islandais'
i18n['ga']='Irlandais'
i18n['it']='Italien'
i18n['ja']='Japonais'
i18n['ko']='Coréen'
i18n['no']='Norvégien'
i18n['pl']='Polonais'
i18n['pt']='Portugais'
i18n['ro']='Roumain'
i18n['sk']='Slovaque'
i18n['sl']='Slovène'
i18n['es']='Espagnol'
i18n['sv']='Suédois'
i18n['th']='Thaïlande'
i18n['tr']='Turc'

function i18n_preferredlanguagelist()
{   
    var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr');
    var s = '<select name="preferredLanguage">';
    for (i=0; i<lang_list.length; i++)
	s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>';
    return s+'</select>'
}

function i18n_search_options()
{

var s = '<select name="attr" size="1">' +
        '<option value="cn">le nom complet</option>' +
        '<option value="givenname">le prénom</option>' +
        '<option value="sn">le nom</option>' +
        '<option value="mail">Adresse e-mail</option>' +
        '<option value="uid">ID utilisateur</option>' +
        '<option value="telephonenumber">le numéro de téléphone</option>\n' +
        '</select>' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">contient</option>' +
        '<option value="equal">est</option>\n' +
        '<option value="begin">commence par</option>\n' +
        '<option value="sound">ressemble à</option>' +
        '<option value="end">finit par</option>' +
        '</select>'
  return s;
}
function i18n_month_list()
{
    var s=''
    for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'</option>'
    }
    return s
}

function i18n_day_list()
{
    var s=''
    for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'</option>'
    }
    return s
}
function i18n_year_list()
{
    var s=''
    var d= new Date();
    var year=d.getYear();

    for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
    }
    return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = 'Carnet d\'adresses'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'

i18n['Current Folder'] = 'Dossier actuel'
i18n['Mail'] = 'Messagerie'
i18n['Calendar'] = 'Agenda'
i18n['Options'] = 'Options'
i18n['Address Book'] = 'Carnet d adresses'
