// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='맞춤법 검사'
i18n['settings autospell exp']='메일 보내기 전에 항상 맞춤법 검사'
i18n['spellok']='확인'
i18n['AutoSpellCheck']='메일을 보내기 전에 맞춤법 검사'
i18n['spell error']='서버 오류: 맞춤법 검사를 할 수 없음'
i18n['spelldicterror']='서버 오류: 언어 사전을 사용할 수 없음'
i18n['select  comp lang']='언어 선택'
i18n['spelldict']='사전'
i18n['spell change'] = '&nbsp;&nbsp;변경&nbsp;&nbsp;&nbsp;'
i18n['spell changeall'] = '모두 변경'
i18n['spell ignoreall'] = '&nbsp;모두 무시&nbsp;'
i18n['spell_progress']='잠시 기다리십시오. 맞춤법 검사기가 곧 실행됩니다.'
i18n['send_progress']='보내는 중';
i18n['spell_no_mistakes']=" 철자가 틀린 단어 없음";
i18n['spell_select_lang']="언어를 선택하십시오.";
i18n['spell_nothing']='검사할 항목 없음';
i18n['send_anyway']= '맞춤법 검사기에서 인식할 수 없는 단어가 메일에 포함되어 있습니다. 그래도 보내시겠습니까?'
i18n['done_anyway']= '맞춤법 검사기에서 인식할 수 없는 단어가 메일에 아직도 포함되어 있습니다.'
i18n['spell_window_title']='맞춤법 검사'
i18n['spell yes']="예"
i18n['spell no']="아니요"
i18n['spelltool done']="완료"
i18n['spelltool help']=" 도움말 "
i18n['No Suggestions']='추천 단어 없음'
i18n['Suggestions']='추천 단어'

//SMIME
i18n['smime not available']='SMIME 구성이 완전하지 않거나 애플릿이 로드되지 않음'
i18n['smime recipients failure']='수신자를 추가하는 중 오류 발생:'
i18n['Signed Message']='서명된 메일'
i18n['Invalid Signature']='잘못된 서명'
i18n['Invalid Encryption']='잘못된 암호화'
i18n['Encrypted Message']='암호화된 메일'
i18n['url_error']="URL을 추가하는 중 오류 발생"

// Compose window toolbar
i18n['compose_send']='메일 보내기'
i18n['compose_attach']='메일에 파일 첨부'
i18n['compose_spell']='맞춤법 검사'
i18n['compose_editor']='스위치 편집기(일반 텍스트 또는 HTML)'




// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = '로드 중: 잠시 기다리십시오...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = '선택'
i18n['Select All']= '모두 선택'
i18n['Deselect All']= '모두 선택 취소'
i18n['no msg'] = '이 폴더에는 메일이 없습니다.'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = '받은 메일함'
fldr['Trash'] = '휴지통'
fldr['Drafts'] = '임시 보관함'
fldr['Sent'] = '보낸 메일함'
fldr['Sent Items'] = '보낸 항목'

// Window titles
i18n['app title'] = '메일 - Communications Express'
i18n['sjs app title'] = 'Sun Java&#153; System Messenger Express'
i18n['attach title'] = '파일 첨부'
i18n['collect title'] = '외부 메일 수집'
i18n['compose title'] = '새 메일'
i18n['lookup title'] = 'LDAP 조회'
i18n['receipt title'] = '수신 확인 보내기'
i18n['editgroup title'] = '그룹 업데이트'
i18n['editentry title'] = '연락처 업데이트'
i18n['newgroup title'] = '새 그룹'
i18n['newentry title'] = '새 연락처'
i18n['comprecipient title'] = '개인 주소록에서 수신자 선택'

// Tabs
i18n['folders'] = '메일함 관리'
i18n['message'] = '메일'
i18n['pab'] = '주소록'
i18n['options'] = '환경 설정'
i18n['search results'] = '검색 결과'
i18n['searching'] = '검색 중 ...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='맞춤법 검사'

function i18n_tab_header(user) {
  return '<nobr>&nbsp;&nbsp;' + user + '님 환영합니다.</nobr>'
}

function i18n_quota_warning(percent) {
  return '경고: 할당량의 ' + percent +
         '%가 현재 작동 중입니다.'
}
function i18n_maxsize(maxsize) {
  return '(첨부 파일의 최대 크기가 ' + maxsize +
         'kb를 초과해서는 안됩니다.)'
}
function i18n_msgQuota_warning(percent) {
  return '경고: 메일 할당량의 ' + percent +
         '%가 현재 작동 중입니다.'
}

// Error Messages

i18n['fldr selfmove'] = '폴더를 동일 폴더로 이동할 수 없습니다.' 
i18n['fldr noinbox'] = '받은 메일함에 하위 폴더를 만들 수 없습니다.'
i18n['mbox nopermission'] = '이 폴더로 메일을 이동할 권한이 없습니다.'
i18n['mbox selfmove'] = '메일이 있는 폴더로 동일 메일을 이동할 수 없습니다.'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']

// Message Headers
i18n['selected'] = '선택됨'
i18n['seen'] = '읽음'
i18n['from'] = '보낸 사람'
i18n['date'] = '날짜'
i18n['recvdate'] = '받은 날짜'
i18n['sentdate'] = '보낸 날짜'
i18n['to'] = '받는 사람'
i18n['cc'] = '참조'
i18n['bcc'] = '숨은 참조'
i18n['subject'] = '제목'
i18n['attachments'] = '첨부 파일'
i18n['size'] = '크기'
i18n['unread'] = '읽지 않음'
i18n['no subject'] = '[ 제목 없음 ]'
i18n['duplicates ignored'] = ' 중복 무시'
i18n['search invalidfolder'] = '잘못된 폴더를 선택했습니다. 검색할 올바른 폴더를 선택하십시오.'

// Tool Bars
i18n['delete'] = '삭제'
i18n['undelete'] = '삭제 취소'
i18n['expunge'] = '영구 삭제'
i18n['rename'] = '이름 바꾸기'
i18n['new folder'] = '새로 만들기'
i18n['subscribe'] = '공유'
i18n['help'] = '도움말'
i18n['logout'] = '로그아웃'
i18n['home'] = '홈'
i18n['attach'] = '첨부'
i18n['draft'] = '임시 보관함에 저장'
i18n['send'] = '보내기'
i18n['cancel'] = '취소'
i18n['compose_help']= '도움말'
i18n['compose'] = '새 메일'
i18n['search'] = '검색'
i18n['get mail'] = '메일 받기'
i18n['update'] = '갱신'
i18n['forward'] = '전송'
i18n['reply'] = '회신'
i18n['reply all'] = '모두 회신'
i18n['add sender'] = '보낸 사람 추가'
i18n['previous'] = '이전'
i18n['printable'] = '인쇄 가능'
i18n['next'] = '다음'
i18n['lookup'] = '주소'
i18n['quote'] = '할당량'
i18n['new search'] = '수정'
i18n['add all addresses'] = '주소 추가'
i18n['sharefolder toolbar'] = '공유'
i18n["attach_help"] = '도움말'

// Shared Folders
i18n["share folder"] = '공유 폴더'
i18n["Shared Folders Title"] = '폴더 사용 권한 설정'
i18n["SetPermissions Header"] = '폴더 :'
i18n["SetPermissions AddUser"] = '사용 권한 목록 '
i18n["SetPermissions AddUser1"] = '이 폴더를 다른 사용자와 공유하려면 \"검색\"을 사용하여 사용자를 찾으십시오.'
i18n["SetPermissions Subtitle1"] = '사용자 아이디를 입력하고 \"추가\"를 누르십시오.'
i18n["SetPermissions Searchtitle"] = '사용자를 검색하려면 \"검색\"을 누르십시오.'
i18n["SetPermissions subtitle2"] = '사용 권한 설정:'
i18n["SetPermissions info"] = '그런 다음 해당 사용자에 대한 권한을 설정하십시오.' 
i18n["SetPermissions read"] = '읽기 전용'
i18n["SetPermissions readwrite"] = '읽기 및 쓰기'
i18n["SetPermissions readwriteaccess"] = '읽기, 쓰기 및 액세스 관리'
i18n["SetPermissions User"] = '사용자 아이디'
i18n["SetPermissions Permission"] = '권한'
i18n["SetPermissions Delete"] = '제거'
i18n["SetPermissions ok"] = '확인'
i18n["SetPermissions apply"] = '적용'
i18n["SetPermissions cancel"] = '취소'
i18n["SetPermissions Help"] = '도움말'
i18n["SetPermissions Alert1"] = '사용자가 이미 목록에 있습니다.'
i18n["SetPermissions AddButton"] = '추가'
i18n["SetPermissions SearchButton"] = '검색...'
i18n["SetPermissions Alert2"] = '아이디를 입력하십시오.'
i18n["SetPermissions subtitle3"] = '목록에서 사용자 한 명을 선택하고 추가를 누르십시오.'
i18n["SetPermissions subtitle4"] = '사용자 검색'
i18n["SetPermissions selfadd"] = '사용자 자신과 폴더를 공유할 수 없습니다.'
i18n["SetPermissions none"] = '없음'
i18n["directdelivery"] = '메일을 폴더로 직접 전달 가능:  '
i18n["SetPermissions owneraddalert"] = '사용자 자신과 폴더를 공유할 수 없습니다.'
i18n["SetPermissions SearchResultHeader"] = '다음 목록에서 사용자를 선택하십시오.'
i18n["SetPermissions nopermissionslaert"] = '사용 권한을 설정할 권한이 없습니다.'
i18n["SetPermissions Remove"] = '제거'
i18n["SetPermissions InvalidUser"] = '잘못된 사용자'
i18n['SetPermissions anyone'] = '모두'
i18n['Mail Delivery Address'] = '메일 전달 주소'
i18n['Folders shared by '] = '공유된 폴더 '
i18n[ 'All Shared folders'] =  '모든 공유 폴더'
i18n['Initial help text'] = '위 메뉴에서 볼 폴더를 선택하십시오.'

// Folders
i18n['fldr folders'] = '폴더'
i18n['fldr personal'] = '개인 폴더'
i18n['fldr shared'] = '가입 된 공유 폴더'
i18n['fldr file header'] = '다음으로 선택한 폴더 이동'
i18n['fldr noinferiors'] = '하위 폴더를 만들 수 없습니다.'
i18n['fldr delete inbox'] = '시스템 폴더 - 삭제할 수 없습니다.'
i18n['fldr move inbox'] = '시스템 폴더 - 이동할 수 없습니다.'
i18n['fldr noselect'] = '이 폴더는 수정할 수 없습니다.'
i18n['fldr cannotselect'] = '이 폴더는 선택할 수 없습니다.'
i18n['fldr empty trash'] = '휴지통 비우기'
i18n['fldr messages'] = '메일'
i18n['fldr nodelete'] = '이 폴더의 이름을 바꿀 수 없습니다.'
i18n['fldr exists']= '이미 존재하는 폴더입니다.'
i18n['fldr select']= '폴더를 선택하십시오.'
i18n['fldr nopermissions'] = '하위 폴더를 만들 권한이 없습니다.'
i18n['fldr nopermissionsdelete'] = '하위 폴더를 삭제할 권한이 없습니다.'
i18n['fldr unsubscribe'] = '폴더 가입을 취소할 수 없습니다.'
i18n['Folder Actions'] = '폴더 작업'

i18n['subscribe'] = '가입'
i18n['subscribe windowtitle'] = '공유 폴더에 가입'
i18n['unsubscribe'] = '가입 취소'
i18n['Subscribe Header1'] = '공유 폴더는 해당 소유자가 구성합니다. 따라서 소유자의 이름, 메일 주소,'
i18n['Subscribe Header2'] = ' 또는 전화 번호를 아래에 입력하고 \"검색\"을 누르십시오. 원하는 폴더를 선택하고 \"가입\"을 누르십시오."'
i18n['No Unsubscribed Folders'] = '가입할 공유 폴더가 없습니다.'
i18n['No Shared Folders'] = '공유 폴더가 없습니다.'
i18n['subscribe select'] = '선택'
i18n['subscribe Folder'] = '폴더'
i18n['subscribe owner'] = '소유자'
i18n['subscribe searchHeader'] = '목록에서 사용자 아이디를 선택하십시오.'
i18n['subscribe User ID'] = '사용자 아이디'
i18n['subscribe Name'] = '이름'
i18n['subscribe E-Mail'] = '메일'
i18n['subscribe owner Header'] = '소유자의'
i18n['subscribe search title'] = '사용자 아이디 선택'
i18n['subscribe Search'] = '검색'
i18n['subscribe Result'] = '검색 결과 가입'

//Rtf
i18n['FontsizeLabel'] = '크기'
i18n['FontnameLabel'] = '글꼴'
i18n['Block Format'] = '단락'
i18n['ViewHTMLSource'] = 'HTML 소스 보기'
i18n['switchEditor']= '텍스트/HTML'
i18n['colorColorLabel'] = '색 : '
i18n['colorOkLabel'] = ' 확인 '
i18n['colorCancelLabel']= ' 취소 '
i18n['emoCloseLabel'] = ' 닫기 '
i18n['Smiley'] = '이모티콘 삽입'
i18n['Cut'] = '잘라내기'
i18n['Copy'] = '복사'
i18n['Paste'] = '붙여넣기'
i18n['Bold'] = '굵은체'
i18n['Italics'] = '기울임꼴'
i18n['Underline'] = '밑줄'
i18n['Change foreground color'] = '텍스트 색'
i18n['Change Background color'] = '배경색'
i18n['Left Justify'] = '왼쪽 정렬'
i18n['Center Justify'] = '가운데 정렬'
i18n['Right Justify'] = '오른쪽 정렬'
i18n['Insert Ordered List'] = '번호 목록'
i18n['Insert bullets'] = '글머리표 목록'
i18n['Outdent'] = '들여쓰기 감소 '
i18n['Indent'] = '들여쓰기 증가'
i18n['Create HyperLink'] = '하이퍼링크 삽입'
i18n['make text left to right align'] = '왼쪽에서 오른쪽으로 텍스트 정렬'
i18n['make text right to left align'] = '오른쪽에서 왼쪽으로 텍스트 정렬'
i18n['all formatting will be lost'] = '지정한 서식이 모두 손실되었습니다. 계속하시겠습니까?'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = '서식 도구를 사용하려면 "HTML 소스 보기" 선택을 취소하십시오.'
i18n['Compose in'] = '작성: '
i18n['Plain Text'] = '일반 텍스트'
i18n['Rich Text (HTML)']= '서식있는 텍스트(HTML)'
//Attach Dialog

i18n['Attach Header'] = '첨부할 파일을 선택하려면 찾아보기를 누른 다음 추가를 눌러 이 메일에 파일을 첨부하십시오.'
i18n['Attach Col1'] = '파일 첨부'
i18n['Attach Col2'] = '크기'
i18n['Attach Remove'] = '제거'
i18n['Attach Add'] = '추가'
i18n['Attachments'] = '첨부'
i18n['Action'] = '작업'

//Tooltips
i18n['folder actions'] = '폴더 작업'
i18n['folder update'] = '폴더 업데이트'
i18n['folder new'] = '새 폴더'
i18n['folder rename'] = '폴더 이름 바꾸기'
i18n['folder share'] = '공유 폴더'
i18n['folder delete'] = '선택된 폴더 삭제'
i18n['folder subscribe'] = '공유 폴더에 가입'
i18n['folder unsubscribe'] = '폴더 가입 취소'
i18n['folder owner'] = '공유 폴더의 소유자'
i18n['mbox getmail'] = '메일 받기'
i18n['mbox search'] = '메일 검색'
i18n['mbox delete'] = '선택된 메일 삭제'
i18n['mbox trash'] = '선택된 메일을 삭제된 것으로 표시'
i18n['mbox actions'] = '메일 작업'
i18n['mbox expunge'] = '영구 삭제'
i18n['mbox undelete'] = '삭제 취소'

i18n['seen up'] = '메일 유형별로 내림차순 정렬'
i18n['seen dn'] = '메일 유형별로 오름차순 정렬' 
i18n['recv up'] = '받은 날짜별로 내림차순 정렬'
i18n['recv dn'] = '받은 날짜별로 오름차순 정렬'
i18n['from up'] = '메일 보낸 사람별로 내림차순 정렬'
i18n['from dn'] = '메일 보낸 사람별로 오름차순 정렬'
i18n['size up'] = '메일 크기별로 내림차순 정렬'
i18n['size dn'] = '메일 크기별로 오름차순 정렬'
i18n['subj up'] = '메일 제목별로 내림차순 정렬'
i18n['subj dn'] = '메일 제목별로 오름차순 정렬'


i18n['name up'] = '디스플레이 이름별로 내림차순 정렬'
i18n['name dn'] = '디스플레이 이름별로 오름차순 정렬'
i18n['mail up'] = '메일 주소별로 내림차순 정렬'
i18n['mail dn'] = '메일 주소별로 오름차순 정렬'
i18n['attach dn'] = '첨부 여부에 따라 오름차순 정렬'
i18n['attach up'] = '첨부 여부에 따라 내림차순 정렬'
i18n['priority dn']  = '메일 우선 순위별로 오름차순 정렬'
i18n['priority up'] = '메일 우선 순위별로 내림차순 정렬'

i18n['msg compose'] = '메일 작성'
i18n['msg reply'] = '메일 회신'
i18n['msg replyall'] = '메일 전체 회신'
i18n['msg forward'] = '메일 전송'
i18n['msg delete'] = '메일 삭제'
i18n['msg addall'] = '주소록에 모든 주소 추가'
i18n['msg prev'] = '이전 메일'
i18n['msg next'] = '다음 메일'
i18n['msg close'] = '메일 닫기'
i18n['msg UnRead'] = '상태: 읽지 않음'
i18n['msg UnreadDel'] = '상태: 읽지 않음, 삭제됨'
i18n['msg Read'] = '상태: 읽음'
i18n['msg ReadDel'] = '상태: 읽음, 삭제됨'
i18n['msg ReadAns'] = '상태: 읽음, 회신함'
i18n['msg ReadAnsDel'] = '상태: 읽음, 회신함, 삭제됨'
i18n['msg Attachment'] = '첨부'
i18n['msg FullHeader'] = '메일 헤더 세부 정보 보기'
i18n['msg NormalHeader'] = '간단한 메일 헤더 보기'
i18n['msg priority'] = '우선 순위'
i18n['msg high'] = '우선 순위: 높음'
i18n['msg low'] = '우선 순위: 낮음'

i18n['Previous'] = '이전'
i18n['Showing'] = '표시'
i18n['Messages'] = '메시지'
i18n['Next'] = '다음'
i18n['of'] = '/'

i18n['pab update'] = '주소록 업데이트'
i18n['pab new'] = '새 연락처'
i18n['pab group'] = '새 그룹'
i18n['pab search'] = '주소록 검색'
i18n['pab editgroup'] = '그룹 편집'

function prompt_delete_folder(m, i) {

var fname = m;
for(j=0; j < fldr.length; j++)
 {
   if(fldr[j] == m)
   {
      fname = fldr[j];
      break;
   }
}

  if (i > 0)
    return '폴더 "' + fname + '" 및 ' + i + ' 메일을 삭제하시겠습니까?'
  else
    return '"' + fname + '" 폴더를 삭제하시겠습니까?'
}

function prompt_new_folder(m) {

var fname = m;
for(i=0; i < fldr.length; i++)
 {
   if(fldr[i] == m)
   {
      fname = fldr[i];
      break;
   }
}

  return '새 폴더 이름을 입력하세요:' 
}

function prompt_rename_folder(f) {
  return '폴더 "' + f + '"을(를) 대체할 새 폴더 이름을 입력하세요:'
}

function prompt_subscribe_folder() {
  return '다음 폴더에 가입:'
}

function prompt_unsubscribe_folder(f) {
  return '"' + f + '" 폴더에 가입 취소하시겠습니까?'
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return '' + fname + '에서 모든 메일을 영구 삭제하시겠습니까?'
}

// Mailbox
i18n['file selected msg'] = '메일을 폴더로 이동'
i18n['copy selected msg'] = '다음 폴더로 메일 복사'
i18n['select folder'] = '폴더 선택'
i18n['mbox select all'] = '모든 메일 선택'
i18n['confirm expunge'] = '선택된 메일을 영구 제거하시겠습니까?'
i18n['confirm expunge all'] = '선택된 메일이 없습니다. 삭제된 메일을 모두 영구 제거하시겠습니까?'

function i18n_mbox_date(d, now, laurel) {
  var i, s, timeformat = 12

  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12;

  if (d.getDate() == now.getDate() && d.getMonth() == now.getMonth() &&
    d.getYear() == now.getYear()) {
    i = d.getHours()
    if(timeformat == 12)
    {
    if (i < 12)
      s = '오전 '
    else
      s = '오후 '
    }
    if (i == 0)
      s += 12
    else if (i < 13)
      s += i
    else {
      if(timeformat == 12)
        s += i - 12;
      else
        s += i;
    }
    s += ':'
    if (d.getMinutes() <= 9)
      s += '0'
    s += d.getMinutes()
  } else {
    i = d.getYear()
    if (i >= 2000)
      i -= 2000
    else if (i >= 100)
      i -= 100
    if (i < 10)
      i = '0' + i
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat'];
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimiter'] : '/';
      format = lformat ? lformat.charAt(0) : '0';
    }

    switch(format){
      case '0': case 'M':
           s = (d.getMonth() + 1) + deli + d.getDate() + deli + i;
           break;
      case '1': case 'D':
           s = d.getDate() + deli +(d.getMonth() + 1)  + deli + i;
           break;
      case '2': case 'Y':
           s = i + deli + (d.getMonth() + 1) + deli + d.getDate();
           break;
    }
  }
  return s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + ' 에 메일이 없습니다.'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>읽은 메일: ' + total
      if (unread == 0)
        s += ' (읽지 않은 메일: ' + unread + ') -'
      else
        s += ' (<b>읽지 않은 메일: ' + unread + '</b>) -'
      i = parseInt(used)
      s += '</nobr> <nobr>' + size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += '제한 없음'
      else
        s += size(i) + ' 제한'
      s += ')'
      s += ' - 전체 메일: ' + msgUsed + ' ('
      if (msgLimit < 0)
        s += '제한 없음'
      else
        s += msgLimit + ' 제한'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = '일치하는 메일 이  없습니다'
    else if (mboxFrame.sortid.length == 1)
      s = '1개 메일 이 일치합니다'
    else
      s = '' + total + ' 개 가 일치합니다'
    s += ' - '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() +
      ' "' + strflr + '"' + ' 을(를) ' +
      (val[0].length == 0 ? '포함' : '포함 안 됨') + ' - ' +
//      ' "' + val[2] + '"' + ' in ' + 
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return '선택된 메일이 없습니다.\n ' + fname + '에서 삭제된 메일을 모두 제거하시겠습니까?'
}

// Message
i18n['file msg'] = '다음 폴더로 메일 이동:'
i18n['msg image'] = '[ 이미지 ]'
i18n['msg file prefix'] = '파일:'
i18n['msg vcard'] = '명함'
i18n['msg signature'] = '디지털 서명'
i18n['msg encrypted'] = '암호화됨(암호를 해독할 수 없음)'
i18n['msg brief'] = '간단한 메일 헤더 보기'
i18n['msg all'] = '메일 헤더 세부 정보 보기'

// Message Composition
i18n['fwd'] = '전송: '
i18n['re'] = '회신: '
i18n['attachment pending'] = '첨부가 보류 중입니다. 잠시 기다리십시오.'
i18n['cancel message'] = '메일을 닫고 변경 내용을 취소하시겠습니까?'
i18n['recipient'] = '수신자'
i18n['recipient mini help'] = '쉼표를 사용하여 여러 수신자를 구분합니다.'
i18n['invalid addr'] = '메일 주소에 잘못된 문자가 포함되어 있습니다.'
i18n['no recipient'] = '이 메일에는 나열된 수신자가 없습니다. 받는 사람, 참조 또는 숨은 참조를 눌러 메일 주소를 추가하십시오.'
i18n['no subject confirm'] = '이 메일에는 제목이 없습니다. 그래도 보내시겠습니까? '
i18n['original message'] = '원본 메일'
i18n['reply text'] = '원본 메일'
i18n['remove'] = '제거'
i18n['reply separator'] = '----- 원본 메일 -----'
i18n['priority'] = '우선 순위'
i18n['priority n'] = '중간'
i18n['priority h'] = '높음'
i18n['priority l'] = '낮음'
i18n['receipt'] = '수신 확인 요청'
i18n['receipt n'] = '없음'
i18n['receipt d'] = '전달될 때'
i18n['receipt r'] = '확인될 때'
i18n['receipt b'] = '모두'
i18n['no mail'] = '메일 주소가 없습니다. 메일을 보낼 수 없습니다.'
i18n['reply too long'] = '원본 메일이 너무 길어 인용할 수 없습니다.\n첨부 파일로 포함됩니다.'
i18n['reply no text'] = 'Messenger Express에서 일반 텍스트로 원본 메일을 인용할 수 없습니다.\n첨부 파일로 포함됩니다.'
i18n['add empty t'] = '이 메일을 받는 사람:'
i18n['add empty c'] = '이 메일의 복사본을 받는 사람:'
i18n['add empty b'] = '이 메일의 익명 복사본을 받는 사람:'
i18n['sent status'] = '메일을 성공적으로 보냈습니다.'

// Return receipt
i18n['receipt request'] = '수신 확인을 요청했습니다. 긍정 응답을 보내시겠습니까?'
i18n['receipt subject'] = '수신 확인(표시됨) - '

function i18n_receipt_text(from) {
  return '다음은 사용자가가 보낸 메일에 대한 수신 확인입니다.\r\n' + from +
    '.\r\n\r\n' +
    '주: 이 반송 확인은 메일이 \r\n' +
    '수신자의 시스템에 표시되었다는 것만 나타냅니다.\r\n' +
    '메일 내용을 읽거나 이해했다는 것을 보장하지는 않습니다.'
}

// Attachment
i18n['attach missing'] = '선택된 파일이 없습니다.'
i18n['attach empty'] = '비어 있거나 잘못된 파일'
i18n['attach msg canceled'] = '취소된 메일'
i18n['attach non ascii allowed'] = '파일 이름이 ASCII가 아닌 경우 파일을 첨부할 수 없습니다.'
i18n['attach pending'] = '첨부 보류 중입니다. 중단하려면 취소하십시오...'
i18n['attach limited'] = '첨부 파일이 제한되어 있습니다.'
i18n['attach maxlimit'] = '최대 첨부 파일 크기에 도달했습니다.'

function i18n_attach_msg() {
  return '<ul><li><b>찾아보기...</b>를 누르십시오.' +
    (IE >= 3 && IE < 4 ? '파일을 선택하려면' : 'IE 파일 업로드 패치가 있어야 합니다.') + 
    '<li>파일을 선택한 다음 <b>첨부</b>를 누르십시오.' +
    '<li>파일 전송이 완료되면 이 창이 닫힙니다.' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = '수집'
i18n['collect long'] = '외부 메일 수집'
i18n['collect host'] = 'POP 서버'
i18n['collect user'] = 'POP 사용자 아이디'
i18n['collect pass'] = '비밀번호'
i18n['collect folder'] = '폴더에 저장'
i18n['collect delete'] = '서버에서 메일 삭제'
i18n['collect pending'] = '수집 보류 중입니다. 잠시 기다리십시오.'
i18n['collect no host'] = 'POP 서버를 지정해야 합니다.'
i18n['collect no user'] = '사용자 아이디를 지정해야 합니다.'
i18n['collect no pass'] = '계정 비밀번호를 지정해야 합니다.'
i18n['msg nocollect'] = '이 폴더에 메일을 수집할 권한이 없습니다.'

// LDAP Lookup
i18n['ldap givenname'] = '이름'
i18n['ldap sn'] = '성'
i18n['ldap cn'] = '이름'
i18n['ldap mail'] = '메일'
i18n['ldap phone'] = '전화 번호'
i18n['ldap searching'] = '검색 중입니다. 잠시 기다리십시오.'
i18n['close'] = '닫기'

// Options
i18n['account summary'] = '계정 요약'
i18n['summary exp'] = '다음 정보 중 일부를 수정하려면 시스템 관리자에게 문의하십시오.'
i18n['email addrs'] = '메일 주소'
i18n['email addrs exp'] = '계정 구성을 사용하면 다음으로 주소가 지정된 메일을 받을 수 있습니다.'
i18n['quota'] = '할당량'
i18n['quota exp'] = '시스템 관리자는 메일 저장소로 사용 가능한 디스크 공간을 제한할 수 있습니다.'
i18n['quota limit'] = '메일함 디스크 할당량:'
i18n['no limit'] = '제한 없음'
i18n['quota usage'] = '현재 디스크 소모:'
i18n['message quota limit'] = '메일 할당량:'
i18n['message quota usage'] = '현재 메일 개수:'
i18n['password'] = '비밀번호'
i18n['passwd exp'] = '이 형식을 사용하여 Messenger Express에 액세스하는 데 사용하는 비밀번호를 변경하십시오.'
i18n['passwd old'] = '1. 현재 비밀번호 입력:'
i18n['passwd new'] = '2. 새 비밀번호 입력:'
i18n['passwd confirm'] = '3. 새 비밀번호 확인:'
i18n['passwd again'] = '(확인)'
i18n['passwd submit'] = '비밀번호 변경'
i18n['clear'] = '재설정'
i18n['new pass alert'] = '새 비밀번호를 입력하십시오.'
i18n['old pass alert'] = '현재 비밀번호를 입력하십시오.'
i18n['pass mismatch alert'] = '새 비밀번호를 입력한 두 항목이 일치하지 않습니다. 다시 입력하십시오.'
i18n['pass changed'] = '성공적으로 비밀번호를 변경했습니다.'
i18n['personal'] = '개인 정보'
i18n['personal exp'] = '이 형식을 사용하여 개인 정보를 변경하십시오.'
i18n['personal cn'] = '이름'
i18n['personal cn exp'] = '보내는 메일에 표시되는 대로:'
i18n['personal lang'] = '기본 언어'
i18n['personal lang exp'] = '다음 기본 언어 사용:'
i18n['personal lang changed'] = '기본 언어가 변경되었습니다.\n\n이 변경 내용을 적용하려면\n로그아웃한 다음 다시 로그인해야 합니다.'
i18n['personal replyto'] = '회신 주소'
i18n['personal replyto exp'] = '다음과 다른 경우 '
i18n['personal vcard'] = '개인 명함'
i18n['personal vcard exp'] = '개인 명함에는 다음 정보가 포함됨:'
i18n['personal signature'] = '서명'
i18n['personal signature exp'] = '작성하는 각 메일에 다음 텍스트 포함:'
i18n['delivery'] = '전달'
i18n['vacation'] = '휴가 메일'
i18n['vacation exp'] = '메일을 읽을 수 없는 기간 동안 이 형식을 사용하여 자동 회신을 설정하십시오.'
i18n['vacation toggle'] = '자동 휴가 회신을 사용할 수 있습니다.'
i18n['vacation date format exp'] = ' (mm/dd/yyyy)'
i18n['vacation date separator'] = '/'
i18n['vacation date day error'] = '잘못된 일'
i18n['vacation invalidautoreplytimeout'] = '잘못된 일 수'
i18n['vacation start exp'] = '휴가 알림 시작: '
i18n['vacation end exp'] = '휴가 알림 중지: '
i18n['vacation timeout exp'] = '보낸 사람에게 반복적으로 회신을 보내는 일 수: '
i18n['vacation subject exp'] = '제목:'
i18n['vacation internal msg exp'] = '내부의 보낸 사람들에게 전송하는 휴가 메일에 포함시킬 텍스트:'
i18n['vacation msg'] = '본 메일은 자동 회신되는 메일입니다. 제가 휴가 중이거나 메일을 읽을 수 없는 상태입니다. 돌아오는 즉시 귀하의 메일을 읽겠습니다.\n\n감사합니다.'
i18n['vacation msg exp'] = '외부의 보낸 사람들에게 전송하는 휴가 메일에 포함시킬 텍스트입니다. 내부의 보낸 사람들에게 지정된 휴가 메일이 없는 경우 같은 휴가 메일 텍스트가 내부의 보낸 사람들에게 전송될 것입니다.'
i18n['startgreaterend'] = '시작 날짜가 끝 날짜 이후입니다.'
i18n['notBeforeToday'] = '날짜를 입력하십시오.(///오늘 이후의 날짜 입력 가능///)'
i18n['mdy']='월,일,연';
i18n['dmy']='일,월,연';
i18n['ymd']='연,월,일';
i18n['noReplyIfNoText']= '휴가가 사용 가능한 경우 휴가 회신 텍스트를 비워두면 안됩니다.'
i18n['settings'] = '설정'
i18n['settings exp'] = '이 형식을 사용하여 Messenger Express의 동작을 수정하십시오.'
i18n['settings delete'] = '메일 삭제'
i18n['settings exit empty'] = '로그아웃 시 폴더 비우기'
i18n['settings delete imap'] = '메일을 삭제된 것으로 표시 (영구 삭제하려면 ' + i18n['expunge'] + ' 를사용)'
i18n['settings exit expunge'] = '로그아웃 시 받은 메일함에서 삭제된 메일 제거'
i18n['settings draft'] = '임시 저장된 메일 '
i18n['settings sent'] = '보낸 메일'
i18n['settings delivery'] = '메일 전달'
i18n['settings forward exp'] = '다음으로 새 메일의 복사본을 전달(줄당 하나의 주소):'
i18n['settings forward enable'] = '전달 가능'
i18n['settings no copy'] = '서버에 복사본을 두지 마십시오.'
i18n['settings quote'] = '회신 인용'
i18n['settings quote exp'] = '회신할 때 원본 메일을 자동으로 인용합니다.'
i18n['appearance'] = '모양'
i18n['appearance exp'] = '이 형식을 사용하여 Messenger Express의 모양을 수정합니다.'
i18n['appearance colors'] = '색 구성표'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = '도구 모음'
i18n['appearance bar both'] = '아이콘 및 텍스트 표시'
i18n['appearance bar icons'] = '아이콘만 표시'
i18n['appearance bar text'] = '텍스트만 표시'
i18n['appearance page'] = '메일 목록 표시'
i18n['appearance page exp'] = '표시 ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '페이지당 <option value="100">100</option></select>개 메일'
i18n['appearance sort'] = '메일 정렬 ' +
  '<select name="meSortOrder"><option value="F">오름차순</option>' +
  '<option value="R">내림차순</option></select>'
i18n['appearance date exp'] = '날짜 '
i18n['appearance date format exp'] = '날짜 형식 '+
  '<select name="meDateFormatFormat"><option value="0">' + i18n['mdy'] + '</option>' +
  '<option value="1">' + i18n['dmy'] + '</option>' +
  '<option value="2">' + i18n['ymd'] + '</option></select>'
i18n['appearance date delimiter exp'] = '분리자 '
i18n['appearance fonts'] = '글꼴 표시'
i18n['appearance fonts face'] = '글꼴'
i18n['appearance fonts space'] = '간격'
i18n['serif'] = 'Serif'
i18n['sans serif'] = 'Sans Serif'
i18n['mono'] = 'Mono'
i18n['appearance fonts size'] = '크기'
i18n['appearance fonts xl'] = '가장 크게'
i18n['appearance fonts l'] = '더 크게'
i18n['appearance fonts m'] = '기본값'
i18n['appearance fonts s'] = '더 작게'
i18n['appearance fonts xs'] = '가장 작게'
i18n['submit changes'] = '변경 내용 저장'
i18n['not changed'] = '변경된 옵션 없음'
i18n['success'] = '계정 업데이트 완료'
i18n['NDA'] = '위임된 관리자'
i18n['filters'] = '메일 필터'
i18n['loadingFilters'] = '필터 로드 중...'
i18n['InvalidMsgSizePrompt'] = '메일 크기를 입력하십시오.'
i18n['InvalidMobileFwdPrompt'] = '잘못되거나 없는 입력 데이터입니다. 다시 입력하십시오.'
i18n['InvalidFilterNamePrompt'] = '올바른 필터 이름을 입력하십시오.'
i18n['DuplicateFilterPrompt'] = '필터 이름이 중복되었습니다. 다른 이름을 입력하십시오.'
i18n['InvalidSieveFormat'] = '잘못된 필터 형식입니다. 도움말 데스크에 지원을 요청하십시오.';


function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  '은(는) 메일 주소로 유효하지 않습니다.')
}

// Alerts
i18n['js error'] = 'JavaScript 오류'
i18n['line'] = '줄'
i18n['login failed'] = '로그인 실패'
i18n['timeout'] = '세션 시간이 초과되었습니다. 다시 로그인하십시오.'
i18n['FolderNameWithSpace'] = '폴더 이름을 비워 두면 안됩니다.'
i18n['orphanwin'] = '창이 비활성 상태이기 때문에 계속할 수 없습니다.'

// Time Arrays
var months = new Array('1', '2', '3', '4', '5', '6',
  '7', '8', '9', '10', '11', '12')
var days = new Array('일요일', '월요일', '화요일', '수요일', '목요일',
  '금요일', '토요일')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i < 12)
    s = '오전 '
  else
    s = '오후 '
  if (i >= 13)
    s += i - 12
  else
    s += i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
  return i + '년 ' + months[d.getMonth()] + '월 ' +  d.getDate() + '일 ' +
    days[d.getDay()] + ' ' + i18n_time(d)
//  return days[d.getDay()] + ', ' + months[d.getMonth()] + ' ' + d.getDate() +
//    ', ' + i + ' ' + i18n_time(d)
}

function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + 'As' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">로컬 디렉토리 검색</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    'Netscape Netcenter 검색</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'Bigfoot 검색</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    'InfoSpace 검색</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'Switchboard 검색</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    'Verisign 검색</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    'WhoWhere 검색</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'Yahoo! 검색</option>\n' +
    '</select>\n' +
    font() + '해당되는 사람' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">전체 이름</option>\n' +
    '<option value="givenname">이름</option>\n' +
    '<option value="sn">성</option>\n' +
    '<option value="mail">전자 메일</option>\n' +
    '<option value="telephonenumber">전화 번호 #</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() +
    '<select name="rule">\n' +
    '<option value="contains">을 포함하는</option>\n' +
    //'<option value="does not">포함 안 됨</option>\n' +
    '<option value="equal">과 같은</option>\n' +
    //'<option value="not equal">같지 않음</option>\n' +
    '<option value="sound">과 비슷한</option>\n' +
    '<option value="begin">으로 시작하는</option>\n' +
    '<option value="end">으로 끝나는</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
   return '<SELECT class="ActMenu" name=dir><option value="3 200">회사 디렉토리 검색</option>\n'+
          '</SELECT>'+main.font() + '&nbsp;해당 사용자'

  else if(what=='2')
   return '<SELECT  class="ActMenu" name=dir><option value="3 200">회사 디렉토리 검색</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">개인 주소록 검색</option>\n' : '' +
          '</select>\n' +
          main.font() + '연락처 또는 그룹에서 검색'
 else if(what=='3')
   return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;폴더에서 선택&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">모든 공유 폴더</option>\n' : '') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">사용자 이름으로 공유 폴더 검색</option>\n' : '') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('이동', ' 이동 ', "parent.subscribeOptions()") + '\n'
}



function i18n_ldap_no_match(attr, rule, value) {
  return attr.toLowerCase() + '에서 ' + '<b>' + html(value) + '</b>' + rule.toLowerCase() + ' 사용자가 없습니다.'

}

function i18n_ldap_match(end, attr, rule, value) {
  return attr.toLowerCase() + '에서 ' + '<b>' + html(value) + '</b>'+ rule.toLowerCase() + ' 검색결과: ' + end 
}

function i18n_search_list() {
  var width1
 
  if(NN > 0) {
    width1 = win ? 12 : 25;
  }
  else
    width1 = 30;
 
  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() +
    folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' 안에 해당 메일을 검색' +
    '</td>\n'+
   '<td>'+i18n['nbsp']+'</td>\n'+
   '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">보낸 사람</option>\n' +
    '<option value="SUBJECT">제목</option>\n' +
    '<option value="BODY">본문</option>\n' +
    '<option value="TO">수신자</option>\n' +
    '</select>\n' +

    ' 에' + '<input type=text name="string">\n' + '가 ' +
    
    '<select name="rule">\n' +
    '<option value="">포함</option>\n' +
    '<option value="NOT ">포함 안 됨</option>\n' +
    '</select>\n' +
    main.nbutton('search', i18n['search'], "parent.doSearch()") + '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return '삭제된 메일 보관함 ' + folder
}

function i18n_settings_draft_folder(folder) {
  return '임시 메일 보관함 ' + folder
}

function i18n_settings_sent_folder(folder) {
  return '메일 보낼 때 복사본 저장 ' + folder
}

function i18n_settings_wrap_width() {
  return '<input size=2 name="meWrapWidth"> 문자에서 메일 줄 바꾸기'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    '메일에 개인 명함 첨부</td></tr>\n' +
    vc('이름', 'nf', 32) +
    vc('성', 'nl', 32) +
    vc('전체 이름', 'fn', 32) +
    vc('직위', 'ti', 32) +
    vc('조직', 'or', 32) +
    vc('부서', 'od', 32) +
    vc('전자 메일', 'ei', 32) +
    vc('홈 페이지', 'ur', 32) +
    vc('직장 전화', 'tw', 14) +
    vc('집 전화', 'th', 14) +
    vc('팩스', 'tf', 14) +
    vc('호출기', 'tp', 14) +
    vc('휴대 전화', 'tc', 14) +
    vc('주소', 'ad', 32) +
    vc('구/군/시', 'ci', 32) +
    vc('시/도', 'st', 32) +
    vc('우편 번호', 'zi', 32) +
    vc('국가', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='아프리칸스어'
i18n['ar']='아랍어'
i18n['ca']='카탈로니아어'
i18n['zh-CN']='중국어/간체'
i18n['zh-TW']='중국어/번체'
i18n['cs']='체코어'
i18n['hr']='크로아티아어'
i18n['da']='덴마크어'
i18n['nl']='네덜란드어'
i18n['en']='영어'
i18n['fi']='핀란드어'
i18n['fr']='프랑스어'
i18n['gl']='갈리시아어'
i18n['de']='독일어'
i18n['el']='그리스어'
i18n['he']='히브리어'
i18n['hu']='헝가리어'
i18n['is']='아이슬란드어'
i18n['ga']='아일랜드어'
i18n['it']='이탈리아어'
i18n['ja']='일본어'
i18n['ko']='한국어'
i18n['no']='노르웨이어'
i18n['pl']='폴란드어'
i18n['pt']='포르투갈어'
i18n['ro']='루마니아어'
i18n['sk']='슬로바키아어'
i18n['sl']='슬로베니아어'
i18n['es']='스페인어'
i18n['sv']='스웨덴어'
i18n['th']='태국어'
i18n['tr']='터키어'

function i18n_preferredlanguagelist()
{
    var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr');
    var s = '<select name="preferredLanguage">';
    for (i=0; i<lang_list.length; i++)
        s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>';
    return s+'</select>'
}

function i18n_search_options()
{

var s = '<select name="attr" size="1">' +
        '<option value="cn">전체 이름</option>' +
        '<option value="givenname">이름</option>' +
        '<option value="sn">성</option>' +
        '<option value="mail">메일</option>' +
        '<option value="uid">사용자 아이디</option>' +
        '<option value="telephonenumber">전화 번호</option>\n' +
        '</select>' +
        ' 에서 다음' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">을(를) 포함하는</option>' +
        '<option value="equal">와(과) 같은</option>\n' +
        '<option value="begin">으로 시작하는</option>\n' +
        '<option value="sound">와(과) 비슷한</option>' +
        '<option value="end">으로 끝나는</option>' +
        '</select>'
  return s;
}
function i18n_month_list()
{
    var s=''
    for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'월'+'</option>'
    }
    return s
}

function i18n_day_list()
{
    var s=''
    for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'일'+'</option>'
    }
    return s
}
function i18n_year_list()
{
    var s=''
    var d= new Date();
    var year=d.getYear();

    for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
    }
    return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = '주소록'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'

i18n['Current Folder'] = '현재 폴더'
i18n['Mail'] = '메일'
i18n['Calendar'] = '달력'
i18n['Options'] = '환경 설정'
i18n['Address Book'] = '주소록'

