// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='拼字檢查'
i18n['settings autospell exp']='在傳送郵件之前永遠檢查拼字'
i18n['spellok']='確定'
i18n['AutoSpellCheck']='在郵件寄出之前檢查拼字'
i18n['spell error']='伺服器錯誤：不能進行拼字檢查'
i18n['spelldicterror']='伺服器錯誤：無法取得語言字典'
i18n['select  comp lang']='選擇語言'
i18n['spelldict']='字典'
i18n['spell change'] = '&nbsp;變更&nbsp;'
i18n['spell changeall'] = '全部變更'
i18n['spell ignoreall'] = '&nbsp;全部忽略&nbsp;'
i18n['spell_progress']='請稍候。拼字檢查程式將會立刻啟動。'
i18n['send_progress']='正在進行傳送';
i18n['spell_no_mistakes']="沒有任何錯誤拼字";
i18n['spell_select_lang']="請選擇一種語言";
i18n['spell_nothing']='沒有文字可供檢查';
i18n['send_anyway']= '您的郵件含有拼字檢查程式不能辨認的單字。您無論如何還是要傳送郵件嗎？'
i18n['done_anyway']= '您的郵件仍然含有拼字檢查程式不能辨認的單字。'
i18n['spell_window_title']='檢查郵件拼字'
i18n['spell yes']="是"
i18n['spell no']="否"
i18n['spelltool done']="完成"
i18n['spelltool help']="輔助說明"
i18n['No Suggestions']='無建議'
i18n['Suggestions']='建議'

//SMIME
i18n['smime not available']='SMIME 配置未完成或 Applet 並未載入'
i18n['smime recipients failure']='新增收件者錯誤：'
i18n['Signed Message']='簽名郵件'
i18n['Invalid Signature']='無效簽名'
i18n['Invalid Encryption']='無效加密'
i18n['Encrypted Message']='加密郵件'
i18n['url_error']="新增 URL 時發生錯誤"

// Compose window toolbar
i18n['compose_send']='傳送郵件'
i18n['compose_attach']='附加檔案到郵件'
i18n['compose_spell']='檢查郵件拼字'
i18n['compose_editor']='切換編輯程式 (純文字或是 HTML)'




// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = '載入中：請稍候...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = '選取'
i18n['Select All']= '全選'
i18n['Deselect All']= '取消全選'
i18n['no msg'] = '此資料夾中沒有郵件。'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = '收件匣'
fldr['Trash'] = '垃圾箱'
fldr['Drafts'] = '草稿'
fldr['Sent'] = '寄件備份'
fldr['Sent Items'] = '寄件備份項目'

// Window titles
i18n['app title'] = '郵件 - Communications Express'
i18n['sjs app title'] = 'Sun Java&#153; System Messenger Express'
i18n['attach title'] = '附加檔案'
i18n['collect title'] = '收取外部郵件'
i18n['compose title'] = '新郵件'
i18n['lookup title'] = 'LDAP 尋找'
i18n['receipt title'] = '回送回條'
i18n['editgroup title'] = '更新群組'
i18n['editentry title'] = '更新連絡人'
i18n['newgroup title'] = '新增群組'
i18n['newentry title'] = '新增連絡人'
i18n['comprecipient title'] = '從 [個人通訊錄] 中選擇收件者'

// Tabs
i18n['folders'] = '資料夾'
i18n['message'] = '郵件'
i18n['pab'] = '通訊錄'
i18n['options'] = '選項'
i18n['search results'] = '搜尋結果'
i18n['searching'] = '搜尋中...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='拼字檢查'

function i18n_tab_header(user) {
  return '<nobr>&nbsp;歡迎 ' + user + '</nobr>'
}

function i18n_quota_warning(percent) {
  return '警告：目前您正操作在 ' + percent + '% 的配額。'
}

function i18n_maxsize(maxsize) {
  return '(附件最大不應超過 ' + maxsize +
         'kb。)'
}

function i18n_msgQuota_warning(percent) {
  return '警告：目前您正操作在 ' + percent + '% 的郵件配額。'
}

// Error Messages

i18n['fldr selfmove'] = '不允許將資料夾移動到其本身' 
i18n['fldr noinbox'] = '不允許在 [收件匣] 之下建立子資料夾'
i18n['mbox nopermission'] = '您沒有權限將郵件移動到此資料夾'
i18n['mbox selfmove'] = '不能將郵件移動到其本來所在的資料夾'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']

// Message Headers
i18n['selected'] = '已選取'
i18n['seen'] = '已讀取'
i18n['from'] = '寄件者'
i18n['date'] = '日期'
i18n['recvdate'] = '收件日期'
i18n['sentdate'] = '寄件日期'
i18n['to'] = '收件者'
i18n['cc'] = '副本'
i18n['bcc'] = '密件副本'
i18n['subject'] = '主旨'
i18n['attachments'] = '附件'
i18n['size'] = '大小'
i18n['unread'] = '未讀取'
i18n['no subject'] = '[ 無主旨 ]'
i18n['duplicates ignored'] = '次重複予以忽略'
i18n['search invalidfolder'] = '所選資料夾無效。請選取一個有效的資料夾以進行搜尋。'

// Tool Bars
i18n['delete'] = '刪除'
i18n['undelete'] = '取消刪除'
i18n['expunge'] = '清除'
i18n['rename'] = '重新命名'
i18n['new folder'] = '新增'
i18n['subscribe'] = '共用'
i18n['help'] = '輔助說明'
i18n['logout'] = '登出'
i18n['home'] = '首頁'
i18n['attach'] = '附加'
i18n['draft'] = '儲存草稿'
i18n['send'] = '傳送'
i18n['cancel'] = '取消'
i18n['compose_help']= '輔助說明'
i18n['compose'] = '新郵件'
i18n['search'] = '搜尋'
i18n['get mail'] = '收信'
i18n['update'] = '更新'
i18n['forward'] = '轉寄'
i18n['reply'] = '回覆'
i18n['reply all'] = '全部回覆'
i18n['add sender'] = '新增寄件者'
i18n['previous'] = '上一封'
i18n['printable'] = '可列印'
i18n['next'] = '下一封'
i18n['lookup'] = '通訊錄'
i18n['quote'] = '引述'
i18n['new search'] = '修改'
i18n['add all addresses'] = '新增位址'
i18n['sharefolder toolbar'] = '共用'
i18n["attach_help"] = '輔助說明'

// Shared Folders
i18n["share folder"] = '共用資料夾'
i18n["Shared Folders Title"] = '設定資料夾權限'
i18n["SetPermissions Header"] = '資料夾：'
i18n["SetPermissions AddUser"] = '權限清單'
i18n["SetPermissions AddUser1"] = '若要與他人共用這個資料夾，使用 [搜尋] 來確定使用者。'
i18n["SetPermissions Subtitle1"] = '輸入使用者 ID，然後按下 [新增]。'
i18n["SetPermissions Searchtitle"] = '要搜尋使用者，請按一下 [搜尋]。'
i18n["SetPermissions subtitle2"] = '設定權限：'
i18n["SetPermissions info"] = '然後，設定該使用者的權限。' 
i18n["SetPermissions read"] = '只能讀取'
i18n["SetPermissions readwrite"] = '可讀可寫'
i18n["SetPermissions readwriteaccess"] = '可讀可寫，並可管理存取'
i18n["SetPermissions User"] = '使用者 ID'
i18n["SetPermissions Permission"] = '權限'
i18n["SetPermissions Delete"] = '移除'
i18n["SetPermissions ok"] = '確定'
i18n["SetPermissions apply"] = '套用'
i18n["SetPermissions cancel"] = '取消'
i18n["SetPermissions Help"] = '輔助說明'
i18n["SetPermissions Alert1"] = '使用者已經在清單上'
i18n["SetPermissions AddButton"] = '新增'
i18n["SetPermissions SearchButton"] = '搜尋...'
i18n["SetPermissions Alert2"] = '請輸入使用者名稱'
i18n["SetPermissions subtitle3"] = '從清單中選取一個使用者然後按一下 [新增]'
i18n["SetPermissions subtitle4"] = '搜尋使用者'
i18n["SetPermissions selfadd"] = '不允許與自己共用資料夾'
i18n["SetPermissions none"] = '無'
i18n["directdelivery"] = '設定將電子郵件直接遞送到資料夾：'
i18n["SetPermissions owneraddalert"] = '不允許與自己共用資料夾'
i18n["SetPermissions SearchResultHeader"] = '請從下列清單中選取使用者'
i18n["SetPermissions nopermissionslaert"] = '您沒有權限設定權限'
i18n["SetPermissions Remove"] = '移除'
i18n["SetPermissions InvalidUser"] = '無效的使用者'
i18n['SetPermissions anyone'] = '任何人'
i18n['Mail Delivery Address'] = '郵件傳遞位址'
i18n['Folders shared by '] = '資料夾共用者'
i18n[ 'All Shared folders'] =  '所有共用資料夾'
i18n['Initial help text'] = '從以上功能表中選取要檢視的資料夾。'

// Folders
i18n['fldr folders'] = '資料夾'
i18n['fldr personal'] = '個人資料夾'
i18n['fldr shared'] = '訂閱的共用資料夾'
i18n['fldr file header'] = '將所選資料夾移至'
i18n['fldr noinferiors'] = '不允許建立子資料夾'
i18n['fldr delete inbox'] = '系統資料夾—無法刪除'
i18n['fldr move inbox'] = '系統資料夾—無法移動'
i18n['fldr noselect'] = '無法修改此資料夾。'
i18n['fldr cannotselect'] = '此資料夾不可選取'
i18n['fldr empty trash'] = '清空垃圾箱'
i18n['fldr messages'] = '郵件'
i18n['fldr nodelete'] = '無法重新命名此資料夾。'
i18n['fldr exists']= '資料夾已經存在。'
i18n['fldr select']= '選取一個資料夾。'
i18n['fldr nopermissions'] = '您沒有權限建立子資料夾'
i18n['fldr nopermissionsdelete'] = '您沒有權限刪除子資料夾'
i18n['fldr unsubscribe'] = '無法取消訂閱該資料夾'
i18n['Folder Actions'] = '資料夾動作'

i18n['subscribe'] = '訂閱'
i18n['subscribe windowtitle'] = '訂閱 [共用資料夾]'
i18n['unsubscribe'] = '取消訂閱'
i18n['Subscribe Header1'] = '共用資料夾是由其所有者所管理。所以請在下方輸入所有者的名稱、電子郵件位址'
i18n['Subscribe Header2'] = '或是電話號碼，然後按一下 [搜尋]。選擇您要的資料夾，然後按一下 [訂閱]'
i18n['No Unsubscribed Folders'] = '沒有資料夾可以訂閱'
i18n['No Shared Folders'] = '這位使用者沒有任何共用資料夾'
i18n['subscribe select'] = '選取'
i18n['subscribe Folder'] = '資料夾'
i18n['subscribe owner'] = '所有者'
i18n['subscribe searchHeader'] = '請從清單中選取使用者 ID '
i18n['subscribe User ID'] = '使用者 ID'
i18n['subscribe Name'] = '姓名'
i18n['subscribe E-Mail'] = '電子郵件'
i18n['subscribe owner Header'] = '所有者的'
i18n['subscribe search title'] = '選取使用者 ID'
i18n['subscribe Search'] = '搜尋'
i18n['subscribe Result'] = '訂閱搜尋結果以用於'

//Rtf
i18n['FontsizeLabel'] = '大小'
i18n['FontnameLabel'] = '字型'
i18n['Block Format'] = '段落'
i18n['ViewHTMLSource'] = '檢視 HTML 原始檔'
i18n['switchEditor']= '純文字/HTML'
i18n['colorColorLabel'] = '色彩：'
i18n['colorOkLabel'] = '確定'
i18n['colorCancelLabel']= '取消'
i18n['emoCloseLabel'] = '關閉'
i18n['Smiley'] = '插入情緒符號'
i18n['Cut'] = '剪下'
i18n['Copy'] = '複製'
i18n['Paste'] = '貼上'
i18n['Bold'] = '粗體'
i18n['Italics'] = '斜體'
i18n['Underline'] = '底線'
i18n['Change foreground color'] = '文字色彩'
i18n['Change Background color'] = '背景色彩'
i18n['Left Justify'] = '靠左對齊'
i18n['Center Justify'] = '置中對齊'
i18n['Right Justify'] = '靠右對齊'
i18n['Insert Ordered List'] = '數字清單'
i18n['Insert bullets'] = '分項符號清單'
i18n['Outdent'] = '減少縮排'
i18n['Indent'] = '增加縮排'
i18n['Create HyperLink'] = '插入超連結'
i18n['make text left to right align'] = '使文字從左到右對齊'
i18n['make text right to left align'] = '使文字從右到左對齊'
i18n['all formatting will be lost'] = '所有格式化將消失。是否繼續？'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = '請取消核取 [檢視 HTML 原始檔]，以使用格式化工具'
i18n['Compose in'] = '撰寫所用文字格式'
i18n['Plain Text'] = '一般文字'
i18n['Rich Text (HTML)']= '豐富文字 (HTML)'

//Attach Dialog

i18n['Attach Header'] = '按一下 [瀏覽] 來選擇要附加的檔案，然後按一下 [新增] 將檔案附加到此郵件中。'
i18n['Attach Col1'] = '附加檔案'
i18n['Attach Col2'] = '大小'
i18n['Attach Remove'] = '移除'
i18n['Attach Add'] = '新增'
i18n['Attachments'] = '附件'
i18n['Action'] = '動作'

//Tooltips

i18n['folder actions'] = '資料夾動作'
i18n['folder update'] = '更新資料夾'
i18n['folder new'] = '新增資料夾'
i18n['folder rename'] = '重新命名資料夾'
i18n['folder share'] = '共用資料夾'
i18n['folder delete'] = '刪除選取的資料夾'
i18n['folder subscribe'] = '訂閱共用的資料夾'
i18n['folder unsubscribe'] = '取消訂閱資料夾'
i18n['folder owner'] = '共用資料夾的所有者'
i18n['mbox getmail'] = '收信'
i18n['mbox search'] = '搜尋郵件'
i18n['mbox delete'] = '刪除選取的郵件'
i18n['mbox trash'] = '標示選取的郵件為已刪除'
i18n['mbox actions'] = '郵件動作'
i18n['mbox expunge'] = '清除'
i18n['mbox undelete'] = '取消刪除'

i18n['seen up'] = '依郵件類型遞減排序'
i18n['seen dn'] = '依郵件類型遞增排序' 
i18n['recv up'] = '依收件日期遞減排序'
i18n['recv dn'] = '依收件日期遞增排序'
i18n['from up'] = '依郵件寄件者遞減排序'
i18n['from dn'] = '依郵件寄件者遞增排序'
i18n['size up'] = '依郵件大小遞減排序'
i18n['size dn'] = '依郵件大小遞增排序'
i18n['subj up'] = '依郵件主旨遞減排序'
i18n['subj dn'] = '依郵件主旨遞增排序'


i18n['name up'] = '依顯示名稱遞減排序'
i18n['name dn'] = '依顯示名稱遞增排序'
i18n['mail up'] = '依電子郵件位址遞減排序'
i18n['mail dn'] = '依電子郵件位址遞增排序'
i18n['attach dn'] = '依附加檔案有無遞增排序'
i18n['attach up'] = '依附加檔案有無遞減排序'
i18n['priority dn']  = '依郵件優先順序遞增排序'
i18n['priority up'] = '依郵件優先順序遞減排序'

i18n['msg compose'] = '撰寫郵件'
i18n['msg reply'] = '回覆郵件'
i18n['msg replyall'] = '全部回覆郵件'
i18n['msg forward'] = '轉寄郵件'
i18n['msg delete'] = '刪除郵件'
i18n['msg addall'] = '新增所有寄件者位址到通訊錄中'
i18n['msg prev'] = '上一封郵件'
i18n['msg next'] = '下一封郵件'
i18n['msg close'] = '關閉郵件'
i18n['msg UnRead'] = '狀態：未讀取'
i18n['msg UnreadDel'] = '狀態：未讀取，已刪除'
i18n['msg Read'] = '狀態：已讀取'
i18n['msg ReadDel'] = '狀態：已讀取，已刪除'
i18n['msg ReadAns'] = '狀態：已讀取，已回應'
i18n['msg ReadAnsDel'] = '狀態：已讀取，已回應，已刪除'
i18n['msg Attachment'] = '附加檔案'
i18n['msg FullHeader'] = '檢視郵件標題詳細資訊'
i18n['msg NormalHeader'] = '檢視郵件簡短標題'
i18n['msg priority'] = '優先程度'
i18n['msg high'] = '優先程度：緊急'
i18n['msg low'] = '優先程度：不緊急'

i18n['Previous'] = '上一個'
i18n['Showing'] = '显示'
i18n['Messages'] = '郵件'
i18n['Next'] = '下上一個'
i18n['of'] = '/'

i18n['pab update'] = '更新通訊錄'
i18n['pab new'] = '新增連絡人'
i18n['pab group'] = '新增群組'
i18n['pab search'] = '搜尋通訊錄'
i18n['pab editgroup'] = '編輯群組'

function prompt_delete_folder(m, i) {

var fname = m;
for(j=0; j < fldr.length; j++)
 {
   if(fldr[j] == m)
   {
      fname = fldr[j];
      break;
   }
}

  if (i > 0)
    return '刪除資料夾 "' + fname + '" 以及 ' + i + ' 封郵件？'
  else
    return '刪除資料夾 "' + fname + '"？'
}

function prompt_new_folder(m) {

var fname = m;
for(i=0; i < fldr.length; i++)
 {
   if(fldr[i] == m)
   {
      fname = fldr[i];
      break;
   }
}

  return '在 ' + fname + ' 下建立新資料夾：'
}

function prompt_rename_folder(f) {
  return '重新命名資料夾 "' + f + '" 為：'
}

function prompt_subscribe_folder() {
  return '訂閱資料夾：'
}

function prompt_unsubscribe_folder(f) {
    return '取消訂閱資料夾 "' + f + '"：'
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
    return '永遠移除所有在 ' + fname + ' 中的郵件？'
}

// Mailbox
i18n['file selected msg'] = '移動郵件到資料夾'
i18n['copy selected msg'] = '複製郵件到資料夾'
i18n['select folder'] = '選取資料夾'
i18n['mbox select all'] = '選取所有郵件'
i18n['confirm expunge'] = '永遠移除選取的郵件？'
i18n['confirm expunge all'] = '沒有選取郵件。永遠移除所有刪除的郵件？'

function i18n_mbox_date(d, now, laurel) {
  var i, s, timeformat =12

  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12;

  if (d.getDate() == now.getDate() && d.getMonth() == now.getMonth() &&
    d.getYear() == now.getYear()) {
    i = d.getHours()
    if (i == 0)
      s = 12
    else if (i < 13)
      s = i
    else {
      if(timeformat == 12)
        s = i - 12;
      else
        s = i;
    }
    s += ':'
    if (d.getMinutes() <= 9)
      s += '0'
    s += d.getMinutes()
    if(timeformat == 12)
    {
    if (i < 12)
      s = '上午 ' + s
    else
      s = '下午 ' + s
    }
  } else {
    i = d.getYear()
    if (i >= 2000)
      i -= 2000
    else if (i >= 100)
      i -= 100
    if (i < 10)
      i = '0' + i
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat'];
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimiter'] : '/';
      format = lformat ? lformat.charAt(0) : '0';
    }

    switch(format){
      case '0': case 'M':
           s = (d.getMonth() + 1) + deli + d.getDate() + deli + i;
           break;
      case '1': case 'D':
           s = d.getDate() + deli +(d.getMonth() + 1)  + deli + i;
           break;
      case '2': case 'Y':
           s = i + deli + (d.getMonth() + 1) + deli + d.getDate();
           break;
    }
  }
  return s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + ' 沒有包含任何郵件'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>' + total + ' 郵件' + (total > 1 ? '' : '')
      if (unread == 0)
        s += ' (' + unread + ' 未讀取) -'
      else
        s += ' (<b>' + unread + ' 未讀取</b>) -'
      i = parseInt(used)
      s += '</nobr> <nobr>' + size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += '無限制'
      else
        s += size(i) + ' 限制'
      s += ')'
      s += ' -  ' + msgUsed + ' 全部郵件 ('
      if (msgLimit < 0)
        s += '無限制'
      else
        s += msgLimit + ' 限制'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = '無符合'
    else if (mboxFrame.sortid.length == 1)
      s = '1 符合'
    else
      s = total + ' 符合'
    s += ' 對於： '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() + ' ' +
      (val[0].length == 0 ? '包含' : '不包含') +
//      ' "' + val[2] + '"' + ' in ' + 
      ' "' + strflr + '"' + ' 在 ' +
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return '沒有選取郵件。\n移除所有在 ' + fname + ' 中已刪除的郵件？'
}

// Message
i18n['file msg'] = '移動郵件到資料夾：'
i18n['msg image'] = '[ 影像 ]'
i18n['msg file prefix'] = '檔案：'
i18n['msg vcard'] = 'vCard'
i18n['msg signature'] = '數位簽名'
i18n['msg encrypted'] = '加密 (不能解碼)'
i18n['msg brief'] = '檢視郵件簡短標題'
i18n['msg all'] = '檢視郵件詳細標題'

// Message Composition
i18n['fwd'] = '轉寄：'
i18n['re'] = '回覆：'
i18n['attachment pending'] = '等待附加檔案中。請稍候'
i18n['cancel message'] = '關閉郵件並放棄變更？'
i18n['recipient'] = '收件者'
i18n['recipient mini help'] = '使用英文逗號分隔多位收件者。'
i18n['invalid addr'] = '電子郵件位址包含無效的字元'
i18n['no recipient'] = '這封郵件沒有列示收件者。請按一下 [收件者]、[副本] 或是 [密件副本] 來新增電子郵件位址。'
i18n['no subject confirm'] = '這封郵件沒有主旨。您還是要傳送嗎？'
i18n['original message'] = '原有信件'
i18n['reply text'] = '原有信件'
i18n['remove'] = '移除'
i18n['reply separator'] = '----- 原有信件 -----'
i18n['priority'] = '優先順序'
i18n['priority n'] = '普通'
i18n['priority h'] = '緊急'
i18n['priority l'] = '不緊急'
i18n['receipt'] = '要求回條'
i18n['receipt n'] = '無'
i18n['receipt d'] = '當完成傳送時'
i18n['receipt r'] = '當開啟檢視時'
i18n['receipt b'] = '兩者都要'
i18n['no mail'] = '沒有郵件位址。無法傳送郵件'
i18n['reply too long'] = '原有信件太大以致不能引述。\n將以附加檔案方式包含在郵件中。'
i18n['reply no text'] = 'Messenger Express 無法以純文字方式引述原有信件。\n將以附加檔案方式包含在郵件中。'
i18n['add empty t'] = '傳送這封郵件到：'
i18n['add empty c'] = '傳送這封郵件的副本到：'
i18n['add empty b'] = '傳送這封郵件的密件副本到：'
i18n['sent status'] = '郵件成功送出'

// Return receipt
i18n['receipt request'] = '要求回條。傳送確認？'
i18n['receipt subject'] = '回送回條 (已顯示) - '

function i18n_receipt_text(from) {
  return '這是您傳送給\r\n' + from +
    '郵件的回送回條。\r\n\r\n' +
    '附註：此回送回條僅表示\r\n' +
    '信件已經在收件者的機器上顯示。這並不保證\r\n' +
    '信件的內容已經被讀取或是被理解。'
}

// Attachment
i18n['attach missing'] = '沒有選取檔案'
i18n['attach empty'] = '空的或是無效檔案'
i18n['attach msg canceled'] = '郵件取消'
i18n['attach non ascii allowed'] = '附加檔案的檔名必須是 ASCII 字元'
i18n['attach pending'] = '等待附加檔案中。按下 [取消] 以放棄...'
i18n['attach limited'] = '附加檔案限制在 '
i18n['attach maxlimit'] = '已達到附加檔案數目最大限制'

function i18n_attach_msg() {
  return '<ul><li>按一下 <b>[瀏覽...]</b> ' +
    (IE >= 3 && IE < 4 ? '必須已經安裝 IE 檔案上載修正檔' : '以選取檔案。') + 
    '<li>在選取檔案之後，按一下 <b>[附加]</b>。' +
    '<li>此視窗會在檔案傳輸完成以後自動關閉。' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = '收取'
i18n['collect long'] = '收取外部郵件'
i18n['collect host'] = 'POP 伺服器'
i18n['collect user'] = 'POP 使用者 ID'
i18n['collect pass'] = '密碼'
i18n['collect folder'] = '儲存到資料夾'
i18n['collect delete'] = '從伺服器中刪除郵件'
i18n['collect pending'] = '正在收取外部信件。請稍候...'
i18n['collect no host'] = '必須指定 POP 伺服器。'
i18n['collect no user'] = '必須指定使用者帳號。'
i18n['collect no pass'] = '必須指定帳號密碼。'
i18n['msg nocollect'] = '您沒有權限將接收的郵件放置在此資料夾中'

// LDAP Lookup
i18n['ldap givenname'] = '名字'
i18n['ldap sn'] = '姓氏'
i18n['ldap cn'] = '姓名'
i18n['ldap mail'] = '帳號'
i18n['ldap phone'] = '電話號碼'
i18n['ldap searching'] = '正在搜尋中。請稍候...'
i18n['close'] = '關閉'

// Options
i18n['account summary'] = '帳號摘要'
i18n['summary exp'] = '若您要修改下列任一資訊，請連絡您的系統管理員。'
i18n['email addrs'] = '電子郵件位址'
i18n['email addrs exp'] = '您的帳號組態設定可以讓您接收下列位址的電子郵件：'
i18n['quota'] = '配額'
i18n['quota exp'] = '您的系統管理員可能會限制郵件儲存可用的磁碟空間。'
i18n['quota limit'] = '您的信箱配額是：'
i18n['no limit'] = '沒有限制'
i18n['quota usage'] = '目前磁碟空間使用量為：'
i18n['message quota limit'] = '您的郵件配額是：'
i18n['message quota usage'] = '目前郵件的數量：'
i18n['password'] = '密碼'
i18n['passwd exp'] = '使用此表單變更您存取 Messenger Express 的密碼。'
i18n['passwd old'] = '1. 輸入您舊的密碼：'
i18n['passwd new'] = '2. 輸入您新的密碼：'
i18n['passwd confirm'] = '3. 確認您新的密碼：'
i18n['passwd again'] = ' (用於確認) '
i18n['passwd submit'] = '變更密碼'
i18n['clear'] = '重設'
i18n['new pass alert'] = '請輸入您新的密碼。'
i18n['old pass alert'] = '請輸入您舊的密碼。'
i18n['pass mismatch alert'] = '新密碼的兩次輸入並不符合。請重新輸入。'
i18n['pass changed'] = '密碼變更成功'
i18n['personal'] = '個人資訊'
i18n['personal exp'] = '使用此表單來變更個人資訊。'
i18n['personal cn'] = '姓名'
i18n['personal cn exp'] = '這會出現在外送郵件的寄件者欄位中：'
i18n['personal lang'] = '喜好的語言'
i18n['personal lang exp'] = '使用下列預設的語言：'
i18n['personal lang changed'] = '您喜好的語言已經變更。\n\n為了要讓變更生效，\n您必須登出然後再次登入。'
i18n['personal replyto'] = '回覆位址'
i18n['personal replyto exp'] = '若不同於 '
i18n['personal vcard'] = 'vCard'
i18n['personal vcard exp'] = '您的 vCard 包含下列資訊：'
i18n['personal signature'] = '簽名'
i18n['personal signature exp'] = '將這些文字包含在您撰寫的每一封郵件中：'
i18n['delivery'] = '傳遞'
i18n['vacation'] = '自動回覆郵件'
i18n['vacation exp'] = '使用此表單建立當您不在辦公室時系統自動回覆的郵件。'
i18n['vacation toggle'] = '啟用自動回覆郵件'

i18n['vacation date format exp'] = ' (mm/dd/yyyy)'
i18n['vacation date separator'] = '/'
i18n['vacation invalid date'] = '無效的日期'
i18n['vacation blank date error'] = '在啟用時，日期不能為空白'
i18n['vacation date separator error'] = '必須為 mm/dd/yyyy'
i18n['vacation date character error'] = '無效的字元'
i18n['vacation date year error'] = '無效的年份'
i18n['vacation date month error'] = '無效的月份'
i18n['vacation date day error'] = '無效的日期'
i18n['vacation invalidautoreplytimeout'] = '無效的天數'
i18n['vacation start exp'] = '自動回覆開始日期：'
i18n['vacation end exp'] = '自動回覆終止日期：'
i18n['vacation timeout exp'] = '對於重複寄件者，兩次自動回覆之間的天數：'
i18n['vacation subject exp'] = '主旨：'
i18n['vacation internal msg exp'] = '以下文字將包含在自動回覆郵件中並傳送給內部寄件者：'

i18n['vacation msg'] = '這是一封自動回覆的郵件。我目前正在假期中，或是無法收取我的郵件。我將會在回到辦公室時，立刻讀取您的郵件。\n\n謝謝。'
i18n['vacation msg exp'] = '下列文字將會自動加入到您傳送給外部寄件者的自動回覆郵件中：(如果未指定用於內部寄件者的自動回覆郵件，則會向內部寄件者傳送與外部寄件者收到的自動回覆郵件相同的文字)'
i18n['startgreaterend'] = '開始日期比結束日期晚'
i18n['notBeforeToday'] = '請輸入一個日期 (不允許輸入今天以前的日期)'
i18n['notBefore'] = '請輸入一個日期 (僅能輸入今天以後的日期)'
i18n['mdy']=' 月，日，年';
i18n['dmy']=' 日，月，年';
i18n['ymd']=' 年，月，日';
i18n['noReplyIfNoText']= '若啟用自動回覆郵件，自動回覆郵件的內容不應該是空白。'
i18n['settings'] = '設定值'
i18n['settings exp'] = '使用此表單修改 Messenger Express 的設定值。'
i18n['settings delete'] = '刪除郵件時'
i18n['settings exit empty'] = '登出時清空資料夾'
i18n['settings delete imap'] = '標示郵件為已刪除 (使用 ' + i18n['expunge'] + ' 將郵件永遠刪除)'
i18n['settings exit expunge'] = '登出時移除 [收件匣] 中已刪除的郵件'
i18n['settings draft'] = '郵件草稿'
i18n['settings sent'] = '寄件備份'
i18n['settings delivery'] = '郵件轉寄'
i18n['settings forward'] = '轉寄新郵件的副本到 (一行一個位址)：'
i18n['settings forward exp'] = '轉寄新郵件的副本到 (一行一個位址)：'
i18n['settings forward enable'] = '啟用轉寄'
i18n['settings no copy'] = '請勿在伺服器上留下副本'
i18n['settings quote'] = '在回覆中引述'
i18n['settings quote exp'] = '當回覆時，自動引述原有信件的內容。'
i18n['appearance'] = '外觀'
i18n['appearance exp'] = '使用此表單修改 Messenger Express 的外觀。'
i18n['appearance colors'] = '色彩組合'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = '工具列'
i18n['appearance bar both'] = '顯示圖示和文字'
i18n['appearance bar icons'] = '只顯示圖示'
i18n['appearance bar text'] = '只顯示文字'
i18n['appearance page'] = '郵件清單檢視'
i18n['appearance page exp'] = '每頁顯示 ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '<option value="100">100</option></select> 封郵件'
i18n['appearance sort'] = '排序郵件' +
  '<select name="meSortOrder"><option value="F">最舊的郵件最上方</option>' +
  '<option value="R">最舊的郵件最下方</option></select>'
i18n['appearance date exp'] = '日期 '
i18n['appearance date format exp'] = '日期格式 '+
  '<select name="meDateFormatFormat"><option value="0">' + i18n['mdy'] + '</option>' +
  '<option value="1">' + i18n['dmy'] + '</option>' +
  '<option value="2">' + i18n['ymd'] + '</option></select>'
i18n['appearance date delimiter exp'] = '分割元 '
i18n['appearance fonts'] = '顯示字型'
i18n['appearance fonts face'] = '字體'
i18n['appearance fonts space'] = '間距'
i18n['serif'] = 'Serif'
i18n['sans serif'] = 'Sans Serif'
i18n['mono'] = 'Mono'
i18n['appearance fonts size'] = '大小'
i18n['appearance fonts xl'] = '最大'
i18n['appearance fonts l'] = '較大'
i18n['appearance fonts m'] = '預設'
i18n['appearance fonts s'] = '較小'
i18n['appearance fonts xs'] = '最小'
i18n['submit changes'] = '儲存變更'
i18n['not changed'] = '沒有變更任何選項。'
i18n['success'] = '帳號更新成功'
i18n['NDA'] = 'Delegated Administrator'
i18n['filters'] = '郵件過濾器'
i18n['loadingFilters'] = '正在載入過濾器...'
i18n['InvalidMsgSizePrompt'] = '請輸入郵件大小。';
i18n['InvalidMobileFwdPrompt'] = '資料無效/未輸入。 請重新輸入。';
i18n['InvalidFilterNamePrompt'] = '請輸入有效的過濾器名稱。';
i18n['DuplicateFilterPrompt'] = '過濾器名稱重複。請輸入其他名稱。';
i18n['InvalidSieveFormat'] = '過濾器格式無效。請與服務台聯絡以取得支援。';

function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  ' 是無效的電子郵件位址')
}

// Alerts
i18n['js error'] = 'JavaScript 錯誤'
i18n['line'] = '行'
i18n['login failed'] = '登入失敗'
i18n['timeout'] = '階段作業逾時。請重新登入'
i18n['FolderNameWithSpace'] = '資料夾名稱不能為空白'
i18n['orphanwin'] = '視窗非作用中，無法繼續'

// Time Arrays
var months = new Array('1 ', '2 ', '3 ', '4 ', '5 ', '6 ', '7 ', '8 ', '9 ', '10 ', '11 ', '12 ')
var days = new Array('星期天', '星期一', '星期二', '星期三', '星期四',
  '星期五', '星期六')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i >= 13)
    s = i - 12
  else
    s = i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  if (i < 12)
    s = '上午 ' + s
  else
    s = '下午 ' + s
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
  return days[d.getDay()] + ', ' + i + ' 年 ' + months[d.getMonth()] + '月 ' + d.getDate() + '日' +', ' + i18n_time(d)
}


function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + 'As' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">搜尋本地目錄</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    '搜尋 Netscape Netcenter</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'Search Bigfoot</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    '搜尋 InfoSpace</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'Search Switchboard</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    '搜尋 Verisign</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    '搜尋 WhoWhere</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'Search Yahoo!</option>\n' +
    '</select>\n' +
    font() + '，其中' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">全名</option>\n' +
    '<option value="givenname">名字</option>\n' +
    '<option value="sn">姓名</option>\n' +
    '<option value="mail">電子郵件</option>\n' +
    '<option value="telephonenumber">電話號碼</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() +
    '<select name="rule">\n' +
    '<option value="contains">包含</option>\n' +
    //'<option value="does not">does not contain</option>\n' +
    '<option value="equal">是</option>\n' +
    //'<option value="not equal">is not</option>\n' +
    '<option value="sound">發音類似</option>\n' +
    '<option value="begin">開頭為</option>\n' +
    '<option value="end">結尾為</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
   return '<SELECT class="ActMenu" name=dir><option value="3 200">搜尋公司目錄</option>\n'+
          '</SELECT>'+main.font() + '&nbsp;中的使用者，其'

  else if(what=='2')
   return '<SELECT  class="ActMenu" name=dir><option value="3 200">搜尋公司目錄</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">搜尋個人通訊錄</option>\n' : '' +
          '</select>\n' +
          main.font() + '中的連絡人或是群組，其'
 else if(what=='3')
   return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;選自資料夾&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">所有共用資料夾</option>\n':'') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">依使用者搜尋共用資料夾</option>\n':'') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('繼續', ' 繼續 ', "parent.subscribeOptions()") + '\n'
}



function i18n_ldap_no_match(attr, rule, value) {
  return '沒有找到符合下列項目的連絡人 ' + attr.toLowerCase() + ' ' +
    rule.toLowerCase() + ' <b>' + html(value) + '</b>'
}

function i18n_ldap_match(end, attr, rule, value) {
  return end + ' 項連絡人符合' + (end == 1 ? '' : '') +
    ' 其中 ' + attr.toLowerCase() + ' ' + rule.toLowerCase() +
    ' <b>' + html(value) + '</b>'
}

function i18n_search_list() {
  var width1
 
  if(NN > 0) {
    width1 = win ? 12 : 25;
  }
  else
    width1 = 30;
 
  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() + '搜尋在 ' +
    folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' 中的郵件，其中' +
    '</td>\n'+
   '<td>'+i18n['nbsp']+'</td>\n'+
   '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">寄件者</option>\n' +
    '<option value="SUBJECT">主旨</option>\n' +
    '<option value="BODY">內文</option>\n' +
    '<option value="TO">收件者</option>\n' +
    '</select>\n' +
    '<select name="rule">\n' +
    '<option value="">包含</option>\n' +
    '<option value="NOT ">不包含</option>\n' +
    '</select>\n' +
    '<input type=text name="string">\n'+
    main.nbutton('search', i18n['search'], "parent.doSearch()") + '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return '移動刪除的郵件到 ' + folder
}

function i18n_settings_draft_folder(folder) {
  return '保留郵件草稿在 ' + folder
}

function i18n_settings_sent_folder(folder) {
  return '當傳送郵件時，保留一份副本在 ' + folder
}

function i18n_settings_wrap_width() {
  return '將郵件在第 <input size=2 name="meWrapWidth"> 字元處分行'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    '附加 vCard 到郵件</td></tr>\n' +
    vc('名字', 'nf', 32) +
    vc('姓氏', 'nl', 32) +
    vc('全名', 'fn', 32) +
    vc('職稱', 'ti', 32) +
    vc('組織', 'or', 32) +
    vc('部門', 'od', 32) +
    vc('電子郵件', 'ei', 32) +
    vc('首頁', 'ur', 32) +
    vc('公司電話', 'tw', 14) +
    vc('住家電話', 'th', 14) +
    vc('傳真', 'tf', 14) +
    vc('呼叫器', 'tp', 14) +
    vc('行動電話', 'tc', 14) +
    vc('住址', 'ad', 32) +
    vc('城市', 'ci', 32) +
    vc('省/州', 'st', 32) +
    vc('郵遞區號', 'zi', 32) +
    vc('國家', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='南非荷蘭文'
i18n['ar']='阿拉伯文'
i18n['ca']='嘉泰羅尼亞文'
i18n['zh-CN']='簡體中文'
i18n['zh-TW']='繁體中文'
i18n['cs']='捷克文'
i18n['hr']='克羅埃西亞文'
i18n['da']='丹麥文'
i18n['nl']='荷蘭文'
i18n['en']='英文'
i18n['fi']='芬蘭文'
i18n['fr']='法文'
i18n['gl']='加里西亞文'
i18n['de']='德文'
i18n['el']='希臘文'
i18n['he']='希伯來文'
i18n['hu']='匈牙利文'
i18n['is']='冰島文'
i18n['ga']='愛爾蘭文'
i18n['it']='義大利文'
i18n['ja']='日文'
i18n['ko']='韓文'
i18n['no']='挪威文'
i18n['pl']='波蘭文'
i18n['pt']='葡萄牙文'
i18n['ro']='羅馬尼西亞文'
i18n['sk']='斯洛伐克文'
i18n['sl']='斯洛維尼亞文'
i18n['es']='西班牙文'
i18n['sv']='瑞典文'
i18n['th']='泰文'
i18n['tr']='土耳其文'

function i18n_preferredlanguagelist()
{
    var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr');
    var s = '<select name="preferredLanguage">';
    for (i=0; i<lang_list.length; i++)
	s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>';
    return s+'</select>'

}

function i18n_search_options()
{

var s = '<select name="attr" size="1">' +
        '<option value="cn">全名</option>' +
        '<option value="givenname">名字</option>' +
        '<option value="sn">姓氏</option>' +
        '<option value="mail">電子郵件</option>' +
        '<option value="uid">使用者 ID</option>' +
        '<option value="telephonenumber">電話號碼</option>\n' +
        '</select>' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">包含</option>' +
        '<option value="equal">完全吻合</option>\n' +
        '<option value="begin">開頭為</option>\n' +
        '<option value="sound">發音類似</option>' +
        '<option value="end">結尾為</option>' +
        '</select>'
  return s;
}
function i18n_month_list()
{
    var s=''
    for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'</option>'
    }
    return s
}

function i18n_day_list()
{
    var s=''
    for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'</option>'
    }
    return s
}
function i18n_year_list()
{
    var s=''
    var d= new Date();
    var year=d.getYear();

    for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
    }
    return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = '通訊錄'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'

i18n['Current Folder'] = '目前檔案夾'
i18n['Mail'] = '郵件'
i18n['Calendar'] = '行事曆'
i18n['Options'] = '選項'
i18n['Address Book'] = '通訊錄'
