// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='拼写检查'
i18n['settings autospell exp']='发送邮件前始终检查拼写'
i18n['spellok']='确定'
i18n['AutoSpellCheck']='发送邮件前检查拼写'
i18n['spell error']='服务器错误: 无法进行拼写检查'
i18n['spelldicterror']='服务器错误：没有该语言的词典'
i18n['select  comp lang']='选择语言'
i18n['spelldict']='词典'
i18n['spell change'] = '&nbsp;&nbsp;更改&nbsp;&nbsp;&nbsp;'
i18n['spell changeall'] = '全部更改'
i18n['spell ignoreall'] = '&nbsp;全部忽略&nbsp;'
i18n['spell_progress']='请稍候。拼写检查程序将立即启动。'
i18n['send_progress']='正在发送';
i18n['spell_no_mistakes']="没有发现拼写错误";
i18n['spell_select_lang']="请选择一种语言";
i18n['spell_nothing']='没有要检查的内容';
i18n['send_anyway']= '您的邮件中包含拼写检查程序无法识别的词。是否仍要发送？'
i18n['done_anyway']= '您的邮件中仍有一些拼写检查程序无法识别的词。'
i18n['spell_window_title']='检查邮件的拼写'
i18n['spell yes']="是"
i18n['spell no']="否"
i18n['spelltool done']="完成"
i18n['spelltool help']=" 帮助 "
i18n['No Suggestions']='无建议'
i18n['Suggestions']='建议'

//SMIME
i18n['smime not available']='SMIME 配置不完整或未载入小应用程序'
i18n['smime recipients failure']='添加收件人时出错:'
i18n['Signed Message']='签名邮件'
i18n['Invalid Signature']='签名无效'
i18n['Invalid Encryption']='加密无效'
i18n['Encrypted Message']='加密邮件'
i18n['url_error']="添加 URL 时出错"

// Compose window toolbar
i18n['compose_send']='发送邮件'
i18n['compose_attach']='将文件附加到邮件'
i18n['compose_spell']='检查邮件的拼写'
i18n['compose_editor']='切换编辑器 (纯文本或 HTML)'




// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = '正在加载，请稍候...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = '选择'
i18n['Select All']= '全部选择'
i18n['Deselect All']= '全部取消'
i18n['no msg'] = 'This folder contains no message.'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = '收件箱'
fldr['Trash'] = '废纸篓'
fldr['Drafts'] = '草稿'
fldr['Sent'] = '已发送'
fldr['Sent Items'] = '已发送项'

// Window titles
i18n['app title'] = 'Mail - Communications Express'
i18n['sjs app title'] = 'Sun Java&#153; System Messenger Express'
i18n['attach title'] = '附加文件'
i18n['collect title'] = '收集外部邮件'
i18n['compose title'] = '新建邮件'
i18n['lookup title'] = 'LDAP 查找'
i18n['receipt title'] = '返回回执'
i18n['editgroup title'] = '更新组信息'
i18n['editentry title'] = '更新联系人信息'
i18n['newgroup title'] = '新建组'
i18n['newentry title'] = '新建联系人'
i18n['comprecipient title'] = '从个人通讯录中选择收件人'

// Tabs
i18n['folders'] = '文件夹'
i18n['message'] = '邮件'
i18n['pab'] = '地址'
i18n['options'] = '选项'
i18n['search results'] = '搜索结果'
i18n['searching'] = '正在搜索...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='拼写检查'

function i18n_tab_header(user) {
  return '<nobr>&nbsp;&nbsp;欢迎' + user + '</nobr>'
}

function i18n_quota_warning(percent) {
  return '警告: 您目前的操作位置是您所用存储空间配额的' + percent +
         '%。'
}

function i18n_maxsize(maxsize) {
  return '（附件的最大大小不应超过 ' + maxsize +
         'kb。）'
}


function i18n_msgQuota_warning(percent) {
  return '警告: 您目前的操作位置是您邮件所用存储空间配额的' + percent +
         '%。'
}

// Error Messages

i18n['fldr selfmove'] = '不允许将文件夹移动到自身内' 
i18n['fldr noinbox'] = '不允许在“收件箱”内创建子文件夹'
i18n['mbox nopermission'] = '您无权将邮件移至此文件夹'
i18n['mbox selfmove'] = '这些邮件已在此文件夹内，不能再次将其移入'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']

// Message Headers
i18n['selected'] = '选定'
i18n['seen'] = '已读'
i18n['from'] = '自'
i18n['date'] = '日期'
i18n['recvdate'] = '已收到'
i18n['sentdate'] = '已发送'
i18n['to'] = '收件人'
i18n['cc'] = '抄送'
i18n['bcc'] = '密件抄送'
i18n['subject'] = '主题'
i18n['attachments'] = '附件'
i18n['size'] = '大小'
i18n['unread'] = '未读'
i18n['no subject'] = '[无主题]'
i18n['duplicates ignored'] = '已忽略重复项'
i18n['search invalidfolder'] = '所选文件夹无效。请选择一个有效的文件夹，以便搜索。'

// Tool Bars
i18n['delete'] = '删除'
i18n['undelete'] = '取消删除'
i18n['expunge'] = '清除'
i18n['rename'] = '重命名'
i18n['new folder'] = '新建'
i18n['subscribe'] = '共享'
i18n['help'] = '帮助'
i18n['logout'] = '退出'
i18n['home'] = '主页'
i18n['attach'] = '附加'
i18n['draft'] = '保存草稿'
i18n['send'] = '发送'
i18n['cancel'] = '取消'
i18n['compose_help']= '帮助'
i18n['compose'] = '新建邮件'
i18n['search'] = '搜索'
i18n['get mail'] = '接收邮件'
i18n['update'] = '刷新'
i18n['forward'] = '转发'
i18n['reply'] = '回复'
i18n['reply all'] = '全部回复'
i18n['add sender'] = '添加发件人'
i18n['previous'] = '上一个'
i18n['printable'] = '可打印'
i18n['next'] = '下一个'
i18n['lookup'] = '地址'
i18n['quote'] = '引用原文'
i18n['new search'] = '修订'
i18n['add all addresses'] = '添加地址'
i18n['sharefolder toolbar'] = '共享'
i18n["attach_help"] = '帮助'

// Shared Folders
i18n["share folder"] = '共享文件夹'
i18n["Shared Folders Title"] = '设置文件夹访问权限'
i18n["SetPermissions Header"] = '文件夹:'
i18n["SetPermissions AddUser"] = '权限列表'
i18n["SetPermissions AddUser1"] = '若要与其他用户共享此文件夹，请使用“搜索”功能查找用户。'
i18n["SetPermissions Subtitle1"] = '输入一个用户 ID，然后单击“添加”。'
i18n["SetPermissions Searchtitle"] = '若要搜索某一用户，请单击“搜索”。'
i18n["SetPermissions subtitle2"] = '设置权限:'
i18n["SetPermissions info"] = '然后再设置该用户的权限。' 
i18n["SetPermissions read"] = '只读'
i18n["SetPermissions readwrite"] = '读写'
i18n["SetPermissions readwriteaccess"] = '读、写和管理访问权限'
i18n["SetPermissions User"] = '用户 ID'
i18n["SetPermissions Permission"] = '权限'
i18n["SetPermissions Delete"] = '去除'
i18n["SetPermissions ok"] = '确定'
i18n["SetPermissions apply"] = '应用'
i18n["SetPermissions cancel"] = '取消'
i18n["SetPermissions Help"] = '帮助'
i18n["SetPermissions Alert1"] = '用户已在列表中'
i18n["SetPermissions AddButton"] = '添加'
i18n["SetPermissions SearchButton"] = '搜索...'
i18n["SetPermissions Alert2"] = '请输入用户名'
i18n["SetPermissions subtitle3"] = '从列表中选择一个用户并单击“添加”'
i18n["SetPermissions subtitle4"] = '搜索用户'
i18n["SetPermissions selfadd"] = '不允许与您自己共享文件夹'
i18n["SetPermissions none"] = '无'
i18n["directdelivery"] = '允许将电子邮件直接传送至文件夹:  '
i18n["SetPermissions owneraddalert"] = '不允许与您自己共享文件夹'
i18n["SetPermissions SearchResultHeader"] = '请从下面的列表中选择用户'
i18n["SetPermissions nopermissionslaert"] = '您无权设置权限'
i18n["SetPermissions Remove"] = '去除'
i18n["SetPermissions InvalidUser"] = '无效用户'
i18n['SetPermissions anyone'] = '任何人'
i18n['Mail Delivery Address'] = '邮件传送地址'
i18n['Folders shared by '] = '共享的文件夹'
i18n[ 'All Shared folders'] =  '所有共享的文件夹'
i18n['Initial help text'] = '从上面的菜单选择要查看的文件夹。'

// Folders
i18n['fldr folders'] = '文件夹'
i18n['fldr personal'] = '个人文件夹'
i18n['fldr shared'] = '预定的共享文件夹'
i18n['fldr file header'] = '将所选文件夹移至'
i18n['fldr noinferiors'] = '不允许建立子文件夹'
i18n['fldr delete inbox'] = '系统文件夹 - 不能删除'
i18n['fldr move inbox'] = '系统文件夹 - 不能移动'
i18n['fldr noselect'] = '不能修改此文件夹。'
i18n['fldr cannotselect'] = '此文件夹不可选'
i18n['fldr empty trash'] = '清空废纸篓'
i18n['fldr messages'] = '邮件'
i18n['fldr nodelete'] = '不能重命名此文件夹。'
i18n['fldr exists']= '文件夹已存在。'
i18n['fldr select']= '选择一个文件夹。'
i18n['fldr nopermissions'] = '您不具备创建子文件夹的权限'
i18n['fldr nopermissionsdelete'] = '您不具备删除子文件夹的权限'
i18n['fldr unsubscribe'] = '无法取消预订的文件夹'
i18n['Folder Actions'] = '文件夹操作'

i18n['subscribe'] = '预订'
i18n['subscribe windowtitle'] = '预订共享文件夹'
i18n['unsubscribe'] = '取消预订'
i18n['Subscribe Header1'] = '共享的文件夹由其所有者管理。因此，请在下面输入所有者姓名、电子邮件地址'
i18n['Subscribe Header2'] = '或电话号码，并单击“搜索”。选择所需的文件夹，并单击“预订”'
i18n['No Unsubscribed Folders'] = '没有可预订的文件夹'
i18n['No Shared Folders'] = '此用户没有共享文件夹'
i18n['subscribe select'] = '选择'
i18n['subscribe Folder'] = '文件夹'
i18n['subscribe owner'] = '所有者'
i18n['subscribe searchHeader'] = '请从列表中选择用户 ID'
i18n['subscribe User ID'] = '用户 ID'
i18n['subscribe Name'] = '姓名'
i18n['subscribe E-Mail'] = '电子邮件'
i18n['subscribe owner Header'] = '所有者的'
i18n['subscribe search title'] = '选择用户 ID'
i18n['subscribe Search'] = '搜索'
i18n['subscribe Result'] = '预订搜索结果'

//Rtf
i18n['FontsizeLabel'] = '大小'
i18n['FontnameLabel'] = '字体'
i18n['Block Format'] = '段落'
i18n['ViewHTMLSource'] = '查看 HTML 源文件'
i18n['switchEditor']= '文本文件/HTML'
i18n['colorColorLabel'] = '颜色: '
i18n['colorOkLabel'] = '确定'
i18n['colorCancelLabel']= '取消'
i18n['emoCloseLabel'] = '关闭'
i18n['Smiley'] = '插入表情图标'
i18n['Cut'] = '剪切'
i18n['Copy'] = '复制'
i18n['Paste'] = '粘贴'
i18n['Bold'] = '粗体'
i18n['Italics'] = '斜体'
i18n['Underline'] = '下划线'
i18n['Change foreground color'] = '文字颜色'
i18n['Change Background color'] = '背景颜色'
i18n['Left Justify'] = '左对齐'
i18n['Center Justify'] = '居中对齐'
i18n['Right Justify'] = '右对齐'
i18n['Insert Ordered List'] = '编号列表'
i18n['Insert bullets'] = '项目符号列表'
i18n['Outdent'] = '减少缩进'
i18n['Indent'] = '增大缩进'
i18n['Create HyperLink'] = '插入超级链接'
i18n['make text left to right align'] = '使文本从左向右对齐'
i18n['make text right to left align'] = '使文本从右向左对齐'
i18n['all formatting will be lost'] = '所有格式都将丢失。是否继续？'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = '请取消选取“查看 HTML 源文件”以使用格式工具'
i18n['Compose in'] = '撰写格式'
i18n['Plain Text'] = '纯文本'
i18n['Rich Text (HTML)']= '多信息文本 (HTML)'

//Attach Dialog

i18n['Attach Header'] = '单击“浏览”选择要附加的文件，然后单击“添加”以将文件附加到此邮件。'
i18n['Attach Col1'] = '附加文件'
i18n['Attach Col2'] = '大小'
i18n['Attach Remove'] = '删除'
i18n['Attach Add'] = '添加'
i18n['Attachments'] = '附件'
i18n['Action'] = '操作'

//Tooltips

i18n['folder actions'] = '文件夹操作'
i18n['folder update'] = '更新文件夹'
i18n['folder new'] = '新建文件夹'
i18n['folder rename'] = '重命名文件夹'
i18n['folder share'] = '共享文件夹'
i18n['folder delete'] = '删除所选文件夹'
i18n['folder subscribe'] = '预订共享文件夹'
i18n['folder unsubscribe'] = '取消预订文件夹'
i18n['folder owner'] = '共享文件夹的所有者'
i18n['mbox getmail'] = '接收邮件'
i18n['mbox search'] = '搜索邮件'
i18n['mbox delete'] = '删除所选邮件'
i18n['mbox trash'] = '将所选邮件标记为删除'
i18n['mbox actions'] = '邮件处理'
i18n['mbox expunge'] = '清除'
i18n['mbox undelete'] = '取消删除'

i18n['seen up'] = '按邮件类型降序排序'
i18n['seen dn'] = '按邮件类型升序排序' 
i18n['recv up'] = '按接收日期降序排序'
i18n['recv dn'] = '按接收日期升序排序'
i18n['from up'] = '按邮件发件人降序排序'
i18n['from dn'] = '按邮件发件人升序排序'
i18n['size up'] = '按邮件大小降序排序'
i18n['size dn'] = '按邮件大小升序排序'
i18n['subj up'] = '按邮件主题降序排序'
i18n['subj dn'] = '按邮件主题升序排序'


i18n['name up'] = '按显示名称降序排序'
i18n['name dn'] = '按显示名称升序排序'
i18n['mail up'] = '按电子邮件地址降序排序'
i18n['mail dn'] = '按电子邮件地址升序排序'
i18n['attach dn'] = '按是否有附件升序排序'
i18n['attach up'] = '按是否有附件降序排序'
i18n['priority dn']  = '按邮件优先级升序排序'
i18n['priority up'] = '按邮件优先级降序排序'

i18n['msg compose'] = '撰写邮件'
i18n['msg reply'] = '回复邮件'
i18n['msg replyall'] = '回复全部邮件'
i18n['msg forward'] = '转发邮件'
i18n['msg delete'] = '删除邮件'
i18n['msg addall'] = '将所有地址添加到通讯录'
i18n['msg prev'] = '上一封邮件'
i18n['msg next'] = '下一封邮件'
i18n['msg close'] = '关闭邮件'
i18n['msg UnRead'] = '状态: 未阅读'
i18n['msg UnreadDel'] = '状态: 未阅读、已删除'
i18n['msg Read'] = '状态: 已阅读'
i18n['msg ReadDel'] = '状态: 已阅读、已删除'
i18n['msg ReadAns'] = '状态: 已阅读、已答复'
i18n['msg ReadAnsDel'] = '状态: 已阅读、已答复、已删除'
i18n['msg Attachment'] = '附件'
i18n['msg FullHeader'] = '查看详细邮件标题'
i18n['msg NormalHeader'] = '查看简短邮件标题'
i18n['msg priority'] = '优先级'
i18n['msg high'] = '优先级：紧急'
i18n['msg low'] = '优先级：不紧急'

i18n['Previous'] = '上一条'
i18n['Showing'] = '显示'
i18n['Messages'] = '邮件'
i18n['Next'] = '下一条'
i18n['of'] = '/'

i18n['pab update'] = '更新通讯录'
i18n['pab new'] = '新建联系人'
i18n['pab group'] = '新建组'
i18n['pab search'] = '搜索通讯录'
i18n['pab editgroup'] = '编辑组'

function prompt_delete_folder(m, i) {

var fname = m;
for(j=0; j < fldr.length; j++)
 {
   if(fldr[j] == m)
   {
      fname = fldr[j];
      break;
   }
}

  if (i > 0)
    return '删除文件夹“' + fname + '”和' + i + '封邮件吗？'
  else
    return '删除文件夹“' + fname + '”？'
}

function prompt_new_folder(m) {

var fname = m;
for(i=0; i < fldr.length; i++)
 {
   if(fldr[i] == m)
   {
      fname = fldr[i];
      break;
   }
}

  return '在下列位置创建名为' + fname + '的新文件夹:'
}

function prompt_rename_folder(f) {
  return '将文件夹“' + f + '”重命名为:'
}

function prompt_subscribe_folder() {
  return '预订文件夹:'
}

function prompt_unsubscribe_folder(f) {
  return '取消从文件夹“' + f + '”的预订:'
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return '永久清除' + fname + '中的邮件吗？'
}

// Mailbox
i18n['file selected msg'] = '将邮件移至文件夹'
i18n['copy selected msg'] = '将邮件复制到文件夹'
i18n['select folder'] = '选择文件夹'
i18n['mbox select all'] = '选择所有邮件'
i18n['confirm expunge'] = '是否要永久清除所选邮件？'
i18n['confirm expunge all'] = '未选择邮件。是否要永久清除所有已删除的邮件？'

function i18n_mbox_date(d, now, laurel) {
  var i, s, timeformat = 12

  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12;

  if (d.getDate() == now.getDate() && d.getMonth() == now.getMonth() &&
    d.getYear() == now.getYear()) {
    i = d.getHours()
    if (i == 0)
      s = 12
    else if (i < 13)
      s = i
    else {
      if(timeformat == 12)
      s = i - 12;
    else
      s = i;
    }
    s += ':'
    if (d.getMinutes() <= 9)
      s += '0'
    s += d.getMinutes()
    if(timeformat == 12)
    {
      if (i < 12)
         s = ' 上午' + s
    else
         s = ' 下午' + s
    }
  } else {
    i = d.getYear()
    if (i >= 2000)
      i -= 2000
    else if (i >= 100)
      i -= 100
    if (i < 10)
      i = '0' + i
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat'];
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimiter'] : '/';
      format = lformat ? lformat.charAt(0) : '0';
    }

    switch(format){
    case '0': case 'M':
           s = (d.getMonth() + 1) + deli + d.getDate() + deli + i;
           break;
    case '1': case 'D':
           s = d.getDate() + deli +(d.getMonth() + 1)  + deli + i;
           break;
    case '2': case 'Y':
           s = i + deli + (d.getMonth() + 1) + deli + d.getDate();
           break;
      }
    }
      return s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + '不包含任何邮件'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>' + total + ' 邮件' + (total > 1 ? 's' : '')
      if (unread == 0)
        s += ' (' + unread + ' 未阅读) -'
      else
        s += ' (<b>' + unread + ' 未阅读</b>) -'
      i = parseInt(used)
      s += '</nobr> <nobr>' + size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += '无限制'
      else
        s += size(i) + ' 限制'
      s += ')'
      s += ' -  ' + msgUsed + ' 邮件总数 ('
      if (msgLimit < 0)
        s += '无限制'
      else
        s += msgLimit + ' 限制'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = '无匹配项'
    else if (mboxFrame.sortid.length == 1)
      s = '1 个匹配项'
    else
      s = total + ' 个匹配项'
    s += '用于: '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() + ' ' +
      (val[0].length == 0 ? '包含' : '不包含') +
//      ' "' + val[2] + '"' + '在' + 
      ' "' + strflr + '"' + '在' +
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return '未选择邮件。\n清除 ' + fname + '中的所有已删除邮件？'
}

// Message
i18n['file msg'] = '将邮件移至文件夹:'
i18n['msg image'] = '[图像]'
i18n['msg file prefix'] = '文件:'
i18n['msg vcard'] = 'vCard'
i18n['msg signature'] = '数字签名'
i18n['msg encrypted'] = '已加密 (无法解码)'
i18n['msg brief'] = '查看简短邮件标题'
i18n['msg all'] = '查看详细邮件标题'

// Message Composition
i18n['fwd'] = '转发:'
i18n['re'] = '回复: '
i18n['attachment pending'] = '正在执行附加操作。请稍候'
i18n['cancel message'] = '关闭邮件并放弃更改？'
i18n['recipient'] = '收件人'
i18n['recipient mini help'] = '使用逗号将多个收件人分隔开。'
i18n['invalid addr'] = '电子邮件地址中包含无效字符'
i18n['no recipient'] = '此邮件没有列出收件人。请单击“收件人、“抄送”或“密件抄送”添加电子邮件地址。'
i18n['no subject confirm'] = '此邮件没有主题。是否仍要发送？'
i18n['original message'] = '原邮件'
i18n['reply text'] = '原邮件'
i18n['remove'] = '删除'
i18n['reply separator'] = '----- 原邮件 -----'
i18n['priority'] = '优先级'
i18n['priority n'] = '一般'
i18n['priority h'] = '紧急'
i18n['priority l'] = '不紧急'
i18n['receipt'] = '请求回执'
i18n['receipt n'] = '无'
i18n['receipt d'] = '发送时'
i18n['receipt r'] = '查看时'
i18n['receipt b'] = '两者'
i18n['no mail'] = '无电子邮件地址。不能发送邮件'
i18n['reply too long'] = '原邮件太大，无法引用。\n它将作为附件包含在邮件中。'
i18n['reply no text'] = 'Messenger Express 无法以纯文本格式引用原邮件。\n它将作为附件包含在邮件中。'
i18n['add empty t'] = '将此邮件发送到:'
i18n['add empty c'] = '将此邮件的副本发送到:'
i18n['add empty b'] = '将此邮件的密件副本发送到:'
i18n['sent status'] = '邮件传递成功'

// Return receipt
i18n['receipt request'] = '要求回执。是否发送确认信息？'
i18n['receipt subject'] = '回执 (已显示) - '

function i18n_receipt_text(from) {
  return '这是发送给\r\n' + from +
    '的邮件的回执。\r\n\r\n' +
    '注意: 该回执只说明邮件在\r\n' +
    '收件人的计算机上显示过。但不保证\r\n' +
    '内容已被阅读或理解。'
}

// Attachment
i18n['attach missing'] = '未选定文件'
i18n['attach empty'] = '空文件或无效文件'
i18n['attach msg canceled'] = '邮件已取消'
i18n['attach non ascii allowed'] = '无法附加具有非 ASCII 文件名的文件Cannot attach a file with non ASCII filename'
i18n['attach pending'] = '正在执行附加操作。单击“取消”可以中止...'
i18n['attach limited'] = '附件数量限定为'
i18n['attach maxlimit'] = '已达最大附件数'

function i18n_attach_msg() {
  return '<ul><li>单击<b>“浏览...”</b> ' +
    (IE >= 3 && IE < 4 ? '必须有 IE 文件上载修补程序' : '以选择文件。') + 
    '<li>选择文件后单击<b>“附加”</b>。' +
    '<li>文件传输完毕后，此窗口将关闭。' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = '接收'
i18n['collect long'] = '接收外部邮件'
i18n['collect host'] = 'POP 服务器'
i18n['collect user'] = 'POP 用户 ID'
i18n['collect pass'] = '密码'
i18n['collect folder'] = '保存到文件夹'
i18n['collect delete'] = '删除服务器中的邮件'
i18n['collect pending'] = '接收操作尚未完成。请稍候...'
i18n['collect no host'] = '必须指定 POP 服务器。'
i18n['collect no user'] = '必须指定用户 ID。'
i18n['collect no pass'] = '必须指定帐户密码。'
i18n['msg nocollect'] = '您不具备从此文件夹接收邮件的权限'

// LDAP Lookup
i18n['ldap givenname'] = '名字'
i18n['ldap sn'] = '姓氏'
i18n['ldap cn'] = '姓名'
i18n['ldap mail'] = '电子邮件'
i18n['ldap phone'] = '电话号码'
i18n['ldap searching'] = '正在搜索。请稍候...'
i18n['close'] = '关闭'

// Options
i18n['account summary'] = '帐户概要'
i18n['summary exp'] = '如果想修改以下任何信息，请与系统管理员联系。'
i18n['email addrs'] = '电子邮件地址'
i18n['email addrs exp'] = '您的帐户配置可使您接收发送到下列地址的邮件:'
i18n['quota'] = '配额'
i18n['quota exp'] = '您的系统管理员可能限制可用于邮件存储的磁盘空间容量。'
i18n['quota limit'] = '您的邮箱磁盘空间配额为:'
i18n['no limit'] = '无限制'
i18n['quota usage'] = '当前磁盘空间的使用量为:'
i18n['message quota limit'] = '您的邮件存储空间配额为:'
i18n['message quota usage'] = '您目前的邮件数为:'
i18n['password'] = '密码'
i18n['passwd exp'] = '使用此表格可以更改您用于访问 Messenger Express 的密码。'
i18n['passwd old'] = '1. 输入原密码:'
i18n['passwd new'] = '2. 输入新密码:'
i18n['passwd confirm'] = '3. 确认新密码:'
i18n['passwd again'] = '(用于确认)'
i18n['passwd submit'] = '更改密码'
i18n['clear'] = '重置'
i18n['new pass alert'] = '请输入新密码。'
i18n['old pass alert'] = '请输入原密码。'
i18n['pass mismatch alert'] = '您两次输入的新密码不匹配。请重新输入。'
i18n['pass changed'] = '密码已成功更改'
i18n['personal'] = '个人信息'
i18n['personal exp'] = '使用此表格可以更改个人信息。'
i18n['personal cn'] = '名称'
i18n['personal cn exp'] = '显示在外发邮件中:'
i18n['personal lang'] = '首选语言'
i18n['personal lang exp'] = '使用以下默认语言:'
i18n['personal lang changed'] = '您已更改您的首选语言。\n\n为了使这一变更生效，\n您需要退出系统，然后再重新登录。'
i18n['personal replyto'] = '回复地址'
i18n['personal replyto exp'] = '如果不同于 '
i18n['personal vcard'] = 'vCard'
i18n['personal vcard exp'] = '您的 vCard 包含以下信息:'
i18n['personal signature'] = '签名'
i18n['personal signature exp'] = '在您撰写的每封邮件中包含此文本:'
i18n['delivery'] = '发送'
i18n['vacation'] = '休假自动回复邮件'
i18n['vacation exp'] = '使用此表格可以设置自动回复功能，以在无法阅读电子邮件时自动回复。'
i18n['vacation toggle'] = '启用休假自动回复功能。'
i18n['vacation date format exp'] = ' (mm/dd/yyyy)'
i18n['vacation date separator'] = '/'
i18n['vacation invalid date'] = '日期无效'
i18n['vacation blank date error'] = '启用日期后，必须填写日期'
i18n['vacation date separator error'] = '所需格式为 mm/dd/yyyy'
i18n['vacation date character error'] = '无效字符'
i18n['vacation date year error'] = '年份无效'
i18n['vacation date month error'] = '月份无效'
i18n['vacation date day error'] = '日期无效'
i18n['vacation invalidautoreplytimeout'] = '天数无效'
i18n['vacation start exp'] = '于下列日期和时间启用休假通知: '
i18n['vacation end exp'] = '于下列日期和时间停止休假通知: '
i18n['vacation timeout exp'] = '回复同一发件人的间隔天数: '
i18n['vacation subject exp'] = '主题:'
i18n['vacation internal msg exp'] = '向内部发件人发送的休假自动回复邮件中将包括以下文本:'

i18n['vacation msg'] = '这是自动回复邮件。我在休假或由于其它原因无法阅读电子邮件。回来后我将阅读您的邮件。\n\n谢谢。'
i18n['vacation msg exp'] = '向外部发件人发送的休假自动回复邮件中将包括以下文本:（如果沒有特別的自动回复邮件給內部寄件者， 以下同样文字將作为您的自动回复邮件发送給內部寄件者）'
i18n['startgreaterend'] = '开始日期晚于结束日期'
i18n['notBeforeToday'] = '请输入一个日期 (不允许输入早于今天的日期)'
i18n['mdy']=' 月,日,年';
i18n['dmy']=' 日,月,年';
i18n['ymd']=' 年,月,日';
i18n['noReplyIfNoText']= '如果启用了休假自动回复功能，则自动回复邮件中必须要有内容，不能为空。'
i18n['settings'] = '设置'
i18n['settings exp'] = '使用该表格可以修改 Messenger Express 的设置。'
i18n['settings delete'] = '删除邮件'
i18n['settings exit empty'] = '退出时清空文件夹'
i18n['settings delete imap'] = '标记已删除的邮件 (使用' + i18n['expunge'] + '以永久删除)'
i18n['settings exit expunge'] = '退出时从“收件箱”中清除已删除的邮件'
i18n['settings draft'] = '邮件草稿'
i18n['settings sent'] = '已发送邮件'
i18n['settings delivery'] = '邮件转发'
i18n['settings forward'] = '将新邮件副本转发到 (每行一个地址):'
i18n['settings forward exp'] = '将新邮件副本转发到 (每行一个地址):'
i18n['settings forward enable'] = '启用转发'
i18n['settings no copy'] = '不在服务器上保留副本'
i18n['settings quote'] = '回复时引用原文'
i18n['settings quote exp'] = '回复时自动引用原邮件。'
i18n['appearance'] = '外观'
i18n['appearance exp'] = '使用该表格可以修改 Messenger Express 的外观。'
i18n['appearance colors'] = '颜色方案'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = '工具栏'
i18n['appearance bar both'] = '显示图标和文本'
i18n['appearance bar icons'] = '只显示图标'
i18n['appearance bar text'] = '只显示文本'
i18n['appearance page'] = '邮件列表视图'
i18n['appearance page exp'] = '每页显示 ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '<option value="100">100</option></select> 封邮件'
i18n['appearance sort'] = '邮件排序' +
  '<select name="meSortOrder"><option value="F">最早的排在最前面</option>' +
  '<option value="R">最早的排在最后面</option></select>'
i18n['appearance date exp'] = '日期'
i18n['appearance date format exp'] = '日期格式'+
  '<select name="meDateFormatFormat"><option value="0">月,日,年</option>' +
  '<option value="1">日,月,年</option>' +
  '<option value="2">年,日,月</option>' +
  '</select>'
i18n['appearance date delimiter exp'] = '分界符 '
i18n['appearance fonts'] = '显示字体'
i18n['appearance fonts face'] = '字体'
i18n['appearance fonts space'] = '间距'
i18n['serif'] = 'Serif'
i18n['sans serif'] = 'Sans Serif'
i18n['mono'] = 'Mono'
i18n['appearance fonts size'] = '大小'
i18n['appearance fonts xl'] = '最大'
i18n['appearance fonts l'] = '较大'
i18n['appearance fonts m'] = '默认'
i18n['appearance fonts s'] = '较小'
i18n['appearance fonts xs'] = '最小'
i18n['submit changes'] = '保存更改'
i18n['not changed'] = '未更改任何选项。'
i18n['success'] = '已成功更新帐户'
i18n['NDA'] = '委派的管理员'
i18n['filters'] = '邮件过滤器'
i18n['loadingFilters'] = '装入过滤器...'
i18n['InvalidMsgSizePrompt'] = '请输入邮件大小。';
i18n['InvalidMobileFwdPrompt'] = '输入数据无效或没有输入数据。请重新输入。';
i18n['InvalidFilterNamePrompt'] = '请输入有效的过滤器名称。';
i18n['DuplicateFilterPrompt'] = '过滤器名称重复。请输入不同的名称。';
i18n['InvalidSieveFormat'] = '过滤器格式无效。请向服务台寻求支持。';

function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  '是无效的电子邮件地址')
}

// Alerts
i18n['js error'] = 'JavaScript 错误'
i18n['line'] = '行'
i18n['login failed'] = '登录失败'
i18n['timeout'] = '会话超时。请重新登录'
i18n['FolderNameWithSpace'] = '文件夹名不能为空'
i18n['orphanwin'] = '窗口处于不不活动状态，无法继续'

// Time Arrays
var months = new Array('1', '2', '3', '4', '5', '6',
  '7', '8', '9', '10', '11', '12')
var days = new Array('星期日', '星期一', '星期二', '星期三', '星期四',
  '星期五', '星期六')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i >= 13)
    s = i - 12
  else
    s = i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  if (i < 12)
    s = '上午' + s
  else
    s = '下午' + s
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
return days[d.getDay()] + ', ' + i + ' 年 ' + months[d.getMonth()] + '月 ' + d.getDate() + '日' +', ' + i18n_time(d)

}


function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + 'As' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">搜索本地目录</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    '搜索 Netscape Netcenter</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'搜索 Bigfoot</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    '搜索 InfoSpace</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'搜索 Switchboard</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    '搜索 Verisign</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    '搜索 WhoWhere</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'搜索 Yahoo!</option>\n' +
    '</select>\n' +
    font() + '为满足以下条件的人员，其' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">全名</option>\n' +
    '<option value="givenname">名字</option>\n' +
    '<option value="sn">姓氏</option>\n' +
    '<option value="mail">电子邮件</option>\n' +
    '<option value="telephonenumber">电话号码</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() +
    '<select name="rule">\n' +
    '<option value="contains">包含</option>\n' +
    //'<option value="does not">不包含</option>\n' +
    '<option value="equal">是</option>\n' +
    //'<option value="not equal">不是</option>\n' +
    '<option value="sound">发音类似于</option>\n' +
    '<option value="begin">开头为</option>\n' +
    '<option value="end">结尾为</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
   return '<SELECT class="ActMenu" name=dir><option value="3 200">搜索公司目录</option>\n'+
          '</SELECT>'+main.font() + '&nbsp;用户，其'

  else if(what=='2')
   return '<SELECT  class="ActMenu" name=dir><option value="3 200">搜索公司目录</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">搜索个人通讯录</option>\n' : '' +
          '</select>\n' +
          main.font() + '联系人或组，搜索条件为'
 else if(what=='3')
   return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;选自资料夹&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">所有共享文件夹</option>\n' : '') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">按用户搜索共享文件夹</option>\n' : '') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('继续', '继续', "parent.subscribeOptions()") + '\n'
}



function i18n_ldap_no_match(attr, rule, value) {
  return '没有匹配的联系人' + attr.toLowerCase() + ' ' +
    rule.toLowerCase() + ' <b>' + html(value) + '</b>'
}

function i18n_ldap_match(end, attr, rule, value) {
  return end + '匹配' + (end == 1 ? '' : 'es') +
    '对于联系人，其' + attr.toLowerCase() + ' ' + rule.toLowerCase() +
    ' <b>' + html(value) + '</b>'
}

function i18n_search_list() {
  var width1
 
  if(NN > 0) {
    width1 = win ? 12 : 25;
  }
  else
    width1 = 30;
 
  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() + '搜索' +
      folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' 邮件，其中' +
    '</td>\n'+
   '<td>'+i18n['nbsp']+'</td>\n'+
   '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">发件人</option>\n' +
    '<option value="SUBJECT">主题</option>\n' +
    '<option value="BODY">正文</option>\n' +
    '<option value="TO">收件人</option>\n' +
    '</select>\n' +
    '<select name="rule">\n' +
    '<option value="">包含</option>\n' +
    '<option value="NOT ">不包含</option>\n' +
    '</select>\n' +
    '<input type=text name="string">\n'+
    main.nbutton('search', i18n['search'], "parent.doSearch()") + '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return '将已删除邮件移至' + folder
}

function i18n_settings_draft_folder(folder) {
  return '将邮件草稿保留在' + folder
}

function i18n_settings_sent_folder(folder) {
  return '发送邮件时，将副本保存在' + folder
}

function i18n_settings_wrap_width() {
  return '邮件文本在 <input size=2 name="meWrapWidth"> 字符处折行'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    '将 vCard 附加到邮件</td></tr>\n' +
    vc('名字', 'nf', 32) +
    vc('姓氏', 'nl', 32) +
    vc('全名', 'fn', 32) +
    vc('职位', 'ti', 32) +
    vc('组织', 'or', 32) +
    vc('部门', 'od', 32) +
    vc('电子邮件', 'ei', 32) +
    vc('主页', 'ur', 32) +
    vc('办公室电话', 'tw', 14) +
    vc('住宅电话', 'th', 14) +
    vc('传真', 'tf', 14) +
    vc('寻呼机', 'tp', 14) +
    vc('移动电话', 'tc', 14) +
    vc('地址', 'ad', 32) +
    vc('市/县/区', 'ci', 32) +
    vc('省/直辖市/自治区', 'st', 32) +
    vc('邮政编码', 'zi', 32) +
    vc('国家/地区', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='南非荷兰语'
i18n['ar']='阿拉伯语'
i18n['ca']='加泰罗尼亚语'
i18n['zh-CN']='简体中文'
i18n['zh-TW']='繁体中文'
i18n['cs']='捷克语'
i18n['hr']='克罗地亚语'
i18n['da']='丹麦语'
i18n['nl']='荷兰语'
i18n['en']='英语'
i18n['fi']='芬兰语'
i18n['fr']='法语'
i18n['gl']='加利西亚语'
i18n['de']='德语'
i18n['el']='希腊语'
i18n['he']='希伯来语'
i18n['hu']='匈牙利语'
i18n['is']='冰岛语'
i18n['ga']='爱尔兰语'
i18n['it']='意大利语'
i18n['ja']='日语'
i18n['ko']='朝鲜语'
i18n['no']='挪威语'
i18n['pl']='波兰语'
i18n['pt']='葡萄牙语'
i18n['ro']='罗马尼亚语'
i18n['sk']='斯洛伐克语'
i18n['sl']='斯洛文尼亚语'
i18n['es']='西班牙语'
i18n['sv']='瑞典语'
i18n['th']='泰语'
i18n['tr']='土耳其语'

function i18n_preferredlanguagelist()
{   
    var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr');
    var s = '<select name="preferredLanguage">';
    for (i=0; i<lang_list.length; i++)
	s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>';
    return s+'</select>'
}

function i18n_search_options()
{

var s = '<select name="attr" size="1">' +
        '<option value="cn">全名</option>' +
        '<option value="givenname">名字</option>' +
        '<option value="sn">姓氏</option>' +
        '<option value="mail">电子邮件</option>' +
        '<option value="uid">用户 ID</option>' +
        '<option value="telephonenumber">电话号码</option>\n' +
        '</select>' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">包含</option>' +
        '<option value="equal">是</option>\n' +
        '<option value="begin">开头为</option>\n' +
        '<option value="sound">发音类似于</option>' +
        '<option value="end">结尾为</option>' +
        '</select>'
  return s;
}
function i18n_month_list()
{
    var s=''
    for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'</option>'
    }
    return s
}

function i18n_day_list()
{
    var s=''
    for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'</option>'
    }
    return s
}
function i18n_year_list()
{
    var s=''
    var d= new Date();
    var year=d.getYear();

    for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
    }
    return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = '通讯录'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'

i18n['Current Folder'] = '当前文件夹'
i18n['Mail'] = '邮件'
i18n['Calendar'] = '日历'
i18n['Options'] = '选项'
i18n['Address Book'] = '通讯录'
