// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='Rechtschreibprüfung'
i18n['settings autospell exp']='Rechtschreibung immer prüfen, bevor eine Nachricht gesendet wird'
i18n['spellok']='OK'
i18n['AutoSpellCheck']='Rechtschreibung vor dem Senden der Nachricht prüfen'
i18n['spell error']='Serverfehler: Rechtschreibprüfung nicht möglich'
i18n['spelldicterror']='Serverfehler: Sprachwörterbuch nicht verfügbar'
i18n['select  comp lang']='Sprache auswählen'
i18n['spelldict']='Wörterbuch'
i18n['spell change'] = '&nbsp;&nbsp;Wechseln&nbsp;&nbsp;&nbsp;'
i18n['spell changeall'] = 'Alle ändern'
i18n['spell ignoreall'] = '&nbsp;Alle ignorieren&nbsp;'
i18n['spell_progress']='Bitte warten. Die Rechtschreibprüfung startet sofort.'
i18n['send_progress']='Sendevorgang läuft';
i18n['spell_no_mistakes']=" Keine fehlerhaften Wörter";
i18n['spell_select_lang']="Wählen Sie eine Sprache aus";
i18n['spell_nothing']='Nichts zu überprüfen';
i18n['send_anyway']= 'Die Nachricht enthält Wörter, die die Rechtschreibprüfung nicht erkennt. Möchten Sie sie dennoch senden?'
i18n['done_anyway']= 'Die Nachricht enthält Wörter, die die Rechtschreibprüfung noch immer nicht erkennt.'
i18n['spell_window_title']='Nachricht auf Rechtschreibung prüfen'
i18n['spell yes']="Ja"
i18n['spell no']="Nein"
i18n['spelltool done']="Fertig"
i18n['spelltool help']=" Hilfe "
i18n['No Suggestions']='Keine Vorschläge'
i18n['Suggestions']='Vorschläge'

//SMIME
i18n['smime not available']='Die SMIME-Konfiguration ist unvollständig oder das Applet wurde nicht geladen'
i18n['smime recipients failure']='Fehler beim Hinzufügen des Empfängers:'
i18n['Signed Message']='Nachricht mit Signatur'
i18n['Invalid Signature']='Ungültige Signatur'
i18n['Invalid Encryption']='Ungültige Verschlüsselung'
i18n['Encrypted Message']='Verschlüsselte Nachricht'
i18n['url_error']="Fehler beim Hinzufügen der URL"

// Compose window toolbar
i18n['compose_send']='Nachricht senden'
i18n['compose_attach']='Datei an Nachricht anhängen'
i18n['compose_spell']='Nachricht auf Rechtschreibung prüfen'
i18n['compose_editor']='Editor wechseln (Nur-Text oder HTML)'




// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = 'Laden: Bitte warten...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = 'Auswählen'
i18n['Select All']= 'Alles auswählen'
i18n['Deselect All']= 'Auswahl aufheben'
i18n['no msg'] = 'Dieser Ordner enthält keine Nachricht.'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = 'Eingang'
fldr['Trash'] = 'Papierkorb'
fldr['Drafts'] = 'Entwürfe'
fldr['Sent'] = 'Gesendet'
fldr['Sent Items'] = 'Gesendete Objekte'

// Window titles
i18n['app title'] = 'Mail - Communications Express'
i18n['sjs app title'] = 'Sun Java&#153; System Messenger Express'
i18n['attach title'] = 'Datei anhängen'
i18n['collect title'] = 'Externe Mails abrufen'
i18n['compose title'] = 'Neue Nachricht'
i18n['lookup title'] = 'LDAP-Suche'
i18n['receipt title'] = 'Empfangsbestätigung'
i18n['editgroup title'] = 'Gruppe aktualisieren'
i18n['editentry title'] = 'Kontakt aktualisieren'
i18n['newgroup title'] = 'Neue Gruppe'
i18n['newentry title'] = 'Neuer Kontakt'
i18n['comprecipient title'] = 'Empfänger im persönlichen Adressbuch auswählen'

// Tabs
i18n['folders'] = 'Ordner'
i18n['message'] = 'Mitteilung'
i18n['pab'] = 'Adressen'
i18n['options'] = 'Optionen'
i18n['search results'] = 'Suchergebnisse'
i18n['searching'] = 'Suchen...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='Rechtschreibprüfung'

function i18n_tab_header(user) {
  return '<nobr>&nbsp;&nbsp;Willkommen ' + user + '</nobr>'
}

function i18n_quota_warning(percent) {
  return 'WARNUNG: Sie bewegen sich derzeit bei ' + percent +
         ' % Ihres Speicherplatzes..'
}
function i18n_maxsize(maxsize) {
  return '(Die maximale Größe des Anhangs sollte nicht größer sein als ' + maxsize +
         ' KB.)'
}
function i18n_msgQuota_warning(percent) {
  return 'WARNUNG: Sie bewegen sich derzeit bei ' + percent +
         ' % Ihres Speicherplatzes für Nachrichten.'
}

// Error Messages

i18n['fldr selfmove'] = 'Ein Ordner kann nicht in sich selbst verschoben werden' 
i18n['fldr noinbox'] = 'Die Erstellung eines Unterordners im EINGANG ist nicht zulässig'
i18n['mbox nopermission'] = 'Sie verfügen nicht über die erforderlichen Rechte, um diese Nachrichten in diesen Ordner zu verschieben'
i18n['mbox selfmove'] = 'Die Nachricht kann nicht in einen Ordner verschoben werden, in dem sie sich bereits befindet'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']

// Message Headers
i18n['selected'] = 'Ausgewählt'
i18n['seen'] = 'Gesehen'
i18n['from'] = 'Von'
i18n['date'] = 'Datum'
i18n['recvdate'] = 'Empfangen'
i18n['sentdate'] = 'Gesendet'
i18n['to'] = 'Bis'
i18n['cc'] = 'Cc'
i18n['bcc'] = 'Bcc'
i18n['subject'] = 'Betreff'
i18n['attachments'] = 'Anhänge'
i18n['size'] = 'Größe'
i18n['unread'] = 'Nicht gelesen'
i18n['no subject'] = '[ Kein Betreff ]'
i18n['duplicates ignored'] = ' Doppelte ignoriert'
i18n['search invalidfolder'] = 'Ungültiger Ordner ausgewählt. Wählen Sie einen gültigen Ordner für die Suche aus.'

// Tool Bars
i18n['delete'] = 'Löschen'
i18n['undelete'] = 'Wiederherstellen'
i18n['expunge'] = 'Endgültig löschen'
i18n['rename'] = 'Umbenennen'
i18n['new folder'] = 'Neu'
i18n['subscribe'] = 'Freigabe'
i18n['help'] = 'Hilfe'
i18n['logout'] = 'Abmelden'
i18n['home'] = 'Privat'
i18n['attach'] = 'Anhängen'
i18n['draft'] = 'Entwurf speichern'
i18n['send'] = 'Senden'
i18n['cancel'] = 'Abbrechen'
i18n['compose_help']= 'Hilfe'
i18n['compose'] = 'Neue Nachricht'
i18n['search'] = 'Suchen'
i18n['get mail'] = 'Mail abrufen'
i18n['update'] = 'Aktualisieren'
i18n['forward'] = 'Weiterleiten'
i18n['reply'] = 'Antwort'
i18n['reply all'] = 'Antwort an alle'
i18n['add sender'] = 'Absender hinzufügen'
i18n['previous'] = 'Zurück'
i18n['printable'] = 'Druckansicht'
i18n['next'] = 'Nächste'
i18n['lookup'] = 'Adresse'
i18n['quote'] = 'Zitat'
i18n['new search'] = 'Überarbeiten'
i18n['add all addresses'] = 'Adressen hinzufügen'
i18n['sharefolder toolbar'] = 'Freigabe'
i18n["attach_help"] = 'Hilfe'

// Shared Folders
i18n["share folder"] = 'Ordner freigeben'
i18n["Shared Folders Title"] = 'Berechtigungen für Ordner festlegen'
i18n["SetPermissions Header"] = 'Ordner:'
i18n["SetPermissions AddUser"] = 'Berechtigungsliste '
i18n["SetPermissions AddUser1"] = 'Um diesen Ordner für andere Benutzer freizugeben, verwenden Sie die Option \"Suche\", um einen Benutzer zu lokalisieren.'
i18n["SetPermissions Subtitle1"] = 'Geben Sie eine Benutzer-ID ein und klicken Sie dann auf \"Hinzufügen\".'
i18n["SetPermissions Searchtitle"] = 'Um nach einem Benutzer zu suchen, klicken Sie auf \"Suche\".'
i18n["SetPermissions subtitle2"] = 'Berechtigungen festlegen:'
i18n["SetPermissions info"] = 'Legen Sie anschließend die Berechtigungen für den Benutzer fest.' 
i18n["SetPermissions read"] = 'Schreibgeschützt'
i18n["SetPermissions readwrite"] = 'Lesen und schreiben'
i18n["SetPermissions readwriteaccess"] = 'Lesen, schreiben und Verwaltungszugriff'
i18n["SetPermissions User"] = 'Benutzerkennung'
i18n["SetPermissions Permission"] = 'Berechtigungen'
i18n["SetPermissions Delete"] = 'Entfernen'
i18n["SetPermissions ok"] = 'OK'
i18n["SetPermissions apply"] = 'Anwenden'
i18n["SetPermissions cancel"] = 'Abbrechen'
i18n["SetPermissions Help"] = 'Hilfe'
i18n["SetPermissions Alert1"] = 'Der Benutzer ist bereits in der Liste vorhanden'
i18n["SetPermissions AddButton"] = 'Hinzufügen'
i18n["SetPermissions SearchButton"] = 'Suchen... '
i18n["SetPermissions Alert2"] = 'Geben Sie den Benutzernamen ein'
i18n["SetPermissions subtitle3"] = 'Wählen Sie einen Benutzer in der Liste aus und klicken Sie auf "Hinzufügen"'
i18n["SetPermissions subtitle4"] = 'Nach Benutzern suchen'
i18n["SetPermissions selfadd"] = 'Die Freigabe eines Ordners für Sie selbst ist nicht zulässig'
i18n["SetPermissions none"] = 'Keine'
i18n["directdelivery"] = 'Direkte Zustellung von E-Mails an folgenden Ordner aktivieren:  '
i18n["SetPermissions owneraddalert"] = 'Die Freigabe eines Ordners für Sie selbst ist nicht zulässig'
i18n["SetPermissions SearchResultHeader"] = 'Wählen Sie die Benutzer in der nachfolgenden Liste aus'
i18n["SetPermissions nopermissionslaert"] = 'Sie verfügen nicht über die erforderlichen Rechte, um Berechtigungen festzulegen'
i18n["SetPermissions Remove"] = 'Entfernen'
i18n["SetPermissions InvalidUser"] = 'Ungültiger Benutzer'
i18n['SetPermissions anyone'] = 'jeder'
i18n['Mail Delivery Address'] = 'Mail-Zustellungsadresse'
i18n['Folders shared by '] = 'Ordner, freigegeben von '
i18n[ 'All Shared folders'] =  'Alle freigegebenen Ordner'
i18n['Initial help text'] = 'Wählen Sie aus dem obigen Menü die Ordner, die angezeigt werden sollen.'

// Folders
i18n['fldr folders'] = 'Ordner'
i18n['fldr personal'] = 'Persönliche Ordner'
i18n['fldr shared'] = 'Abonnierte freigegebene Ordner'
i18n['fldr file header'] = 'Ausgewählten Ordner verschieben nach'
i18n['fldr noinferiors'] = 'Unterordner nicht zulässig'
i18n['fldr delete inbox'] = 'Systemordner - kann nicht gelöscht werden'
i18n['fldr move inbox'] = 'Systemordner - kann nicht verschoben werden'
i18n['fldr noselect'] = 'Dieser Ordner kann nicht geändert werden.'
i18n['fldr cannotselect'] = 'Dieser Ordner kann nicht ausgewählt werden'
i18n['fldr empty trash'] = 'Leerer Papierkorb'
i18n['fldr messages'] = 'Nachrichten'
i18n['fldr nodelete'] = 'Dieser Ordner kann nicht umbenannt werden.'
i18n['fldr exists']= 'Der Ordner ist bereits vorhanden.'
i18n['fldr select']= 'Wählen Sie einen Ordner aus.'
i18n['fldr nopermissions'] = 'Sie verfügen nicht über die Berechtigung zur Erstellung eines Unterordners'
i18n['fldr nopermissionsdelete'] = 'Sie verfügen nicht über die Berechtigung zum Löschen eines Unterordners'
i18n['fldr unsubscribe'] = 'Der Ordner kann nicht abgemeldet werden'
i18n['Folder Actions'] = 'Ordneraktionen'

i18n['subscribe'] = 'Abonnieren'
i18n['subscribe windowtitle'] = 'Freigegebene Ordner abonnieren'
i18n['unsubscribe'] = 'Abmelden'
i18n['Subscribe Header1'] = 'Freigegebene Ordner sind nach ihrem Eigentümer sortiert. Geben Sie deshalb unten den Namen des Eigentümers, die E-Mail-Adresse'
i18n['Subscribe Header2'] = ' oder die Telefonnummer ein und klicken Sie auf \"Suche\". Wählen Sie die gewünschten Ordner aus und klicken Sie auf \"Abonnieren\".'
i18n['No Unsubscribed Folders'] = 'Keine Ordner zum Abonnieren vorhanden'
i18n['No Shared Folders'] = 'Für diesen Benutzer sind keine freigegebenen Ordner vorhanden'
i18n['subscribe select'] = 'Auswählen'
i18n['subscribe Folder'] = 'Ordner'
i18n['subscribe owner'] = 'Eigentümer'
i18n['subscribe searchHeader'] = 'Wählen Sie die Benutzer-ID in der Liste aus'
i18n['subscribe User ID'] = 'Benutzerkennung'
i18n['subscribe Name'] = 'Name'
i18n['subscribe E-Mail'] = 'E-Mail'
i18n['subscribe owner Header'] = 'Eigentümer'
i18n['subscribe search title'] = 'Benutzer-ID auswählen'
i18n['subscribe Search'] = 'Suchen'
i18n['subscribe Result'] = 'Suchergebnis abonnieren für '

//Rtf
i18n['FontsizeLabel'] = 'Größe'
i18n['FontnameLabel'] = 'Schriftart'
i18n['Block Format'] = 'Absatz'
i18n['ViewHTMLSource'] = 'HTML-Quelle anzeigen'
i18n['switchEditor']= 'Text/HTML'
i18n['colorColorLabel'] = 'Farbe: '
i18n['colorOkLabel'] = ' OK '
i18n['colorCancelLabel']= ' Abbrechen '
i18n['emoCloseLabel'] = ' Schließen '
i18n['Smiley'] = 'Emoticon einfügen'
i18n['Cut'] = 'Ausschneiden'
i18n['Copy'] = 'Kopieren'
i18n['Paste'] = 'Einfügen'
i18n['Bold'] = 'Fett'
i18n['Italics'] = 'Kursiv'
i18n['Underline'] = 'Unterstrichen'
i18n['Change foreground color'] = 'Textfarbe'
i18n['Change Background color'] = 'Hintergrundfarbe'
i18n['Left Justify'] = 'Links ausrichten'
i18n['Center Justify'] = 'Zentriert ausrichten'
i18n['Right Justify'] = 'Rechts ausrichten'
i18n['Insert Ordered List'] = 'Liste mit Nummern'
i18n['Insert bullets'] = 'Liste mit Punkten'
i18n['Outdent'] = 'Einzug verkleinern '
i18n['Indent'] = 'Einzug vergrößern'
i18n['Create HyperLink'] = 'HyperLink einfügen'
i18n['make text left to right align'] = 'Text von links nach rechts ausrichten'
i18n['make text right to left align'] = 'Text von rechts nach links ausrichten'
i18n['all formatting will be lost'] = 'Jegliche Formatierung geht verloren. Möchten Sie fortfahren?'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = 'Deaktivieren Sie die Option "HTML-Quelle anzeigen", um die Formatierungswerkzeuge zu verwenden'
i18n['Compose in'] = 'Verfassen in '
i18n['Plain Text'] = 'Nur Text'
i18n['Rich Text (HTML)']= 'Rich Text (HTML)'
//Attach Dialog

i18n['Attach Header'] = 'Klicken Sie auf "Durchsuchen", um eine Datei auszuwählen, die Sie anhängen möchten. Klicken Sie dann auf "Hinzufügen", um die Datei an diese Nachricht anzuhängen.'
i18n['Attach Col1'] = 'Dateianlage'
i18n['Attach Col2'] = 'Größe'
i18n['Attach Remove'] = 'Entfernen'
i18n['Attach Add'] = 'Hinzufügen'
i18n['Attachments'] = 'Anhänge'
i18n['Action'] = 'Aktion'

//Tooltips
i18n['folder actions'] = 'Ordneraktionen'
i18n['folder update'] = 'Ordner aktualisieren'
i18n['folder new'] = 'Neuer Ordner'
i18n['folder rename'] = 'Ordner umbenennen'
i18n['folder share'] = 'Ordner freigeben'
i18n['folder delete'] = 'Ausgewählten Ordner löschen'
i18n['folder subscribe'] = 'Freigegebenen Ordner abonnieren'
i18n['folder unsubscribe'] = 'Ordner abmelden'
i18n['folder owner'] = 'Eigentümer der freigegebenen Ordner'
i18n['mbox getmail'] = 'Mail abrufen'
i18n['mbox search'] = 'Nachrichten durchsuchen'
i18n['mbox delete'] = 'Ausgewählte Nachrichten löschen'
i18n['mbox trash'] = 'Ausgewählte Nachricht als gelöscht markieren'
i18n['mbox actions'] = 'Aktionen für Nachrichten'
i18n['mbox expunge'] = 'Endgültig löschen'
i18n['mbox undelete'] = 'Wiederherstellen'

i18n['seen up'] = 'Absteigend nach Nachrichtentyp sortieren'
i18n['seen dn'] = 'Aufsteigend nach Nachrichtentyp sortieren' 
i18n['recv up'] = 'Absteigend nach Empfangsdatum sortieren '
i18n['recv dn'] = 'Aufsteigend nach Empfangsdatum sortieren'
i18n['from up'] = 'Absteigend nach Absender der Nachricht sortieren'
i18n['from dn'] = 'Aufsteigend nach Absender der Nachricht sortieren'
i18n['size up'] = 'Absteigend nach Nachrichtengröße sortieren'
i18n['size dn'] = 'Aufsteigend nach Nachrichtengröße sortieren'
i18n['subj up'] = 'Absteigend nach Betreff der Nachricht sortieren'
i18n['subj dn'] = 'Aufsteigend nach Betreff der Nachricht sortieren'


i18n['name up'] = 'Absteigend nach Anzeigename sortieren'
i18n['name dn'] = 'Aufsteigend nach Anzeigename sortieren'
i18n['mail up'] = 'Absteigend nach E-Mail-Adresse sortieren'
i18n['mail dn'] = 'Aufsteigend nach E-Mail-Adresse sortieren'
i18n['attach dn'] = 'Aufsteigend nach vorhandenen Anhängen sortieren'
i18n['attach up'] = 'Absteigend nach vorhandenen Anhängen sortieren'
i18n['priority dn']  = 'Aufsteigend nach Priorität der Nachricht sortieren'
i18n['priority up'] = 'Absteigend nach Priorität der Nachricht sortieren'

i18n['msg compose'] = 'Nachricht verfassen'
i18n['msg reply'] = 'Auf Nachricht antworten'
i18n['msg replyall'] = 'Allen auf Nachricht antworten'
i18n['msg forward'] = 'Nachricht weiterleiten'
i18n['msg delete'] = 'Nachricht löschen'
i18n['msg addall'] = 'Alle Adressen im Adressbuch hinzufügen'
i18n['msg prev'] = 'Vorherige Nachricht'
i18n['msg next'] = 'Nächste Nachricht'
i18n['msg close'] = 'Nachricht schließen'
i18n['msg UnRead'] = 'Status: Nicht gelesen'
i18n['msg UnreadDel'] = 'Status: Nicht gelesen, gelöscht'
i18n['msg Read'] = 'Status: Gelesen'
i18n['msg ReadDel'] = 'Status: Gelesen, gelöscht'
i18n['msg ReadAns'] = 'Status: Gelesen, beantwortet'
i18n['msg ReadAnsDel'] = 'Status: Gelesen, beantwortet, gelöscht'
i18n['msg Attachment'] = 'Anhang'
i18n['msg FullHeader'] = 'Details des Nachrichten-Headers anzeigen'
i18n['msg NormalHeader'] = 'Kurzen Nachrichten-Header anzeigen'
i18n['msg priority'] = 'Priorität'
i18n['msg high'] = 'Priorität: Hoch'
i18n['msg low'] = 'Priorität: Gering'

i18n['Previous'] = 'Vorheriges'
i18n['Showing'] = 'Anzeigend'
i18n['Messages'] = 'E-Mailen'
i18n['Next'] = 'Nächste'
i18n['of'] = 'von'

i18n['pab update'] = 'Adressbuch aktualisieren'
i18n['pab new'] = 'Neuer Kontakt'
i18n['pab group'] = 'Neue Gruppe'
i18n['pab search'] = 'Adressbuch durchsuchen'
i18n['pab editgroup'] = 'Gruppe bearbeiten'

function prompt_delete_folder(m, i) {

var fname = m;
for(j=0; j < fldr.length; j++)
 {
   if(fldr[j] == m)
   {
      fname = fldr[j];
      break;
   }
}

  if (i > 0)
    return 'Ordner "' + fname + '" und  ' + i + ' Nachrichten löschen?'
  else
    return 'Ordner löschen "' + fname + '"?'
}

function prompt_new_folder(m) {

var fname = m;
for(i=0; i < fldr.length; i++)
 {
   if(fldr[i] == m)
   {
      fname = fldr[i];
      break;
   }
}

  return 'Neuen Ordner in ' + fname + ' mit folgendem Namen erstellen:'
}

function prompt_rename_folder(f) {
  return 'Ordner "' + f + '" umbenennen in:'
}

function prompt_subscribe_folder() {
  return 'Ordner abonnieren:'
}

function prompt_unsubscribe_folder(f) {
  return 'Von folgendem Ordner abmelden: "' + f + '":'
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'Alle Nachrichten dauerhaft löschen in ' + fname + '?'
}

// Mailbox
i18n['file selected msg'] = 'Nachrichten in Ordner verschieben'
i18n['copy selected msg'] = 'Nachrichten kopieren in Ordner'
i18n['select folder'] = 'Ordner auswählen'
i18n['mbox select all'] = 'Alle Nachrichten auswählen'
i18n['confirm expunge'] = 'Alle ausgewählten Nachrichten dauerhaft löschen?'
i18n['confirm expunge all'] = 'Keine Nachrichten ausgewählt. Alle gelöschten Nachrichten dauerhaft entfernen?'

function i18n_mbox_date(d, now, laurel) {
  var i, s, timeformat = 12

  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12;

  if (d.getDate() == now.getDate() && d.getMonth() == now.getMonth() &&
    d.getYear() == now.getYear()) {
    i = d.getHours()
    if (i == 0)
      s = 12
    else if (i < 13)
      s = i
    else {
      if(timeformat == 12)
        s = i - 12;
      else
        s = i;
    }
    s += ':'
    if (d.getMinutes() <= 9)
      s += '0'
    s += d.getMinutes()
    if(timeformat == 12)
    {
    if (i < 12)
      s += ' am'
    else
      s += ' pm'
    }
  } else {
    i = d.getYear()
    if (i >= 2000)
      i -= 2000
    else if (i >= 100)
      i -= 100
    if (i < 10)
      i = '0' + i
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat'];
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimiter'] : '/';
      format = lformat ? lformat.charAt(0) : '0';
    }

    switch(format){
      case '0': case 'M':
           s = (d.getMonth() + 1) + deli + d.getDate() + deli + i;
           break;
      case '1': case 'D':
           s = d.getDate() + deli +(d.getMonth() + 1)  + deli + i;
           break;
      case '2': case 'Y':
           s = i + deli + (d.getMonth() + 1) + deli + d.getDate();
           break;
    }
  }
  return s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + ' enthält keine Nachrichten'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>' + total + ' Nachricht' + (total > 1 ? 'en' : '')
      if (unread == 0)
        s += ' (' + unread + ' nicht gelesen) -'
      else
        s += ' (<b>' + unread + ' nicht gelesen</b>) -'
      i = parseInt(used)
      s += '</nobr> <nobr>' + size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += 'keine Einschränkung'
      else
        s += size(i) + ' Einschränkung'
      s += ')'
      s += ' -  ' + msgUsed + ' Nachrichten gesamt ('
      if (msgLimit < 0)
        s += 'keine Einschränkung'
      else
        s += msgLimit + ' Einschränkung'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = 'Keine Übereinstimmungen'
    else if (mboxFrame.sortid.length == 1)
      s = '1 Übereinstimmung'
    else
      s = total + ' Übereinstimmungen'
    s += ' for: '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() + ' ' +
      (val[0].length == 0 ? 'enthält' : 'enthält nicht') +
//      ' "' + val[2] + '"' + ' Ein ' + 
      ' "' + strflr + '"' + ' Ein ' +
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'Keine Nachrichten ausgewählt.\nAlle gelöschten Nachrichten entfernen in ' + fname + '?'
}

// Message
i18n['file msg'] = 'Nachricht in Ordner verschieben:'
i18n['msg image'] = '[Bild]'
i18n['msg file prefix'] = 'Datei:'
i18n['msg vcard'] = 'Visitenkarte'
i18n['msg signature'] = 'Digitale Signatur'
i18n['msg encrypted'] = 'Verschlüsselt (Entschlüsselung nicht möglich)'
i18n['msg brief'] = 'Kurze Nachrichten-Header anzeigen'
i18n['msg all'] = 'Details des Nachrichten-Headers anzeigen'

// Message Composition
i18n['fwd'] = 'Fwd: '
i18n['re'] = 'Re: '
i18n['attachment pending'] = 'Ausstehende Anhänge. Bitte warten'
i18n['cancel message'] = 'Nachricht schließen und Änderungen verwerfen?'
i18n['recipient'] = 'Empfänger'
i18n['recipient mini help'] = 'Trennen Sie mehrere Empfänger durch Kommata.'
i18n['invalid addr'] = 'Die E-Mail-Adresse enthält ungültige Zeichen'
i18n['no recipient'] = 'Für diese Nachricht sind keine Empfänger aufgelistet. Klicken Sie auf "An", "Cc" oder "Bcc", um eine E-Mail-Adresse hinzuzufügen.'
i18n['no subject confirm'] = 'Für diese Nachricht ist kein Betreff vorhanden. Möchten Sie sie dennoch senden? '
i18n['original message'] = 'Ursprüngliche Nachricht'
i18n['reply text'] = 'Ursprüngliche Nachricht'
i18n['remove'] = 'Entfernen'
i18n['reply separator'] = '----- Ursprüngliche Nachricht -----'
i18n['priority'] = 'Priorität'
i18n['priority n'] = 'Normal'
i18n['priority h'] = 'Hoch'
i18n['priority l'] = 'Gering'
i18n['receipt'] = 'Empfangsbestätigung'
i18n['receipt n'] = 'Keine'
i18n['receipt d'] = 'Bei Zustellung'
i18n['receipt r'] = 'Nach Anzeige'
i18n['receipt b'] = 'Beides'
i18n['no mail'] = 'Keine Mail-Adressen. Nachrichten können nicht gesendet werden'
i18n['reply too long'] = 'Die ursprüngliche Nachricht ist zu lang für ein Zitat\nSie wird als Anhang angefügt.'
i18n['reply no text'] = 'Messenger Express kann die ursprüngliche Nachricht nicht im Nur-Text-Format zitieren.\nSie wird als Anhang angefügt.'
i18n['add empty t'] = 'Diese Nachricht senden an:'
i18n['add empty c'] = 'Eine Kopie dieser Nachricht senden an:'
i18n['add empty b'] = 'Eine Blindkopie dieser Nachricht senden an:'
i18n['sent status'] = 'Mail erfolgreich übermittelt'

// Return receipt
i18n['receipt request'] = 'Empfangsbestätigung angefordert. Bestätigung senden?'
i18n['receipt subject'] = 'Empfangsbestätigung (angezeigt) - '

function i18n_receipt_text(from) {
  return 'Dies ist eine Empfangsbestätigung für die gesendete Mail an\r\n' + from +
    '.\r\n\r\n' +
    'Hinweis: Durch diese Empfangsbestätigung wird lediglich angegeben, dass die Nachricht\r\n' +
    'auf dem Computer des Empfängers angezeigt wurde. Es kann nicht garantiert werden, dass der\r\n' +
    'Inhalt gelesen und verstanden wurde.'
}

// Attachment
i18n['attach missing'] = 'Keine Datei ausgewählt'
i18n['attach empty'] = 'Leere oder ungültige Datei'
i18n['attach msg canceled'] = 'Nachricht abgebrochen'
i18n['attach non ascii allowed'] = 'Es kann keine Datei mit einem anderen als einem ASCII-Dateinamen angehängt werden'
i18n['attach pending'] = 'Ausstehender Anhang. Zum Abbrechen "Abbrechen" verwenden...'
i18n['attach limited'] = 'Anhänge sind begrenzt auf '
i18n['attach maxlimit'] = 'Maximale Anzahl der Anhänge erreicht'

function i18n_attach_msg() {
  return '<ul><li>Klicken Sie auf <b>Durchsuchen...</b> ' +
    (IE >= 3 && IE < 4 ? 'Zum Auswählen einer Datei muss das IE-Dateiupload-Patch ' : ' vorhanden sein.') + 
    '<li>Klicken Sie auf <b>Anhängen</b>, nachdem Sie eine Datei ausgewählt haben.' +
    '<li>Dieses Fenster wird geschlossen, wenn die Übertragung abgeschlossen ist.' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = 'Sammeln'
i18n['collect long'] = 'Externe Mails abrufen'
i18n['collect host'] = 'POP-Server'
i18n['collect user'] = 'POP-Benutzer-ID'
i18n['collect pass'] = 'Passwort'
i18n['collect folder'] = 'Speichern in Ordner'
i18n['collect delete'] = 'Nachrichten auf dem Server löschen'
i18n['collect pending'] = 'Ausstehender Abruf. Bitte warten...'
i18n['collect no host'] = 'Der POP-Server muss angegeben werden.'
i18n['collect no user'] = 'Die Benutzer-ID muss angegeben werden.'
i18n['collect no pass'] = 'Das Kontopasswort muss angegeben werden.'
i18n['msg nocollect'] = 'Sie verfügen nicht über die erforderlichen Rechte, um diese Nachrichten in diesem Ordner zu sammeln'

// LDAP Lookup
i18n['ldap givenname'] = 'Vorname'
i18n['ldap sn'] = 'Nachname'
i18n['ldap cn'] = 'Name'
i18n['ldap mail'] = 'E-Mail'
i18n['ldap phone'] = 'Telefonnr.'
i18n['ldap searching'] = 'Suche läuft. Bitte warten...'
i18n['close'] = 'Schließen'

// Options
i18n['account summary'] = 'Kontenübersicht'
i18n['summary exp'] = 'Wenden Sie sich an den Systemadministrator, wenn Sie eine der folgenden Informationen ändern möchten.'
i18n['email addrs'] = 'E-Mail-Adressen'
i18n['email addrs exp'] = 'Aufgrund Ihrer Kontokonfiguration können Sie Mails empfangen, die an die folgenden Empfänger adressiert sind:'
i18n['quota'] = 'Speicherplatz'
i18n['quota exp'] = 'Der Systemadministrator kann den für die Mailspeicherung verfügbaren Speicherplatz begrenzen.'
i18n['quota limit'] = 'Der Speicherplatz für Ihre Mailbox ist:'
i18n['no limit'] = 'Nicht eingeschränkt'
i18n['quota usage'] = 'Die aktuelle Speicherplatzbelegung beträgt:'
i18n['message quota limit'] = 'Der Speicherplatz für Nachrichten beträgt:'
i18n['message quota usage'] = 'Die aktuelle Anzahl der Nachrichten ist:'
i18n['password'] = 'Passwort'
i18n['passwd exp'] = 'Verwenden Sie dieses Formular, um das für den Zugriff auf Messenger Express verwendete Passwort zu ändern.'
i18n['passwd old'] = '1. Altes Kennwort eingeben:'
i18n['passwd new'] = '2. Neues Kennwort eingeben:'
i18n['passwd confirm'] = '3. Neues Kennwort bestätigen:'
i18n['passwd again'] = '(zur Bestätigung)'
i18n['passwd submit'] = 'Passwort ändern'
i18n['clear'] = 'Zurücksetzen'
i18n['new pass alert'] = 'Geben Sie ein neues Passwort ein.'
i18n['old pass alert'] = 'Geben Sie Ihr altes Passwort ein.'
i18n['pass mismatch alert'] = 'Die beiden Einträge für das neue Passwort stimmen nicht überein. Wiederholen Sie die Eingabe.'
i18n['pass changed'] = 'Passwortänderung erfolgreich durchgeführt'
i18n['personal'] = 'Persönliche Daten'
i18n['personal exp'] = 'Verwenden Sie dieses Formular, um persönliche Informationen zu ändern.'
i18n['personal cn'] = 'Name'
i18n['personal cn exp'] = 'So wie in den ausgehenden Nachrichten angezeigt:'
i18n['personal lang'] = 'Bevorzugte Sprache'
i18n['personal lang exp'] = 'Folgende Standardsprachen verwenden:'
i18n['personal lang changed'] = 'Die bevorzugte Sprache wurde geändert.\n\nDamit diese Änderung wirksam wird,\nmüssen Sie sich abmelden und dann erneut anmelden.'
i18n['personal replyto'] = 'Antwortadresse'
i18n['personal replyto exp'] = 'Wenn abweichend von '
i18n['personal vcard'] = 'Visitenkarte'
i18n['personal vcard exp'] = 'Die vCard enthält folgende Informationen:'
i18n['personal signature'] = 'Unterschrift'
i18n['personal signature exp'] = 'Diesen Text in jede verfasste Nachricht aufnehmen:'
i18n['delivery'] = 'Zustellung'
i18n['vacation'] = 'Abwesenheitsnachricht'
i18n['vacation exp'] = 'Verwenden Sie dieses Formular, um automatische Antworten für Zeiträume einzurichten, in denen Sie Ihre E-Mails nicht lesen können.'
i18n['vacation toggle'] = 'Automatische Abwesenheitsantwort aktivieren.'
i18n['vacation date format exp'] = ' (MM/TT/JJJJ)'
i18n['vacation date separator'] = '/'
i18n['vacation invalid date'] = 'Ungültiges Datum'
i18n['vacation invalidautoreplytimeout'] = 'Ungültige Anzahl der Tage'
i18n['vacation start exp'] = 'Abwesenheitsmitteilung starten am: '
i18n['vacation end exp'] = 'Abwesenheitsmitteilung anhalten am: '
i18n['vacation timeout exp'] = 'Anzahl der Tage zwischen den Antworten an wiederholte Absender: '
i18n['vacation subject exp'] = 'Betreff:'
i18n['vacation internal msg exp'] = 'Der folgende Text wird in die Abwesenheitsnachricht an interne Absender aufgenommen:'
i18n['vacation msg'] = 'Dies ist eine automatische Antwort. Ich bin im Urlaub oder kann meine E-Mails aus anderen Gründen nicht lesen. Ich lese die Nachricht bei meiner Rückkehr.\n\nVielen Dank.'
i18n['vacation msg exp'] = 'Der folgende Text wird in die Abwesenheitsnachricht an externe Absender aufgenommen. Falls keine Abwesenheitsnachricht für interne Absender angegeben wurde, wird derselbe Text als Ihre Abwesenheitsnachricht an die internen Absender gesendet.'
i18n['startgreaterend'] = 'Das Enddatum sollte mindestens einen Tag nach dem Startdatum liegen'
i18n['notBeforeToday'] = 'Geben Sie ein Datum ein (ein Datum ab dem heutigen Datum ist zulässig)'
i18n['mdy']='Monat, Tag, Jahr';
i18n['dmy']='Tag, Monat, Jahr';
i18n['ymd']='Jahr, Monat, Tag';
i18n['noReplyIfNoText']= 'Wenn Abwesenheitsnachrichten aktiviert sind, sollte der Text für die Abwesenheitsantwort nicht leer sein.'
i18n['settings'] = 'Einstellungen'
i18n['settings exp'] = 'Mit diesem Formular können Sie das Verhalten von Messenger Express ändern.'
i18n['settings delete'] = 'Löschen von Mails'
i18n['settings exit empty'] = 'Leerer Ordner bei Abmeldung'
i18n['settings delete imap'] = 'Nachrichten als gelöscht markieren (verwenden Sie ' + i18n['expunge'] + ', um die Nachrichten dauerhaft zu löschen)'
i18n['settings exit expunge'] = 'Gelöschte Nachrichten im Eingang bei Abmeldung löschen'
i18n['settings draft'] = 'Nachrichtenentwürfe'
i18n['settings sent'] = 'Weiterleiten von Nachrichten'
i18n['settings delivery'] = 'Weiterleiten-Optionen'
i18n['settings forward exp'] = 'Kopien einer neuen Nachricht weiterleiten an (eine Adresse pro Zeile):'
i18n['settings forward enable'] = 'Weiterleitung aktivieren'
i18n['settings no copy'] = 'Keine Kopie auf Server lassen'
i18n['settings quote'] = 'Ursprüngliche Nachricht in Antwort einschließen'
i18n['settings quote exp'] = 'Ursprüngliche Nachricht bei Antwort automatisch zitieren.'
i18n['appearance'] = 'Gesamtbild'
i18n['appearance exp'] = 'Mit diesem Formular können Sie die Darstellungsform von Messenger Express ändern.'
i18n['appearance colors'] = 'Farbschema'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = 'Symbolleiste'
i18n['appearance bar both'] = 'Bild und Text anzeigen'
i18n['appearance bar icons'] = 'Nur Bild anzeigen'
i18n['appearance bar text'] = 'Nur Text anzeigen'
i18n['appearance page'] = 'Nachrichten pro Seite'
i18n['appearance page exp'] = 'Anzeigen ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '<option value="100">100</option></select> Nachrichten pro Seite'
i18n['appearance sort'] = 'Nachrichten sortieren ' +
  '<select name="meSortOrder"><option value="F">Älteste zuerst</option>' +
  '<option value="R">Älteste zuletzt</option></select>'
i18n['appearance date exp'] = 'Datum '
i18n['appearance date format exp'] = 'Datumsformat '+
  '<select name="meDateFormatFormat"><option value="0">' + i18n['mdy'] + '</option>' +
  '<option value="1">' + i18n['dmy'] + '</option>' +
  '<option value="2">' + i18n['ymd'] + '</option></select>'
i18n['appearance date delimiter exp'] = 'Trennzeichen '
i18n['appearance fonts'] = 'Bildschirmschriftart'
i18n['appearance fonts face'] = 'Schriftbild'
i18n['appearance fonts space'] = 'Abstände'
i18n['serif'] = 'Serif'
i18n['sans serif'] = 'Sans Serif'
i18n['mono'] = 'Mono'
i18n['appearance fonts size'] = 'Größe'
i18n['appearance fonts xl'] = 'Größte'
i18n['appearance fonts l'] = 'Größer'
i18n['appearance fonts m'] = 'Standard'
i18n['appearance fonts s'] = 'Kleiner'
i18n['appearance fonts xs'] = 'Kleinste'
i18n['submit changes'] = 'Änderungen speichern'
i18n['not changed'] = 'Es wurden keine Optionen geändert.'
i18n['success'] = 'Kontoaktualisierung erfolgreich'
i18n['NDA'] = 'Delegierter Administrator'
i18n['filters'] = 'Mail-Filter'
i18n['loadingFilters'] = 'Filter werden geladen...'
i18n['InvalidMsgSizePrompt'] = 'Geben Sie die Nachrichtengröße ein.';
i18n['InvalidMobileFwdPrompt'] = 'Ungültige/keine Eingabedaten. Wiederholen Sie die Eingabe.';
i18n['InvalidFilterNamePrompt'] = 'Geben Sie einen gültigen Filternamen ein.';
i18n['DuplicateFilterPrompt'] = 'Doppelter Filtername. Geben Sie einen anderen Namen ein.';
i18n['InvalidSieveFormat'] = 'Ungültiges Filterformat. Wenden Sie sich für weitere Unterstützung an Ihren Help-Desk.';


function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  'ist als E-Mail-Adresse ungültig')
}

// Alerts
i18n['js error'] = 'JavaScript-Fehler'
i18n['line'] = 'Zeile'
i18n['login failed'] = 'Anmeldung fehlgeschlagen'
i18n['timeout'] = 'Sitzung nach Zeitüberschreitung abgebrochen. Erneut anmelden'
i18n['FolderNameWithSpace'] = 'Ordnername kann nicht leer sein'
i18n['orphanwin'] = 'Fenster nicht aktiv. Vorgang konnte nicht fortgesetzt werden'

// Time Arrays
var months = new Array('Januar', 'Februar', 'März', 'April', 'Mai', 'Juni',
  'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember')
var days = new Array('Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
  'Freitag', 'Samstag')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i >= 13)
    s = i - 12
  else
    s = i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  if (i < 12)
    s += ' am'
  else
    s += ' pm'
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
  return days[d.getDay()] + ', ' + months[d.getMonth()] + ' ' + d.getDate() +
    ', ' + i + ' ' + i18n_time(d)
}

function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + 'As' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">Lokales Verzeichnis durchsuchen</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    'Netscape Netcenter durchsuchen</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'Bigfoot durchsuchen</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    'InfoSpace durchsuchen</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'Switchboard durchsuchen</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    'Verisign durchsuchen</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    'WhoWhere durchsuchen</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'Yahoo! durchsuchen</option>\n' +
    '</select>\n' +
    font() + 'nach Personen, deren' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">Vollständiger Name</option>\n' +
    '<option value="givenname">Vorname</option>\n' +
    '<option value="sn">Nachname</option>\n' +
    '<option value="mail">E-Mail</option>\n' +
    '<option value="telephonenumber">Telefonnummer</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() +
    '<select name="rule">\n' +
    '<option value="contains">enthält</option>\n' +
    //'<option value="does not">enthält nicht</option>\n' +
    '<option value="equal">ist</option>\n' +
    //'<option value="not equal">ist nicht</option>\n' +
    '<option value="sound">klingt wie</option>\n' +
    '<option value="begin">beginnt mit</option>\n' +
    '<option value="end">endet mit</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
   return '<SELECT class="ActMenu" name=dir><option value="3 200">Unternehmensverzeichnisse durchsuchen</option>\n'+
          '</SELECT>'+main.font() + '&nbsp;nach Benutzern, deren'

  else if(what=='2')
   return '<SELECT  class="ActMenu" name=dir><option value="3 200">Unternehmensverzeichnisse durchsuchen</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">Persönliches Adressbuch durchsuchen</option>\n' : '' +
          '</select>\n' +
          main.font() + 'nach Kontakten oder Gruppen, für die Folgendes gilt:'
 else if(what=='3')
   return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;In Ordnern auswählen&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">Alle freigegebenen Ordner</option>\n' : '') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">Freigegebene Ordner nach Benutzern durchsuchen</option>\n' : '') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('Go', ' Wechseln zu ', "parent.subscribeOptions()") + '\n'
}



function i18n_ldap_no_match(attr, rule, value) {
  return 'Keine Übereinstimmungen für Kontakte, deren ' + attr.toLowerCase() + ' ' +
    rule.toLowerCase() + ' <b>' + html(value) + '</b>'
}

function i18n_ldap_match(end, attr, rule, value) {
  return end + ' Übereinstimmung' + (end == 1 ? '' : 'en') +
    ' für Kontakte, deren ' + attr.toLowerCase() + ' ' + rule.toLowerCase() +
    ' <b>' + html(value) + '</b>'
}

function i18n_search_list() {
  var width1
 
  if(NN > 0) {
    width1 = win ? 12 : 25;
  }
  else
    width1 = 30;
 
  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() + 'Suchen ' +
    folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' nach Nachrichten, in denen' +
    '</td>\n'+
   '<td>'+i18n['nbsp']+'</td>\n'+
   '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">Absender</option>\n' +
    '<option value="SUBJECT">Betreff</option>\n' +
    '<option value="BODY">Nachrichtentext</option>\n' +
    '<option value="TO">Empfänger</option>\n' +
    '</select>\n' +
    '<select name="rule">\n' +
    '<option value="">enthält</option>\n' +
    '<option value="NOT ">enthält nicht</option>\n' +
    '</select>\n' +
    '<input type=text name="string">\n'+
    main.nbutton('search', i18n['search'], "parent.doSearch()") + '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return 'Gelöschte Nachrichten verschieben nach ' + folder
}

function i18n_settings_draft_folder(folder) {
  return 'Nachrichtenentwürfe beibehalten in ' + folder
}

function i18n_settings_sent_folder(folder) {
  return 'Beim Senden einer Nachricht Kopie speichern in ' + folder
}

function i18n_settings_wrap_width() {
  return 'Nachrichten bei <input size=2 name="meWrapWidth"> Zeichen wrappen'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    'vCard an Nachricht anhängen</td></tr>\n' +
    vc('Vorname', 'nf', 32) +
    vc('Nachname', 'nl', 32) +
    vc('Vollständiger Name', 'fn', 32) +
    vc('Titel', 'ti', 32) +
    vc('Unternehmen', 'or', 32) +
    vc('Abteilung', 'od', 32) +
    vc('E-Mail', 'ei', 32) +
    vc('Homepage', 'ur', 32) +
    vc('Geschäftliche Telefonnummer', 'tw', 14) +
    vc('Private Telefonnummer', 'th', 14) +
    vc('Fax', 'tf', 14) +
    vc('Pager', 'tp', 14) +
    vc('Mobiltelefon', 'tc', 14) +
    vc('Adresse', 'ad', 32) +
    vc('Stadt', 'ci', 32) +
    vc('US-Staat', 'st', 32) +
    vc('Postleitzahl', 'zi', 32) +
    vc('Land', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='Afrikaans'
i18n['ar']='Arabisch'
i18n['ca']='Katalanisch'
i18n['zh-CN']='Chinesisch/vereinfacht'
i18n['zh-TW']='Chinesisch/traditionell'
i18n['cs']='Tschechisch'
i18n['hr']='Kroatisch'
i18n['da']='Dänisch'
i18n['nl']='Niederländisch'
i18n['en']='Englisch'
i18n['fi']='Finnisch'
i18n['fr']='Französich'
i18n['gl']='Galicisch'
i18n['de']='Deutsch'
i18n['el']='Griechisch'
i18n['he']='Hebräisch'
i18n['hu']='Ungarisch'
i18n['is']='Isländisch'
i18n['ga']='Irisch'
i18n['it']='Italienisch'
i18n['ja']='Japanisch'
i18n['ko']='Koreanisch'
i18n['no']='Norwegisch'
i18n['pl']='Polnisch'
i18n['pt']='Portugiesisch'
i18n['ro']='Rumänisch'
i18n['sk']='Slovakisch'
i18n['sl']='Slowenisch'
i18n['es']='Spanisch'
i18n['sv']='Schwedisch'
i18n['th']='Thai'
i18n['tr']='Türkisch'

function i18n_preferredlanguagelist()
{   
    var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr');
    var s = '<select name="preferredLanguage">';
    for (i=0; i<lang_list.length; i++)
	s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>';
    return s+'</select>'
}

function i18n_search_options()
{

var s = '<select name="attr" size="1">' +
        '<option value="cn">Vollständiger Name</option>' +
        '<option value="givenname">Vorname</option>' +
        '<option value="sn">Nachname</option>' +
        '<option value="mail">E-Mail</option>' +
        '<option value="uid">Benutzerkennung</option>' +
        '<option value="telephonenumber">Telefonnummer</option>\n' +
        '</select>' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">enthält</option>' +
        '<option value="equal">ist</option>\n' +
        '<option value="begin">beginnt mit</option>\n' +
        '<option value="sound">klingt wie</option>' +
        '<option value="end">endet mit</option>' +
        '</select>'
  return s;
}
function i18n_month_list()
{
    var s=''
    for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'</option>'
    }
    return s
}

function i18n_day_list()
{
    var s=''
    for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'</option>'
    }
    return s
}
function i18n_year_list()
{
    var s=''
    var d= new Date();
    var year=d.getYear();

    for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
    }
    return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = 'Adressbuch'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'

i18n['Current Folder'] = 'Aktuell Ordner'
i18n['Mail'] = 'Mail'
i18n['Calendar'] = 'Kalender'
i18n['Options'] = 'Optionen'
i18n['Address Book'] = 'Adressen'
