// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='スペルチェック'
i18n['settings autospell exp']='メッセージの送信前に常にスペルチェックする'
i18n['spellok']='了解'
i18n['AutoSpellCheck']='メッセージ送信前にスペルチェックする'
i18n['spell error']='サーバーエラー: スペルチェックできません'
i18n['spelldicterror']='サーバーエラー: 言語辞書が利用できません'
i18n['select  comp lang']='言語の選択'
i18n['spelldict']='辞書'
i18n['spell change'] = '&nbsp;&nbsp;変更&nbsp;&nbsp;&nbsp;'
i18n['spell changeall'] = 'すべて変更'
i18n['spell ignoreall'] = '&nbsp;すべて無視&nbsp;'
i18n['spell_progress']='お待ちください。スペルチェッカーがただちに起動します。'
i18n['send_progress']='送信中です';
i18n['spell_no_mistakes']=" スペルミスはありません";
i18n['spell_select_lang']="言語を選択してください";
i18n['spell_nothing']='チェックするものがありません';
i18n['send_anyway']= 'メッセージ内にスペルチェッカーが認識できない単語が含まれています。送信してよろしいですか'
i18n['done_anyway']= 'メッセージにスペルチェッカーが認識できない単語がまだ含まれています。'
i18n['spell_window_title']='メッセージのスペルチェック'
i18n['spell yes']="はい"
i18n['spell no']="いいえ"
i18n['spelltool done']="完了"
i18n['spelltool help']=" ヘルプ "
i18n['No Suggestions']='提案なし'
i18n['Suggestions']='提案'

//SMIME
i18n['smime not available']='SMIME の設定が不完全であるか、アプレットが読み込まれていません'
i18n['smime recipients failure']='受取人追加時のエラー: '
i18n['Signed Message']='署名付きメッセージ'
i18n['Invalid Signature']='無効な署名です'
i18n['Invalid Encryption']='無効な暗号化です'
i18n['Encrypted Message']='暗号化されたメッセージ'
i18n['url_error']="URL 追加時のエラー"

// Compose window toolbar
i18n['compose_send']='メッセージを送信'
i18n['compose_attach']='ファイルをメッセージに添付'
i18n['compose_spell']='メッセージのスペルチェック'
i18n['compose_editor']='エディタの切り替え (テキストまたは HTML)'




// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = '読み込み中。しばらくお待ちください...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = '選択'
i18n['Select All']= 'すべてを選択'
i18n['Deselect All']= '選択をすべて解除'
i18n['no msg'] = 'フォルダーはメッセージを含みません。'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = '受信箱'
fldr['Trash'] = 'ごみ箱'
fldr['Drafts'] = '一時保管'
fldr['Sent'] = '送信済み'
fldr['Sent Items'] = '送信済み項目'

// Window titles
i18n['app title'] = 'Mail - Communications Express'
i18n['sjs app title'] = 'Sun Java&#153; System Messenger Express'
i18n['attach title'] = 'ファイルの添付'
i18n['collect title'] = '外部メールの収集'
i18n['compose title'] = '新規メッセージ'
i18n['lookup title'] = 'LDAP ルックアップ'
i18n['receipt title'] = 'Return Receipt'
i18n['editgroup title'] = 'グループの更新'
i18n['editentry title'] = '連絡先の更新'
i18n['newgroup title'] = '新規グループ'
i18n['newentry title'] = '新規連絡先'
i18n['comprecipient title'] = '個人用アドレスブックから受取人を選択'

// Tabs
i18n['folders'] = 'フォルダ'
i18n['message'] = 'メッセージ'
i18n['pab'] = 'アドレス'
i18n['options'] = 'オプション'
i18n['search results'] = '検索結果'
i18n['searching'] = '検索中 ...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='スペルチェック'

function i18n_tab_header(user) {
  return '<nobr>&nbsp;&nbsp;ようこそ ' + user + '</nobr>'
}

function i18n_quota_warning(percent) {
  return '警告: 現在、制限容量の ' + percent +
         '% を使って処理を実行しています。'
}

function i18n_maxsize(maxsize) {
  return '(添付の最大サイズは '+ maxsize +
         'K バイトを超えてはいけません。)'
}


function i18n_msgQuota_warning(percent) {
  return '警告: 現在、メッセージ制限容量の ' + percent +
         '% を使って処理を実行しています。'
}

// Error Messages

i18n['fldr selfmove'] = 'フォルダをそれ自身に移動することはできません' 
i18n['fldr noinbox'] = 'INBOX 内にサブフォルダを作成することはできません'
i18n['mbox nopermission'] = 'このフォルダにメッセージを移動する権限がありません'
i18n['mbox selfmove'] = 'メッセージを現在のフォルダに移動することはできません'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']

// Message Headers
i18n['selected'] = '選択済み'
i18n['seen'] = '開封済み'
i18n['from'] = '差出人'
i18n['date'] = '日付'
i18n['recvdate'] = '受信'
i18n['sentdate'] = '送信'
i18n['to'] = '宛先'
i18n['cc'] = 'Cc'
i18n['bcc'] = 'Bcc'
i18n['subject'] = '件名'
i18n['attachments'] = '添付ファイル'
i18n['size'] = 'サイズ'
i18n['unread'] = '未開封'
i18n['no subject'] = '[ 件名なし ]'
i18n['duplicates ignored'] = ' 重複は無視されました'
i18n['search invalidfolder'] = '無効なフォルダが選択されました。有効なフォルダを選択して検索してください。'

// Tool Bars
i18n['delete'] = '削除'
i18n['undelete'] = '削除解除'
i18n['expunge'] = '消去'
i18n['rename'] = '名前の変更'
i18n['new folder'] = '新規'
i18n['subscribe'] = '共有'
i18n['help'] = 'ヘルプ'
i18n['logout'] = 'ログアウト'
i18n['home'] = 'ホーム'
i18n['attach'] = '添付'
i18n['draft'] = '下書きを保存'
i18n['send'] = '送信'
i18n['cancel'] = '取消し'
i18n['compose_help']= 'ヘルプ'
i18n['compose'] = '新規メッセージ'
i18n['search'] = '検索'
i18n['get mail'] = 'メールの受信'
i18n['update'] = '更新'
i18n['forward'] = '転送'
i18n['reply'] = '返信'
i18n['reply all'] = '全員に返信'
i18n['add sender'] = '差出人の追加'
i18n['previous'] = '前へ'
i18n['printable'] = '印刷用ページ'
i18n['next'] = '次へ'
i18n['lookup'] = 'アドレス'
i18n['quote'] = '制限容量'
i18n['new search'] = '変更'
i18n['add all addresses'] = 'アドレスの追加'
i18n['sharefolder toolbar'] = '共有'
i18n["attach_help"] = 'ヘルプ'

// Shared Folders
i18n["share folder"] = 'フォルダの共有'
i18n["Shared Folders Title"] = 'フォルダ権限の設定'
i18n["SetPermissions Header"] = 'フォルダ: '
i18n["SetPermissions AddUser"] = '権限リスト '
i18n["SetPermissions AddUser1"] = 'このフォルダを他のユーザーと共有するには、「検索」を使ってユーザーを検索します。'
i18n["SetPermissions Subtitle1"] = 'ユーザー ID を入力し、「追加」をクリックします。'
i18n["SetPermissions Searchtitle"] = 'ユーザーを検索するには、「検索」をクリックします。'
i18n["SetPermissions subtitle2"] = '権限の設定: '
i18n["SetPermissions info"] = '次に、そのユーザーの権限を設定します。' 
i18n["SetPermissions read"] = '読み取り専用'
i18n["SetPermissions readwrite"] = '読み取りおよび書き込み'
i18n["SetPermissions readwriteaccess"] = '読み取り、書き込み、および管理アクセス'
i18n["SetPermissions User"] = 'ユーザー ID'
i18n["SetPermissions Permission"] = '権限'
i18n["SetPermissions Delete"] = '削除'
i18n["SetPermissions ok"] = '了解'
i18n["SetPermissions apply"] = '適用'
i18n["SetPermissions cancel"] = '取消し'
i18n["SetPermissions Help"] = 'ヘルプ'
i18n["SetPermissions Alert1"] = 'ユーザーはすでにリストに含まれています'
i18n["SetPermissions AddButton"] = '追加'
i18n["SetPermissions SearchButton"] = '検索...'
i18n["SetPermissions Alert2"] = 'ユーザー名を入力してください'
i18n["SetPermissions subtitle3"] = 'リストから特定のユーザーを選択し、「追加」をクリックします'
i18n["SetPermissions subtitle4"] = 'ユーザーの検索'
i18n["SetPermissions selfadd"] = '自分自身とフォルダを共有することはできません'
i18n["SetPermissions none"] = 'なし'
i18n["directdelivery"] = '電子メールを直接配信するフォルダ: '
i18n["SetPermissions owneraddalert"] = '自分自身とフォルダを共有することはできません'
i18n["SetPermissions SearchResultHeader"] = '以下のリストからユーザーを選択してください'
i18n["SetPermissions nopermissionslaert"] = '権限を設定する権限がありません'
i18n["SetPermissions Remove"] = '削除'
i18n["SetPermissions InvalidUser"] = '無効なユーザーです'
i18n['SetPermissions anyone'] = 'すべて'
i18n['Mail Delivery Address'] = 'メール配信アドレス'
i18n['Folders shared by '] = 'フォルダは共有されています '
i18n[ 'All Shared folders'] =  '全ての共有フォルダ'
i18n['Initial help text'] = 'メニュー上から表示するフォルダを選択してください。'

// Folders
i18n['fldr folders'] = 'フォルダ'
i18n['fldr personal'] = '個人フォルダ'
i18n['fldr shared'] = '登録された共有フォルダ'
i18n['fldr file header'] = '選択したフォルダの移動先: '
i18n['fldr noinferiors'] = 'サブフォルダは許可されていません'
i18n['fldr delete inbox'] = 'システムフォルダです - 削除できません'
i18n['fldr move inbox'] = 'システムフォルダです - 移動できません'
i18n['fldr noselect'] = 'このフォルダは変更できません。'
i18n['fldr cannotselect'] = 'このフォルダは選択できません'
i18n['fldr empty trash'] = 'ごみ箱を空にする'
i18n['fldr messages'] = 'メッセージ'
i18n['fldr nodelete'] = 'このフォルダの名前は変更できません。'
i18n['fldr exists']= 'フォルダがすでに存在しています。'
i18n['fldr select']= 'フォルダを選択してください。'
i18n['fldr nopermissions'] = 'サブフォルダを作成する権限がありません'
i18n['fldr nopermissionsdelete'] = 'サブフォルダを削除する権限がありません'
i18n['fldr unsubscribe'] = 'フォルダの購読を取り消すことはできません'
i18n['Folder Actions'] = 'フォルダアクション'

i18n['subscribe'] = '購読'
i18n['subscribe windowtitle'] = '共有フォルダの購読'
i18n['unsubscribe'] = '購読取消'
i18n['Subscribe Header1'] = '共有フォルダは、所有者ごとに管理されています。所有者の名前、電子メールアドレス、'
i18n['Subscribe Header2'] = 'または電話番号を以下に入力し、「検索」をクリックしてください。次に、目的のフォルダを選択し、「購読」をクリックします'
i18n['No Unsubscribed Folders'] = '購読対象のフォルダがありません'
i18n['No Shared Folders'] = 'このユーザーの共有フォルダはありません'
i18n['subscribe select'] = '選択'
i18n['subscribe Folder'] = 'フォルダ'
i18n['subscribe owner'] = '所有者'
i18n['subscribe searchHeader'] = 'リストからユーザー ID を選択してください'
i18n['subscribe User ID'] = 'ユーザー ID'
i18n['subscribe Name'] = '名前'
i18n['subscribe E-Mail'] = '電子メール'
i18n['subscribe owner Header'] = '所有者の'
i18n['subscribe search title'] = 'ユーザー ID の選択'
i18n['subscribe Search'] = '検索'
i18n['subscribe Result'] = '検索結果に登録 '

//Rtf
i18n['FontsizeLabel'] = 'サイズ'
i18n['FontnameLabel'] = 'フォント'
i18n['Block Format'] = '段落'
i18n['ViewHTMLSource'] = 'HTML ソースの表示'
i18n['switchEditor']= 'テキスト/HTML'
i18n['colorColorLabel'] = '色 : '
i18n['colorOkLabel'] = '了解 '
i18n['colorCancelLabel']= ' 取消し '
i18n['emoCloseLabel'] = ' 閉じる '
i18n['Smiley'] = '絵文字の挿入'
i18n['Cut'] = 'カット'
i18n['Copy'] = 'コピー'
i18n['Paste'] = 'ペースト'
i18n['Bold'] = 'ボールド'
i18n['Italics'] = '斜体'
i18n['Underline'] = '下線'
i18n['Change foreground color'] = '文字の色'
i18n['Change Background color'] = '背景色'
i18n['Left Justify'] = '左揃え'
i18n['Center Justify'] = '中央揃え'
i18n['Right Justify'] = '右揃え'
i18n['Insert Ordered List'] = '番号付きリスト'
i18n['Insert bullets'] = '箇条書きリスト'
i18n['Outdent'] = '字下げ分の減少'
i18n['Indent'] = '字下げ分の増加'
i18n['Create HyperLink'] = 'ハイパーリンクの挿入'
i18n['make text left to right align'] = 'テキストを左から右へ揃える'
i18n['make text right to left align'] = 'テキストを右から左へ揃える'
i18n['all formatting will be lost'] = 'すべての書式が失われます。実行しますか ?'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = '書式設定ツールを使用する場合、「HTML ソースの表示」チェックボックスのチェックマークを外してください'
i18n['Compose in'] = '次で作成 '
i18n['Plain Text'] = 'プレーンテキスト'
i18n['Rich Text (HTML)']= 'リッチテキスト (HTML)'

//Attach Dialog

i18n['Attach Header'] = '「参照」をクリックし、添付するファイルを選択し、「追加」をクリックしてこのメッセージに添付します。'
i18n['Attach Col1'] = '添付ファイル'
i18n['Attach Col2'] = 'サイズ'
i18n['Attach Remove'] = '削除'
i18n['Attach Add'] = '追加'
i18n['Attachments'] = '添付'
i18n['Action'] = 'アクション'

//Tooltips
i18n['folder actions'] = 'フォルダアクション'
i18n['folder update'] = 'フォルダの更新'
i18n['folder new'] = '新規フォルダ'
i18n['folder rename'] = 'フォルダの名前変更'
i18n['folder share'] = '選択したフォルダの共有'
i18n['folder delete'] = '選択したフォルダの削除'
i18n['folder subscribe'] = '共有フォルダの購読'
i18n['folder unsubscribe'] = '選択したフォルダの購読取消'
i18n['folder owner'] = '共有フォルダの所有者'
i18n['mbox getmail'] = 'メールの受信'
i18n['mbox search'] = 'メッセージの検索'
i18n['mbox delete'] = '選択したメッセージの削除'
i18n['mbox trash'] = '選択したメッセージを削除済みとマークする'
i18n['mbox actions'] = 'メッセージアクション'
i18n['mbox expunge'] = '削除'
i18n['mbox undelete'] = '削除の取り消し'

i18n['seen up'] = 'メッセージのタイプ別に降順に並べ替える'
i18n['seen dn'] = 'メッセージのタイプ別に昇順に並べ替える' 
i18n['recv up'] = 'メッセージの受信日別に降順に並べ替える'
i18n['recv dn'] = 'メッセージの受信日別に昇順に並べ替える'
i18n['from up'] = 'メッセージの差出人別に降順に並べ替える'
i18n['from dn'] = 'メッセージの差出人別に昇順に並べ替える'
i18n['size up'] = 'メッセージのサイズ別に降順に並べ替える'
i18n['size dn'] = 'メッセージのサイズ別に昇順に並べ替える'
i18n['subj up'] = 'メッセージの件名別に降順に並べ替える'
i18n['subj dn'] = 'メッセージの件名別に昇順に並べ替える'


i18n['name up'] = '表示名別に降順に並べ替える'
i18n['name dn'] = '表示名別に昇順に並べ替える'
i18n['mail up'] = '電子メールアドレス別に降順に並べ替える'
i18n['mail dn'] = '電子メールアドレス別に昇順に並べ替える'
i18n['attach dn'] = '添付ファイルの有無別に昇順に並べ替える'
i18n['attach up'] = '添付ファイルの有無別に降順に並べ替える'
i18n['priority dn']  = 'メッセージの優先度別に昇順に並べ替える'
i18n['priority up'] = 'メッセージの優先度別に降順に並べ替える'

i18n['msg compose'] = 'メッセージの作成'
i18n['msg reply'] = 'メッセージに返信'
i18n['msg replyall'] = '全員に返信'
i18n['msg forward'] = 'メッセージの転送'
i18n['msg delete'] = 'メッセージの削除'
i18n['msg addall'] = 'すべてのアドレスをアドレスブックに追加する'
i18n['msg prev'] = '前のメッセージ'
i18n['msg next'] = '次のメッセージ'
i18n['msg close'] = 'メッセージを閉じる'
i18n['msg UnRead'] = 'ステータス: 未開封'
i18n['msg UnreadDel'] = 'ステータス: 未開封、削除済み'
i18n['msg Read'] = 'ステータス: 開封済み'
i18n['msg ReadDel'] = 'ステータス: 開封済み、削除済み'
i18n['msg ReadAns'] = 'ステータス: 開封済み、返信済み'
i18n['msg ReadAnsDel'] = 'ステータス: 開封済み、返信済み、削除済み'
i18n['msg Attachment'] = '添付ファイル'
i18n['msg FullHeader'] = '詳細メッセージヘッダーの表示'
i18n['msg NormalHeader'] = '簡易メッセージヘッダーの表示'
i18n['msg priority'] = '優先度'
i18n['msg high'] = '優先度: 緊急'
i18n['msg low'] = '優先度: 緊急ではない'

i18n['Previous'] = '前へ'
i18n['Showing'] = '表示'
i18n['Messages'] = 'メッセージ'
i18n['Next'] = '次へ'
i18n['of'] = '/'

i18n['pab update'] = 'アドレスブックの更新'
i18n['pab new'] = '新規連絡先'
i18n['pab group'] = '新規グループ'
i18n['pab search'] = 'アドレスブックの検索'
i18n['pab editgroup'] = 'グループの編集'

function prompt_delete_folder(m, i) {

var fname = m;
for(j=0; j < fldr.length; j++)
 {
   if(fldr[j] == m)
   {
      fname = fldr[j];
      break;
   }
}

  if (i > 0)
    return 'フォルダ "' + fname + '" と ' + i + ' 個のメッセージを削除しますか ?'
  else
    return 'フォルダ "' + fname + '" を削除しますか ?'
}

function prompt_new_folder(m) {

var fname = m;
for(i=0; i < fldr.length; i++)
 {
   if(fldr[i] == m)
   {
      fname = fldr[i];
      break;
   }
}

  return fname + ' 内にフォルダを新規作成します。フォルダ名: '
}

function prompt_rename_folder(f) {
  return 'フォルダ "' + f + '" の名前を変更します。変更後の名前: '
}

function prompt_subscribe_folder() {
  return '購読するフォルダ: '
}

function prompt_unsubscribe_folder(f) {
  return 'フォルダ "' + f + '" の購読取消: '
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return fname + ' 内のすべてのメッセージを永久的に削除しますか ?'
}

// Mailbox
i18n['file selected msg'] = 'メッセージをフォルダに移動: '
i18n['copy selected msg'] = 'メッセージをフォルダにコピー: '
i18n['select folder'] = 'フォルダを選択'
i18n['mbox select all'] = 'すべてのメッセージを選択'
i18n['confirm expunge'] = '選択したメッセージを永久的に削除しますか ?'
i18n['confirm expunge all'] = 'メッセージが選択されていません。すべての削除済みメッセージを永久的に削除しますか ?'

function i18n_mbox_date(d, now, laurel) {
  var i, s, timeformat = 12

  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12;

  if (d.getDate() == now.getDate() && d.getMonth() == now.getMonth() &&
    d.getYear() == now.getYear()) {
    i = d.getHours()
    if(timeformat == 12)
    {
      if (i < 12)
         s = '午前 '
      else
         s = '午後 '
    }
    if (i == 0)
      s += 12
    else if (i < 13)
      s += i
    else {
      if(timeformat == 12)
        s += i - 12;
      else
        s += i;
    }
    s += ':'
    if (d.getMinutes() <= 9)
      s += '0'
    s += d.getMinutes()
  } else {
    i = d.getYear()
    if (i >= 2000)
      i -= 2000
    else if (i >= 100)
      i -= 100
    if (i < 10)
      i = '0' + i
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat'];
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimiter'] : '/';
      format = lformat ? lformat.charAt(0) : '0';
    }

    switch(format){
      case '0': case 'M':
           s = (d.getMonth() + 1) + deli + d.getDate() + deli + i;
           break;
      case '1': case 'D':
           s = d.getDate() + deli +(d.getMonth() + 1)  + deli + i;
           break;
      case '2': case 'Y':
           s = i + deli + (d.getMonth() + 1) + deli + d.getDate();
           break;
    }
  }
  return s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + ' にはメッセージが含まれていません'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>メッセージ: ' + total
      if (unread == 0)
        s += ' (未開封メッセージ: ' + unread + ') -'
      else
        s += ' (<b>未開封メッセージ: ' + unread + '</b>) -'
      i = parseInt(used)
      s += '</nobr> <nobr>' + size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += '無制限'
      else
        s += size(i) + ' 制限'
      s += ')'
      s += ' -  合計メッセージ: ' + msgUsed + ' ('
      if (msgLimit < 0)
        s += '無制限'
      else
        s += msgLimit + ' 制限'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = '次の条件に一致する項目はありません'
    else if (mboxFrame.sortid.length == 1)
      s = '次の条件に一致する項目は 1 件あります'
    else
      s = '次の条件に一致する項目は ' + total + ' 件あります'
    s += ': '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() +
      ' "' + strflr + '" を' +
      (val[0].length == 0 ? '含む' : '含まない') +
//      ' "' + val[2] + '"' + ' in ' + 
      ' 場所: ' +
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'メッセージが選択されていません。\n' + fname + ' 内のすべての削除済みメッセージを削除しますか ?'
}

// Message
i18n['file msg'] = 'メッセージを移動するフォルダ: '
i18n['msg image'] = '[ イメージ ]'
i18n['msg file prefix'] = 'ファイル: '
i18n['msg vcard'] = 'vCard'
i18n['msg signature'] = 'デジタル署名'
i18n['msg encrypted'] = '暗号化済み (復号化できません)'
i18n['msg brief'] = '簡易メッセージヘッダーの表示'
i18n['msg all'] = '詳細メッセージヘッダーの表示'

// Message Composition
i18n['fwd'] = 'Fwd: '
i18n['re'] = 'Re: '
i18n['attachment pending'] = '添付を処理しています。お待ちください'
i18n['cancel message'] = 'メッセージを閉じて、変更を取り消しますか ?'
i18n['recipient'] = '受取人'
i18n['recipient mini help'] = '複数の受取人はコンマで区切ります。'
i18n['invalid addr'] = '電子メールアドレスに無効な文字が含まれています'
i18n['no recipient'] = 'このメッセージには受取人が指定されていません。「宛先」、「Cc」、「Bcc」のいずれかをクリックし、電子メールアドレスを追加してください。'
i18n['no subject confirm'] = 'このメッセージには件名が指定されていません。このまま送信してよろしいですか ? '
i18n['original message'] = '元のメッセージ'
i18n['reply text'] = '元のメッセージ'
i18n['remove'] = '削除'
i18n['reply separator'] = '----- 元のメッセージ -----'
i18n['priority'] = '優先度'
i18n['priority n'] = '通常'
i18n['priority h'] = '緊急'
i18n['priority l'] = '緊急ではない'
i18n['receipt'] = '受信確認の要求'
i18n['receipt n'] = 'なし'
i18n['receipt d'] = '配信時'
i18n['receipt r'] = '表示時'
i18n['receipt b'] = '両方'
i18n['no mail'] = 'メールアドレスが指定されていないため、メッセージを送信できません'
i18n['reply too long'] = '元のメッセージはサイズが大きすぎて引用できません。\n添付ファイルとして取り込まれます。'
i18n['reply no text'] = 'Messenger Express は元のメッセージをテキスト内に引用できません。\n添付ファイルとして取り込まれます。'
i18n['add empty t'] = 'このメッセージの送信先: '
i18n['add empty c'] = 'このメッセージの Cc 送信先: '
i18n['add empty b'] = 'このメッセージの Bcc 送信先: '
i18n['sent status'] = 'メールの送信を完了しました'

// Return receipt
i18n['receipt request'] = '受信確認が要求されました。確認を送信しますか ?'
i18n['receipt subject'] = '受信確認 (開封済み) - '

function i18n_receipt_text(from) {
  return 'これは、' + from + ' への送信メールに対する\r\n受信確認メッセージです。\r\n\r\n' +
    '注意: この受信確認は、受取人のマシン上でそのメッセージが\r\n' +
    '表示されたことを示すものです。受取人がその内容を読んで理解したことを\r\n' +
    '保証するものではありません。'
}

// Attachment
i18n['attach missing'] = 'ファイルが選択されていません'
i18n['attach empty'] = 'ファイルが空であるか無効です'
i18n['attach msg canceled'] = 'メッセージが取り消されました'
i18n['attach non ascii allowed'] = 'ASCII 以外の名前を持つファイルは添付できません'
i18n['attach pending'] = '添付を処理しています。「取消し」で中止...'
i18n['attach limited'] = '添付ファイルの最大個数: '
i18n['attach maxlimit'] = '添付ファイルの最大個数に達しました'

function i18n_attach_msg() {
  return '<ul><li><b>「参照...」</b>をクリック' +
    (IE >= 3 && IE < 4 ? 'して IE ファイルのパッチをアップロードする必要があります。' : 'してファイルを選択します。') + 
    '<li>ファイルを選択した後、<b>「添付」</b>をクリックします。' +
    '<li>このウィンドウは、ファイル転送が完了すると閉じます。' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = '収集'
i18n['collect long'] = '外部メールの収集'
i18n['collect host'] = 'POP サーバー'
i18n['collect user'] = 'POP ユーザー ID'
i18n['collect pass'] = 'パスワード'
i18n['collect folder'] = 'フォルダに保存'
i18n['collect delete'] = '収集後サーバーからメッセージを削除'
i18n['collect pending'] = '収集中。お待ちください...'
i18n['collect no host'] = 'POP サーバーを指定してください。'
i18n['collect no user'] = 'ユーザー ID を指定してください。'
i18n['collect no pass'] = 'アカウントのパスワードを指定してください。'
i18n['msg nocollect'] = 'このフォルダにメッセージを収集する権限がありません'

// LDAP Lookup
i18n['ldap givenname'] = '名'
i18n['ldap sn'] = '姓'
i18n['ldap cn'] = '名前'
i18n['ldap mail'] = '電子メール'
i18n['ldap phone'] = '電話番号'
i18n['ldap searching'] = '検索中。お待ちください...'
i18n['close'] = '閉じる'

// Options
i18n['account summary'] = 'アカウントの概要'
i18n['summary exp'] = '次の情報を変更する場合は、システム管理者に問い合わせてください。'
i18n['email addrs'] = '電子メールアドレス'
i18n['email addrs exp'] = '現在のアカウント設定では、次のアドレス宛のメールを受信できます: '
i18n['quota'] = '制限容量'
i18n['quota exp'] = 'メール保存用のディスク容量をシステム管理者が制限することがあります。'
i18n['quota limit'] = 'メールボックスのディスク制限容量: '
i18n['no limit'] = '無制限'
i18n['quota usage'] = '現在のディスク使用量: '
i18n['message quota limit'] = 'メッセージ制限容量: '
i18n['message quota usage'] = '現在のメッセージ件数: '
i18n['password'] = 'パスワード'
i18n['passwd exp'] = 'このフォームでは、Messenger Express アクセス用のパスワードを変更できます。'
i18n['passwd old'] = '1. 古いパスワードを入力: '
i18n['passwd new'] = '2. 新しいパスワードを入力: '
i18n['passwd confirm'] = '3. 新しいパスワードを再入力: '
i18n['passwd again'] = '(確認用)'
i18n['passwd submit'] = 'パスワードの変更'
i18n['clear'] = 'リセット'
i18n['new pass alert'] = '新しいパスワードを入力してください。'
i18n['old pass alert'] = '古いパスワードを入力してください。'
i18n['pass mismatch alert'] = '入力された 2 つの新規パスワードが一致しません。もう一度入力してください。'
i18n['pass changed'] = 'パスワードが変更されました'
i18n['personal'] = '個人情報'
i18n['personal exp'] = 'このフォームでは個人情報を変更できます。'
i18n['personal cn'] = '名前'
i18n['personal cn exp'] = '外部のメッセージに追加される名前: '
i18n['personal lang'] = '優先言語'
i18n['personal lang exp'] = '次のデフォルト言語を使用: '
i18n['personal lang changed'] = '優先言語が変更されました。\n\nこの変更を反映するには、\n一度ログアウトし、再度ログインしてください。'
i18n['personal replyto'] = '返信メールアドレス'
i18n['personal replyto exp'] = '異なる場合'
i18n['personal vcard'] = 'vCard'
i18n['personal vcard exp'] = 'vCard には次の情報が含れます: '
i18n['personal signature'] = '署名'
i18n['personal signature exp'] = 'すべての新規メッセージにこのテキストを追加: '
i18n['delivery'] = '配信'
i18n['vacation'] = '不在通知メッセージ'
i18n['vacation exp'] = 'このフォームでは、電子メールを読むことができない期間の自動返信を設定できます。'
i18n['vacation toggle'] = '不在通知メッセージの自動返信を有効'
i18n['vacation date format exp'] = ' (mm/dd/yyyy)'
i18n['vacation date separator'] = '/'
i18n['vacation invalid date'] = '無効な日付'
i18n['vacation invalidautoreplytimeout'] = '無効な日数'
i18n['vacation start exp'] = '不在通知の開始日: '
i18n['vacation end exp'] = '不在通知の終了日: '
i18n['vacation timeout exp'] = '同一差出人への返信間隔日数: '
i18n['vacation subject exp'] = '件名: '
i18n['vacation internal msg exp'] = '内部の差出人への不在通知メッセージに次のテキストを含める: '
i18n['vacation msg'] = 'これは自動返信です。ただ今不在のため電子メールを読むことができませんが、戻りしだい電子メールをチェックいたします。\n\nよろしくお願いいたします。'
i18n['vacation msg exp'] = '不在通知メッセージに次のテキストを含める: '
i18n['startgreaterend'] = '終了日はすくなくとも開始日より 1 日以降でなくてはいけません'
i18n['notBeforeToday'] = '今日以降の日付を入力してください'
i18n['mdy']='月、日、年'
i18n['dmy']='日、月、年'
i18n['ymd']='年、月、日'
i18n['noReplyIfNoText']= '不在通知が有効になっている場合、不在通知返信テキストを空白にしないでください。'
i18n['settings'] = '設定'
i18n['settings exp'] = 'このフォームでは、Messenger Express の動作を変更できます。'
i18n['settings delete'] = 'メールの削除'
i18n['settings exit empty'] = 'ログアウト時にフォルダを空にする'
i18n['settings delete imap'] = 'メッセージを削除済みとしてマークする (永久的に削除するには「' + i18n['expunge'] + '」を使用)'
i18n['settings exit expunge'] = 'ログアウト時に受信箱から削除済みメッセージを削除する'
i18n['settings draft'] = 'メッセージの下書き'
i18n['settings sent'] = '送信されたメッセージ'
i18n['settings delivery'] = 'メールの転送'
i18n['settings forward exp'] = '新規メッセージの転送先 (各行に 1 つのアドレスを記述): '
i18n['settings forward enable'] = '転送を有功'
i18n['settings no copy'] = 'サーバーにコピーを残さない'
i18n['settings quote'] = '元のメッセージの引用'
i18n['settings quote exp'] = '返信時に元のメッセージを自動的に引用する。'
i18n['appearance'] = '外観'
i18n['appearance exp'] = 'このフォームでは、Messenger Express の外観を変更できます。'
i18n['appearance colors'] = 'カラースキーム'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = 'ツールバー'
i18n['appearance bar both'] = 'アイコンとテキストを表示'
i18n['appearance bar icons'] = 'アイコンのみ表示'
i18n['appearance bar text'] = 'テキストのみ表示'
i18n['appearance page'] = 'メッセージリスト表示'
i18n['appearance page exp'] = 'ページあたりのメッセージ数: ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '<option value="100">100</option></select>'
i18n['appearance sort'] = 'メッセージの並べ替え: ' +
  '<select name="meSortOrder"><option value="F">古い順に並べる</option>' +
  '<option value="R">新しい順に並べる</option></select>'
i18n['appearance date exp'] = '日付 '
i18n['appearance date format exp'] = '日付書式 '+
  '<select name="meDateFormatFormat"><option value="0">' + i18n['mdy'] + '</option>' +
  '<option value="1">' + i18n['dmy'] + '</option>' +
  '<option value="2">' + i18n['ymd'] + '</option></select>'
i18n['appearance date delimiter exp'] = '区切り文字 '
i18n['appearance fonts'] = '表示フォント'
i18n['appearance fonts face'] = '書体'
i18n['appearance fonts space'] = '間隔'
i18n['serif'] = 'セリフ'
i18n['sans serif'] = 'サンセリフ'
i18n['mono'] = 'モノスペース'
i18n['appearance fonts size'] = 'サイズ'
i18n['appearance fonts xl'] = '最大'
i18n['appearance fonts l'] = '大'
i18n['appearance fonts m'] = '標準'
i18n['appearance fonts s'] = '小'
i18n['appearance fonts xs'] = '最小'
i18n['submit changes'] = '変更を保存'
i18n['not changed'] = '変更はありません。'
i18n['success'] = 'アカウントが正常に更新されました'
i18n['NDA'] = 'Delegated Administrator'
i18n['filters'] = 'メールフィルタ'
i18n['loadingFilters'] = 'フィルタを読み込み中...'
i18n['InvalidMsgSizePrompt'] = 'メッセージサイズを入力してください。';
i18n['InvalidMobileFwdPrompt'] = 'データが無効か存在しません。再入力してください。';
i18n['InvalidFilterNamePrompt'] = '有効なフィルター名を入力してください。';
i18n['DuplicateFilterPrompt'] = 'フィルター名が重複しています。別の名前を入力してください。';
i18n['InvalidSieveFormat'] = 'フィルタ書式が不正です。サポートのヘルプデスクにお問い合わせ下さい。';


function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  ' は電子メールアドレスとしては不適切です')
}

// Alerts
i18n['js error'] = 'JavaScript エラー'
i18n['line'] = '行'
i18n['login failed'] = 'ログインに失敗しました'
i18n['timeout'] = 'セッションがタイムアウトしました。ログインし直してください。'
i18n['FolderNameWithSpace'] = 'フォルダ名を空白にすることはできません'
i18n['orphanwin'] = 'ウィンドウがアクティブでないため、続行できませんでした'

// Time Arrays
var months = new Array('1', '2', '3', '4', '5', '6',
  '7', '8', '9', '10', '11', '12')
var days = new Array('日曜日', '月曜日', '火曜日', '水曜日', '木曜日',
  '金曜日', '土曜日')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i < 12)
    s = '午前 '
  else
    s = '午後 '
  if (i >= 13)
    s += i - 12
  else
    s += i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
  return i + '年, ' + months[d.getMonth()] + '月 ' +  d.getDate() + '日, ' +
    days[d.getDay()] + ', ' +  i18n_time(d) 
}



function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + ' を次のように使用: ' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">ローカルディレクトリを検索</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    'Netscape Netcenter を検索</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'Bigfoot を検索</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    'InfoSpace を検索</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'Switchboard を検索</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    'Verisign を検索</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    'WhoWhere を検索</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'Yahoo! を検索</option>\n' +
    '</select>\n' +
    font() + 'ユーザーの条件: ' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">フルネーム</option>\n' +
    '<option value="sn">姓</option>\n' +
    '<option value="givenname">名</option>\n' +
    '<option value="mail">電子メール</option>\n' +
    '<option value="telephonenumber">電話番号</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() + 'が文字列' + '</td>' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    '<select name="rule">\n' +
    '<option value="contains">を含む</option>\n' +
    //'<option value="does not">を含まない</option>\n' +
    '<option value="equal">と等しい</option>\n' +
    //'<option value="not equal">と等しくない</option>\n' +
    '<option value="sound">に似ている</option>\n' +
    '<option value="begin">で始まる</option>\n' +
    '<option value="end">で終わる</option>\n' +
    '</select>\n' +
    '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
   return '<SELECT class="ActMenu" name=dir><option value="3 200">コーポレートディレクトリ内で</option>\n'+
          '</SELECT>'+main.font() + '次の条件に一致するユーザーを検索'

  else if(what=='2')
   return '<SELECT  class="ActMenu" name=dir><option value="3 200">コーポレートディレクトリ内で</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">個人用アドレスブック内で</option>\n' : '' +
          '</select>\n' +
          main.font() + '次の条件に一致する連絡先またはグループを検索'
 else if(what=='3')
   return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;フォルダから選択&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">すべての共有フォルダ</option>\n' : '') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">共有フォルダをユーザー別に検索</option>\n' : '') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('移動', ' 移動 ', "parent.subscribeOptions()") + '\n'
}



function i18n_ldap_no_match(attr, rule, value) {
  return attr.toLowerCase() + rule.toLowerCase() + 'ユーザーは見つかりませんでした : ' + '<b>' + html(value) + '</b>'
   
}

function i18n_ldap_match(end, attr, rule, value) {
  return attr.toLowerCase() + rule.toLowerCase() + 'ユーザーが ' + end + ' 件見つかりました : ' + '<b>' + html(value) + '</b>'
    
}

function i18n_search_list() {
  var width1
 
  if(NN > 0) {
    width1 = win ? 12 : 25;
  }
  else
    width1 = 30;
 
  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() +
    folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' 内で、次の条件に一致するメッセージを検索' +
    '</td>\n'+
   '<td>'+i18n['nbsp']+'</td>\n'+
   '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">送信者が</option>\n' +
    '<option value="SUBJECT">件名が</option>\n' +
    '<option value="BODY">本文が</option>\n' +
    '<option value="TO">受取人が</option>\n' +
    '</select>\n' +

    '<input type=text name="string">\n'+

    '<select name="rule">\n' +
    '<option value="">を含む</option>\n' +
    '<option value="NOT ">を含まない</option>\n' +
    '</select>\n' +

    main.nbutton('search', i18n['search'], "parent.doSearch()") +

    '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return '削除済みメッセージを ' + folder + ' フォルダへ移動'
}

function i18n_settings_draft_folder(folder) {
  return '作成中のメッセージを ' + folder + ' フォルダに保存'
}

function i18n_settings_sent_folder(folder) {
  return '送信したメッセージのコピーを ' + folder + ' フォルダに保存'
}

function i18n_settings_wrap_width() {
  return '<input size=2 name="meWrapWidth"> 文字でメッセージを折り返す'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    'メッセージに vCard を添付</td></tr>\n' +
    vc('名', 'nf', 32) +
    vc('姓', 'nl', 32) +
    vc('フルネーム', 'fn', 32) +
    vc('役職', 'ti', 32) +
    vc('組織', 'or', 32) +
    vc('部署', 'od', 32) +
    vc('電子メールアドレス', 'ei', 32) +
    vc('ホームページ', 'ur', 32) +
    vc('勤務先電話番号', 'tw', 14) +
    vc('自宅電話番号', 'th', 14) +
    vc('FAX 番号', 'tf', 14) +
    vc('ポケットベル番号', 'tp', 14) +
    vc('携帯電話番号', 'tc', 14) +
    vc('区町村および番地', 'ad', 32) +
    vc('市区郡', 'ci', 32) +
    vc('都道府県', 'st', 32) +
    vc('郵便番号', 'zi', 32) +
    vc('国', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='アフリカーンス語'
i18n['ar']='アラビア語'
i18n['ca']='カタロニア語'
i18n['zh-CN']='中国語/簡字体'
i18n['zh-TW']='中国語/繁字体'
i18n['cs']='チェコ語'
i18n['hr']='クロアチア語'
i18n['da']='デンマーク語'
i18n['nl']='オランダ語'
i18n['en']='英語'
i18n['fi']='フィンランド語'
i18n['fr']='フランス語'
i18n['gl']='ガリシア語'
i18n['de']='ドイツ語'
i18n['el']='ギリシャ語'
i18n['he']='ヘブライ語'
i18n['hu']='ハンガリー語'
i18n['is']='アイスランド語'
i18n['ga']='アイルランド'
i18n['it']='イタリア語'
i18n['ja']='日本語'
i18n['ko']='韓国語'
i18n['no']='ノルウェー語'
i18n['pl']='ポーランド語'
i18n['pt']='ポルトガル語'
i18n['ro']='ルーマニア語'
i18n['sk']='スロバキア語'
i18n['sl']='スロベニア語'
i18n['es']='スペイン語'
i18n['sv']='スウェーデン語'
i18n['th']='タイ語'
i18n['tr']='トルコ語'

function i18n_preferredlanguagelist()
{
    var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr');
    var s = '<select name="preferredLanguage">';
    for (i=0; i<lang_list.length; i++)
        s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>';
    return s+'</select>'
}

function i18n_search_options()
{

var s = '<select name="attr" size="1">' +
        '<option value="cn">フルネーム</option>' +
        '<option value="sn">姓</option>' +
        '<option value="givenname">名</option>' +
        '<option value="mail">電子メール</option>' +
        '<option value="uid">ユーザー ID</option>' +
        '<option value="telephonenumber">電話番号</option>\n' +
        '</select>' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">が次を含む</option>' +
        '<option value="equal">が次と等しい</option>\n' +
        '<option value="begin">が次で始まる</option>\n' +
        '<option value="sound">が次に似ている</option>' +
        '<option value="end">が次で終わる</option>' +
        '</select>'
  return s;
}
function i18n_month_list()
{
    var s=''
    for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'月'+'</option>'
    }
    return s
}

function i18n_day_list()
{
    var s=''
    for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'日'+'</option>'
    }
    return s
}
function i18n_year_list()
{
    var s=''
    var d= new Date();
    var year=d.getYear();

    for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
    }
    return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = 'アドレスブック'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'

i18n['Current Folder'] = '現在のフォルダ'
i18n['Mail'] = 'メール'
i18n['Calendar'] = 'カレンダー'
i18n['Options'] = 'オプション'
i18n['Address Book'] = 'アドレスブック'

// 2003年08月14日 (木) 10時48分09秒 JST
// 2003年08月22日 (金) 17時18分10秒 JST
// 2003年09月09日 (火) 15時59分12秒 JST
// 2003年09月12日 (金) 17時05分04秒 JST
// 2004年02月06日 (金) 12時05分13秒 JST
// 2004年03月19日 (金) 19時21分58秒 JST
// 2004 03 24 joon
