/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Map;
import netscape.ldap.LDAPEntry;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commDomainEntry;

public class commConstants {
    public static final String DOMAIN_OBJECT = "Domain";
    public static final String DOMAIN_OSI_OBJECT = "DomainOsi";
    public static final String DOMAIN_DC_OBJECT = "DomainDc";
    public static final String USER_OBJECT = "User";
    public static final String STATIC_GROUP_OBJECT = "StaticGroup";
    public static final String DYNAMIC_GROUP_OBJECT = "DynamicGroup";
    public static final String RESOURCE_OBJECT = "Resource";
    public static final String PEOPLE_CONTAINER_OBJECT = "PeopleContainer";
    public static final String GROUP_CONTAINER_OBJECT = "GroupContainer";
    public static final String ADMIN_OBJECT = "Admin";
    public static final int DOMAIN_TYPE = 1;
    public static final int DOMAIN_OSI_TYPE = 2;
    public static final int DOMAIN_DC_TYPE = 3;
    public static final int USER_TYPE = 4;
    public static final int GROUP_TYPE = 5;
    public static final int RESOURCE_TYPE = 6;
    public static final int PEOPLE_CONTAINER_TYPE = 7;
    public static final int GROUP_CONTAINER_TYPE = 8;
    public static final int ADMIN_ENTRY_TYPE = 9;
    public static final String BASE_SERVICE = "Base";
    public static final String MAIL_SERVICE = "Mail";
    public static final String CALENDAR_SERVICE = "Calendar";
    public static final String SCHEMA_I = "S1";
    public static final String SCHEMA_II = "S2";
    public static final int SCHEMA_I_TYPE = 1;
    public static final int SCHEMA_II_TYPE = 2;
    public static final String ATTRIBUTE = "attribute";
    public static final String MOVE = "Move";
    public static final String SERVICES = "Service";
    public static final String OBJECTS = "Object";
    public static final String DOMAIN_SUB_ENTRY = "DomainSubEntry";
    public static final String DOMAIN_ADMIN_ENTRY = "DomainAdminEntry";
    public static final String MOVE_AVPAIR_STRING = "Move=256";
    public static final String CONFIG_TOKEN_SEPARATOR = "^";
    public static final String CONFIG_VALUE_SEPARATOR = "=";
    public static final String CONFIG_ID_SEPARATOR = "-";
    public static final String ATTR_OPERATION = "op";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ORDER = "order";
    public static final String ATTR_REPLACE_OP_STR = "replace";
    public static final String ATTR_DELETE_OP_STR = "delete";
    public static final String ATTR_ADD_OP_STRING = "add";
    public static final int SINGLE_TYPE = 1;
    public static final int MULTI_TYPE = 2;
    public static final int ADMIN_TYPE = 3;
    public static final int COMPUTED_CLASS = 4;
    public static final int COMPUTED_MULTI_CLASS = 5;
    public static final int STATIC_CLASS = 6;
    public static final int MOVE_CLASS = 7;
    public static final int DN_ORDER = 8;
    public static final int ATTRIBUTE_ORDER = 9;
    public static final int ORG_POLICY_ORDER = 10;
    public static final int ORG_HELPDESK_ORDER = 11;
    public static final int ORG_ORGADMIN_ORDER = 12;
    public static final int ORG_CONTDEFTEMPLATE_ORDER = 13;
    public static final int ORG_PEOPLECONTAINER_ORDER = 14;
    public static final int ORG_GROUPADMIN_ORDER = 15;
    public static final int ATTRIBUTE_MOVE_ORDER = 16;
    public static final int COMMAND_RANK = 1;
    public static final int DOMAIN_ENTRY_RANK = 2;
    public static final int RUNTIME_RANK = 4;
    public static final String SINGLE_VALUE = "single";
    public static final String MULTI_VALUE = "multi";
    public static final String ADMIN_VALUE = "admin";
    public static final String COMPUTED_VALUE = "computed";
    public static final String COMPUTED_MULTI_VALUE = "computed-multi";
    public static final String STATIC_VALUE = "static";
    public static final String MOVE_VALUE = "move";
    public static final String ORG_POLICY_VALUE = "orgpolicy";
    public static final String ORG_HELPDESK_VALUE = "helpdesk";
    public static final String ORG_ORGADMIN_VALUE = "orgadmin";
    public static final String ORG_CONTDEFTEMPLATE_VALUE = "contdeftemplate";
    public static final String ORG_PEOPLECONTAINER_VALUE = "peoplecontainer";
    public static final String ORG_GROUPADMIN_VALUE = "groupadmin";
    public static final String ATTRIBUTE_MOVE_VALUE = "move";
    public static final String DN_VALUE = "dn";
    public static final String ATTRIBUTE_VALUE = "attribute";
    public static final String SCHEMA_I_SERVICEADMIN = "serviceadmin";
    public static final String SCHEMA_I_DOMAINADMIN = "domainadmin";
    public static final String SCHEMA_II_SERVICEADMIN = "topleveladmin";
    public static final String SCHEMA_II_DOMAINADMIN = "orgadmin";
    public static final String DOMAIN_BASEDN_ATTR = "inetdomainbasedn";
    public static final String DOMAIN_NAME_ATTR = "sunpreferreddomain";
    public static final String DOMAIN_CANONICAL_ATTR = "inetCanonicalDomainName";
    public static final String DOMAIN_ASSOCIATED_ATTR = "associateddomain";
    public static final String UNIQUEMEMBER_ATTR = "uniquemember";
    public static final String AM_AUTH_LDAP_BIND_PASSWD = "iplanet-am-auth-ldap-bind-passwd";
    public static final int LDAP_ADD = 0;
    public static final int LDAP_REPLACE = 2;
    public static final int LDAP_DELETE = 1;
    public static final String PACKAGE_NAME = "sun.comm.dirmig.resource";
    public static final String LOG_FILES_LOCATION = "/opt/SUNWcomm/data/log";
    private static final String ALL_USER_SF = "objectclass=inetuser";
    private static final String SINGLE_USER_SF = "(uid=%s)(objectclass=inetuser)";
    private static final String ALL_GROUP_SF = "objectclass=inetgroup";
    public static final int DC_TREE = 1;
    public static final int OSI_TREE = 2;
    public static final int DOMAIN_TREE = 3;
    public static final String ALL_S1 = "All-S1";
    public static final String ALL_S2 = "All-S2";
    public static final String SINGLE_S1 = "Single-S1";
    public static final String SINGLE_S2 = "Single-S2";
    public static final String ALL = "All";
    public static final String SINGLE = "Single";
    public static final String ALL_BY_INETDOMAIN = "All-Inetdomainbasedn";
    public static final int SEARCH_SYNC = 1000;
    public static final int SEARCH_ASYNC = 1001;
    public static final String M_OSI_ROOT = "%OSI_ROOT%";
    public static final String M_DC_ROOT = "%DC_ROOT%";
    public static final String M_SEARCH_BASEDN = "%SEARCH_BASEDN%";
    public static final String M_MAIL_HOST = "%MAIL_HOST%";
    public static final String M_DOMAIN_MARKER_CLASS = "%DOMAIN_MARKER%";
    public static final String M_DOMAIN_NAME = "%DOMAIN_NAME%";
    public static final String M_DOMAIN_NODE = "%DOMAIN_NODE%";
    public static final String M_DOMAIN_UG_DN = "%DOMAIN_UG_DN%";
    public static final String M_DOMAIN_IS_DN = "%DOMAIN_IS_DN%";
    public static final String M_DOMAIN_CANONICAL_NAME = "%DOMAIN_CANONICAL_NAME%";
    public static final String M_DOMAIN_ASSOCIATED_DOMAIN = "%DOMAIN_ASSOCIATED_DOMAIN%";
    public static final String M_USER_MARKER_CLASS = "%USER_MARKER%";
    public static final String M_USER_UID = "%USER_UID%";
    public static final String M_STATIC_GROUP_MARKER_CLASS = "%STATIC_GROUP_MARKER%";
    public static final String M_DYNAMIC_GROUP_MARKER_CLASS = "%DYNAMIC_GROUP_MARKER%";
    public static final String M_HETEROGEN_MARKER_CLASS = "%HETRO_GROUP_MARKER%";
    public static final String M_GROUP_NAME = "%GROUP_NAME%";
    public static final String M_RESOURCE_MARKER_CLASS = "%RESOURCE_MARKER%";
    public static final String M_RESOURCE_NAME = "%RESOURCE_NAME%";
    public static final String M_PEOPLE_CONTAINER_MARKER_CLASS = "%PEOPLE_CONTAINER_MARKER%";
    public static final String M_GROUP_CONTAINER_MARKER_CLASS = "%GROUP_CONTAINER_MARKER%";
    public static final String M_LDAP_BIND_PASSWORD = "%LDAP_BIND_PASSWORD%";
    public static final String M_CN = "%CN%";
    public static final String M_ADMIN_DN = "%ADMIN_DN%";
    public static final String SECTION_END = "%%SECTION_END%%";
    public static final String CN = "cn";
    public static final String UID = "uid";
    public static final String MAIL = "mail";
    public static final String CAL = "cal";
    public static final String ADMIN_ID = "D";
    public static final String ADMIN_PASSWORD = "w";
    public static final String LDAP_HOST = "X";
    public static final String LDAP_PORT = "p";
    public static final String OSI_ROOT = "b";
    public static final String DC_ROOT = "r";
    public static final String MIGRATION_TYPE = "t";
    public static final String SERVICES_TO_ADD = "S";
    public static final String ONLINE = "o";
    public static final String LDIF_OUTPUT_FILE = "a";
    public static final String DOMAINS = "d";
    public static final String LOGFILE_NAME = "l";
    public static final String VERBOSE = "V";
    public static final String CONTINUE = "c";
    public static final String INPUTFILE_NAME = "i";
    public static final String HELP = "h";
    public static final String QUESTION = "?";
    public static final String VERSION = "V";
    public static final String MAIL_HOST = "H";
    public static final String LDIF_UNDO_FILE = "u";
    public static final String LOG_MAX_SIZE = "m";
    public static final String DOMAINSFILE = "f";
    public static final String CONSISTENCYCHECK = "k";
    public static final int S1_TO_S2 = 1;
    public static final int S1_TO_S2C = 2;
    public static final int S2C_TO_S2 = 3;
    public static final String VERSIONINFO = "commdirmig 1.0";
    public static final String LIBDIR = "../lib";
    public static final String COMMDIRMIG_PREFS = "/commdirmig-userprefs.properties";
    public static final String DCROOT = "dcroot";
    public static final String OSIROOT = "osiroot";
    public static final String LDAPHOST = "ldaphost";
    public static final String LDAPPORT = "ldapport";
    public static final String EQUALTO = "=";
    public static final String LOGMAXSIZE = "logmaxsize";
    public static final String LOGMAXSIZEDEFAULT = "500k";
    public static final String USAGE = "Usage :\nMandatory Options : \n\n-D  <authentication id> \n-w  <password> \n-t  migration type : allowed values are <1,2,3> \n                   (1= S1 to s2, 2= S1 to S2c, 3= S2c to S2) \n\nMandatory and configurable options :\n\n-X  <directory server hostname> \n-p  <directory server port no.> \n-b  <OSI root suffix> \n-r  <DC root suffix> \n\nNon Mandatory Options :\n\n-S  service to add : allowed values are <mail,cal>  \n                   service to be added to user, groups of the domain \n-H  <mailHost>     The mailhost to be used to add mail services to users \n                   and groups. This is mandatory when -S mail is used. \n\n-o                 To change directory data this option is needed.\n\t\t\tIf this option is not given only ldif s are generated \n                   no directory changes are done \n\n-a  <audit ldif file> \n                   default name of the file is commdirmig.audit.ldif \n-u  <undo ldif file> \n                   default name of the file is commdirmig.undo.ldif \n-d  <domain>       * means all domains \n-f  <file>         an input file with domain names \n                   or with sets of domain names and preferredMailHost \n                   values, which can be used as mailhost when mail \n                   service is being added to users and groups of the domain \n                    either of -d or -f can be used at a time \n\n-l  <log filename> dfeualt name of the file is commdirmig.log \n                   \n-m  <logmaxsize>   It is an integer followed by an unit. \n                   Unit should be k or m; k for KiloBytes, m for Megabytes \n\n-k  \t\tcheck for erroneously provisioned domains. Bad domains \n                   are reported in the log file \n\n-v  verbose \n-c  continue on error \n-i  <input file>   contains option arguments in a file \n-h  prints help information \n-?  prints help information \n-V  version \n\n";
    public static final String GIVE_AUTH_ID = "Administrator login id is required ";
    public static final String GIVE_PASSWORD = "Administrator password is required ";
    public static final String TYPE_REQUIRED = "Migration type is required";
    public static final String INVALID_TYPE = "Invalid Value for Migration Type, Valid values are 1, 2, 3";
    public static final String ONLY_FOR_MAIL_SERVICE = "Mailhost is valid only when mail service to be added";
    public static final String INVALID_SERVICE_LIST = "Invalid no. of Services";
    public static final String INVALID_SERVICE = "Invalid Service value";
    public static final String INVALID_DOMAIN = "Invalid Domain Name";
    public static final String LDAPHOSTREQUIRED = "Directory server host name is required";
    public static final String LDAPPORTREQUIRED = "Directory server port no. is required";
    public static final String OSIROOTSREQUIRED = "OSI root suffix is required";
    public static final String DCROOTSREQUIRED = "DC root suffix is required";
    public static final String ONLYCONSISTENCYCHECK = "When -k is specified only erroneous provisioning of domains are checked and logged. -o does not take affect. No migration takes place";
    public static final String ALLDOMAINSWILLBECHECKED = "When -k is specified erroneous provisioning of all domains are checked and logged. -d doesn't take affect";
    public static final String INVALIDOPTIONCOMBO = "-d and -f both can not be used together";
    public static final String PASSWORDFILEEMPTY = "Password file is empty";
    public static final String MAILHOST_REQUIRED = "Mailhost is required option to add mail service";
    public static final String CONTINUATION_LINE = "\n ";
    public static final String NEW_LINE = "\n";
    public static final int LOG_LEVEL_NORMAL = 1;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final String CODED_STRINGS = "Coded";
    public static final String LDIF_AUDIT_DEFAULT = "commdirmig.audit.ldif";
    public static final String LDIF_UNDO_DEFAULT = "commdirmig.undo.ldif";
    public static final String LOG_OUTPUT_DEFAULT = "commdirmig.log";
    public static final String LOG_MAXSIZE_DEFAULT = "500K";
    public static final String CHANGETYPE_ADD = "changetype: add";
    public static final String CHANGETYPE_DELETE = "changetype: delete";
    public static final String CHANGETYPE_MODIFY = "changetype: modify";
    public static final String LDIF_NEW_ITEM = "-";
    public static final String LDIF_ADD = "add";
    public static final String LDIF_DELETE = "delete";
    public static final String LDIF_REPLACE = "replace";
    public static final String LDIF_SEPARATOR = ": ";
    public static final String LOG_SECTION = "Log";
    public static final String MISSING_CODED_STRING = "missing_coded_string";
    public static final String EXCEPTION = "exception";
    public static final String LDAP_EXCEPTION = "ldap_exception";
    public static final String DN_TITLE = "dn_title";
    public static final String MISSING_WORD = "missingword";
    public static final int DOMAIN_GROUP_NO_CANONICAL = 1;
    public static final int DOMAIN_GROUP_YES_CANONICAL = 2;
    public static final int DOMAIN_GROUP_MAYBE_CANONICAL = 3;
    public static final int DOMAIN_GROUP_MULTI_CANONICAL = 4;
    public static final int DOMAIN_GROUP_ERROR_CANONICAL = 5;
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    public static final int DOMAIN_CODE_SUCCESS = 100;
    public static final int DOMAIN_CODE_FAILURE = 101;
    public static final int INVALID_DOMAIN_CODE = 4;
    public static final int INVALID_ALIAS_DOMAIN_CODE = 5;
    public static final int INVALID_LOGMAX_CODE = 6;

    public static String getUserSearchFilter() {
        return ALL_USER_SF;
    }

    public static String getGroupSearchFilter() {
        return ALL_GROUP_SF;
    }

    public static String substitute(String theString) throws Exception {
        Map aMap = null;
        return commConstants.substitute(theString, null, null, aMap);
    }

    public static String substitute(String theString, commDomainEntry theDomain, LDAPEntry theEntry) throws Exception {
        Map aMap = null;
        return commConstants.substitute(theString, theDomain, theEntry, aMap);
    }

    public static String substitute(String theString, Map theValues) throws Exception {
        return commConstants.substitute(theString, null, null, theValues);
    }

    public static String substitute(String theString, commDomainEntry theDomain, LDAPEntry theEntry, Map theValueMap) throws Exception {
        int aMacroIndex = -1;
        boolean aMacroLength = false;
        boolean aEndMacroOffset = false;
        String aReturnString = theString;
        String aSubstitueString = null;
        Object aSubValue = null;
        String aUserId = null;
        Object aDomainName = null;
        Object aDomainNode = null;
        String aCn = null;
        String[] aValueArray = null;
        aMacroIndex = aReturnString.indexOf(M_DOMAIN_NAME);
        if (aMacroIndex != -1) {
            if (theDomain != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_NAME, theDomain.getDomainName());
            } else if (theValueMap != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_NAME, (String)theValueMap.get(M_DOMAIN_NAME));
            }
        }
        if ((aMacroIndex = aReturnString.indexOf(M_DOMAIN_UG_DN)) != -1) {
            if (theDomain != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_UG_DN, theDomain.getUgBaseDn());
            } else if (theValueMap != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_UG_DN, (String)theValueMap.get(M_DOMAIN_UG_DN));
            }
        }
        if ((aMacroIndex = aReturnString.indexOf(M_DOMAIN_CANONICAL_NAME)) != -1) {
            if (theDomain != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_CANONICAL_NAME, theDomain.getCanonicalName());
            } else if (theValueMap != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_CANONICAL_NAME, (String)theValueMap.get(M_DOMAIN_CANONICAL_NAME));
            }
        }
        if ((aMacroIndex = aReturnString.indexOf(M_DOMAIN_ASSOCIATED_DOMAIN)) != -1 && theValueMap != null) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_ASSOCIATED_DOMAIN, (String)theValueMap.get(M_DOMAIN_ASSOCIATED_DOMAIN));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_DOMAIN_IS_DN)) != -1) {
            if (theDomain != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_IS_DN, commConstants.createIsDn(theDomain.getUgBaseDn()));
            } else if (theValueMap != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_IS_DN, commConstants.createIsDn((String)theValueMap.get(M_DOMAIN_UG_DN)));
            }
        }
        if ((aMacroIndex = aReturnString.indexOf(M_USER_UID)) != -1) {
            if (theEntry != null) {
                aValueArray = theEntry.getAttribute(UID).getStringValueArray();
                if (aValueArray.length > 0) {
                    aUserId = aValueArray[0];
                    aReturnString = commConstants.insertStringValue(aReturnString, M_USER_UID, aUserId);
                }
            } else if (theValueMap != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_USER_UID, (String)theValueMap.get(M_USER_UID));
            }
        }
        if ((aMacroIndex = aReturnString.indexOf(M_CN)) != -1) {
            if (theEntry != null) {
                aValueArray = theEntry.getAttribute(CN).getStringValueArray();
                if (aValueArray.length > 0) {
                    aCn = aValueArray[0];
                    if (aCn != null) {
                        aCn = aCn.replace(' ', '_');
                    }
                    aReturnString = commConstants.insertStringValue(aReturnString, M_CN, aCn);
                }
            } else if (theValueMap != null) {
                aReturnString = commConstants.insertStringValue(aReturnString, M_CN, (String)theValueMap.get(M_CN));
            }
        }
        if ((aMacroIndex = aReturnString.indexOf(M_GROUP_NAME)) != -1 && theValueMap != null) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_GROUP_NAME, (String)theValueMap.get(M_GROUP_NAME));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_RESOURCE_NAME)) != -1 && theValueMap != null) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_RESOURCE_NAME, (String)theValueMap.get(M_RESOURCE_NAME));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_ADMIN_DN)) != -1 && theValueMap != null) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_ADMIN_DN, (String)theValueMap.get(M_ADMIN_DN));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_LDAP_BIND_PASSWORD)) != -1) {
            aReturnString = theValueMap != null && (aSubstitueString = (String)theValueMap.get(M_LDAP_BIND_PASSWORD)) != null ? commConstants.insertStringValue(aReturnString, M_LDAP_BIND_PASSWORD, aSubstitueString) : commConstants.insertStringValue(aReturnString, M_LDAP_BIND_PASSWORD, commConfig.getMacroValue(M_LDAP_BIND_PASSWORD));
        }
        if ((aMacroIndex = theString.indexOf(M_OSI_ROOT)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_OSI_ROOT, commConfig.getMacroValue(M_OSI_ROOT));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_MAIL_HOST)) != -1) {
            String macroValue = theDomain.getMailHost();
            if (macroValue == null) {
                macroValue = commConfig.getMacroValue(M_MAIL_HOST);
            }
            aReturnString = commConstants.insertStringValue(aReturnString, M_MAIL_HOST, macroValue);
        }
        if ((aMacroIndex = aReturnString.indexOf(M_DOMAIN_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_DOMAIN_MARKER_CLASS, commConfig.getMacroValue(M_DOMAIN_MARKER_CLASS));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_USER_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_USER_MARKER_CLASS, commConfig.getMacroValue(M_USER_MARKER_CLASS));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_STATIC_GROUP_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_STATIC_GROUP_MARKER_CLASS, commConfig.getMacroValue(M_STATIC_GROUP_MARKER_CLASS));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_DYNAMIC_GROUP_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_DYNAMIC_GROUP_MARKER_CLASS, commConfig.getMacroValue(M_DYNAMIC_GROUP_MARKER_CLASS));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_PEOPLE_CONTAINER_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_PEOPLE_CONTAINER_MARKER_CLASS, commConfig.getMacroValue(M_PEOPLE_CONTAINER_MARKER_CLASS));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_GROUP_CONTAINER_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_GROUP_CONTAINER_MARKER_CLASS, commConfig.getMacroValue(M_GROUP_CONTAINER_MARKER_CLASS));
        }
        if ((aMacroIndex = aReturnString.indexOf(M_RESOURCE_MARKER_CLASS)) != -1) {
            aReturnString = commConstants.insertStringValue(aReturnString, M_RESOURCE_MARKER_CLASS, commConfig.getMacroValue(M_RESOURCE_MARKER_CLASS));
        }
        return aReturnString;
    }

    private static String insertStringValue(String theOrigString, String theTargetString, String theSubstituteString) throws Exception {
        String aReturnString = theOrigString;
        Object aBeginning = null;
        Object aEnding = null;
        int aTargetIndex = 0;
        int aTargetEndIndex = 0;
        int aTargetStringLen = theTargetString.length();
        int aReturnStringLen = 0;
        if (theSubstituteString == null) {
            return theOrigString;
        }
        while ((aTargetIndex = aReturnString.indexOf(theTargetString)) != -1) {
            aTargetEndIndex = aTargetIndex + aTargetStringLen;
            aReturnStringLen = aReturnString.length();
            if (aTargetIndex == 0) {
                if (aTargetEndIndex > aReturnStringLen) {
                    aReturnString = theSubstituteString;
                    continue;
                }
                aReturnString = theSubstituteString + aReturnString.substring(aTargetEndIndex);
                continue;
            }
            if (aTargetIndex > aReturnStringLen) {
                aReturnString = aReturnString.substring(0, aTargetIndex) + theSubstituteString;
                continue;
            }
            aReturnString = aReturnString.substring(0, aTargetIndex) + theSubstituteString + aReturnString.substring(aTargetEndIndex);
        }
        return aReturnString;
    }

    public static String createIsDn(String theDomainDn) {
        Object aReturnString = null;
        boolean aIdx = false;
        if (theDomainDn == null) {
            return theDomainDn;
        }
        return theDomainDn.replace(',', '_');
    }
}

