/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commDirMig;
import sun.comm.dirmig.commDomainEntry;
import sun.comm.dirmig.commEntry;
import sun.comm.dirmig.commFactoryInterface;
import sun.comm.dirmig.commLdifLogger;
import sun.comm.dirmig.commLogger;
import sun.comm.dirmig.commSearchConstraints;
import sun.comm.dirmig.commSearchResults;

public class commDirectory {
    LDAPConnection myConn = new LDAPConnection();
    commLdifLogger sLdifAudit = null;
    commLdifLogger sLdifUndo = null;
    String osiRoot = null;
    private static String dcRoot = null;
    commConfig myCommConfig = null;
    public static final String USER_SEARCH_FILTER = "objectclass=inetuser";

    public commDirectory(String host, int port, String bindDN, String bindPasswd, String osi) throws LDAPException {
        this.myConn.connect(host, port, bindDN, bindPasswd);
        this.myConn.setOption(3, (Object)new Integer(0));
        this.osiRoot = osi;
    }

    public void setCommConfig(commConfig gCommConfig) {
        this.myCommConfig = gCommConfig;
    }

    public void setLogs(commLdifLogger theAuditLog, commLdifLogger theUndoLog) {
        this.sLdifAudit = theAuditLog;
        this.sLdifUndo = theUndoLog;
    }

    public void setDCRoot(String dc) {
        dcRoot = dc;
    }

    public commDomainEntry getDomain_ByDomainName_SI(String theDomainName) throws LDAPException {
        String aDomEntryDn = commDirectory._domainToDC(theDomainName);
        return this.getDomain_SI(theDomainName, aDomEntryDn);
    }

    public commDomainEntry getDomain_ByDn_SI(String theDomainDn) throws LDAPException {
        String aDomainName = commDirectory.domainDnToDomainName(theDomainDn);
        return this.getDomain_SI(aDomainName, theDomainDn);
    }

    public commDomainEntry getDomain_SI(String theDomainName, String theDomainDn) throws LDAPException {
        LDAPEntry aDcNode = null;
        commDomainEntry aCommDomainEntry = null;
        aDcNode = this.myConn.read(theDomainDn);
        if (aDcNode == null) {
            return null;
        }
        aCommDomainEntry = new commDomainEntry(aDcNode);
        return aCommDomainEntry;
    }

    public void resolveOsiNode(commDomainEntry theDomainEntry) {
        LDAPEntry aOsiNode = null;
        Vector aTraversedList = new Vector();
        try {
            aOsiNode = this.findOsiNode(theDomainEntry.getLDAPEntry(), aTraversedList);
            if (aOsiNode != null) {
                theDomainEntry.setOsiNode(aOsiNode);
            } else {
                theDomainEntry.setOsiNode(null);
                theDomainEntry.setOsiFailureList(aTraversedList);
            }
        }
        catch (Exception theException) {
            theDomainEntry.setOsiNode(null);
            theDomainEntry.setOsiFailureList(aTraversedList);
        }
    }

    protected LDAPEntry findOsiNode(LDAPEntry theDcNode, Vector theTraversedList) throws Exception {
        LDAPEntry aOsiNode = null;
        String aBaseDnValue = null;
        String aDcNodeMarkerClass = null;
        if (theTraversedList.indexOf(commDirectory.normalizeDn(theDcNode.getDN())) >= 0) {
            return null;
        }
        aDcNodeMarkerClass = commConfig.getMarkerClass("Domain", "Base", "S1");
        try {
            aBaseDnValue = commDirectory.getFirstAttrValue(theDcNode, "inetdomainbasedn");
            if (aBaseDnValue != null) {
                if (aBaseDnValue.equals(commDirectory.normalizeDn(theDcNode.getDN()))) {
                    return theDcNode;
                }
            } else {
                return null;
            }
            aOsiNode = this.myConn.read(aBaseDnValue);
            if (commDirectory.attributeHasValue(aOsiNode, "objectclass", aDcNodeMarkerClass)) {
                theTraversedList.add(commDirectory.normalizeDn(aOsiNode.getDN()));
                return this.findOsiNode(aOsiNode, theTraversedList);
            }
            return aOsiNode;
        }
        catch (LDAPException le) {
            commLogger.writeLog(commConfig.getCodedString(12) + le.errorCodeToString());
            commLogger.writeLog(commConfig.getCodedString(14) + theDcNode.getDN());
            return null;
        }
    }

    public commDomainEntry getDomain_SII(String theDomainName) throws Exception {
        commDomainEntry aDomain = null;
        return aDomain;
    }

    public Set searchObjects(String theObjectType, String theObjectSearchType, commDomainEntry theDomain, Map theValueMap, int theRoot) throws Exception {
        HashSet<commEntry> aObjects;
        block12: {
            LDAPSearchResults aSearchResults = null;
            LDAPEntry aLdapEntry = null;
            commEntry aCommEntry = null;
            aObjects = new HashSet<commEntry>();
            String aFilter = null;
            String aBaseDn = null;
            aFilter = this.getFilter(theObjectType, theObjectSearchType, theDomain, null, theValueMap);
            if (theRoot == 1) {
                aBaseDn = commConfig.getMacroValue("%DC_ROOT%");
            } else if (theRoot == 2) {
                aBaseDn = commConfig.getMacroValue("%OSI_ROOT%");
            } else if (theRoot == 3 && theDomain != null) {
                aBaseDn = theDomain.getUgBaseDn();
            }
            if (aBaseDn == null && theValueMap != null) {
                aBaseDn = (String)theValueMap.get("%SEARCH_BASEDN%");
            }
            if (aBaseDn == null) {
                return null;
            }
            commFactoryInterface fac = null;
            String facName = commConfig.getFactoryClass(theObjectType);
            Class<?> cl = Class.forName(facName);
            fac = (commFactoryInterface)cl.newInstance();
            try {
                aSearchResults = this.myConn.search(aBaseDn, 2, aFilter, null, false);
                while (aSearchResults.hasMoreElements()) {
                    aLdapEntry = aSearchResults.next();
                    aCommEntry = fac.createObject(aLdapEntry);
                    if (aCommEntry == null) continue;
                    aObjects.add(aCommEntry);
                }
            }
            catch (LDAPException le) {
                commLogger.writeLog(commConfig.getCodedString(12) + le.errorCodeToString());
                String matchedDN = le.getMatchedDN();
                if (matchedDN == null) break block12;
                commLogger.writeLog(commConfig.getCodedString(10) + matchedDN);
            }
        }
        return aObjects;
    }

    public commSearchResults searchObjects(commSearchConstraints theCommSearchConstraints) throws Exception {
        commSearchResults aCommSearchResults = null;
        aCommSearchResults = theCommSearchConstraints.getSearchType() == 1001 ? this.searchObjects_async(theCommSearchConstraints) : this.searchObjects_sync(theCommSearchConstraints);
        return aCommSearchResults;
    }

    protected commSearchResults searchObjects_sync(commSearchConstraints theCommSearchConstraints) throws Exception {
        LDAPSearchResults aSearchResults = null;
        LDAPEntry aLdapEntry = null;
        commEntry aCommEntry = null;
        commSearchResults aCommSearchResults = null;
        commFactoryInterface aFactory = null;
        aCommSearchResults = new commSearchResults(theCommSearchConstraints.getObjectString(), 1000);
        aFactory = aCommSearchResults.getClassFactory();
        try {
            String aFilter = theCommSearchConstraints.getFilter();
            String aBaseDn = theCommSearchConstraints.getBaseDn();
            aSearchResults = this.myConn.search(aBaseDn, 2, aFilter, null, false);
            while (aSearchResults.hasMoreElements()) {
                aLdapEntry = aSearchResults.next();
                aCommEntry = aFactory.createObject(aLdapEntry);
                if (aCommEntry == null) continue;
                aCommSearchResults.add(aCommEntry);
            }
        }
        catch (LDAPException le) {
            commLogger.writeLog(commConfig.getCodedString(12) + le.errorCodeToString());
        }
        return aCommSearchResults;
    }

    protected commSearchResults searchObjects_async(commSearchConstraints theCommSearchConstraints) throws Exception {
        LDAPSearchListener aLdapSearchListener = null;
        commSearchResults aCommSearchResults = null;
        aCommSearchResults = new commSearchResults(theCommSearchConstraints.getObjectString(), 1001);
        try {
            String aFilter = theCommSearchConstraints.getFilter();
            String aBaseDn = theCommSearchConstraints.getBaseDn();
            aLdapSearchListener = this.myConn.search(aBaseDn, 2, aFilter, null, false, aLdapSearchListener);
        }
        catch (LDAPException le) {
            commLogger.writeLog(commConfig.getCodedString(12) + le.errorCodeToString());
        }
        aCommSearchResults.setListener(aLdapSearchListener);
        return aCommSearchResults;
    }

    public int modify(Set theEntrySet) throws Exception {
        Iterator aIterator = theEntrySet.iterator();
        int aReturn = 0;
        if (commDirMig.getOptionValue("o") != null) {
            while (aIterator.hasNext() && aReturn == 0) {
                aReturn = this.modifyEntryOnline((commEntry)aIterator.next());
            }
        } else {
            while (aIterator.hasNext() && aReturn == 0) {
                aReturn = this.modifyEntryLog((commEntry)aIterator.next());
            }
        }
        return aReturn;
    }

    public int modify(commEntry theCommEntry) throws Exception {
        if (commDirMig.getOptionValue("o") != null) {
            return this.modifyEntryOnline(theCommEntry);
        }
        return this.modifyEntryLog(theCommEntry);
    }

    protected int modifyEntryOnline(commEntry theCommEntry) throws Exception {
        LDAPModificationSet modSet = theCommEntry.getModificationSet();
        String aEntryDn = "";
        if (modSet != null && modSet.size() > 0) {
            try {
                aEntryDn = theCommEntry.getLDAPEntry().getDN();
                this.myConn.modify(aEntryDn, modSet);
                this.sLdifAudit.modifyEntry(modSet, aEntryDn);
                this.sLdifUndo.undoModification(modSet, aEntryDn);
            }
            catch (LDAPException e) {
                commLogger.writeLog(1, e, modSet, aEntryDn);
                if (commDirMig.getOptionValue("c") == null) {
                    System.err.println(commConfig.getCodedString(12) + e.errorCodeToString());
                    System.exit(-1);
                }
            }
        } else {
            commLogger.writeLog(2, theCommEntry.getLDAPEntry().getDN());
        }
        return 0;
    }

    protected int modifyEntryLog(commEntry theCommEntry) throws Exception {
        LDAPModificationSet modSet = theCommEntry.getModificationSet();
        String aEntryDn = "";
        aEntryDn = theCommEntry.getLDAPEntry().getDN();
        if (modSet != null && modSet.size() > 0) {
            this.sLdifAudit.modifyEntry(modSet, aEntryDn);
            this.sLdifUndo.undoModification(modSet, aEntryDn);
        } else {
            commLogger.writeLog(2, theCommEntry.getLDAPEntry().getDN());
        }
        return 0;
    }

    public int add(Set theEntrySet) throws Exception {
        Vector theEntryVector = new Vector(theEntrySet);
        return this.add(theEntryVector);
    }

    public int add(Vector theEntryVector) throws Exception {
        Iterator aIterator = theEntryVector.iterator();
        LDAPEntry aLdapEntry = null;
        PrintWriter aLdifOutputFile = commDirMig.getLdifOutputFile();
        commEntry aCommEntry = null;
        String aDn = null;
        Object aStringRep = null;
        if (commDirMig.getOptionValue("o") != null) {
            while (aIterator.hasNext()) {
                aCommEntry = (commEntry)aIterator.next();
                try {
                    aLdapEntry = aCommEntry.getLDAPEntry();
                    aDn = aLdapEntry.getDN();
                    this.myConn.add(aLdapEntry);
                    this.sLdifAudit.addLdapEntry(aLdapEntry);
                    this.sLdifUndo.deleteLdapEntry(aLdapEntry);
                }
                catch (LDAPException e) {
                    commLogger.writeLog(1, e, aLdapEntry);
                    if (commDirMig.getOptionValue("c") != null) continue;
                    System.err.println(commConfig.getCodedString(12) + e.errorCodeToString());
                    System.exit(-1);
                }
            }
        } else {
            while (aIterator.hasNext()) {
                aCommEntry = (commEntry)aIterator.next();
                this.sLdifAudit.addLdapEntry(aCommEntry.getLDAPEntry());
                this.sLdifUndo.deleteLdapEntry(aCommEntry.getLDAPEntry());
            }
        }
        return 0;
    }

    public int add(LDAPAttributeSet theAttributeSet, String theDn) throws Exception {
        block2: {
            LDAPEntry aLdapEntry = null;
            try {
                aLdapEntry = new LDAPEntry(theDn, theAttributeSet);
                this.myConn.add(aLdapEntry);
            }
            catch (LDAPException e) {
                commLogger.writeLog(1, e, aLdapEntry);
                if (commDirMig.getOptionValue("c") != null) break block2;
                System.err.println(commConfig.getCodedString(12) + e.errorCodeToString());
                System.exit(-1);
            }
        }
        return 0;
    }

    public LDAPEntry getLDAPEntry(String dn) throws Exception {
        LDAPEntry aLdapEntry = null;
        try {
            aLdapEntry = this.myConn.read(dn);
        }
        catch (LDAPException le) {
            int aResultCode = le.getLDAPResultCode();
            if (aResultCode == 32) {
                aLdapEntry = null;
            }
            throw le;
        }
        return aLdapEntry;
    }

    public LDAPEntry getLDAPEntry(String dn, String[] theAttributesToRetrieve) throws Exception {
        LDAPEntry aLdapEntry = null;
        try {
            aLdapEntry = this.myConn.read(dn, theAttributesToRetrieve);
        }
        catch (LDAPException le) {
            int aResultCode = le.getLDAPResultCode();
            if (aResultCode == 32) {
                aLdapEntry = null;
            }
            throw le;
        }
        return aLdapEntry;
    }

    public LDAPConnection getConnection() {
        return this.myConn;
    }

    private String getFilter(String theObject, String theSearchType, commDomainEntry theDomainEntry, LDAPEntry theLdapEntry, Map theValueMap) throws Exception {
        String aFilter = commConfig.getSearchFilter(theObject, theSearchType, theDomainEntry, theLdapEntry, theValueMap);
        return aFilter;
    }

    protected commEntry getEntry(String theObjectName, LDAPEntry theEntry, commConfig theCommConfig) throws Exception {
        commEntry aCommEntry = null;
        return aCommEntry;
    }

    public static String _domainToDC(String domainName) {
        String[] comps = domainName.split("\\.");
        String dn = "dc=" + comps[0];
        for (int i = 1; i < comps.length; ++i) {
            dn = dn + ",dc=" + comps[i];
        }
        dn = dn + "," + dcRoot;
        return commDirectory.normalizeDn(dn);
    }

    public static String domainDnToDomainName(String theDomainDn) {
        StringBuffer aReturnBuffer = new StringBuffer(64);
        String[] aElements = theDomainDn.split(",");
        int aElementCount = aElements.length - 2;
        int aIdx = 0;
        for (aIdx = 0; aIdx < aElementCount; ++aIdx) {
            aReturnBuffer.append(aElements[aIdx].split("=")[1].trim()).append(".");
        }
        aReturnBuffer.append(aElements[aIdx].split("=")[1].trim());
        return aReturnBuffer.toString().toLowerCase();
    }

    public static String normalizeDn(String theDn) {
        String[] aElements = theDn.split(",");
        String[] aSingleElement = null;
        StringBuffer aReturnDn = new StringBuffer(128);
        int aIdx = 0;
        int aCount = aElements.length - 1;
        for (aIdx = 0; aIdx < aCount; ++aIdx) {
            aSingleElement = aElements[aIdx].split("=");
            aReturnDn.append(aSingleElement[0].trim()).append("=").append(aSingleElement[1].trim()).append(",");
        }
        aSingleElement = aElements[aIdx].split("=");
        aReturnDn.append(aSingleElement[0].trim()).append("=").append(aSingleElement[1].trim());
        return aReturnDn.toString().toLowerCase();
    }

    public static boolean attributeHasValue(LDAPEntry theLdapEntry, String theAttributeName, String theAttributeValue) {
        LDAPAttribute aLdapAttribute = null;
        String[] aAttrValues = null;
        boolean aBoolReturn = false;
        int aIdx = 0;
        if (theLdapEntry == null || theAttributeName == null || theAttributeValue == null) {
            return false;
        }
        aLdapAttribute = theLdapEntry.getAttribute(theAttributeName = theAttributeName.trim());
        if (aLdapAttribute != null) {
            aAttrValues = aLdapAttribute.getStringValueArray();
            for (aIdx = 0; aIdx < aAttrValues.length; ++aIdx) {
                if (!theAttributeValue.equalsIgnoreCase(aAttrValues[aIdx].trim())) continue;
                aBoolReturn = true;
                break;
            }
        }
        return aBoolReturn;
    }

    public static String getFirstAttrValue(LDAPEntry theLdapEntry, String theAttributeName) throws Exception {
        LDAPAttribute aLdapAttribute = null;
        String[] aAttrValues = null;
        String aReturnString = null;
        if (theLdapEntry == null || theAttributeName == null) {
            return null;
        }
        aLdapAttribute = theLdapEntry.getAttribute(theAttributeName);
        if (aLdapAttribute != null && (aAttrValues = aLdapAttribute.getStringValueArray()) != null && aAttrValues.length > 0) {
            aReturnString = aAttrValues[0];
        }
        return aReturnString;
    }

    public int test() throws Exception {
        String aDomainDn = "o=Sub Domain one  ,  o = Sub Domain Two,  o=Domain Three, o= internet";
        String aDcDn = "dc=Red,   dc  = Iplanet,  dc=Com  ,  dc  = internet";
        String aDomainName = "reD.iplaneT.coM";
        String aReturnString = null;
        aReturnString = commDirectory.normalizeDn(aDomainDn);
        aReturnString = commDirectory.domainDnToDomainName(aDcDn);
        aReturnString = commDirectory._domainToDC(aDomainName);
        return 1;
    }
}

