/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.CommandToNet;
import com.iplanet.im.net.Config;
import com.iplanet.im.net.Connection;
import com.iplanet.im.net.ConnectionEvent;
import com.iplanet.im.net.ConnectionStatusListener;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageListener;
import com.iplanet.im.net.MessageStatusEvent;
import com.iplanet.im.net.MsgStatusListener;
import com.iplanet.im.net.NetIOException;
import com.iplanet.im.net.QueueConnection;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomConnection;
import com.iplanet.im.net.RoomMsg;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.TopicConnection;
import com.iplanet.im.net.UserEvent;
import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.UserStatus;
import com.iplanet.im.net.UserStatusListener;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.util.HostPort;
import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.TimeoutException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ConnectionFactory {
    public static String VERSION = "6.1";
    private float _serverVersion = 6.0f;
    public static final String NMS = "net.nms";
    public static final String USER = "net.user";
    public static final String PASS = "net.password";
    public static final String SERV = "net.server";
    public static final String LOGINTYPE = "net.login";
    public static final int LOGINTYPE_PRIMARY = 1;
    public static final int LOGINTYPE_SECONDARY = 2;
    public static final String PING_INTERVAL = "net.pinginterval";
    public static final String USER_ENV_VAR = "net.user.property";
    public static final String USER_CACHE = "net.user.cache";
    public static final String SERVER_ARCHIVE_ENABLED = "net.archive.enabled";
    public static final String USE_SSL = "net.use.ssl";
    public static final String FORWARD_EMAIL = "forward.email";
    public static final String FORWARD_EMAIL_ADDR = "forward.email.addr";
    public static final String FORWARD_PAGER = "forward.pager";
    public static final String FORWARD_PAGER_ADDR = "forward.pager.addr";
    public static final String FORWARD_SMS = "forward.sms";
    public static final String FORWARD_SMS_ADDR = "forward.sms.addr";
    public static final String DELIVER_OFFLINE_ALERTS = "alerts.offline.deliver";
    public static final String ID_MSGTYPE_URL = "net/url";
    public static final String ID_MSGTYPE_URLEX = "net/urlex";
    public static final String ID_MSGTYPE_HTML = "net/html";
    public static final String ID_MSGTYPE_HTMLEX = "net/htmlex";
    public static final String ID_MSGTYPE_TEXT = "net/text";
    public static final String ID_MSGTYPE_REPLY = "net/reply";
    public static final String ID_MSGTYPE_POLL = "net/poll";
    public static final String ID_MSGTYPE_POLL_REPLY = "net/pollreply";
    public static final String ID_MSGTYPE_STATUSALERT = "net/status";
    public static final String ID_MSGTYPE_EXTENDED = "net/extended";
    public static final String ID_MSGTYPE_CHAT = "net/chat";
    public static final String ID_MSGTYPE_CHATEX = "net/chatex";
    public static final String ID_MSGTYPE_TYPING = "net/typing";
    public static final String ID_MSGTYPE_TYPING_OFF = "net/typing_off";
    public static final String ID_MSGTYPE_MODCHAT = "net/moderated";
    public static final String ID_MSGTYPE_WHITEBOARD = "net/wb";
    public static final String ID_MSGTYPE_INVITE = "net/invite";
    public static final String ID_MSGTYPE_SEND_FILE = "net/sendfile";
    public static final String ID_MSGTYPE_RECEIVE_FILE = "net/recfile";
    public static final String ID_MSGTYPE_PLUGIN = "net/plugin";
    public static final String ID_NEW_WB = "net/wb";
    public static final String ID_MSGTYPE_RELOAD = "net/reload";
    public static final String ID_MSGTYPE_UPDATE = "net/update";
    public static final String ID_MSGTYPE_MEDIA = "net/media";
    public static final String ID_MSGTYPE_REQUEST = "net/request";
    public static final String ID_MSGTYPE_ADVERTIZE = "net/advertize";
    public static final String ID_MSGTYPE_MESSAGE = "net/msg";
    public static final String ID_MSGFIELD_BODY = "BODY";
    public static final String ID_MSGFIELD_FILES = "FILES";
    public static final String ID_MSGFIELD_IMAGES = "IMAGES";
    public static final String SSO_PREFIX = "~~~";
    public static final String SSO_PORTALID_PREFIX = "^^^";
    private Hashtable connHT = new Hashtable(10);
    private String currentServer;
    private String netVer;
    private String nmsVer;
    protected Properties props;
    protected Socket socket;
    private DataOutputStream os;
    private DataInputStream is;
    private CommandToNet c2n = new CommandToNet();
    private CommandData _reply;
    Object replyLock = new Object();
    boolean connected = false;
    boolean bReceivedHello = false;
    iIMUser nlu;
    protected Vector userStatusListeners = new Vector(20);
    protected Vector msgStatusListeners = new Vector(5);
    protected Vector cfStatusListeners = new Vector(5);
    CommandData _pendingCommand;
    Object receivedHello = new Object();
    Thread pinger = null;
    int pingInterval = 30000;
    public static final String JVMID_PROP = "com.iplanet.im.jvmid";
    protected static String processId;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetAddress[] findServers(int port) {
        if (port == 0) {
            port = 9909;
        }
        Vector<InetAddress> v = new Vector<InetAddress>();
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.setSoTimeout(2000);
            String ask = "WhereIsiIMMessageServer";
            byte[] baout = ask.getBytes();
            InetAddress broadcast = InetAddress.getByName("255.255.255.255");
            DatagramPacket dpout = new DatagramPacket(baout, baout.length, broadcast, port);
            ds.send(dpout);
            try {
                while (true) {
                    byte[] bain = new byte[255];
                    DatagramPacket dpin = new DatagramPacket(bain, bain.length);
                    ds.receive(dpin);
                    String ans = new String(dpin.getData(), 0, dpin.getLength());
                    if (!ans.equals("HereIsiIMMessageServer")) continue;
                    v.addElement(dpin.getAddress());
                }
            }
            catch (InterruptedIOException ie) {
            }
        }
        catch (Exception e) {
            System.err.println("Error trying to find server");
        }
        Object[] iaa = new InetAddress[v.size()];
        v.copyInto(iaa);
        return iaa;
    }

    public ConnectionFactory(Properties props) {
        this.props = props;
    }

    public String getServerName() {
        return this.currentServer;
    }

    public String getServerVersionDisplayString() {
        return "Sun ONE IM Server " + this.nmsVer + " - protocol version " + this.netVer;
    }

    public String getiIMProtocolVersion() {
        return this.netVer;
    }

    public String getNMSVersion() {
        return this.nmsVer;
    }

    public String getNetVersion() {
        return this.netVer;
    }

    public void connect() throws UnknownHostException, IOException, CollaborationException {
        String host = this.props.getProperty(NMS, "localhost");
        HostPort hp = new HostPort(host, 9909);
        this.socket = new Socket(hp.getHostName(), hp.getPort());
        this._connect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void _connect() throws UnknownHostException, IOException, CollaborationException {
        try {
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException io) {
            io.printStackTrace();
            this.os = null;
            this.is = null;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            throw new CollaborationException(io.toString());
        }
        this.connected = true;
        Thread t = new Thread(new Runnable(){

            public void run() {
                ConnectionFactory.this.readThread();
            }
        });
        t.setName("cf - reader");
        t.start();
        Object object = this.receivedHello;
        // MONITORENTER : object
        while (!this.bReceivedHello && this.connected) {
            try {
                this.receivedHello.wait(30000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (this.bReceivedHello) continue;
            this._close("Timeout waiting for server greeting", false, 0);
            throw new TimeoutException("Timeout waiting for server greeting");
        }
        // MONITOREXIT : object
        if (!this.connected) {
            throw new NetIOException("Error occured before receiving hello");
        }
        this.sayHello();
    }

    void sayHello() throws IOException, CollaborationException {
        CommandData cd = Command.create(106, VERSION, VERSION, VERSION, "");
        CommandData reply = this.sendCommand(cd);
        if (reply == null || reply.command != 100) {
            System.err.println("Invalid protocol ");
            this._close("error at hello phase", false, 0);
        }
    }

    Config _login() throws CollaborationException, AuthenticationException {
        Config c = this.auth();
        this.currentServer = c.server;
        this.nlu = c.me;
        return c;
    }

    public Config login() throws CollaborationException, AuthenticationException {
        String s;
        Config c = this._login();
        if (c.me != null && (s = c.me.getAttribute(PING_INTERVAL)) != null) {
            this.pingInterval = Integer.parseInt(s);
        }
        if (this.pingInterval > 0) {
            this.pinger = new Thread(new Runnable(){

                public void run() {
                    while (ConnectionFactory.this.isConnected()) {
                        try {
                            Thread.sleep(ConnectionFactory.this.pingInterval);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!ConnectionFactory.this.isConnected()) continue;
                        try {
                            CommandData cd = Command.create(10);
                            ConnectionFactory.this.writeCommand(cd);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.pinger.setName("cf - ping");
            this.pinger.start();
        }
        return c;
    }

    protected void finalize() throws Throwable {
        this._close("finalize: Cleaning up ConnectionFactory", false, ConnectionEvent.NETWORK_ERROR);
    }

    public boolean isConnected() {
        return this.connected;
    }

    private CommandData readCommand() throws CollaborationException {
        if (!this.connected) {
            throw new CollaborationException("not connected");
        }
        try {
            return this.c2n.readCommand(this.is);
        }
        catch (ClassNotFoundException e) {
            this._close(e.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new CollaborationException("invalid class type");
        }
        catch (OptionalDataException ode) {
            this._close(ode.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new CollaborationException("invalid class format");
        }
        catch (IOException ioe) {
            this._close(ioe.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new CollaborationException(ioe.toString());
        }
    }

    void writeCommand(CommandData cd) throws CollaborationException {
        this.threadCheck(cd);
        if (!this.connected) {
            throw new NetIOException("not connected");
        }
        try {
            DataOutputStream dataOutputStream = this.os;
            synchronized (dataOutputStream) {
                this.c2n.sendCommand(this.os, cd);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this._close(ioe.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new NetIOException(ioe.toString());
        }
    }

    public void close() {
        this._close("User request", false, 0);
    }

    void _close(String reason, boolean notify, int type) {
        if (reason == null) {
            reason = "unknown";
        }
        if (reason.equals("")) {
            reason = "unknown";
        }
        if (!this.connected) {
            return;
        }
        this.connected = false;
        Object object = this.receivedHello;
        synchronized (object) {
            if (!this.bReceivedHello) {
                this.receivedHello.notify();
            }
        }
        try {
            if (this.pinger != null) {
                this.pinger.interrupt();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.socket = null;
        }
        if (notify) {
            this.fireConnectionLost(reason, type);
        }
    }

    public Properties getAuthProperties() {
        return this.props;
    }

    private Config auth() throws CollaborationException, AuthenticationException {
        String user = this.props.getProperty(USER, "anonymous");
        String pass = this.props.getProperty(PASS, "");
        String serv = this.props.getProperty(SERV, "");
        Boolean b = serv.equals("true") ? new Boolean(true) : new Boolean(false);
        String s = this.props.getProperty(LOGINTYPE, "1");
        Integer loginType = new Integer(s);
        char[] ua = new char[user.length()];
        user.getChars(0, user.length(), ua, 0);
        int i = 0;
        while (i < ua.length) {
            ua[i] = (char)(ua[i] ^ 0xBA);
            ++i;
        }
        char[] pa = new char[pass.length()];
        pass.getChars(0, pass.length(), pa, 0);
        int i2 = 0;
        while (i2 < pa.length) {
            pa[i2] = (char)(pa[i2] ^ 0xBE);
            ++i2;
        }
        String eu = new String(ua);
        String ep = new String(pa);
        Config config = null;
        CommandData c = loginType != 1 ? Command.create(200, eu, ep, b, loginType) : Command.create(200, eu, ep, b);
        try {
            CommandData nc = this.sendCommand(c);
            config = (Config)nc.args[3];
        }
        catch (CollaborationException e) {
            if (e.getMessage().startsWith("Authentication Failed")) {
                throw new AuthenticationException(e.getMessage());
            }
            throw e;
        }
        return config;
    }

    private void threadCheck(CommandData cd) {
        Thread t = Thread.currentThread();
        if (t.getName().equals("cf - reader") && cd.command != 10) {
            System.err.println("ConnectionFactory calling network send in reader class : " + Command.toString(cd));
            RuntimeException e = new RuntimeException("programmer threading error");
            throw e;
        }
        if (t.getName().startsWith("AWT")) {
            System.out.println("WARNING: sending data in the UI Thread : " + Command.toString(cd));
        }
    }

    private void readThread() {
        Thread t = Thread.currentThread();
        t.setName("cf - reader");
        while (true) {
            try {
                CommandData nc = this.readCommand();
                this.handleCommand(nc);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    synchronized void onReply(CommandData cd) {
        String uid = "";
        if (this.nlu != null) {
            uid = this.nlu.getUID();
        }
        if (this._pendingCommand == null) {
            System.err.println("ERROR: <" + uid + "> no pending request - ignoring reply to " + Command.toString((Integer)cd.args[0]));
            return;
        }
        if ((Integer)cd.args[0] != this._pendingCommand.command) {
            System.err.println("ERROR: <" + uid + "> request/reply mismatch - ignoring reply to " + Command.toString((Integer)cd.args[0]));
            return;
        }
        if (this._reply != null) {
            System.err.println("ERROR: <" + uid + "> writing over last reply: " + Command.toString((Integer)this._reply.args[0]));
        }
        this._reply = cd;
        this.notify();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleCommand(CommandData nc) {
        switch (nc.command) {
            case 10: {
                return;
            }
            case 101: {
                Destination d = (Destination)nc.args[0];
                if (d == null) {
                    System.err.println("ConnectionFactory.handleCommand(): invalid destination in MSGADDED command");
                    return;
                }
                Message m = (Message)nc.args[1];
                Connection c = this.findConnection(d);
                if (c == null) {
                    if (this.nlu != null) {
                        System.err.println("ConnectionFactory.handleCommand(): " + this.nlu.getUID() + ": MSGADDED: no connection for " + d.getUID());
                        return;
                    } else {
                        System.err.println("ConnectionFactory.handleCommand(): MSGADDED: no connection for " + d.getName());
                    }
                    return;
                }
                c.addMessage(m, nc);
                return;
            }
            case 102: {
                Destination d = (Destination)nc.args[0];
                if (d == null) {
                    System.err.println("ConnectionFactory.handleCommand(): invalid destination in MSGDELED command");
                    return;
                }
                String msgid = (String)nc.args[1];
                Connection c = this.findConnection(d);
                if (c == null) {
                    System.err.println("ConnectionFactory.handleCommand(): " + this.nlu.getUID() + ": MSGDELED: no connection for " + d.getName());
                    return;
                }
                c.delMessage(msgid, nc);
                return;
            }
            case 100: {
                this.onReply(nc);
                return;
            }
            case 103: {
                String uid = (String)nc.args[0];
                Integer status = (Integer)nc.args[1];
                String reason = (String)nc.args[2];
                Integer prevStatus = (Integer)nc.args[3];
                this.fireUserStatus(uid, status, reason, prevStatus, nc);
                return;
            }
            case 104: {
                iIMQueue to = (iIMQueue)nc.args[0];
                Integer ret = (Integer)nc.args[1];
                String descr = (String)nc.args[2];
                String smsgid = (String)nc.args[3];
                Destination sd = (Destination)nc.args[4];
                this.fireMsgStatus(sd, ret, descr, smsgid, nc);
                return;
            }
            case 105: {
                RoomConnection rc;
                Room r = (Room)nc.args[0];
                String rm_uid = (String)nc.args[1];
                String rm_status = (String)nc.args[2];
                String rm_note = null;
                if (nc.args.length > 3) {
                    rm_note = (String)nc.args[3];
                }
                if ((rc = (RoomConnection)this.findConnection(r)) == null) return;
                rc.setUserStatus(rm_uid, rm_status, rm_note, nc);
                return;
            }
            case 106: {
                try {
                    this.nmsVer = (String)nc.args[1];
                    String ver = (String)nc.args[2];
                    this.netVer = ver.charAt(0) + "." + ver.charAt(ver.length() - 1);
                    this._serverVersion = Float.parseFloat(this.netVer);
                    Object object = this.receivedHello;
                    synchronized (object) {
                        this.bReceivedHello = true;
                        this.receivedHello.notify();
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._close("error at hello phase: " + e.toString(), false, 0);
                }
                return;
            }
            case 108: {
                this._close("Server Close", true, ConnectionEvent.SERVER_CLOSED);
                return;
            }
            default: {
                System.err.println("ConnectionFactory.handleCommand(): Unknown command " + nc.command);
            }
        }
    }

    private CommandData readReply() throws CollaborationException {
        int increment = 0;
        CommandData d = null;
        while (this.connected && this._reply == null) {
            if (increment > 5) {
                this._reply = null;
                String cmd = this._pendingCommand != null ? Command.toString(this._pendingCommand) : "null";
                this._pendingCommand = null;
                throw new TimeoutException("Timeout while waiting for server response to " + cmd);
            }
            ConnectionFactory connectionFactory = this;
            synchronized (connectionFactory) {
                try {
                    this.wait(5000L);
                    d = this._reply;
                    if (d != null) {
                        break;
                    }
                    ++increment;
                }
                catch (Exception e) {
                    System.err.println("WAIT interrupted " + e);
                }
            }
        }
        this._reply = null;
        return d;
    }

    public CommandData sendCommand(CommandData cd) throws CollaborationException {
        CommandData ret;
        Object object = this.replyLock;
        synchronized (object) {
            this._pendingCommand = cd;
            this.writeCommand(cd);
            ret = this.readReply();
            this._pendingCommand = null;
        }
        if (ret == null) {
            return null;
        }
        if (!Command.checkReplyCommand(cd.command, ret)) {
            if (ret.command == 100) {
                System.out.println("ERROR : Expected reply to : " + Command.toString(cd) + " and got reply to " + Command.toString((Integer)ret.args[0]));
            } else {
                System.out.println("ERROR : Expected reply to : " + Command.toString(cd) + " and got " + Command.toString(ret));
            }
            throw new CollaborationException("protocol error");
        }
        if (Command.getReplyCode(ret) != 0) {
            throw new CollaborationException(Command.getReplyString(ret));
        }
        return ret;
    }

    public Connection createConnection(Destination d) {
        Connection c = this.findConnection(d);
        if (c != null) {
            return c;
        }
        if (d instanceof Topic) {
            c = new TopicConnection(this, (Topic)d);
        } else if (d instanceof Room) {
            c = new RoomConnection(this, (Room)d);
        } else if (d instanceof iIMQueue) {
            c = new QueueConnection(this, (iIMQueue)d);
        } else {
            System.err.println("Unknown Destination type");
            return null;
        }
        this.connHT.put(c.getDestination().getUID(), c);
        return c;
    }

    public Connection findConnection(Destination d) {
        return (Connection)this.connHT.get(d.getUID());
    }

    public void removeConnection(Destination d) {
        this.connHT.remove(d.getUID());
    }

    public Topic[] getTopics(String location) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.length() < 1) {
            location = "*";
        }
        if ((reply = this.sendCommand(nc = Command.create(218, location, "*"))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Topic[])Command.getReplyArg1(reply);
    }

    public Room[] getRooms(String location) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.length() < 1) {
            location = "*";
        }
        if ((reply = this.sendCommand(nc = Command.create(217, location))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Room[])Command.getReplyArg1(reply);
    }

    public Room[] getManagedRooms(String pattern) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (pattern == null || pattern.length() < 1) {
            pattern = "*";
        }
        if ((reply = this.sendCommand(nc = Command.create(217, this.getServerName(), pattern, new Integer(14)))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Room[])Command.getReplyArg1(reply);
    }

    public iIMQueue[] getQueues(String location) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.equals("")) {
            location = this.currentServer;
        }
        if ((reply = this.sendCommand(nc = Command.create(219, location))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMQueue[])Command.getReplyArg1(reply);
    }

    void start(Connection c, String note) throws CollaborationException {
        CommandData nc = Command.create(201, c.getDestination(), note, new Boolean(c.isArchiveEnabled()));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        if (reply.args.length > 2) {
            int access;
            c.getDestination()._access = access = ((Integer)Command.getReplyArg1(reply)).intValue();
        }
    }

    void stop(Connection c) throws CollaborationException {
        CommandData nc = Command.create(202, c.getDestination(), new Boolean(c.isArchiveEnabled()));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void setArchive(Destination d, boolean b) throws CollaborationException {
        CommandData nc = Command.create(228, d, new Boolean(b));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addMsg(Message m) throws CollaborationException {
        CommandData reply;
        Destination[] da;
        if (m.getFrom() == null) {
            m.setFrom(new iIMQueue(this.nlu));
        }
        CommandData nc = Command.create(203, m);
        if (m instanceof RoomMsg && (da = m.getTo()).length > 0) {
            int i = 0;
            while (i < da.length) {
                Destination d = da[i];
                if (d instanceof Room) {
                    Connection c = this.findConnection(d);
                    if (c == null) {
                        System.err.println("addMsg: no connection for " + d.getName());
                    } else {
                        c.addMessage(m, nc);
                    }
                }
                ++i;
            }
        }
        if ((reply = this.sendCommand(nc)) == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addServerMsg(Message m, MessageListener originator) throws CollaborationException {
        if (this.nlu != null) {
            System.err.println("addServerMsg: called by real user " + this.nlu.getUID());
            return;
        }
        Destination[] da = m.getTo();
        if (da.length > 0) {
            int i = 0;
            while (i < da.length) {
                Destination d = da[i];
                if (d instanceof Room || d instanceof Topic) {
                    Connection c = this.findConnection(d);
                    if (c == null) {
                        System.err.println("addServerMsg: no connection for " + d.getUID());
                    } else {
                        CommandData cd = Command.create(101, d, m);
                        c.removeChangeListener(originator);
                        c.addMessage(m, cd);
                        c.addChangeListener(originator);
                    }
                }
                ++i;
            }
        }
    }

    public void delMsg(Destination d, Message m) throws CollaborationException {
        CommandData nc = Command.create(204, d, m.getMsgid());
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void markRead(Message m) throws CollaborationException {
        CommandData nc = Command.create(211, m.getMsgid(), m.getFrom());
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addTopic(Topic t) throws CollaborationException {
        CommandData nc = Command.create(206, t);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addRoom(Room r, boolean isTemp) throws CollaborationException {
        CommandData nc = Command.create(212, r, new Boolean(isTemp));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void setUserStatus(int state, String reason) throws CollaborationException {
        CommandData nc = Command.create(224, new Integer(state), reason);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void delRoom(Room r) throws CollaborationException {
        CommandData nc = Command.create(213, r);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void delTopic(Topic t) throws CollaborationException {
        CommandData nc = Command.create(207, t);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public Properties getUserSettings(iIMUser u) throws CollaborationException {
        CommandData nc = Command.create(221, u);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Properties)Command.getReplyArg1(reply);
    }

    public void saveUserSettings(iIMUser u, Properties p, boolean merge) throws CollaborationException {
        CommandData nc = Command.create(205, u, p, new Boolean(merge));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public iIMGroup[] getGroups(String location) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.equals("")) {
            location = this.currentServer;
        }
        if ((reply = this.sendCommand(nc = Command.create(209, location))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMGroup[])Command.getReplyArg1(reply);
    }

    public boolean isMemberOf(iIMUser u, iIMGroup g) throws CollaborationException {
        CommandData nc = Command.create(222, u, g);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        Boolean b = (Boolean)Command.getReplyArg1(reply);
        return b;
    }

    public iIMUser getCurrentUser() {
        return this.nlu;
    }

    public String[] getServers() throws CollaborationException {
        String[] domains = new String[]{this.currentServer};
        return domains;
    }

    public iIMGroup[] getiIMGroupsFromUIDs(String[] groupUids) throws CollaborationException {
        CommandData nc = Command.create(225, new Boolean(true), groupUids);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMGroup[])Command.getReplyArg1(reply);
    }

    public iIMPrincipal[] getPrincipalsFromUIDs(String[] uid) throws CollaborationException {
        if (this._serverVersion > 0.0f) {
            CommandData nc = Command.create(229, new Boolean(true), uid);
            CommandData reply = this.sendCommand(nc);
            if (reply == null) {
                throw new CollaborationException("No reply from server");
            }
            return (iIMPrincipal[])Command.getReplyArg1(reply);
        }
        return this.getiIMUsersFromUIDs(uid);
    }

    public iIMGroup getiIMGroupFromUID(String groupUid) throws CollaborationException {
        String[] groupA = new String[]{groupUid};
        CommandData nc = Command.create(225, new Boolean(true), groupA);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        iIMGroup[] nlg = (iIMGroup[])Command.getReplyArg1(reply);
        return nlg[0];
    }

    public iIMUser[] getiIMUsersFromUIDs(String[] uids) throws CollaborationException {
        CommandData nc = Command.create(208, new Boolean(true), uids);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMUser[])Command.getReplyArg1(reply);
    }

    public UserSearchReply searchForiIMUsers(String server, String search, boolean byid) throws CollaborationException {
        CommandData nc = Command.create(226, "*", search, new Boolean(byid));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        return (UserSearchReply)Command.getReplyArg1(reply);
    }

    public Room[] searchRooms(String location, String pattern) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.length() < 1) {
            location = "*";
        }
        if (pattern == null || pattern.length() < 1) {
            pattern = "*";
        }
        if ((reply = this.sendCommand(nc = Command.create(217, location, pattern))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Room[])Command.getReplyArg1(reply);
    }

    public Topic[] searchTopics(String location, String pattern) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.length() < 1) {
            location = "*";
        }
        if ((reply = this.sendCommand(nc = Command.create(218, location, pattern))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Topic[])Command.getReplyArg1(reply);
    }

    public Topic[] getManagedTopics(String pattern) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (pattern == null || pattern.length() < 1) {
            pattern = "*";
        }
        if ((reply = this.sendCommand(nc = Command.create(218, this.getServerName(), pattern, new Integer(14)))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Topic[])Command.getReplyArg1(reply);
    }

    public iIMUser getiIMUserFromUID(String uid) throws CollaborationException {
        String[] userA = new String[]{uid};
        CommandData nc = Command.create(208, new Boolean(true), userA);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        iIMUser[] nlu = (iIMUser[])Command.getReplyArg1(reply);
        return nlu[0];
    }

    public iIMUser[] getiIMUsersInGroup(String groupuid) throws CollaborationException {
        CommandData nc = Command.create(208, new Boolean(false), groupuid);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMUser[])Command.getReplyArg1(reply);
    }

    public UserStatus[] getUserStatus(iIMQueue[] q, boolean updates) throws CollaborationException {
        CommandData nc = Command.create(210, q, new Boolean(updates));
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
        Integer[] io = (Integer[])Command.getReplyArg1(reply);
        String[] reason = (String[])Command.getReplyArg2(reply);
        Integer[] prevStatus = (Integer[])Command.getReplyArg3(reply);
        UserStatus[] ret = new UserStatus[q.length];
        int i = 0;
        while (i < q.length) {
            ret[i] = new UserStatus(io[i], reason[i], prevStatus[i]);
            ++i;
        }
        return ret;
    }

    public UserStatus getUserStatus(iIMQueue q, boolean updates) throws CollaborationException {
        iIMQueue[] qa = new iIMQueue[]{q};
        UserStatus[] u = this.getUserStatus(qa, updates);
        return u[0];
    }

    public BooleanAccessControlList getAdminACL(String location) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("admin", location, null);
    }

    public BooleanAccessControlList getTopicsAddDelACL(String location) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("topicsAddDel", location, null);
    }

    public BooleanAccessControlList getSendAlertsACL(String location) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("sendAlerts", location, null);
    }

    public BooleanAccessControlList getRoomsAddDelACL(String location) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("roomsAddDel", location, null);
    }

    public BooleanAccessControlList getSaveUserSettingsACL(String location) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("saveUserSettings", location, null);
    }

    public BooleanAccessControlList getWatchACL(String location) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("watch", location, null);
    }

    public DestinationAccessControlList getDestinationACL(Destination d) throws CollaborationException {
        return (DestinationAccessControlList)this.getACL("destination", d.getLocation(), d);
    }

    public BooleanAccessControlList getUserACL(String location, iIMUser u) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("user", location, u);
    }

    public void setAdminACL(String location, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "admin", location, null);
    }

    public void setTopicsAddDelACL(String location, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "topicsAddDel", location, null);
    }

    public void setSendAlertsACL(String location, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "sendAlerts", location, null);
    }

    public void setRoomsAddDelACL(String location, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "roomsAddDel", location, null);
    }

    public void setSaveUserSettingsACL(String location, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "saveUserSettings", location, null);
    }

    public void setWatchACL(String location, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "watch", location, null);
    }

    public void setDestinationACL(DestinationAccessControlList acl, Destination d) throws CollaborationException {
        this.setACL(acl, "destination", d.getLocation(), d);
    }

    public void saveDestinationProperties(Destination d) throws CollaborationException {
        if (this._serverVersion > 3.0f) {
            CommandData nc;
            CommandData reply;
            String location = d.getLocation();
            if (location == null || location.equals("")) {
                location = this.currentServer;
            }
            if ((reply = this.sendCommand(nc = Command.create(227, d))) == null) {
                throw new CollaborationException("No reply from server");
            }
        }
    }

    public void setUserACL(String location, iIMUser u, BooleanAccessControlList acl) throws CollaborationException {
        this.setACL(acl, "user", location, u);
    }

    public boolean checkAdminACL(String location) throws CollaborationException {
        boolean[] b = this.checkACL("admin", location, null, 0);
        return b[0];
    }

    public boolean checkTopicsAddDelACL(String location) throws CollaborationException {
        boolean[] b = this.checkACL("topicsAddDel", location, null, 0);
        return b[0];
    }

    public boolean checkSendAlertsACL(String location) throws CollaborationException {
        boolean[] b = this.checkACL("sendAlerts", location, null, 0);
        return b[0];
    }

    public boolean checkRoomsAddDelACL(String location) throws CollaborationException {
        boolean[] b = this.checkACL("roomsAddDel", location, null, 0);
        return b[0];
    }

    public boolean checkSaveUserSettingsACL(String location) throws CollaborationException {
        boolean[] b = this.checkACL("saveUserSettings", location, null, 0);
        return b[0];
    }

    public boolean checkWatchACL(String location) throws CollaborationException {
        boolean[] b = this.checkACL("watch", location, null, 0);
        return b[0];
    }

    public boolean[] checkDestinationACL(String location, Destination[] d, int access) throws CollaborationException {
        return this.checkACL("destination", location, d, access);
    }

    public boolean[] checkUserACL(String location, iIMUser[] u) throws CollaborationException {
        return this.checkACL("user", location, u, 0);
    }

    private void setACL(Object acl, String name, String location, Object doru) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.equals("")) {
            location = this.currentServer;
        }
        if ((reply = this.sendCommand(nc = Command.create(215, name, location, doru, acl))) == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    private Object getACL(String name, String location, Object doru) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.equals("")) {
            location = this.currentServer;
        }
        if ((reply = this.sendCommand(nc = Command.create(214, name, location, doru))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return Command.getReplyArg1(reply);
    }

    private boolean[] checkACL(String name, String location, Object[] doru, int access) throws CollaborationException {
        CommandData nc;
        CommandData reply;
        if (location == null || location.equals("")) {
            location = this.currentServer;
        }
        if ((reply = this.sendCommand(nc = Command.create(216, name, location, doru, new Integer(access)))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (boolean[])Command.getReplyArg1(reply);
    }

    public void subscribe(Destination d, iIMPrincipal u) throws CollaborationException {
        CommandData nc = Command.create(231, d, u);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void unsubscribe(Destination d, iIMPrincipal u) throws CollaborationException {
        CommandData nc = Command.create(232, d, u);
        CommandData reply = this.sendCommand(nc);
        if (reply == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public synchronized void addUserStatusListener(UserStatusListener l) {
        if (this.userStatusListeners.contains(l)) {
            return;
        }
        Vector v = (Vector)this.userStatusListeners.clone();
        v.addElement(l);
        this.userStatusListeners = v;
    }

    public synchronized void removeUserStatusListener(UserStatusListener l) {
        if (!this.userStatusListeners.contains(l)) {
            return;
        }
        Vector v = (Vector)this.userStatusListeners.clone();
        v.removeElement(l);
        this.userStatusListeners = v;
    }

    protected void fireUserStatus(String user, int state, String reason, int prevStatus, CommandData cd) {
        Vector tl = this.userStatusListeners;
        int size = tl.size();
        if (size == 0) {
            return;
        }
        UserStatus us = new UserStatus(state, reason, prevStatus);
        UserEvent event = new UserEvent(user, us, cd);
        int i = 0;
        while (i < size) {
            UserStatusListener listener = (UserStatusListener)tl.elementAt(i);
            listener.userStatusChange(event);
            ++i;
        }
    }

    public synchronized void addMsgStatusListener(MsgStatusListener l) {
        if (this.msgStatusListeners.contains(l)) {
            return;
        }
        Vector v = (Vector)this.msgStatusListeners.clone();
        v.addElement(l);
        this.msgStatusListeners = v;
    }

    public synchronized void removeMsgStatusListener(MsgStatusListener l) {
        if (!this.msgStatusListeners.contains(l)) {
            return;
        }
        Vector v = (Vector)this.msgStatusListeners.clone();
        v.removeElement(l);
        this.msgStatusListeners = v;
    }

    protected void fireMsgStatus(Destination d, Integer ret, String descr, String msgid, CommandData cd) {
        Vector tl = this.msgStatusListeners;
        int size = tl.size();
        if (size == 0) {
            return;
        }
        MessageStatusEvent event = new MessageStatusEvent(d, ret, descr, msgid, cd);
        int i = 0;
        while (i < size) {
            MsgStatusListener listener = (MsgStatusListener)tl.elementAt(i);
            listener.msgStatusChange(event);
            ++i;
        }
    }

    public synchronized void addConnectionStatusListener(ConnectionStatusListener l) {
        if (this.cfStatusListeners.contains(l)) {
            return;
        }
        this.cfStatusListeners.addElement(l);
    }

    public synchronized void removeConnectionStatusListener(ConnectionStatusListener l) {
        this.cfStatusListeners.removeElement(l);
    }

    protected void fireConnectionLost(String reason, int type) {
        Vector tl;
        ConnectionFactory connectionFactory = this;
        synchronized (connectionFactory) {
            tl = (Vector)this.cfStatusListeners.clone();
        }
        int size = tl.size();
        if (size == 0) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(reason, type, null);
        int i = 0;
        while (i < size) {
            ConnectionStatusListener listener = (ConnectionStatusListener)tl.elementAt(i);
            listener.connectionLost(event);
            ++i;
        }
    }

    protected void fireUpdateAvailable(String update, CommandData cd) {
        Vector tl;
        ConnectionFactory connectionFactory = this;
        synchronized (connectionFactory) {
            tl = (Vector)this.cfStatusListeners.clone();
        }
        int size = tl.size();
        if (size == 0) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(update, 0, cd);
        int i = 0;
        while (i < size) {
            ConnectionStatusListener listener = (ConnectionStatusListener)tl.elementAt(i);
            listener.updateAvailable(event);
            ++i;
        }
    }

    static {
        try {
            processId = InetAddress.getLocalHost().getHostAddress() + "." + System.getProperty(JVMID_PROP, "jvm");
        }
        catch (Exception e) {
            processId = "ip." + System.getProperty(JVMID_PROP, "pid");
        }
    }
}

