/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.util;

import com.iplanet.im.util.PlatformUtil;
import com.iplanet.im.util.StringUtility;
import com.iplanet.im.util.Worker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public final class FileUtility {
    public static void writeString(File file, String s) {
        if (file == null) {
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(s);
            out.close();
        }
        catch (Exception e) {
            System.out.println("writeString:" + e);
        }
    }

    public static final void save(String path, String s, Worker w) {
        FileUtility.save(new File(path), s, w);
    }

    public static void save(File file, String s, Worker w) {
        if (w != null) {
            w.addRunnable(new SaveStringRunnable(file, s));
        } else {
            FileUtility.writeString(file, s);
        }
    }

    public static void writeByte(File file, byte[] b, boolean append) {
        if (file == null) {
            return;
        }
        try {
            FileOutputStream w = new FileOutputStream(file.getAbsolutePath(), append);
            w.write(b);
            w.close();
        }
        catch (Exception e) {
            System.out.println("FileUtility.writeByte(): Exception thrown: " + e);
        }
    }

    private static void writeByte(File file, byte[] b) {
        FileUtility.writeByte(file, b, false);
    }

    public static void writeByte(String path, byte[] b, boolean append) {
        FileUtility.writeByte(new File(path), b, append);
    }

    public static final void save(String path, byte[] b) {
        FileUtility.save(new File(path), b);
    }

    public static final void save(File file, byte[] b) {
        FileUtility.writeByte(file, b);
    }

    public static final byte[] readByte(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            byte[] b = new byte[(int)f.length()];
            FileInputStream is = new FileInputStream(f);
            int len = is.read(b);
            is.close();
            return b;
        }
        catch (FileNotFoundException e) {
            System.out.println("FileUtility.readByte(): FileNotFoundException thrown: " + e);
        }
        catch (IOException e) {
            System.out.println("FileUtility.readByte(): IOException thrown: " + e);
        }
        return null;
    }

    public static final void findReplace(File infile, File outfile, Map substitutions, String match, String encoding) throws IOException {
        String line;
        boolean isSameFile = infile.equals(outfile);
        File tmpfile = outfile;
        if (isSameFile) {
            tmpfile = new File(outfile.getAbsolutePath() + ".tmp");
        }
        FileInputStream fis = new FileInputStream(infile);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
        FileOutputStream fos = new FileOutputStream(tmpfile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoding));
        PrintWriter out = new PrintWriter(bw);
        while ((line = in.readLine()) != null) {
            String replaced = line;
            if (match == null || match != null && line.indexOf(match) >= 0) {
                Iterator i = substitutions.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    replaced = StringUtility.substitute(replaced, (String)e.getKey(), (String)e.getValue());
                }
            }
            out.println(replaced);
        }
        in.close();
        out.flush();
        out.close();
        if (isSameFile) {
            boolean rc = tmpfile.renameTo(outfile);
        }
    }

    public static final boolean setFilePermissions(File f, String mode) {
        try {
            if (PlatformUtil.isUnix() && f.exists()) {
                String[] args = new String[]{"/bin/chmod", mode, f.getAbsolutePath()};
                Runtime.getRuntime().exec(args);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static class SaveStringRunnable
    implements Runnable {
        private String s;
        private File f = null;

        public SaveStringRunnable(File f, String s) {
            this.s = s;
            this.f = f;
        }

        public void run() {
            FileUtility.writeString(this.f, this.s);
        }
    }
}

